/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.rails;

import com.sun.enterprise.rails.RailsDeployer;
import com.sun.grizzly.jruby.RubyObjectPool;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.Deployer;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="com.sun.enterprise.rails.RailsContainer")
public class RailsContainer
implements Container,
PostConstruct,
PreDestroy {
    private Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.deployment");
    private String jrubyLib = null;
    private int numberOfRuntime = 1;
    private RubyObjectPool pool = null;

    public void postConstruct() {
        String jrubyBase = System.getProperty("jruby.base");
        String jrubyHome = System.getProperty("jruby.home");
        String jrubyShell = System.getProperty("jruby.shell");
        String jrubyScript = System.getProperty("jruby.script");
        String jrubyRuntime = System.getProperty("jruby.runtime");
        String railsEnv = System.getProperty("RAILS_ENV");
        if (jrubyHome == null) {
            this.logger.severe("jruby.home cannot be null");
            return;
        }
        if (jrubyBase == null) {
            jrubyBase = jrubyHome;
        }
        if (jrubyShell == null) {
            jrubyShell = "";
        }
        if (jrubyScript == null) {
            jrubyScript = "";
        }
        if (this.numberOfRuntime == 1) {
            if (jrubyRuntime != null) {
                try {
                    this.numberOfRuntime = Integer.parseInt(jrubyRuntime);
                }
                catch (NumberFormatException ex) {
                    this.logger.log(Level.WARNING, "Invalid number of Runtimes specified");
                }
            }
            if (railsEnv != null && railsEnv.equalsIgnoreCase("production") && jrubyRuntime == null) {
                this.numberOfRuntime = 3;
            }
        }
        System.setProperty("jruby.script", jrubyScript);
        System.setProperty("jruby.shell", jrubyShell);
        System.setProperty("jruby.base", jrubyBase);
        this.jrubyLib = System.getProperty("jruby.lib");
        if (this.jrubyLib == null) {
            this.jrubyLib = new File(jrubyHome, "lib").getPath();
            System.setProperty("jruby.lib", this.jrubyLib);
        }
        this.initializeRubyRuntime();
    }

    protected void initializeRubyRuntime() {
        this.pool = new RubyObjectPool();
        this.pool.setNumberOfRuntime(this.numberOfRuntime);
        this.pool.setJrubyLib(this.jrubyLib);
    }

    RubyObjectPool getPool() {
        return this.pool;
    }

    public URL getInfoSite() {
        try {
            return new URL("http://jruby.dev.java.net");
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public Class<? extends Deployer> getDeployer() {
        return RailsDeployer.class;
    }

    public String getName() {
        return "Rails";
    }

    public void preDestroy() {
        if (this.pool != null) {
            this.pool.stop();
            this.pool = null;
        }
    }
}

