/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transactions {
    private static final Transactions t = new Transactions();
    final List<TransactionListener> listeners = new ArrayList<TransactionListener>();
    private final BlockingQueue<List<PropertyChangeEvent>> pendingRecords = new ArrayBlockingQueue<List<PropertyChangeEvent>>(5);
    Thread pump;
    final Semaphore semaphore = new Semaphore(100);

    public static Transactions get() {
        return t;
    }

    public synchronized void addTransactionsListener(TransactionListener listener) {
        this.listeners.add(listener);
    }

    public synchronized boolean removeTransactionsListener(TransactionListener listener) {
        return this.listeners.remove(listener);
    }

    void addTransaction(List<PropertyChangeEvent> events) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pendingRecords.add(events);
    }

    public boolean pendingTransactionEvents() {
        return 100 != this.semaphore.availablePermits();
    }

    public void waitForDrain() {
        while (this.pendingTransactionEvents()) {
        }
    }

    public void shutdown() {
        this.pump.interrupt();
    }

    private Transactions() {
        this.pump = new Thread(){

            public void run() {
                try {
                    while (true) {
                        List events = (List)Transactions.this.pendingRecords.take();
                        for (TransactionListener listener : new ArrayList<TransactionListener>(Transactions.this.listeners)) {
                            try {
                                listener.transactionCommited(events);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        for (PropertyChangeEvent evt : events) {
                            Dom dom = (Dom)((Object)((ConfigView)Proxy.getInvocationHandler(evt.getSource())).getMasterView());
                            if (dom.getListeners() == null) continue;
                            for (ConfigListener listener : dom.getListeners()) {
                                try {
                                    listener.changed(events.toArray(new PropertyChangeEvent[events.size()]));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        Transactions.this.semaphore.release();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        this.pump.start();
    }
}

