/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-virtual-server")
@Scoped(value=PerLookup.class)
@I18n(value="delete.virtual.server")
public class DeleteVirtualServer
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteVirtualServer.class);
    @Param(name="virtual_server_id", primary=true)
    String virtualServerId;
    @Inject
    HttpService httpService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    List list = param.getVirtualServer();
                    for (VirtualServer virtualServer : list) {
                        if (!virtualServer.getId().equals(DeleteVirtualServer.this.virtualServerId)) continue;
                        list.remove(virtualServer);
                    }
                    return list;
                }
            }, (ConfigBeanProxy)this.httpService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.virtual.server.fail", "{0} delete failed ", new Object[]{this.virtualServerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setMessage(localStrings.getLocalString("delete.virtual.server.success", "{0} deleted successfully", new Object[]{this.virtualServerId}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

