/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.hl7.cli;

import com.sun.jbi.hl7.cli.Operation;
import com.sun.jbi.hl7.cli.OptionData;
import com.sun.jbi.hl7.cli.display.Displayer;
import com.sun.jbi.hl7.mgmt.api.HL7ManagementService;
import com.sun.jbi.hl7.mgmt.client.HL7ManagementClient;
import com.sun.jbi.hl7.mgmt.client.HL7ManagementClientFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class HL7CLI {
    public static final String USER = "user";
    public static final String USER_DESC = "user name - default=[admin]";
    public static final String USER_SHORT = "u";
    public static final String PASSWORD = "password";
    public static final String PASSWORD_DESC = "user password";
    public static final String PASSWORD_SHORT = "w";
    public static final String HOST = "host";
    public static final String HOST_DESC = "host name - default=[localhost]";
    public static final String HOST_SHORT = "h";
    public static final String PORT = "port";
    public static final String PORT_DESC = "jmx port number - default=[8686]";
    public static final String PORT_SHORT = "p";
    public static final String REMOTE = "remote";
    public static final String REMOTE_DESC = "use a remote client connection in conjunction with the --host option.";
    public static final String REMOTE_SHORT = "r";
    public static final String TARGET = "target";
    public static final String TARGET_DESC = "name of the target server - default=[server]\n\tFor standalone server profile, specify the server name [server].\n\tFor cluster profile, specify the cluster name [cluster1]";
    public static final String TARGET_SHORT = "t";
    public static final String TARGET_INSTANCE = "targetInstance";
    public static final String TARGET_INSTANCE_DESC = "name of the cluster instance.\n\tFor standalone profile, this option is not required.";
    public static final String TARGET_INSTANCE_SHORT = "i";
    public static final String HELP = "help";
    public static final String HELP_DESC = "print this usage";
    public static final String HELP_SHORT = "?";
    public static final String LIST_ENDPOINTS = "list-endpoints";
    public static final String LIST_ENDPOINTS_DESC = "list all endpoints (active and inctive) ";
    public static final String LIST_ENDPOINTS_SHORT = "le";
    public static final String LIST_ENDPOINTS_METHOD_NAME = "listEndpoints";
    public static final String LIST_ENDPOINTS_USAGE = "list-endpoints";
    public static final String GET_ENDPOINTS = "get-endpoints";
    public static final String GET_ENDPOINTS_DESC = "get endpoints for a given service unit";
    public static final String GET_ENDPOINTS_SHORT = "ge";
    public static final String GET_ENDPOINTS_METHOD_NAME = "getEndpoints";
    public static final String GET_ENDPOINTS_USAGE = "list-endpoints <serviceunit>";
    public static final String LIST_ACTIVE_ENDPOINTS = "list-active-endpoints";
    public static final String LIST_ACTIVE_ENDPOINTS_DESC = "list active endpoints";
    public static final String LIST_ACTIVE_ENDPOINTS_SHORT = "lae";
    public static final String LIST_ACTIVE_ENDPOINTS_METHOD_NAME = "listActiveEndpoints";
    public static final String LIST_ACTIVE_ENDPOINTS_USAGE = "list-active-endpoints";
    public static final String LIST_INACTIVE_ENDPOINTS = "list-inactive-endpoints";
    public static final String LIST_INACTIVE_ENDPOINTS_DESC = "list inactive or suspended endpoints";
    public static final String LIST_INACTIVE_ENDPOINTS_SHORT = "lie";
    public static final String LIST_INACTIVE_ENDPOINTS_METHOD_NAME = "listInactiveEndpoints";
    public static final String LIST_INACTIVE_ENDPOINTS_USAGE = "list-inactive-endpoints";
    public static final String LIST_EXTERNAL_CONNECTIONS = "list-external-system-connections";
    public static final String LIST_EXTERNAL_CONNECTIONS_DESC = "list active external system connections (inbound)";
    public static final String LIST_EXTERNAL_CONNECTIONS_SHORT = "lec";
    public static final String LIST_EXTERNAL_CONNECTIONS_METHOD_NAME = "listExternalSystemConnections";
    public static final String LIST_EXTERNAL_CONNECTIONS_USAGE = "list-external-system-connections";
    public static final String LIST_SERVICE_UNITS = "list-service-units";
    public static final String LIST_SERVICE_UNITS_DESC = "list all service units deployed to the HL7 BC";
    public static final String LIST_SERVICE_UNITS_SHORT = "lsu";
    public static final String LIST_SERVICE_UNITS_METHOD_NAME = "listServiceUnits";
    public static final String LIST_SERVICE_UNITS_USAGE = "list-service-units";
    public static final String SUSPEND_ENDPOINT = "suspend-endpoint";
    public static final String SUSPEND_ENDPOINT_DESC = "suspend a given endpoint";
    public static final String SUSPEND_ENDPOINT_SHORT = "se";
    public static final String SUSPEND_ENDPOINT_METHOD_NAME = "suspend";
    public static final String SUSPEND_ENDPOINT_USAGE = "suspend-endpoint <endpoint>";
    public static final String RESUME_ENDPOINT = "resume-endpoint";
    public static final String RESUME_ENDPOINT_DESC = "resume a given endpoint";
    public static final String RESUME_ENDPOINT_SHORT = "re";
    public static final String RESUME_ENDPOINT_METHOD_NAME = "resume";
    public static final String RESUME_ENDPOINT_USAGE = "resume-endpoint <endpoint>";
    public static final String IS_ENDPOINT_ACTIVE = "is-endpoint-active";
    public static final String IS_ENDPOINT_ACTIVE_DESC = "check whether the endpoint is active";
    public static final String IS_ENDPOINT_ACTIVE_SHORT = "iea";
    public static final String IS_ENDPOINT_ACTIVE_METHOD_NAME = "isEndpointActive";
    public static final String IS_ENDPOINT_ACTIVE_USAGE = "is-endpoint-active <endpoint>";
    public static final String STATUS_EXTERNAL_CONNECTIONS = "get-status-external-system-connections";
    public static final String STATUS_EXTERNAL_CONNECTIONS_DESC = "get the status of external client connections (outbound)";
    public static final String STATUS_EXTERNAL_CONNECTIONS_SHORT = "gsesc";
    public static final String STATUS_EXTERNAL_CONNECTIONS_METHOD_NAME = "getExternalSystemConnStatus";
    public static final String STATUS_EXTERNAL_CONNECTIONS_USAGE = "get-status-external-system-connections <serverHostName> <serverPort>";
    public static final String GET_HL7_SERVERS = "list-hl7-servers";
    public static final String GET_HL7_SERVERS_DESC = "retrieve a list of HL7 servers with key value pairs - hostname and port";
    public static final String GET_HL7_SERVERS_SHORT = "lhs";
    public static final String GET_HL7_SERVERS_METHOD_NAME = "getHL7Servers";
    public static final String GET_HL7_SERVERS_USAGE = "list-hl7-servers";
    public static final String MESSAGE_SENT_TIMESTAMP = "get-message-sent-timestamps";
    public static final String MESSAGE_SENT_TIMESTAMP_DESC = "retrieve a list of last sent message timestamps for outbound";
    public static final String MESSAGE_SENT_TIMESTAMP_SHORT = "mst";
    public static final String MESSAGE_SENT_TIMESTAMP_METHOD_NAME = "getMessageSentTimestamps";
    public static final String MESSAGE_SENT_TIMESTAMP_USAGE = "get-message-sent-timestamps";
    public static final String MESSAGE_RECEIVED_TIMESTAMP = "get-message-received-timestamps";
    public static final String MESSAGE_RECEIVED_TIMESTAMP_DESC = "retrieve a list of last message received timestamps for inbound";
    public static final String MESSAGE_RECEIVED_TIMESTAMP_SHORT = "mrt";
    public static final String MESSAGE_RECEIVED_TIMESTAMP_METHOD_NAME = "getMethodReceivedTimestamps";
    public static final String MESSAGE_RECEIVED_TIMESTAMP_USAGE = "get-message-received-timestamps";
    public static final String SEQUENCE_NUMBER = "get-sequence-number";
    public static final String SEQUENCE_NUMBER_DESC = "retrieve the sequence number for a given service unit";
    public static final String SEQUENCE_NUMBER_SHORT = "sn";
    public static final String SEQUENCE_NUMBER_METHOD_NAME = "getSequenceNumber";
    public static final String SEQUENCE_NUMBER_USAGE = "get-sequence-number <serviceunit>";
    public static final Boolean ARG_REQUIRED = Boolean.TRUE;
    public static final Boolean ARG_NOT_REQUIRED = Boolean.FALSE;
    public static final String TAB = "   ";
    public static final String NEWLINE = "\n";
    public static final String COMMA = ",";
    public static final String PREFIX_SHORT = "-";
    public static final String PREFIX_LONG = "--";
    public static final boolean REQUIRED = true;
    public static final boolean NOT_REQUIRED = false;
    private Options options;
    private List<OptionData> optionList = new ArrayList<OptionData>();
    private String port = "8686";
    private String user = "admin";
    private String password = "adminadmin";
    private String host = "localhost";
    private boolean help = false;
    private Map operations;
    private Operation operation;
    private String operationName;
    private String targetName = "server";
    private String targetInstanceName = null;
    private String remoteConnection = null;

    public HL7CLI() {
        this.options = new Options();
        this.optionList.add(new OptionData(HELP, HELP_SHORT, HELP_DESC, false));
        this.optionList.add(new OptionData(USER, USER_SHORT, USER_DESC, true));
        this.optionList.add(new OptionData(PASSWORD, PASSWORD_SHORT, PASSWORD_DESC, true));
        this.optionList.add(new OptionData(HOST, HOST_SHORT, HOST_DESC, true));
        this.optionList.add(new OptionData(PORT, PORT_SHORT, PORT_DESC, true));
        this.optionList.add(new OptionData(REMOTE, REMOTE_SHORT, REMOTE_DESC, false));
        this.optionList.add(new OptionData(TARGET, TARGET_SHORT, TARGET_DESC, true));
        this.optionList.add(new OptionData(TARGET_INSTANCE, TARGET_INSTANCE_SHORT, TARGET_INSTANCE_DESC, true));
        this.addOptions();
        this.operations = new LinkedHashMap();
        this.operations.put("list-service-units", new Operation("list-service-units", LIST_SERVICE_UNITS_SHORT, LIST_SERVICE_UNITS_DESC, LIST_SERVICE_UNITS_METHOD_NAME, ARG_NOT_REQUIRED, "list-service-units", 0));
        this.operations.put("list-endpoints", new Operation("list-endpoints", LIST_ENDPOINTS_SHORT, LIST_ENDPOINTS_DESC, LIST_ENDPOINTS_METHOD_NAME, ARG_NOT_REQUIRED, "list-endpoints", 0));
        this.operations.put(GET_ENDPOINTS, new Operation(GET_ENDPOINTS, GET_ENDPOINTS_SHORT, GET_ENDPOINTS_DESC, GET_ENDPOINTS_METHOD_NAME, ARG_REQUIRED, GET_ENDPOINTS_USAGE, 1));
        this.operations.put("list-active-endpoints", new Operation("list-active-endpoints", LIST_ACTIVE_ENDPOINTS_SHORT, LIST_ACTIVE_ENDPOINTS_DESC, LIST_ACTIVE_ENDPOINTS_METHOD_NAME, ARG_NOT_REQUIRED, "list-active-endpoints", 0));
        this.operations.put("list-inactive-endpoints", new Operation("list-inactive-endpoints", LIST_INACTIVE_ENDPOINTS_SHORT, LIST_INACTIVE_ENDPOINTS_DESC, LIST_INACTIVE_ENDPOINTS_METHOD_NAME, ARG_NOT_REQUIRED, "list-inactive-endpoints", 0));
        this.operations.put("list-external-system-connections", new Operation("list-external-system-connections", LIST_EXTERNAL_CONNECTIONS_SHORT, LIST_EXTERNAL_CONNECTIONS_DESC, LIST_EXTERNAL_CONNECTIONS_METHOD_NAME, ARG_NOT_REQUIRED, "list-external-system-connections", 0));
        this.operations.put("list-hl7-servers", new Operation("list-hl7-servers", GET_HL7_SERVERS_SHORT, GET_HL7_SERVERS_DESC, GET_HL7_SERVERS_METHOD_NAME, ARG_NOT_REQUIRED, "list-hl7-servers", 0));
        this.operations.put(SUSPEND_ENDPOINT, new Operation(SUSPEND_ENDPOINT, SUSPEND_ENDPOINT_SHORT, SUSPEND_ENDPOINT_DESC, SUSPEND_ENDPOINT_METHOD_NAME, ARG_REQUIRED, SUSPEND_ENDPOINT_USAGE, 1));
        this.operations.put(RESUME_ENDPOINT, new Operation(RESUME_ENDPOINT, RESUME_ENDPOINT_SHORT, RESUME_ENDPOINT_DESC, RESUME_ENDPOINT_METHOD_NAME, ARG_REQUIRED, RESUME_ENDPOINT_USAGE, 1));
        this.operations.put(IS_ENDPOINT_ACTIVE, new Operation(IS_ENDPOINT_ACTIVE, IS_ENDPOINT_ACTIVE_SHORT, IS_ENDPOINT_ACTIVE_DESC, IS_ENDPOINT_ACTIVE_METHOD_NAME, ARG_REQUIRED, IS_ENDPOINT_ACTIVE_USAGE, 1));
        this.operations.put(STATUS_EXTERNAL_CONNECTIONS, new Operation(STATUS_EXTERNAL_CONNECTIONS, STATUS_EXTERNAL_CONNECTIONS_SHORT, STATUS_EXTERNAL_CONNECTIONS_DESC, STATUS_EXTERNAL_CONNECTIONS_METHOD_NAME, ARG_REQUIRED, STATUS_EXTERNAL_CONNECTIONS_USAGE, 2));
        this.operations.put("get-message-sent-timestamps", new Operation("get-message-sent-timestamps", MESSAGE_SENT_TIMESTAMP_SHORT, MESSAGE_SENT_TIMESTAMP_DESC, MESSAGE_SENT_TIMESTAMP_METHOD_NAME, ARG_NOT_REQUIRED, "get-message-sent-timestamps", 0));
        this.operations.put("get-message-received-timestamps", new Operation("get-message-received-timestamps", MESSAGE_RECEIVED_TIMESTAMP_SHORT, MESSAGE_RECEIVED_TIMESTAMP_DESC, MESSAGE_RECEIVED_TIMESTAMP_METHOD_NAME, ARG_NOT_REQUIRED, "get-message-received-timestamps", 0));
        this.operations.put(SEQUENCE_NUMBER, new Operation(SEQUENCE_NUMBER, SEQUENCE_NUMBER_SHORT, SEQUENCE_NUMBER_DESC, SEQUENCE_NUMBER_METHOD_NAME, ARG_REQUIRED, SEQUENCE_NUMBER_USAGE, 1));
        this.operation = new Operation();
    }

    private void addOptions() {
        for (OptionData optionData : this.optionList) {
            this.options.addOption(optionData.getShortName(), optionData.getName(), optionData.hasArg(), optionData.getDesc());
        }
    }

    public void parseArguments(HL7CLI cli, String[] args) {
        PosixParser parser = new PosixParser();
        try {
            boolean remote;
            String instance;
            String target;
            String port;
            String host;
            String password;
            CommandLine line = parser.parse(this.options, args);
            cli.help = this.getBooleanOption(line, HELP_SHORT, HELP);
            if (cli.help) {
                return;
            }
            String user = this.getStringOption(line, USER_SHORT, USER, false);
            if (user != null) {
                cli.user = user;
            }
            if ((password = this.getStringOption(line, PASSWORD_SHORT, PASSWORD, false)) != null) {
                cli.password = password;
            }
            if ((host = this.getStringOption(line, HOST_SHORT, HOST, false)) != null) {
                cli.host = host;
            }
            if ((port = this.getIntOption(line, PORT_SHORT, PORT, false)) != null) {
                cli.port = port;
            }
            if ((target = this.getStringOption(line, TARGET_SHORT, TARGET, false)) != null) {
                cli.targetName = target;
            }
            if ((instance = this.getStringOption(line, TARGET_INSTANCE_SHORT, TARGET_INSTANCE, false)) != null) {
                cli.targetInstanceName = instance;
            }
            if (remote = this.getBooleanOption(line, REMOTE_SHORT, REMOTE)) {
                cli.remoteConnection = "true";
            }
            this.getOperation(line, cli);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.printUsage();
            System.exit(2);
        }
    }

    public String getStringOption(CommandLine line, String c, String opt, boolean required) throws Exception {
        String r = line.getOptionValue(c);
        if (r == null) {
            r = line.getOptionValue(opt);
        }
        if (required) {
            this.validateStringOption(r, opt);
        }
        return r;
    }

    public void validateStringOption(String param, String option) throws Exception {
        if (param == null) {
            throw new Exception("Invalid value for parameter " + option + "[" + param + "]. Parameter is required");
        }
    }

    public boolean getBooleanOption(CommandLine line, String c, String opt) {
        boolean hasOption = false;
        hasOption = line.hasOption(c);
        if (!hasOption) {
            hasOption = line.hasOption(opt);
        }
        return hasOption;
    }

    public String getIntOption(CommandLine line, String c, String opt, boolean required) throws Exception {
        String p = this.getStringOption(line, c, opt, required);
        if (p != null) {
            Integer.parseInt(p);
        }
        return p;
    }

    public void getOperation(CommandLine line, HL7CLI cli) {
        List argsList = line.getArgList();
        if (argsList != null && !argsList.isEmpty()) {
            this.operationName = (String)argsList.get(0);
            Operation op = (Operation)this.operations.get(this.operationName);
            if (op != null) {
                this.operation.copy(op);
                if (op.hasArgs()) {
                    for (int i = 1; i < argsList.size(); ++i) {
                        String arg = (String)argsList.get(i);
                        this.operation.addArg(arg);
                    }
                }
            } else {
                System.out.println(this.operationName + " not defined. Processing aborted!");
            }
        }
    }

    public void printUsage() {
        System.out.println("Usage: " + this.getClass().getSimpleName() + " [options] operation [args...]");
        System.out.println("\n where options include:");
        for (OptionData optionData : this.optionList) {
            System.out.println(optionData.printUsage());
        }
        System.out.println("\n where operations include:");
        for (Operation op : this.operations.values()) {
            System.out.println(op.printUsage());
        }
    }

    public Object execute(HL7CLI cli) {
        System.out.println(this.operation);
        if (this.operation.validate()) {
            HL7ManagementClient client = this.getClient(cli);
            HL7ManagementService service = client.getHL7ManagementService();
            Object result = null;
            try {
                if (GET_ENDPOINTS_METHOD_NAME.equals(this.operation.getMethodName())) {
                    String serviceUnit = this.operation.getArg(0);
                    result = service.getEndpoints(serviceUnit, cli.targetName, cli.targetInstanceName);
                } else if (LIST_ENDPOINTS_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.listEndpoints(cli.targetName, cli.targetInstanceName);
                } else if (LIST_ACTIVE_ENDPOINTS_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.listActiveEndpoints(cli.targetName, cli.targetInstanceName);
                } else if (LIST_INACTIVE_ENDPOINTS_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.listInactiveEndpoints(cli.targetName, cli.targetInstanceName);
                } else if (LIST_EXTERNAL_CONNECTIONS_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.listExternalSystemConnections(cli.targetName, cli.targetInstanceName);
                } else if (LIST_SERVICE_UNITS_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.listServiceUnits(cli.targetName, cli.targetInstanceName);
                } else if (GET_HL7_SERVERS_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.getHl7Servers(cli.targetName, cli.targetInstanceName);
                } else if (STATUS_EXTERNAL_CONNECTIONS_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    String serverLocation = cli.operation.getArg(0);
                    String serverPort = cli.operation.getArg(1);
                    result = service.getExternalSystemConnectionStatus(serverLocation, Long.parseLong(serverPort), cli.targetName, cli.targetInstanceName);
                } else if (SUSPEND_ENDPOINT_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    String endpoint = cli.operation.getArg(0);
                    result = service.suspend(endpoint, cli.targetName, cli.targetInstanceName);
                } else if (RESUME_ENDPOINT_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    String endpoint = cli.operation.getArg(0);
                    result = service.resume(endpoint, cli.targetName, cli.targetInstanceName);
                } else if (IS_ENDPOINT_ACTIVE_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    String endpoint = cli.operation.getArg(0);
                    result = service.isEndpointActive(endpoint, cli.targetName, cli.targetInstanceName);
                } else if (MESSAGE_SENT_TIMESTAMP_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.getMessageSentTimestamps(cli.targetName, cli.targetInstanceName);
                } else if (MESSAGE_RECEIVED_TIMESTAMP_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    result = service.getMessageReceivedTimestamps(cli.targetName, cli.targetInstanceName);
                } else if (SEQUENCE_NUMBER_METHOD_NAME.equals(cli.operation.getMethodName())) {
                    String endpoint = cli.operation.getArg(0);
                    result = service.getSequenceNumber(endpoint, cli.targetName, cli.targetInstanceName);
                } else if (cli.operation.getName() == null) {
                    System.out.println("Error: no operation specified. Please use the --help option to see usage.");
                } else {
                    System.out.println("Error: " + this.operation.getName() + " not supported.");
                }
                if (result != null) {
                    System.out.println("result:");
                    this.display(result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Error: validation failed! - see usage\n" + cli.operation.printUsage());
        }
        return "";
    }

    public void display(Object obj) {
        Displayer displayer = new Displayer();
        if (displayer != null) {
            displayer.display(obj);
        } else if (obj != null) {
            System.out.println("Displayer not found for:" + obj.getClass().getName());
            System.out.println(obj + "");
        }
    }

    public HL7ManagementClient getClient(HL7CLI cli) {
        HL7ManagementClient client = null;
        try {
            client = cli.remoteConnection != null ? HL7ManagementClientFactory.getInstance((String)cli.host, (int)Integer.parseInt(cli.port), (String)cli.user, (String)cli.password, (boolean)true) : HL7ManagementClientFactory.getInstance((String)cli.host, (int)Integer.parseInt(cli.port), (String)cli.user, (String)cli.password);
        }
        catch (Exception ex) {
            System.out.println("Exception in connecting to Runtime *******" + ex.getMessage());
        }
        return client;
    }

    public ObjectName getMBean() {
        ObjectName objName = null;
        try {
            objName = new ObjectName("com.sun.jbi:JbiName=server,CustomControlName=Administration,ComponentName=sun-hl7-binding,ControlType=Custom,ComponentType=Installed,InstalledType=Binding");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objName;
    }

    public static void main(String[] args) {
        String line = "";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                line = line + " " + args[i];
            }
        }
        try {
            HL7CLI cli = new HL7CLI();
            if (args.length < 1) {
                cli.printUsage();
                return;
            }
            line = cli.getClass().getName() + line;
            cli.parseArguments(cli, args);
            if (cli.help) {
                cli.printUsage();
                return;
            }
            cli.execute(cli);
        }
        catch (Exception e) {
            System.out.println("ERROR executing command:\n\n" + line + NEWLINE);
            System.out.println("ERROR:" + e.getMessage() + NEWLINE);
        }
    }
}

