/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.hl7.cli;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation {
    private String name;
    private String description;
    private String shortName;
    private String methodName;
    private boolean hasArgs = false;
    private List<String> args = new ArrayList<String>();
    private String usage;
    private int numberRequiredArgs;

    public Operation() {
    }

    public Operation(String name, String shortName, String description, String methodName, boolean hasArg, String usage, int numRequiredArgs) {
        this.name = name;
        this.shortName = shortName;
        this.description = description;
        this.methodName = methodName;
        this.hasArgs = hasArg;
        this.usage = usage;
        this.numberRequiredArgs = numRequiredArgs;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasArgs() {
        return this.hasArgs;
    }

    public void setHasArgs(boolean hasArg) {
        this.hasArgs = hasArg;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void addArg(String arg) {
        this.args.add(arg);
    }

    public String getArg(int index) {
        if (index < this.args.size()) {
            return this.args.get(index);
        }
        return null;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void copy(Operation op) {
        this.name = op.name;
        this.shortName = op.shortName;
        this.description = op.description;
        this.methodName = op.methodName;
        this.hasArgs = op.hasArgs;
        this.usage = op.usage;
    }

    public int getNumberRequiredArgs() {
        return this.numberRequiredArgs;
    }

    public void setNumberRequiredArgs(int numberRequiredArgs) {
        this.numberRequiredArgs = numberRequiredArgs;
    }

    public boolean validate() {
        return !this.hasArgs() || !this.args.isEmpty() && this.args.size() >= this.numberRequiredArgs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.args != null) {
            for (String arg : this.args) {
                sb.append(" " + arg);
            }
        }
        return "operation: " + this.name + sb.toString();
    }

    public String printUsage() {
        return "   " + this.usage + "\n" + "   " + "   " + this.description;
    }
}

