/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.hl7.mgmt.impl;

import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.Service;
import com.sun.esb.management.impl.configuration.ConfigurationServiceImpl;
import com.sun.jbi.hl7.mgmt.api.HL7ManagementService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HL7ManagementServiceImpl
implements HL7ManagementService,
Service {
    protected static final String SUSPEND_ENDPOINT = "suspend";
    protected static final String RESUME_ENDPOINT = "resume";
    protected static final String IS_ENDPOINT_ACTIVE = "isEndpointActive";
    protected static final String LIST_ENDPOINTS = "listEndpoints";
    protected static final String LIST_ACTIVE_ENDPOINTS = "listActiveEndpoints";
    protected static final String LIST_INACTIVE_ENDPOINTS = "listInactiveEndpoints";
    protected static final String LIST_SERVICE_UNITS = "listServiceUnits";
    protected static final String GET_EXTSYS_CONN_STATUS = "getExternalSystemConnStatus";
    protected static final String LIST_EXTSYS_CONNECTIONS = "listExternalSystemConnections";
    protected static final String GET_ENDPOINTS = "getEndpoints";
    protected static final String GET_SEQUENCE_NUMBER = "getSequenceNumber";
    protected static final String COMPONENT_NAME = "sun-hl7-binding";
    protected static final String CONN_MBEAN_PATTERN = "com.sun.jbi:JbiName=server,ComponentName=sun-hl7-binding,ControlType=Custom,ComponentType=Installed,InstalledType=Binding,CustomControlName=HL7Service-*";
    protected String targetName = "server";
    protected static final String ADMINISTRATION_KEY = "Administration";
    protected static final String HL7SERVICE = "HL7Service-";
    protected MBeanServerConnection connection;
    protected boolean isRemoteConnection;
    protected HL7ManagementServiceImpl serviceInstance = null;
    protected ConfigurationService configurationService;

    public HL7ManagementServiceImpl() {
    }

    public HL7ManagementServiceImpl(MBeanServerConnection theConnection, boolean isRemoteConnection) {
        this.connection = theConnection;
        this.isRemoteConnection = isRemoteConnection;
    }

    public HL7ManagementService getService(MBeanServerConnection connection, boolean isRemoteConnection) throws ManagementRemoteException {
        if (this.serviceInstance == null) {
            this.serviceInstance = new HL7ManagementServiceImpl(connection, isRemoteConnection);
        }
        return this.serviceInstance;
    }

    public ConfigurationService getConfigurationService() throws ManagementRemoteException {
        if (this.configurationService == null) {
            this.configurationService = new ConfigurationServiceImpl(this.connection, this.isRemoteConnection);
        }
        return this.configurationService;
    }

    @Override
    public boolean suspend(String consumingEndpointName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        Boolean resultObject = Boolean.TRUE;
        consumingEndpointName = this.stripQuotes(consumingEndpointName);
        ConfigurationService configurationService = this.getConfigurationService();
        Object[] params = new Object[]{consumingEndpointName};
        String[] signatures = new String[]{"java.lang.String"};
        Boolean result = (Boolean)configurationService.invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, SUSPEND_ENDPOINT, params, signatures, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public boolean resume(String consumingEndpointName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        Boolean resultObject = Boolean.TRUE;
        consumingEndpointName = this.stripQuotes(consumingEndpointName);
        Object[] params = new Object[]{consumingEndpointName};
        String[] signatures = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, RESUME_ENDPOINT, params, signatures, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public boolean isEndpointActive(String consumingEndpointName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        Boolean resultObject = Boolean.FALSE;
        Object[] params = new Object[]{consumingEndpointName};
        String[] signatures = new String[]{"java.lang.String"};
        resultObject = (Boolean)this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, IS_ENDPOINT_ACTIVE, params, signatures, targetName, targetInstanceName);
        return resultObject;
    }

    @Override
    public List<String> listActiveEndpoints(String targetName, String targetInstanceName) throws ManagementRemoteException {
        String[] endpoints = null;
        Object[] params = null;
        String[] signatures = null;
        endpoints = (String[])this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, LIST_ACTIVE_ENDPOINTS, params, signatures, targetName, targetInstanceName);
        ArrayList<String> endpointsList = new ArrayList<String>();
        if (endpoints != null) {
            for (String activeEndpoint : endpoints) {
                endpointsList.add("\"" + activeEndpoint + "\"");
            }
        }
        return endpointsList;
    }

    @Override
    public List<String> listInactiveEndpoints(String targetName, String targetInstanceName) throws ManagementRemoteException {
        String[] endpoints = null;
        Object[] params = null;
        String[] signatures = null;
        endpoints = (String[])this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, LIST_INACTIVE_ENDPOINTS, params, signatures, targetName, targetInstanceName);
        ArrayList<String> endpointsList = new ArrayList<String>();
        if (endpoints != null) {
            for (String activeEndpoint : endpoints) {
                endpointsList.add("\"" + activeEndpoint + "\"");
            }
        }
        return endpointsList;
    }

    @Override
    public List<String> getEndpoints(String serviceUnit, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ArrayList<String> endpointsList = new ArrayList<String>();
        Object[] params = new Object[]{serviceUnit};
        String[] signatures = null;
        List endpoints = (List)this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, GET_ENDPOINTS, params, signatures, targetName, targetInstanceName);
        if (endpoints != null) {
            for (String endpoint : endpoints) {
                endpointsList.add("\"" + endpoint + "\"");
            }
        }
        return endpointsList;
    }

    @Override
    public List<String> listEndpoints(String targetName, String targetInstanceName) throws ManagementRemoteException {
        ArrayList<String> endpointsList = new ArrayList<String>();
        Object[] params = null;
        String[] signatures = null;
        List endpoints = (List)this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, LIST_ENDPOINTS, params, signatures, targetName, targetInstanceName);
        if (endpoints != null) {
            for (String endpoint : endpoints) {
                endpointsList.add("\"" + endpoint + "\"");
            }
        }
        return endpointsList;
    }

    @Override
    public List<String> getHl7Servers(String targetName, String targetInstanceName) throws ManagementRemoteException {
        ArrayList<String> servers = new ArrayList<String>();
        try {
            String pattern = CONN_MBEAN_PATTERN;
            Set<ObjectName> objNames = this.connection.queryNames(new ObjectName(pattern), null);
            for (ObjectName objName : objNames) {
                String prop = objName.getKeyProperty("CustomControlName");
                String[] tokens = prop.split("-");
                if (tokens == null) continue;
                String server = tokens[1] + " " + tokens[2];
                servers.add(server);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return servers;
    }

    @Override
    public ConcurrentHashMap<String, String> getExternalSystemConnectionStatus(String serverLocation, long serverPort, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ConcurrentHashMap extSystemConnections = new ConcurrentHashMap();
        try {
            String objName = "com.sun.jbi:JbiName=server,ComponentName=sun-hl7-binding,ControlType=Custom,ComponentType=Installed,InstalledType=Binding,CustomControlName=HL7Service-" + serverLocation + "-" + serverPort;
            Object[] params = null;
            String[] sigs = null;
            extSystemConnections = (ConcurrentHashMap)this.connection.invoke(new ObjectName(objName), GET_EXTSYS_CONN_STATUS, params, sigs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extSystemConnections;
    }

    @Override
    public ConcurrentHashMap<String, String> getMessageReceivedTimestamps(String targetName, String targetInstanceName) throws ManagementRemoteException {
        ConcurrentHashMap<String, String> msgTimestamps = new ConcurrentHashMap<String, String>();
        try {
            String pattern = CONN_MBEAN_PATTERN;
            Set<ObjectName> objNames = this.connection.queryNames(new ObjectName(pattern), null);
            for (ObjectName objName : objNames) {
                String[] sigs;
                Object[] params;
                Map map = (Map)this.connection.invoke(objName, "getMessageReceivedTimeStamp", params = null, sigs = null);
                if (map == null) continue;
                msgTimestamps.putAll(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgTimestamps;
    }

    @Override
    public ConcurrentHashMap<String, String> getMessageSentTimestamps(String targetName, String targetInstanceName) throws ManagementRemoteException {
        ConcurrentHashMap<String, String> msgTimestamps = new ConcurrentHashMap<String, String>();
        try {
            String pattern = CONN_MBEAN_PATTERN;
            Set<ObjectName> objNames = this.connection.queryNames(new ObjectName(pattern), null);
            for (ObjectName objName : objNames) {
                String[] sigs;
                Object[] params;
                Map map = (Map)this.connection.invoke(objName, "getACKMessageSentTimeStamp", params = null, sigs = null);
                if (map == null) continue;
                msgTimestamps.putAll(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgTimestamps;
    }

    @Override
    public long getSequenceNumber(String serviceUnit, String targetName, String targetInstanceName) throws ManagementRemoteException {
        long seqno = -1L;
        Object[] params = new Object[]{serviceUnit};
        String[] signatures = new String[]{"java.lang.String"};
        seqno = (Long)this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, GET_SEQUENCE_NUMBER, params, signatures, targetName, targetInstanceName);
        return seqno;
    }

    @Override
    public List<String> listExternalSystemConnections(String targetName, String targetInstanceName) throws ManagementRemoteException {
        ArrayList<String> extSystemConnections = new ArrayList<String>();
        try {
            String pattern = CONN_MBEAN_PATTERN;
            Set<ObjectName> objNames = this.connection.queryNames(new ObjectName(pattern), null);
            for (ObjectName objName : objNames) {
                String[] sigs;
                Object[] params;
                Map map = (Map)this.connection.invoke(objName, GET_EXTSYS_CONN_STATUS, params = null, sigs = null);
                if (map == null) continue;
                for (String clientId : map.keySet()) {
                    extSystemConnections.add(clientId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extSystemConnections;
    }

    @Override
    public List<String> listServiceUnits(String targetName, String targetInstanceName) throws ManagementRemoteException {
        Object[] params = null;
        String[] signatures = null;
        List serviceUnits = (List)this.getConfigurationService().invokeExtensionMBeanOperation(COMPONENT_NAME, ADMINISTRATION_KEY, LIST_SERVICE_UNITS, params, signatures, targetName, targetInstanceName);
        return serviceUnits;
    }

    private String stripQuotes(String str) {
        return str.replaceAll("\"", "");
    }
}

