/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.File;
import java.util.Map;

public abstract class FileQuestion
extends Question {
    protected File value;
    protected File[] suggestions;
    private File defaultValue;
    private File baseDir;
    private boolean baseRelativeOnly;
    private FileFilter[] filters;

    protected FileQuestion(Interview interview, String tag) {
        super(interview, tag);
        if (interview.getInterviewSemantics() > 0) {
            this.clear();
        }
        this.setDefaultValue(this.value);
    }

    public File[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(File[] newSuggestions) {
        if (newSuggestions != null) {
            for (int i = 0; i < newSuggestions.length; ++i) {
                if (newSuggestions[i] != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.suggestions = newSuggestions;
    }

    public File getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(File v) {
        this.defaultValue = v;
    }

    public File getValue() {
        return this.value;
    }

    public File getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        return this.value == null ? null : this.value.getPath();
    }

    public void setValue(String path) {
        this.setValue(path == null ? (File)null : new File(path));
    }

    public void setValue(File newValue) {
        File oldValue = this.value;
        this.value = newValue;
        if (!FileQuestion.equal(this.value, oldValue)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public FileFilter[] getFilters() {
        return this.filters;
    }

    public void setFilter(FileFilter filter) {
        this.filters = new FileFilter[]{filter};
    }

    public void setFilters(FileFilter[] filters) {
        this.filters = filters;
    }

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public void setBaseDirectory(File dir) {
        this.baseDir = dir;
    }

    public boolean isBaseRelativeOnly() {
        return this.baseRelativeOnly;
    }

    public void setBaseRelativeOnly(boolean b) {
        this.baseRelativeOnly = b;
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map data) {
        Object o = data.get(this.tag);
        if (o instanceof File) {
            this.setValue((File)o);
        } else if (o instanceof String) {
            this.setValue(new File((String)o));
        }
    }

    protected void save(Map data) {
        if (this.value != null) {
            data.put(this.tag, this.value.toString());
        }
    }

    protected static boolean equal(File f1, File f2) {
        return f1 == null ? f2 == null : f1.equals(f2);
    }
}

