/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class EditableList
extends JPanel {
    private boolean duplicatesAllowed;
    private Listener listener = new Listener();
    private Renderer renderer = new Renderer();
    private DefaultListModel listModel;
    private JList list;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton upBtn;
    private JButton downBtn;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public EditableList(String uiKey, Object[] items) {
        this.setLayout(new BorderLayout());
        this.setName(uiKey);
        this.setFocusable(false);
        this.listModel = new DefaultListModel();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.listModel.addElement(items[i]);
            }
        }
        this.list = new JList(this.listModel);
        this.list.setName(uiKey);
        this.list.setToolTipText(i18n.getString(uiKey + ".tip"));
        this.list.getAccessibleContext().setAccessibleName(this.list.getName());
        this.list.getAccessibleContext().setAccessibleDescription(this.list.getToolTipText());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this.renderer);
        this.list.addListSelectionListener(this.listener);
        this.list.addMouseListener(this.listener);
        this.list.setVisibleRowCount(5);
        JScrollPane sp = new JScrollPane(this.list);
        sp.setName(uiKey + ".sp");
        sp.setFocusable(false);
        this.add((Component)sp, "Center");
        JToolBar bar = new JToolBar(1);
        bar.setName(uiKey + "bar");
        bar.setFocusable(false);
        bar.setFloatable(false);
        this.addBtn = this.createButton("elst.add");
        bar.add(this.addBtn);
        this.removeBtn = this.createButton("elst.remove");
        bar.add(this.removeBtn);
        this.upBtn = this.createButton("elst.up");
        bar.add(this.upBtn);
        this.downBtn = this.createButton("elst.down");
        bar.add(this.downBtn);
        this.add((Component)bar, "East");
        this.updateButtons();
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public int getItemCount() {
        return this.listModel.getSize();
    }

    public Object getItem(int index) {
        return this.listModel.elementAt(index);
    }

    public Object[] getItems() {
        return this.listModel.toArray();
    }

    public Object[] getItems(Class c) {
        Object[] items = (Object[])Array.newInstance(c, this.listModel.size());
        this.listModel.copyInto(items);
        return items;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.list.getSelectedValue();
    }

    public void setSelectedItem(Object item) {
        this.list.setSelectedValue(item, true);
    }

    public void addListDataListener(ListDataListener l) {
        this.listModel.addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listModel.removeListDataListener(l);
    }

    public void setDuplicatesAllowed(boolean b) {
        this.duplicatesAllowed = b;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    protected Object getDisplayValue(Object item) {
        return item;
    }

    protected Object getNewItem() {
        return JOptionPane.showInputDialog(this, (Object)i18n.getString("elst.add.title"));
    }

    protected Object getNewItem(Object oldItem) {
        return JOptionPane.showInputDialog(this, i18n.getString("elst.change.title"), oldItem);
    }

    protected void itemsChanged() {
    }

    protected void selectedItemChanged() {
    }

    protected void insertItem() {
        Object newItem = this.getNewItem();
        if (!this.duplicatesAllowed && this.listModel.contains(newItem)) {
            this.showDuplicateError(newItem);
            return;
        }
        if (newItem != null) {
            if (this.list.isSelectionEmpty()) {
                this.listModel.addElement(newItem);
            } else {
                this.listModel.add(1 + this.list.getSelectedIndex(), newItem);
            }
            this.list.setSelectedValue(newItem, true);
        }
    }

    protected void removeSelectedItem() {
        if (!this.list.isSelectionEmpty()) {
            this.listModel.remove(this.list.getSelectedIndex());
        }
    }

    protected void moveSelectedItemUp() {
        int i;
        if (!this.list.isSelectionEmpty() && (i = this.list.getSelectedIndex()) > 0) {
            this.swap(i, i - 1);
            this.list.setSelectedIndex(i - 1);
        }
    }

    private void moveSelectedItemDown() {
        int i;
        if (!this.list.isSelectionEmpty() && (i = this.list.getSelectedIndex()) + 1 < this.listModel.size()) {
            this.swap(i, i + 1);
            this.list.setSelectedIndex(i + 1);
        }
    }

    private void editItem(int index) {
        Object newItem = this.getNewItem(this.listModel.getElementAt(index));
        if (!this.duplicatesAllowed && this.listModel.contains(newItem)) {
            this.showDuplicateError(newItem);
            return;
        }
        if (newItem != null) {
            this.listModel.set(index, newItem);
        }
    }

    protected JButton createButton(String uiKey) {
        JButton b = new JButton(i18n.getString(uiKey + ".btn"));
        b.setName(uiKey);
        b.setToolTipText(i18n.getString(uiKey + ".tip"));
        b.setMnemonic(i18n.getString(uiKey + ".mne").charAt(0));
        b.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        b.addActionListener(this.listener);
        return b;
    }

    private void showDuplicateError(Object item) {
        String text = MessageFormat.format(i18n.getString("elst.duplicate.text"), this.getDisplayValue(item));
        String title = i18n.getString("elst.duplicate.title");
        JOptionPane.showMessageDialog(this, text, title, 1);
    }

    private void updateButtons() {
        if (this.list.isSelectionEmpty()) {
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else {
            this.removeBtn.setEnabled(true);
            int i = this.list.getSelectedIndex();
            this.upBtn.setEnabled(i > 0);
            this.downBtn.setEnabled(i + 1 < this.listModel.size());
        }
    }

    private void swap(int i1, int i2) {
        Object o1 = this.listModel.elementAt(i1);
        Object o2 = this.listModel.elementAt(i2);
        this.listModel.set(i1, o2);
        this.listModel.set(i2, o1);
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == EditableList.this.addBtn) {
                EditableList.this.insertItem();
            } else if (src == EditableList.this.removeBtn) {
                EditableList.this.removeSelectedItem();
            } else if (src == EditableList.this.upBtn) {
                EditableList.this.moveSelectedItemUp();
            } else if (src == EditableList.this.downBtn) {
                EditableList.this.moveSelectedItemDown();
            }
            EditableList.this.itemsChanged();
            EditableList.this.updateButtons();
        }

        public void valueChanged(ListSelectionEvent e) {
            EditableList.this.selectedItemChanged();
            EditableList.this.updateButtons();
        }

        public void mouseClicked(MouseEvent e) {
            int index;
            if (e.getClickCount() == 2 && (index = EditableList.this.list.locationToIndex(e.getPoint())) != -1) {
                EditableList.this.editItem(index);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, EditableList.this.getDisplayValue(value), index, isSelected, cellHasFocus);
        }
    }
}

