/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FloatQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

class FloatQuestionRenderer
implements QuestionRenderer {
    private float lwb;
    private float upb;
    private float resolution;
    private float value;
    private float range;
    private float[] suggs;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    FloatQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        FloatQuestion q = (FloatQuestion)qq;
        this.lwb = q.getLowerBound();
        this.upb = q.getUpperBound();
        this.resolution = q.getResolution();
        this.value = q.getValue();
        this.range = this.upb - this.lwb;
        this.suggs = q.getSuggestions();
        return this.createTextField(q, listener);
    }

    public String getInvalidValueMessage(Question q) {
        return null;
    }

    private JPanel createTextField(FloatQuestion q, ActionListener listener) {
        JButton resetBtn;
        String[] strSuggs;
        int w = 1;
        while (this.range >= 10.0f) {
            this.range /= 10.0f;
            ++w;
        }
        if (this.lwb < 0.0f) {
            ++w;
        }
        w += 5;
        w = Math.min(w, 20);
        if (this.suggs == null) {
            strSuggs = null;
        } else {
            strSuggs = new String[this.suggs.length];
            for (int i = 0; i < this.suggs.length; ++i) {
                strSuggs[i] = String.valueOf(this.suggs[i]);
            }
        }
        final float defVal = q.getDefaultValue();
        if (Float.isNaN(defVal)) {
            resetBtn = null;
        } else {
            resetBtn = new JButton(i18n.getString("flt.reset.btn"));
            resetBtn.setName("flt.reset.btn");
            resetBtn.setMnemonic(i18n.getString("flt.reset.mne").charAt(0));
            resetBtn.setToolTipText(i18n.getString("flt.reset.tip"));
        }
        final TypeInPanel p = new TypeInPanel("flt.field", q, w, strSuggs, resetBtn, listener);
        if (resetBtn != null) {
            resetBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NumberFormat fmt = NumberFormat.getNumberInstance();
                    p.setValue(fmt.format(new Double(defVal)));
                }
            });
        }
        return p;
    }

    private JPanel createSlider(final FloatQuestion q, ActionListener listener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("flt");
        panel.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(i18n.getString("flt.sldr.lbl"));
        label.setName("flt.sldr.lbl");
        label.setDisplayedMnemonic(i18n.getString("flt.sldr.mne").charAt(0));
        label.setToolTipText(i18n.getString("flt.sldr.tip"));
        panel.add((Component)label, c);
        int iMax = (int)((this.upb - this.lwb) / this.resolution);
        int iVal = (int)((this.value - this.lwb) / this.resolution);
        final JSlider slider = new JSlider(0, iMax, iVal);
        slider.setName("flt");
        slider.getAccessibleContext().setAccessibleName(slider.getName());
        slider.getAccessibleContext().setAccessibleDescription(slider.getToolTipText());
        slider.setMajorTickSpacing(iMax / 2);
        slider.setMinorTickSpacing(Math.max((int)(1.0f / this.resolution), 1));
        slider.setSnapToTicks(true);
        slider.setPaintTicks(true);
        float startHint = q.getLabelStartHint();
        float incHint = q.getLabelIncrementHint();
        int iStartHint = (int)((startHint - this.lwb) / this.resolution);
        int iIncHint = (int)(incHint / this.resolution);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        for (int i = iStartHint; i < iMax; i += iIncHint) {
            float f = this.lwb + (float)i * this.resolution;
            String s = f == (float)((int)f) ? String.valueOf((int)f) : String.valueOf(f);
            labels.put(new Integer(i), new JLabel(s));
        }
        slider.setLabelTable(labels);
        slider.setPaintLabels(true);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)slider, c);
        Runnable valueSaver = new Runnable(){

            public void run() {
                int i = slider.getValue();
                q.setValue(FloatQuestionRenderer.this.lwb + (float)i * FloatQuestionRenderer.this.resolution);
            }
        };
        panel.putClientProperty("valueSaver", valueSaver);
        return panel;
    }
}

