/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.InetAddressQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Keymap;

class InetAddressQuestionRenderer
implements QuestionRenderer {
    private JOptionPane lookupPane;
    private static final KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static Color INVALID_VALUE_COLOR = i18n.getErrorColor();

    InetAddressQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        InetAddressQuestion q = (InetAddressQuestion)qq;
        int type = q.getType();
        int style = q.getStyle();
        InetAddress[] suggestions = q.getSuggestions();
        if (type == 0 && style == 0 && suggestions == null) {
            return this.createIPv4Panel(q, listener);
        }
        return this.createIPv6Panel(q, listener);
    }

    private JPanel createIPv4Panel(final InetAddressQuestion q, ActionListener listener) {
        InetAddress v = q.getValue();
        byte[] addr = v == null ? new byte[4] : v.getAddress();
        final JTextField[] fields = new JTextField[4];
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JTextField src = (JTextField)e.getSource();
                JTextField next = (JTextField)src.getClientProperty("next");
                String cmd = e.getActionCommand();
                if (cmd.equals(".")) {
                    if (next != null) {
                        next.requestFocus();
                        next.getCaret().setDot(0);
                        next.getCaret().moveDot(next.getText().length());
                        return;
                    }
                } else if (Character.isDigit(cmd.charAt(0))) {
                    int savedDot = src.getCaret().getDot();
                    int savedMark = src.getCaret().getMark();
                    String savedText = src.getText();
                    DefaultEditorKit.InsertContentAction delegate = new DefaultEditorKit.InsertContentAction();
                    delegate.actionPerformed(e);
                    String newText = src.getText();
                    int newValue = Integer.parseInt(newText);
                    if (newText.length() <= 3 && newValue <= 255) {
                        if (src.getCaretPosition() == 3 && next != null) {
                            next.requestFocus();
                            next.getCaret().setDot(0);
                            next.getCaret().moveDot(next.getText().length());
                        }
                        return;
                    }
                    src.setText(savedText);
                    src.getCaret().setDot(savedMark);
                    src.getCaret().moveDot(savedDot);
                } else if (cmd.charAt(0) == '\n') {
                    return;
                }
                fields[0].getToolkit().beep();
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("inet");
        panel.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        for (int i = 0; i < 4; ++i) {
            String lblKey = i == 0 ? "inet.ip" : "inet.dot";
            JLabel label = new JLabel(i18n.getString(lblKey + ".lbl"));
            label.setDisplayedMnemonic(i == 0 ? (int)i18n.getString(lblKey + ".mne").charAt(0) : 48 + i);
            label.setToolTipText(i18n.getString(lblKey + ".tip"));
            panel.add((Component)label, c);
            int b = addr[i];
            JTextField field = new JTextField(String.valueOf(b < 0 ? b + 256 : b), 3);
            field.setName("inet." + i);
            field.setToolTipText(i18n.getString("inet.field.tip", new Integer(i)));
            field.getDocument().addDocumentListener(new ActionDocListener(field, listener, "edited"));
            Keymap keymap = JTextField.addKeymap("IP field", field.getKeymap());
            keymap.setDefaultAction(action);
            field.setKeymap(keymap);
            label.setLabelFor(field);
            if (i == 3) {
                c.weightx = 1.0;
                c.anchor = 17;
            }
            panel.add((Component)field, c);
            if (i > 0) {
                fields[i - 1].putClientProperty("next", field);
            }
            fields[i] = field;
        }
        Runnable valueSaver = new Runnable(){

            public void run() {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < 4; ++i) {
                    String s = fields[i].getText();
                    if (s == null || s.length() == 0) {
                        sb.append("0");
                    } else {
                        sb.append(s);
                    }
                    if (i >= 3) continue;
                    sb.append(".");
                }
                try {
                    InetAddress a = InetAddress.getByName(sb.toString());
                    q.setValue(a);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        };
        panel.putClientProperty("valueSaver", valueSaver);
        return panel;
    }

    private JPanel createIPv6Panel(InetAddressQuestion q, ActionListener listener) {
        String[] ss;
        InetAddress[] suggestions = q.getSuggestions();
        if (suggestions == null) {
            ss = null;
        } else {
            ss = new String[suggestions.length];
            for (int i = 0; i < suggestions.length; ++i) {
                InetAddress sugg = suggestions[i];
                ss[i] = sugg == null ? "" : sugg.getHostAddress();
            }
        }
        JButton lookupBtn = new JButton(i18n.getString("inet.lookup.btn"));
        lookupBtn.setName("inet.lookup.btn");
        lookupBtn.setMnemonic(i18n.getString("inet.lookup.mne").charAt(0));
        lookupBtn.setToolTipText(i18n.getString("inet.lookup.tip"));
        int type = q.getType();
        int width = type == 0 ? 16 : 0;
        final TypeInPanel p = new TypeInPanel("inet", q, width, ss, lookupBtn, listener);
        this.lookupPane = new LookupPane(type);
        lookupBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog d = InetAddressQuestionRenderer.this.lookupPane.createDialog(p, i18n.getString("inet.lookup.title"));
                d.setVisible(true);
                p.setValue((String)InetAddressQuestionRenderer.this.lookupPane.getValue());
            }
        });
        return p;
    }

    public String getInvalidValueMessage(Question q) {
        return null;
    }

    private class LookupPane
    extends JOptionPane
    implements ActionListener,
    DocumentListener,
    ListSelectionListener {
        private int type;
        private JTextField nameField;
        private JTextField errorField;
        private DefaultListModel listModel;
        private JList list;
        private JButton okBtn;
        private static final String LOOKUP = "lookup";
        private static final String OK = "ok";
        private static final String CANCEL = "cancel";

        LookupPane(int type) {
            super(new JPanel(new GridBagLayout()));
            this.setMessageType(3);
            this.type = type;
            JPanel msgPanel = (JPanel)this.getMessage();
            GridBagConstraints c = new GridBagConstraints();
            JLabel lbl = new JLabel(i18n.getString("inet.lookup.name.lbl"));
            lbl.setDisplayedMnemonic(i18n.getString("inet.lookup.name.mne").charAt(0));
            c.insets.right = 5;
            msgPanel.add((Component)lbl, c);
            this.nameField = new JTextField(16);
            this.nameField.setActionCommand(LOOKUP);
            this.nameField.addActionListener(this);
            lbl.setLabelFor(this.nameField);
            c.insets.right = 0;
            c.weightx = 1.0;
            msgPanel.add((Component)this.nameField, c);
            String r = i18n.getString("inet.lookup.icon");
            URL url = this.getClass().getResource(r);
            JButton lookupBtn = url == null ? new JButton(r) : new JButton(new ImageIcon(url));
            lookupBtn.setActionCommand(LOOKUP);
            lookupBtn.addActionListener(this);
            c.weightx = 0.0;
            c.insets.left = 5;
            c.gridwidth = 0;
            msgPanel.add((Component)lookupBtn, c);
            this.errorField = new JTextField(16);
            this.errorField.setName("inet.lookup.error");
            this.errorField.setEditable(false);
            this.errorField.setBorder(null);
            this.errorField.setFont(this.errorField.getFont().deriveFont(1));
            this.errorField.setForeground(INVALID_VALUE_COLOR);
            c.fill = 2;
            c.insets.left = 0;
            c.weightx = 1.0;
            msgPanel.add((Component)this.errorField, c);
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.setVisibleRowCount(3);
            this.list.setSelectionMode(0);
            this.list.addListSelectionListener(this);
            c.fill = 1;
            c.weightx = 1.0;
            msgPanel.add((Component)new JScrollPane(this.list), c);
            this.okBtn = new JButton(i18n.getString("inet.lookup.ok.btn"));
            this.okBtn.setActionCommand(OK);
            this.okBtn.setEnabled(false);
            this.okBtn.addActionListener(this);
            JButton cancelBtn = new JButton(i18n.getString("inet.lookup.cancel.btn"));
            cancelBtn.setActionCommand(OK);
            cancelBtn.addActionListener(this);
            this.setOptions(new Object[]{this.okBtn, cancelBtn});
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(LOOKUP)) {
                String name = this.nameField.getText();
                if (name == null || name.length() == 0) {
                    this.errorField.setText(i18n.getString("inet.lookup.noName.err"));
                } else {
                    InetAddress[] addrs;
                    try {
                        addrs = InetAddress.getAllByName(name);
                    }
                    catch (UnknownHostException ex) {
                        addrs = null;
                    }
                    this.listModel.clear();
                    if (addrs == null || addrs.length == 0) {
                        this.errorField.setText(i18n.getString("inet.lookup.notFound.err"));
                    } else {
                        this.errorField.setText("");
                        for (int i = 0; i < addrs.length; ++i) {
                            this.listModel.addElement(addrs[i].getHostAddress());
                        }
                        this.list.setSelectedIndex(0);
                    }
                }
            } else if (cmd.equals(OK)) {
                this.setValue(this.list.getSelectedValue());
                SwingUtilities.getRoot(this).setVisible(false);
            } else if (cmd.equals(CANCEL)) {
                this.setValue(null);
                SwingUtilities.getRoot(this).setVisible(false);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.errorField.setText("");
        }

        public void valueChanged(ListSelectionEvent e) {
            this.okBtn.setEnabled(this.list.getSelectedValue() != null);
        }
    }
}

