/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class StringQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    StringQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question q, ActionListener listener) {
        StringQuestion sq = (StringQuestion)q;
        String[] suggestions = sq.getSuggestions();
        int nomMaxLen = sq.getNominalMaxLength();
        if (nomMaxLen > 80) {
            return this.createTextArea(sq, listener);
        }
        return this.createTypeInPanel(sq, listener);
    }

    public String getInvalidValueMessage(Question q) {
        return null;
    }

    private JPanel createTextArea(final StringQuestion q, ActionListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setName("str");
        panel.setFocusable(false);
        JLabel label = new JLabel(i18n.getString("str.area.lbl"));
        label.setName("str.area.lbl");
        label.setDisplayedMnemonic(i18n.getString("str.area.mne").charAt(0));
        label.setToolTipText(i18n.getString("str.area.tip"));
        panel.add((Component)label, "North");
        final JTextArea textArea = new JTextArea(q.getValue());
        textArea.setName("str");
        textArea.setLineWrap(true);
        textArea.getDocument().addDocumentListener(new ActionDocListener(textArea, listener, "edited"));
        textArea.setToolTipText(label.getToolTipText());
        label.setLabelFor(textArea);
        JScrollPane sp = new JScrollPane(textArea);
        sp.setName("str.sp");
        sp.setFocusable(false);
        panel.add((Component)sp, "Center");
        Runnable valueSaver = new Runnable(){

            public void run() {
                q.setValue(textArea.getText());
            }
        };
        panel.putClientProperty("valueSaver", valueSaver);
        return panel;
    }

    private JPanel createTypeInPanel(StringQuestion q, ActionListener listener) {
        return new TypeInPanel("str", q, q.getNominalMaxLength(), q.getSuggestions(), null, listener);
    }
}

