/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class CompositeFilter
extends TestFilter {
    private TestFilter[] filters;
    private String description;
    private String name;
    private String reason;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(CompositeFilter.class);

    public CompositeFilter(TestFilter[] filters, I18NResourceBundle bundle, String prefix) {
        this.filters = filters;
        this.description = bundle.getString(prefix + ".description");
        this.name = bundle.getString(prefix + ".name");
        this.reason = bundle.getString(prefix + ".reason");
        if (this.description == null) {
            this.description = i18n.getString("compFilter.unset.description");
        }
        if (this.name == null) {
            this.name = i18n.getString("compFilter.unset.name");
        }
        if (this.reason == null) {
            this.reason = i18n.getString("compFilter.unset.reason");
        }
    }

    public CompositeFilter(TestFilter[] filters) {
        if (filters == null) {
            throw new NullPointerException();
        }
        this.filters = filters;
    }

    public String getName() {
        if (this.name == null) {
            return i18n.getString("compFilter.name");
        }
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            return i18n.getString("compFilter.description");
        }
        return this.description;
    }

    public String getReason() {
        if (this.reason == null) {
            return i18n.getString("compFilter.reason");
        }
        return this.reason;
    }

    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        if (this.filters == null || this.filters.length == 0) {
            return true;
        }
        try {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].accepts(td)) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException e) {
            throw new TestFilter.Fault(i18n, "compFilter.exception", e);
        }
    }

    public boolean accepts(TestDescription td, TestFilter.Observer o) throws TestFilter.Fault {
        if (this.filters == null || this.filters.length == 0) {
            return true;
        }
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i].accepts(td, o)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object tf) {
        if (tf == null) {
            return false;
        }
        if (!(tf instanceof CompositeFilter)) {
            return false;
        }
        TestFilter[] thoseFilters = ((CompositeFilter)tf).getFilters();
        if ((this.filters == null || this.filters.length == 0) && thoseFilters.length == 0) {
            return true;
        }
        if (this.filters.length != thoseFilters.length) {
            return false;
        }
        return CompositeFilter.equals(this.filters, thoseFilters);
    }

    public TestFilter[] getFilters() {
        if (this.filters == null) {
            return new TestFilter[0];
        }
        TestFilter[] copy = new TestFilter[this.filters.length];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        return copy;
    }

    public static boolean equals(TestFilter[] array1, TestFilter[] array2) {
        List<TestFilter> list1 = Arrays.asList(array1);
        List<TestFilter> list2 = Arrays.asList(array2);
        HashSet<TestFilter> set1 = new HashSet<TestFilter>(list1);
        HashSet<TestFilter> set2 = new HashSet<TestFilter>(list2);
        return set1.equals(set2);
    }
}

