/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.AllKeywords;
import com.sun.javatest.AnyKeywords;
import com.sun.javatest.ExprParser;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class Keywords {
    public static final String ALL_OF = "all of";
    public static final String ANY_OF = "any of";
    public static final String EXPR = "expr";
    static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Keywords.class);

    public static Keywords create(String type, String text) throws Fault {
        return Keywords.create(type, text, null);
    }

    public static Keywords create(String type, String text, Set validKeywords) throws Fault {
        Set lowerCaseValidKeywords = Keywords.toLowerCase(validKeywords);
        if (type == null || type.equals("ignore")) {
            return null;
        }
        if (type.equals(ALL_OF)) {
            return new AllKeywords(StringArray.split(text), lowerCaseValidKeywords);
        }
        if (type.equals(ANY_OF)) {
            return new AnyKeywords(StringArray.split(text), lowerCaseValidKeywords);
        }
        if (type.equals(EXPR)) {
            ExprParser p = new ExprParser(text, lowerCaseValidKeywords);
            return p.parse();
        }
        throw new Fault(i18n, "kw.badKeywordType", type);
    }

    public static void setAllowNumericKeywords(boolean allowNumericKeywords) {
        ExprParser.allowNumericKeywords = allowNumericKeywords;
    }

    public abstract boolean accepts(Set var1);

    private static Set toLowerCase(Set words) {
        boolean allLowerCase;
        String word;
        if (words == null) {
            return null;
        }
        Iterator iter = words.iterator();
        for (allLowerCase = true; iter.hasNext() && allLowerCase; allLowerCase &= word.equals(word.toLowerCase())) {
            word = (String)iter.next();
        }
        if (allLowerCase) {
            return words;
        }
        HashSet<String> s = new HashSet<String>();
        for (String word2 : words) {
            s.add(word2.toLowerCase());
        }
        return s;
    }

    private static boolean isLowerCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }
}

