/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.WorkDirectory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class LastRunInfo {
    private String configName;
    private long startTime;
    private long finishTime;
    private static final String FILENAME = "lastRun.txt";
    private static final String START = "startTime";
    private static final String FINISH = "finishTime";
    private static final String CONFIG = "configName";

    private LastRunInfo() {
    }

    private LastRunInfo(WorkDirectory wd) throws IOException {
        this();
        FileInputStream in = new FileInputStream(wd.getSystemFile(FILENAME));
        Properties p = new Properties();
        p.load(in);
        String val = p.getProperty(START);
        try {
            this.startTime = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        val = p.getProperty(FINISH);
        try {
            this.finishTime = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.configName = p.getProperty(CONFIG);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public Date getStartDate() {
        return new Date(this.startTime);
    }

    public Date getFinishDate() {
        return new Date(this.finishTime);
    }

    public String getConfigName() {
        return this.configName;
    }

    public static LastRunInfo readInfo(WorkDirectory wd) throws IOException {
        return new LastRunInfo(wd);
    }

    public static void writeInfo(WorkDirectory workdir, long start, long stop, String config) throws IOException {
        Properties p = new Properties();
        p.setProperty(CONFIG, config);
        p.setProperty(START, Long.toString(start));
        p.setProperty(FINISH, Long.toString(stop));
        FileOutputStream out = new FileOutputStream(workdir.getSystemFile(FILENAME));
        p.store(out, "Last test run info");
    }
}

