/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TestEnvironment {
    static String[] defaultPropTableNames = new String[0];
    static Map[] defaultPropTables = new Map[0];
    private String name;
    private String[] inherits;
    private HashMap table = new HashMap();
    private HashMap extras = new HashMap();
    private HashMap cache = new HashMap();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestEnvironment.class);

    public static synchronized void addDefaultPropTable(String name, Map propTable) {
        if (name == null || propTable == null) {
            throw new NullPointerException();
        }
        defaultPropTableNames = (String[])DynamicArray.append(defaultPropTableNames, name);
        defaultPropTables = (Map[])DynamicArray.append(defaultPropTables, propTable);
    }

    public static synchronized void clearDefaultPropTables() {
        defaultPropTableNames = new String[0];
        defaultPropTables = new Map[0];
    }

    public TestEnvironment(String name, Map propTable, String propTableName) throws Fault {
        this(name, new Map[]{propTable}, new String[]{propTableName});
    }

    public TestEnvironment(String name, Map[] propTables, String[] propTableNames) throws Fault {
        this.name = name;
        if (defaultPropTables != null && defaultPropTables.length > 0) {
            propTables = (Map[])DynamicArray.join(defaultPropTables, propTables);
            propTableNames = (String[])DynamicArray.join(defaultPropTableNames, propTableNames);
        }
        Vector<String> v = new Vector<String>();
        String n = name;
        String inherit = null;
        while (n != null && n.length() > 0) {
            if (v.contains(n)) {
                throw new Fault(i18n, "env.loop", name);
            }
            v.addElement(n);
            String prefix = "env." + n + ".";
            for (int i = propTables.length - 1; i >= 0 && inherit == null; --i) {
                inherit = (String)propTables[i].get("env." + n + ".inherits");
            }
            n = inherit;
            inherit = null;
        }
        this.inherits = new String[v.size()];
        v.copyInto(this.inherits);
        for (int inheritIndex = 0; inheritIndex < this.inherits.length; ++inheritIndex) {
            String prefix = "env." + this.inherits[inheritIndex] + ".";
            for (int propIndex = propTables.length - 1; propIndex >= 0; --propIndex) {
                Map propTable = propTables[propIndex];
                for (String prop : propTable.keySet()) {
                    String key;
                    if (!prop.startsWith(prefix) || this.table.containsKey(key = prop.substring(prefix.length()))) continue;
                    Element elem = new Element(key, (String)propTable.get(prop), this.inherits[inheritIndex], propTableNames[propIndex]);
                    this.table.put(key, elem);
                }
            }
        }
        for (int propIndex = propTables.length - 1; propIndex >= 0; --propIndex) {
            Map propTable = propTables[propIndex];
            for (String key : propTable.keySet()) {
                if (key.startsWith("env.") || this.table.containsKey(key)) continue;
                Element elem = new Element(key, (String)propTable.get(key), null, propTableNames[propIndex]);
                this.table.put(key, elem);
            }
        }
    }

    public TestEnvironment copy() {
        return new TestEnvironment(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        if (this.table == null || !this.table.containsKey("description")) {
            return null;
        }
        return ((Element)this.table.get("description")).getValue();
    }

    public String[] getInherits() {
        return this.inherits;
    }

    public void put(String name, String value) {
        String[] v = new String[]{value};
        this.extras.put(name, v);
    }

    public void put(String name, String[] value) {
        this.extras.put(name, value);
    }

    public void putUrlAndFile(String name, File f, boolean dir) {
        String filePath = f.getPath();
        if (filePath.endsWith(File.separator)) {
            filePath = filePath.substring(0, filePath.length() - File.separator.length());
        }
        String urlPath = HTMLWriter.encodeUri(filePath, !File.separator.equals("/"));
        urlPath = urlPath.replace(File.separatorChar, '/');
        String urlHead = urlPath.startsWith("/") ? "file://" : "file:///";
        String url = urlHead + urlPath + (dir ? "/" : "");
        this.put(name, filePath);
        this.put(name + "URL", url);
    }

    public String[] lookup(String key) throws Fault {
        return this.lookup(key, null);
    }

    private String[] lookup(String key, Vector activeKeys) throws Fault {
        String[] v = (String[])this.extras.get(key);
        if (v != null) {
            return v;
        }
        Element elem = (Element)this.table.get(key);
        if (elem != null) {
            this.cache.put(key, elem);
            if (activeKeys == null) {
                activeKeys = new Vector<String>();
            } else if (activeKeys.contains(key)) {
                throw new Fault(i18n, "env.recursive", new Object[]{key, elem.getDefinedInFile()});
            }
            activeKeys.addElement(key);
            try {
                String[] stringArray = this.resolve(elem.getValue(), activeKeys);
                return stringArray;
            }
            catch (Fault e) {
                throw new Fault(i18n, "env.badName", new Object[]{key, elem.getDefinedInFile(), e.getMessage()});
            }
            finally {
                activeKeys.removeElement(key);
            }
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] resolve(String s) throws Fault {
        return this.resolve(s, null);
    }

    private String[] resolve(String s, Vector activeKeys) throws Fault {
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer(64);
        char term = '\u0000';
        block14: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '#': {
                    if (term == '\u0000' || term == ' ') break block14;
                    current.append(c);
                    continue block14;
                }
                case '\"': 
                case '\'': {
                    if (term == '\u0000' || term == ' ') {
                        term = c;
                        continue block14;
                    }
                    if (term == c) {
                        term = ' ';
                        continue block14;
                    }
                    current.append(c);
                    continue block14;
                }
                case '$': {
                    if (term != '\'') {
                        StringBuffer buf = new StringBuffer();
                        String name = null;
                        String[] nameArgs = null;
                        try {
                            c = s.charAt(++i);
                            switch (c) {
                                case '/': {
                                    current.append(File.separatorChar);
                                    continue block14;
                                }
                                case ':': {
                                    current.append(File.pathSeparatorChar);
                                    continue block14;
                                }
                                case '$': {
                                    current.append('$');
                                    continue block14;
                                }
                                case '{': {
                                    c = s.charAt(++i);
                                    while (c != ':' && c != '}') {
                                        buf.append(c);
                                        c = s.charAt(++i);
                                    }
                                    name = this.convertToName(this.resolve(buf.toString()));
                                    if (c != ':') break;
                                    buf = new StringBuffer();
                                    c = s.charAt(++i);
                                    while (c != '}') {
                                        buf.append(c);
                                        c = s.charAt(++i);
                                    }
                                    nameArgs = StringArray.split(buf.toString());
                                    break;
                                }
                                default: {
                                    if (TestEnvironment.isNameChar(c)) {
                                        while (i < s.length() && TestEnvironment.isNameChar(s.charAt(i))) {
                                            buf.append(s.charAt(i++));
                                        }
                                        --i;
                                    } else {
                                        throw new Fault(i18n, "env.badExprChar", new Character(c));
                                    }
                                    name = buf.toString();
                                }
                            }
                            String[] val = this.lookup(name, activeKeys);
                            if (nameArgs != null) {
                                for (int argi = 0; argi < nameArgs.length; ++argi) {
                                    void arg = nameArgs[argi];
                                    if (arg.startsWith("FS=") && arg.length() == 4) {
                                        this.substituteChar(val, File.separatorChar, arg.charAt(3));
                                        continue;
                                    }
                                    if (arg.startsWith("PS=") && arg.length() == 4) {
                                        this.substituteChar(val, File.pathSeparatorChar, arg.charAt(3));
                                        continue;
                                    }
                                    if (arg.startsWith("MAP=")) {
                                        this.substituteMap(val, this.lookup("map." + arg.substring(4), activeKeys));
                                        continue;
                                    }
                                    if (arg.equals("MAP")) {
                                        this.substituteMap(val, this.lookup("map", activeKeys));
                                        continue;
                                    }
                                    throw new Fault(i18n, "env.badOption", arg);
                                }
                            }
                            if (val == null || val.length <= 0) continue block14;
                            if (term == '\u0000') {
                                term = ' ';
                            }
                            for (int vi = 0; vi < val.length; ++vi) {
                                if (vi == 0) {
                                    current.append(val[vi]);
                                    continue;
                                }
                                if (term == '\"') {
                                    current.append(' ');
                                    current.append(val[vi]);
                                    continue;
                                }
                                v.addElement(current.toString());
                                current.setLength(0);
                                current.append(val[vi]);
                            }
                            continue block14;
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new Fault(i18n, "env.badExpr");
                        }
                    }
                    current.append(c);
                    continue block14;
                }
                case '\t': 
                case ' ': {
                    if (term == '\u0000') continue block14;
                    if (term == ' ') {
                        v.addElement(current.toString());
                        current.setLength(0);
                        term = '\u0000';
                        continue block14;
                    }
                    current.append(c);
                    continue block14;
                }
                default: {
                    if (term == '\u0000') {
                        term = ' ';
                    }
                    current.append(c);
                }
            }
        }
        if (term != '\u0000') {
            v.addElement(current.toString());
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    public boolean hasUndefinedValues() {
        for (Element entry : this.elements()) {
            if (entry.value.indexOf("VALUE_NOT_DEFINED") < 0) continue;
            return true;
        }
        return false;
    }

    private void substituteChar(String[] v, char from, char to) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i].replace(from, to);
        }
    }

    private void substituteMap(String[] v, String[] map) {
        if (map == null) {
            return;
        }
        for (int i = 0; i < v.length; ++i) {
            String word = v[i];
            int j = 0;
            while (j + 1 < map.length) {
                String f = map[j];
                String t = map[j + 1];
                int index = word.indexOf(f);
                while (index != -1) {
                    word = word.substring(0, index) + t + word.substring(index + f.length());
                    index = word.indexOf(f, index + t.length());
                }
                j += 2;
            }
            v[i] = word;
        }
    }

    private String convertToName(String[] v) {
        String s = "";
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                s = s + '_';
            }
            for (int j = 0; j < v[i].length(); ++j) {
                char c = v[i].charAt(j);
                s = s + (TestEnvironment.isNameChar(c) ? c : (char)'_');
            }
        }
        return s;
    }

    private static boolean isNameChar(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c) || Character.isDigit(c) || c == '_' || c == '.';
    }

    public Set keys() {
        return this.table.keySet();
    }

    public Collection elementsUsed() {
        return this.cache.values();
    }

    public void resetElementsUsed() {
        this.cache.clear();
    }

    public Collection elements() {
        return this.table.values();
    }

    protected TestEnvironment(TestEnvironment o) {
        this.name = o.name;
        this.inherits = o.inherits;
        this.table = o.table;
        this.extras = (HashMap)o.extras.clone();
    }

    public class Element {
        String key;
        String value;
        String definedInEnv;
        String definedInFile;

        Element(String key, String value, String definedInEnv, String definedInFile) {
            this.key = key;
            this.value = value;
            this.definedInEnv = definedInEnv;
            this.definedInFile = definedInFile;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefinedInEnv() {
            return this.definedInEnv;
        }

        public String getDefinedInFile() {
            return this.definedInFile;
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }
}

