/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.Properties;
import com.sun.javatest.util.PropertyArray;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class TestResult {
    public static final int NO_CHECKSUM = 0;
    public static final int BAD_CHECKSUM = 1;
    public static final int GOOD_CHECKSUM = 2;
    public static final int NUM_CHECKSUM_STATES = 3;
    private File resultsFile;
    private Status execStatus;
    private String testURL;
    private long endTime = -1L;
    private byte checksumState;
    private TestDescription desc;
    private String[] props;
    private String[] env;
    private Section[] sections;
    private TestResultTable.TreeNode parent;
    private static Hashtable observersTable = new Hashtable(16);
    public static final String MESSAGE_OUTPUT_NAME = "messages";
    public static final String MSG_SECTION_NAME = "script_messages";
    public static final String DESCRIPTION = "description";
    public static final String END = "end";
    public static final String ENVIRONMENT = "environment";
    public static final String EXEC_STATUS = "execStatus";
    public static final String JAVATEST_OS = "javatestOS";
    public static final String SCRIPT = "script";
    public static final String SECTIONS = "sections";
    public static final String START = "start";
    public static final String TEST = "test";
    public static final String VERSION = "javatestVersion";
    public static final String WORK = "work";
    static final String EXTN = ".jtr";
    private static final Status filesSame = Status.passed("Output file and reference file matched");
    private static final Status filesDifferent = Status.failed("Output file and reference file were different");
    private static final Status fileError = Status.failed("Error occurred during comparison");
    private static final Status interrupted = Status.failed("interrupted");
    private static final Status inProgress = Status.notRun("Test running...");
    private static final Status incomplete = Status.notRun("Section not closed, may be incomplete");
    private static final Status tdMismatch = Status.notRun("Old test flushed, new test description located");
    private static final Status notRunStatus = Status.notRun("");
    private static final String[] emptyStringArray = new String[0];
    private static final Section[] emptySectionArray = new Section[0];
    private static final String defaultClassDir = "classes";
    private static final String JTR_V1_HEADER = "#Test Results";
    private static final String JTR_V1_SECTRESULT = "command result:";
    private static final String JTR_V1_TSTRESULT = "test result:";
    private static final String JTR_V2_HEADER = "#Test Results (version 2)";
    private static final String JTR_V2_SECTION = "#section:";
    private static final String JTR_V2_CHECKSUM = "#checksum:";
    private static final String JTR_V2_TESTDESC = "#-----testdescription-----";
    private static final String JTR_V2_RESPROPS = "#-----testresult-----";
    private static final String JTR_V2_ENVIRONMENT = "#-----environment-----";
    private static final String JTR_V2_SECTRESULT = "result: ";
    private static final String JTR_V2_TSTRESULT = "test result: ";
    private static final String JTR_V2_SECTSTREAM = "----------";
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final int DEFAULT_MAX_SHRINK_LIST_SIZE = 128;
    private static final int maxShrinkListSize = Integer.getInteger("javatest.numCachedResults", 128);
    private static LinkedList shrinkList = new LinkedList();
    private static final int DEFAULT_MAX_OUTPUT_SIZE = 100000;
    private static final int maxOutputSize = Integer.getInteger("javatest.maxOutputSize", 100000);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TestResult.class);
    private static boolean debug = Boolean.getBoolean("debug." + TestResult.class.getName());

    public TestResult(TestDescription td) {
        this.desc = td;
        this.execStatus = inProgress;
        this.testURL = this.desc.getRootRelativeURL();
        this.createSection(MSG_SECTION_NAME);
        this.props = emptyStringArray;
    }

    public TestResult(TestDescription td, WorkDirectory workDir) throws Fault {
        this.desc = td;
        this.testURL = this.desc.getRootRelativeURL();
        this.execStatus = inProgress;
        this.reloadFromWorkDir(workDir);
    }

    public TestResult(File file) throws ResultFileNotFoundFault, ReloadFault {
        this.resultsFile = file;
        this.reload();
        this.testURL = this.desc.getRootRelativeURL();
        this.execStatus = Status.parse(PropertyArray.get(this.props, EXEC_STATUS));
    }

    public TestResult(WorkDirectory workDir, String workRelativePath) throws Fault {
        this.resultsFile = workDir.getFile(workRelativePath);
        this.reload();
        this.testURL = this.desc.getRootRelativeURL();
        this.execStatus = Status.parse(PropertyArray.get(this.props, EXEC_STATUS));
    }

    public TestResult(TestDescription td, Status s) {
        this.desc = td;
        this.testURL = this.desc.getRootRelativeURL();
        this.resultsFile = null;
        this.execStatus = s;
        this.props = emptyStringArray;
    }

    public static TestResult notRun(TestDescription td) {
        return new TestResult(td, notRunStatus);
    }

    public synchronized Section createSection(String name) {
        if (!this.isMutable()) {
            throw new IllegalStateException("This TestResult is no longer mutable!");
        }
        Section section = new Section(name);
        this.sections = (Section[])DynamicArray.append(this.sections, section);
        this.notifyCreatedSection(section);
        section.createOutput(MESSAGE_OUTPUT_NAME);
        return section;
    }

    public synchronized void setEnvironment(TestEnvironment environment) {
        if (!this.isMutable()) {
            throw new IllegalStateException("This TestResult is no longer mutable!");
        }
        for (TestEnvironment.Element elem : environment.elementsUsed()) {
            this.env = PropertyArray.put(this.env, elem.getKey(), elem.getValue());
        }
    }

    public synchronized void setStatus(Status stat) {
        if (!this.isMutable()) {
            throw new IllegalStateException("This TestResult is no longer mutable!");
        }
        if (stat == null) {
            throw new IllegalArgumentException("TestResult status cannot be set to null!");
        }
        this.sections[0].setStatus(null);
        this.execStatus = stat;
        if (this.execStatus == inProgress) {
            this.execStatus = interrupted;
        }
        for (int i = 0; i < this.sections.length; ++i) {
            if (!this.sections[i].isMutable()) continue;
            this.sections[i].setStatus(incomplete);
        }
        this.props = PropertyArray.put(this.props, SECTIONS, StringArray.join(this.getSectionTitles()));
        this.props = PropertyArray.put(this.props, EXEC_STATUS, this.execStatus.toString());
        if (PropertyArray.get(this.props, END) == null) {
            this.props = PropertyArray.put(this.props, END, new Date().toString());
        }
        this.notifyCompleted();
    }

    public synchronized void putProperty(String name, String value) {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot put property, the TestResult is no longer mutable!");
        }
        this.props = PropertyArray.put(this.props, name, value);
        this.notifyUpdatedProperty(name, value);
    }

    public void reloadFromWorkDir(WorkDirectory workDir) throws Fault {
        if (!this.isMutable()) {
            throw new IllegalStateException("Cannot reload results, the TestResult is no longer mutable!");
        }
        try {
            this.resultsFile = workDir.getFile(this.getWorkRelativePath());
            this.props = null;
            this.sections = null;
            this.execStatus = null;
            this.reload(new FileReader(this.resultsFile));
            this.execStatus = Status.parse(PropertyArray.get(this.props, EXEC_STATUS));
        }
        catch (FileNotFoundException e) {
            this.props = emptyStringArray;
            this.env = emptyStringArray;
            this.sections = emptySectionArray;
            this.execStatus = Status.notRun("no test result file found");
        }
        catch (IOException e) {
            this.props = emptyStringArray;
            this.env = emptyStringArray;
            this.sections = emptySectionArray;
            this.execStatus = Status.error("error opening result file: " + e);
            throw new Fault(i18n, "rslt.badFile", e.toString());
        }
        catch (Fault f) {
            this.props = emptyStringArray;
            this.env = emptyStringArray;
            this.sections = emptySectionArray;
            this.execStatus = Status.error(f.getMessage());
            throw f;
        }
    }

    public byte getChecksumState() {
        return this.checksumState;
    }

    public PrintWriter getTestCommentWriter() {
        return this.sections[0].getMessageWriter();
    }

    public String getTestName() {
        return this.testURL;
    }

    public boolean isReloadable() {
        return this.resultsFile != null && this.resultsFile.canRead();
    }

    public boolean isShrunk() {
        return !this.isMutable() && (this.desc == null || this.props == null || this.env == null || this.sections == null && this.execStatus != inProgress);
    }

    public synchronized TestDescription getDescription() throws Fault {
        if (this.desc == null) {
            this.reload();
        }
        return this.desc;
    }

    public String getWorkRelativePath() {
        return TestResult.getWorkRelativePath(this.testURL);
    }

    public File getFile() {
        return this.resultsFile;
    }

    public static String getWorkRelativePath(TestDescription td) {
        String baseURL = td.getRootRelativePath();
        String id = td.getParameter("id");
        return TestResult.getWorkRelativePath(baseURL, id);
    }

    public static String getWorkRelativePath(String testURL) {
        int pound = testURL.lastIndexOf("#");
        if (pound == -1) {
            return TestResult.getWorkRelativePath(testURL, null);
        }
        return TestResult.getWorkRelativePath(testURL.substring(0, pound), testURL.substring(pound + 1));
    }

    public static String getWorkRelativePath(String baseURL, String testId) {
        StringBuffer sb = new StringBuffer(baseURL);
        block4: for (int i = sb.length() - 1; i >= 0; --i) {
            switch (sb.charAt(i)) {
                case '.': {
                    sb.setLength(i);
                    break block4;
                }
                case '/': {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (testId != null) {
            sb.append('_');
            sb.append(testId);
        }
        sb.append(EXTN);
        return sb.toString();
    }

    public synchronized Enumeration getPropertyNames() {
        return PropertyArray.enumerate(this.props);
    }

    public synchronized String getProperty(String name) throws Fault {
        if (this.props == null) {
            this.reload();
        }
        return PropertyArray.get(this.props, name);
    }

    public synchronized Map getEnvironment() throws Fault {
        if (this.env == null) {
            this.reload();
        }
        return PropertyArray.getProperties(this.env);
    }

    public TestResultTable.TreeNode getParent() {
        return this.parent;
    }

    void setParent(TestResultTable.TreeNode p) {
        this.parent = p;
    }

    public synchronized boolean isMutable() {
        return this.execStatus == inProgress;
    }

    public synchronized Status getStatus() {
        return this.execStatus;
    }

    public synchronized int getSectionCount() {
        if (this.sections != null) {
            return this.sections.length;
        }
        if (PropertyArray.get(this.props, SECTIONS) != null) {
            return StringArray.split(PropertyArray.get(this.props, SECTIONS)).length;
        }
        return 0;
    }

    public synchronized Section getSection(int index) throws ReloadFault {
        if (this.sections == null && this.execStatus != inProgress) {
            try {
                this.reload();
            }
            catch (ReloadFault f) {
                throw f;
            }
            catch (Fault f) {
                throw new ReloadFault(i18n, "rslt.badFile", f.getMessage());
            }
        }
        Section target = index >= this.sections.length ? null : this.sections[index];
        return target;
    }

    public synchronized String[] getSectionTitles() {
        String names;
        if (this.props == null) {
            try {
                this.reload();
            }
            catch (Fault f) {
                return null;
            }
        }
        if ((names = PropertyArray.get(this.props, SECTIONS)) != null) {
            return StringArray.split(names);
        }
        if (this.sections != null) {
            int numSections = this.getSectionCount();
            String[] data = new String[numSections];
            for (int i = 0; i < numSections; ++i) {
                data[i] = this.sections[i].getTitle();
            }
            return data;
        }
        return null;
    }

    public static boolean isResultFile(File f) {
        String p = f.getPath();
        return p.endsWith(EXTN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeResults(WorkDirectory workDir, BackupPolicy backupPolicy) throws IOException {
        if (this.isMutable()) {
            throw new IllegalStateException("This TestResult is still mutable - set the status!");
        }
        if (this.props == null) {
            this.props = emptyStringArray;
        }
        String wrp = TestResult.getWorkRelativePath(this.desc).replace('/', File.separatorChar);
        this.resultsFile = workDir.getFile(wrp);
        File resultsDir = this.resultsFile.getParentFile();
        resultsDir.mkdirs();
        File tempFile = this.createTempFile(workDir, backupPolicy);
        try {
            this.writeResults(tempFile, backupPolicy);
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private File createTempFile(WorkDirectory workDir, BackupPolicy backupPolicy) throws IOException {
        int MAX_TRIES = 100;
        for (int i = 0; i < 100; ++i) {
            File tempFile = new File(this.resultsFile.getPath() + "." + i + ".tmp");
            if (!tempFile.createNewFile()) continue;
            return tempFile;
        }
        throw new IOException("could not create temp file for " + this.resultsFile + ": too many tries");
    }

    private void writeResults(File tempFile, BackupPolicy backupPolicy) throws IOException {
        FileWriter out;
        try {
            out = new FileWriter(tempFile);
        }
        catch (IOException e) {
            this.execStatus = Status.error("Problem writing result file for test: " + this.getTestName());
            this.resultsFile = null;
            throw e;
        }
        try {
            this.props = PropertyArray.put(this.props, EXEC_STATUS, this.execStatus.toString());
            out.write(JTR_V2_HEADER);
            out.write(lineSeparator);
            out.write("#" + new Date().toString());
            out.write(lineSeparator);
            out.write(JTR_V2_CHECKSUM);
            out.write(Long.toHexString(this.computeChecksum()));
            out.write(lineSeparator);
            if (debug) {
                out.write("# debug: test desc checksum: ");
                out.write(Long.toHexString(TestResult.computeChecksum(this.desc)));
                out.write(lineSeparator);
                Iterator iter = this.desc.getParameterKeys();
                while (iter.hasNext()) {
                    String KEY = (String)iter.next();
                    out.write("# debug: test desc checksum key " + KEY + ": ");
                    out.write(Long.toHexString(TestResult.computeChecksum(KEY) * TestResult.computeChecksum(this.desc.getParameter(KEY))));
                    out.write(lineSeparator);
                }
                out.write("# debug: test env checksum: ");
                if (this.env == null) {
                    out.write("null");
                } else {
                    out.write(Long.toHexString(TestResult.computeChecksum(this.env)));
                }
                out.write(lineSeparator);
                out.write("# debug: test props checksum: ");
                out.write(Long.toHexString(TestResult.computeChecksum(this.props)));
                out.write(lineSeparator);
                out.write("# debug: test sections checksum: ");
                out.write(Long.toHexString(TestResult.computeChecksum(this.sections)));
                out.write(lineSeparator);
                for (int I = 0; I < this.sections.length; ++I) {
                    out.write("# debug: test section[" + I + "] checksum: ");
                    out.write(Long.toHexString(TestResult.computeChecksum(this.sections[I])));
                    out.write(lineSeparator);
                    String[] NAMES = this.sections[I].getOutputNames();
                    for (int J = 0; J < NAMES.length; ++J) {
                        out.write("# debug: test section[" + I + "] name=" + NAMES[J] + " checksum: ");
                        out.write(Long.toHexString(TestResult.computeChecksum(NAMES[J])));
                        out.write(lineSeparator);
                        out.write("# debug: test section[" + I + "] name=" + NAMES[J] + " output checksum: ");
                        out.write(Long.toHexString(TestResult.computeChecksum(this.sections[I].getOutput(NAMES[J]))));
                        out.write(lineSeparator);
                    }
                }
            }
            out.write(JTR_V2_TESTDESC);
            out.write(lineSeparator);
            Properties tdProps = new Properties();
            this.desc.save(tdProps);
            PropertyArray.save(PropertyArray.getArray(tdProps), out);
            out.write(lineSeparator);
            if (this.env != null) {
                out.write(JTR_V2_ENVIRONMENT);
                out.write(lineSeparator);
                PropertyArray.save(this.env, out);
                out.write(lineSeparator);
            }
            out.write(JTR_V2_RESPROPS);
            out.write(lineSeparator);
            PropertyArray.save(this.props, out);
            out.write(lineSeparator);
            if (this.sections == null) {
                throw new JavaTestError("Cannot write test result - it contains no sections.");
            }
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.sections.length; ++i) {
                this.sections[i].save(out);
            }
            out.write(lineSeparator);
            out.write(JTR_V2_TSTRESULT);
            out.write(this.execStatus.toString());
            out.write(lineSeparator);
            out.close();
        }
        catch (IOException e) {
            this.execStatus = Status.error("Write to temp. JTR file failed (old JTR intact): " + tempFile.getPath());
            this.resultsFile = null;
            throw e;
        }
        try {
            backupPolicy.backupAndRename(tempFile, this.resultsFile);
            this.addToShrinkList();
        }
        catch (IOException e) {
            this.execStatus = Status.error("Problem writing result file: " + this.resultsFile.getPath());
            this.resultsFile = null;
            throw e;
        }
    }

    public synchronized void addObserver(Observer obs) {
        if (this.isMutable()) {
            Object[] observers = (Observer[])observersTable.get(this);
            if (observers == null) {
                observers = new Observer[]{};
            }
            observers = (Observer[])DynamicArray.append(observers, obs);
            observersTable.put(this, observers);
        }
    }

    public synchronized void removeObserver(Observer obs) {
        Object[] observers = (Observer[])observersTable.get(this);
        if (observers == null) {
            return;
        }
        if ((observers = (Observer[])DynamicArray.remove(observers, obs)) == null) {
            observersTable.remove(this);
        } else {
            observersTable.put(this, observers);
        }
    }

    public long getEndTime() {
        if (this.endTime < 0L) {
            try {
                String datestr = PropertyArray.get(this.props, END);
                if (datestr == null) {
                    try {
                        datestr = this.getProperty(END);
                    }
                    catch (Fault f) {
                        // empty catch block
                    }
                }
                if (datestr != null) {
                    SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                    Date date = df.parse(datestr);
                    this.endTime = date.getTime();
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this.endTime;
    }

    TestResult(String url, WorkDirectory workDir, Status status) {
        if (url == null) {
            throw new JavaTestError(i18n, "rslt.badTestUrl");
        }
        if (workDir == null) {
            throw new JavaTestError(i18n, "rslt.badWorkdir");
        }
        if (status == null) {
            throw new JavaTestError(i18n, "rslt.badStatus");
        }
        this.testURL = url;
        this.resultsFile = workDir.getFile(this.getWorkRelativePath());
        this.execStatus = status;
    }

    TestResult(String url, WorkDirectory workDir, Status status, long endTime) {
        if (url == null) {
            throw new JavaTestError(i18n, "rslt.badTestUrl");
        }
        if (workDir == null) {
            throw new JavaTestError(i18n, "rslt.badWorkdir");
        }
        if (status == null) {
            throw new JavaTestError(i18n, "rslt.badStatus");
        }
        this.testURL = url;
        this.resultsFile = workDir.getFile(this.getWorkRelativePath());
        this.execStatus = status;
        this.endTime = endTime;
    }

    void shareStatus(Hashtable[] tables) {
        this.execStatus = TestResult.shareStatus(tables, this.execStatus);
    }

    String[] getTags() {
        if (this.sections == null) {
            return null;
        }
        Vector<String> tagV = new Vector<String>(this.sections.length * 2);
        for (int i = 0; i < this.sections.length; ++i) {
            String[] names = this.sections[i].getOutputNames();
            for (int j = 0; j < names.length; ++j) {
                tagV.addElement(names[j]);
            }
        }
        Object[] tagA = new String[tagV.size()];
        tagV.copyInto(tagA);
        return tagA;
    }

    void setTestDescription(TestDescription td) {
        if (td == null) {
            return;
        }
        String name = td.getRootRelativeURL();
        if (!this.testURL.equals(name)) {
            throw new IllegalStateException();
        }
        if (this.desc != null) {
            if (!this.desc.equals(td)) {
                this.execStatus = tdMismatch;
                this.desc = td;
                this.props = emptyStringArray;
                this.resultsFile = null;
                this.env = emptyStringArray;
                this.sections = emptySectionArray;
                if (this.isMutable()) {
                    this.createSection(MSG_SECTION_NAME);
                }
            }
        } else {
            this.desc = td;
        }
    }

    private static Reader getLastRefOutput(TestResult tr) {
        try {
            Section lastBlk = tr.getSection(tr.getSectionCount() - 1);
            return new StringReader(lastBlk.getOutput("ref"));
        }
        catch (ReloadFault f) {
            return null;
        }
    }

    private long computeChecksum() {
        long cs = 0L;
        cs = cs * 37L + TestResult.computeChecksum(this.desc);
        String jtv = PropertyArray.get(this.props, VERSION);
        if (!(this.env == null || jtv != null && jtv.equals("JT_2.1.1a"))) {
            cs = cs * 37L + TestResult.computeChecksum(this.env);
        }
        cs = cs * 37L + TestResult.computeChecksum(this.props);
        if (this.sections != null) {
            cs = cs * 37L + TestResult.computeChecksum(this.sections);
        }
        cs = cs * 37L + (long)this.execStatus.getType() + TestResult.computeChecksum(this.execStatus.getReason());
        return Math.abs(cs);
    }

    private static long computeChecksum(TestDescription td) {
        long cs = 0L;
        Iterator i = td.getParameterKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            cs += TestResult.computeChecksum(key) * TestResult.computeChecksum(td.getParameter(key));
        }
        return cs;
    }

    private static long computeChecksum(Section[] sections) {
        long cs = sections.length;
        for (int i = 0; i < sections.length; ++i) {
            cs = cs * 37L + TestResult.computeChecksum(sections[i]);
        }
        return cs;
    }

    private static long computeChecksum(Section s) {
        long cs = TestResult.computeChecksum(s.getTitle());
        String[] names = s.getOutputNames();
        for (int i = 0; i < names.length; ++i) {
            cs = cs * 37L + TestResult.computeChecksum(names[i]);
            cs = cs * 37L + TestResult.computeChecksum(s.getOutput(names[i]));
        }
        return cs;
    }

    private static long computeChecksum(String[] strings) {
        long cs = strings.length;
        for (int i = 0; i < strings.length; ++i) {
            cs = cs * 37L + TestResult.computeChecksum(strings[i]);
        }
        return cs;
    }

    private static long computeChecksum(String s) {
        long cs = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            cs = cs * 37L + (long)c;
        }
        return cs;
    }

    private synchronized void reload() throws ResultFileNotFoundFault, ReloadFault {
        if (this.resultsFile == null) {
            throw new ReloadFault(i18n, "rslt.noResultFile");
        }
        if (this.isMutable()) {
            throw new IllegalStateException("Cannot do a reload of this object.");
        }
        try {
            this.reload(new FileReader(this.resultsFile));
            this.addToShrinkList();
        }
        catch (FileNotFoundException e) {
            throw new ResultFileNotFoundFault(i18n, "rslt.fileNotFound", this.resultsFile);
        }
        catch (IOException e) {
            throw new ReloadFault(i18n, "rslt.badFile", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(Reader r) throws ReloadFault, IOException {
        block6: {
            try {
                BufferedReader br = new BufferedReader(r);
                String line = br.readLine();
                if (line == null) {
                    throw new ReloadFault(i18n, "rslt.empty", this.resultsFile);
                }
                if (line.equals(JTR_V2_HEADER)) {
                    this.reloadVersion2(br);
                    break block6;
                }
                if (line.equals(JTR_V1_HEADER)) {
                    this.reloadVersion1(br);
                    break block6;
                }
                throw new ReloadFault(i18n, "rslt.badHeader", this.resultsFile);
            }
            finally {
                r.close();
            }
        }
    }

    private void reloadVersion1(BufferedReader in) throws ReloadFault, IOException {
        Section blk;
        StringBuffer buff = new StringBuffer();
        String line = in.readLine();
        while (line != null && line.length() != 0) {
            buff.append(line);
            buff.append(lineSeparator);
            line = in.readLine();
        }
        Properties pairs = new Properties();
        if (this.props == null || this.desc == null) {
            StringReader sr = new StringReader(buff.toString());
            buff = null;
            line = null;
            pairs = new Properties();
            pairs.load(sr);
        }
        if (this.props == null) {
            this.props = PropertyArray.getArray(pairs);
        }
        pairs = null;
        if (this.desc == null) {
            File path = new File(PropertyArray.get(this.props, "testsuite"));
            if (!path.isDirectory()) {
                path = new File(path.getParent());
            }
            File file = new File(PropertyArray.get(this.props, "file"));
            this.uniquifyStrings(this.props);
            this.desc = new TestDescription(path, file, PropertyArray.getProperties(this.props));
        }
        buff = new StringBuffer();
        line = in.readLine();
        while (line != null) {
            if (line.startsWith("command: ")) {
                blk = this.processOldSection(line, in);
                if (blk != null) {
                    this.sections = (Section[])DynamicArray.append(this.sections, blk);
                }
            } else {
                if (line.startsWith(JTR_V1_TSTRESULT)) {
                    if (line == null) break;
                    line = this.extractSlice(line, JTR_V1_TSTRESULT.length(), " ", null);
                    this.execStatus = Status.parse(line);
                    break;
                }
                buff.append(line);
                buff.append(lineSeparator);
            }
            line = in.readLine();
        }
        blk = new Section(MSG_SECTION_NAME);
        blk.reloadOutput(MESSAGE_OUTPUT_NAME, buff.toString());
        Section[] tempBlks = new Section[this.sections.length + 1];
        tempBlks[0] = blk;
        System.arraycopy(this.sections, 0, tempBlks, 1, this.sections.length);
        this.sections = tempBlks;
    }

    private Section processOldSection(String line1, BufferedReader in) throws ReloadFault, IOException {
        StringBuffer sb = new StringBuffer();
        Section section = null;
        String line = line1;
        while (line != null) {
            if (line.startsWith(JTR_V2_SECTSTREAM)) {
                String streamName = null;
                String sectionName = null;
                StringBuffer buff = new StringBuffer();
                int lines = 0;
                int chars = 0;
                try {
                    streamName = this.extractSlice(line, 10, null, ":");
                    sectionName = this.extractSlice(line, 10, ":", "(");
                    lines = Integer.parseInt(this.extractSlice(line, 10, "(", "/"));
                    chars = Integer.parseInt(this.extractSlice(line, 10, "/", ")"));
                    for (int count = 0; count < lines; ++count) {
                        buff.append(in.readLine());
                    }
                }
                catch (NumberFormatException e) {
                    throw new ReloadFault(i18n, "rslt.badFile", e);
                }
                if (section == null) {
                    section = new Section(sectionName);
                }
                section.reloadOutput(streamName, buff.toString());
            } else {
                if (line.startsWith(JTR_V1_SECTRESULT)) {
                    if (section == null) {
                        section = new Section("");
                    }
                    if ((line = this.extractSlice(line, JTR_V1_SECTRESULT.length(), " ", null)) == null) {
                        throw new ReloadFault(i18n, "rslt.noSectionResult");
                    }
                    section.reloadStatus(Status.parse(line));
                    break;
                }
                sb.append(line);
                sb.append(lineSeparator);
            }
            line = in.readLine();
        }
        section.reloadOutput(MESSAGE_OUTPUT_NAME, sb.toString());
        return section;
    }

    private void reloadVersion2(BufferedReader in) throws ReloadFault, IOException {
        String line;
        String checksumText = null;
        while ((line = in.readLine()) != null && !line.equals(JTR_V2_TESTDESC)) {
            if (line.startsWith(JTR_V2_CHECKSUM)) {
                checksumText = line.substring(JTR_V2_CHECKSUM.length());
                continue;
            }
            if (line.startsWith("#")) continue;
            throw new ReloadFault(i18n, "rslt.badLine", line);
        }
        String[] tdProps = PropertyArray.load(in);
        if (this.desc == null) {
            this.uniquifyStrings(tdProps);
            this.desc = TestDescription.load(tdProps);
        }
        tdProps = null;
        while ((line = in.readLine()) != null && !line.startsWith(JTR_V2_RESPROPS)) {
            if (line.startsWith(JTR_V2_ENVIRONMENT)) {
                this.env = PropertyArray.load(in);
                this.uniquifyStrings(this.env);
                continue;
            }
            if (line.startsWith("#")) continue;
            throw new ReloadFault(i18n, "rslt.badLine", line);
        }
        if (this.env == null) {
            this.env = new String[0];
        }
        if (line == null) {
            throw new ReloadFault(i18n, "rslt.badFormat");
        }
        String[] trProps = PropertyArray.load(in);
        if (this.props == null) {
            this.uniquifyStrings(trProps);
            this.props = trProps;
        }
        trProps = null;
        int sectionCount = this.getSectionCount();
        this.sections = new Section[sectionCount];
        for (int i = 0; i < this.getSectionCount(); ++i) {
            this.sections[i] = new Section(in);
        }
        while ((line = in.readLine()) != null) {
            if (!line.startsWith(JTR_V2_TSTRESULT)) continue;
            this.execStatus = Status.parse(line.substring(JTR_V2_TSTRESULT.length()));
            break;
        }
        if (this.execStatus == null) {
            this.execStatus = Status.error("NO STATUS RECORDED IN FILE");
        }
        if (checksumText == null) {
            this.checksumState = 0;
        } else {
            try {
                long cs = Long.parseLong(checksumText, 16);
                this.checksumState = cs == this.computeChecksum() ? (byte)2 : (byte)1;
            }
            catch (RuntimeException e) {
                this.checksumState = 1;
            }
        }
    }

    void uniquifyStrings(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i].intern();
        }
    }

    String extractSlice(String s, int where, String start, String end) {
        int endInd;
        int startInd;
        if (start == null) {
            startInd = where;
        } else {
            int i = s.indexOf(start, where);
            if (i < 0) {
                return null;
            }
            startInd = i + start.length();
        }
        if (end == null) {
            endInd = s.length();
        } else {
            endInd = s.indexOf(end, startInd);
            if (endInd == -1) {
                return null;
            }
        }
        try {
            return s.substring(startInd, endInd);
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean compare(Reader left, Reader right) throws Fault {
        try {
            try {
                int l;
                do {
                    int r;
                    if ((l = left.read()) == (r = right.read())) continue;
                    boolean bl = false;
                    return bl;
                } while (l != -1);
                boolean bl = true;
                return bl;
            }
            finally {
                left.close();
                right.close();
            }
        }
        catch (IOException e) {
            throw new Fault(i18n, "rslt.badCompare", e);
        }
    }

    private static Status shareStatus(Hashtable[] tables, Status s) {
        String reason;
        int type = s.getType();
        Status result = (Status)tables[type].get(reason = s.getReason());
        if (result == null) {
            tables[type].put(reason, s);
            result = s;
        }
        return result;
    }

    private synchronized void notifyCreatedSection(Section section) {
        Observer[] observers = (Observer[])observersTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].createdSection(this, section);
            }
        }
    }

    private synchronized void notifyCompletedSection(Section section) {
        Observer[] observers = (Observer[])observersTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].completedSection(this, section);
            }
        }
    }

    private synchronized void notifyCreatedOutput(Section section, String outputName) {
        Observer[] observers = (Observer[])observersTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].createdOutput(this, section, outputName);
            }
        }
    }

    private synchronized void notifyCompletedOutput(Section section, String outputName) {
        Observer[] observers = (Observer[])observersTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].completedOutput(this, section, outputName);
            }
        }
    }

    private synchronized void notifyUpdatedOutput(Section section, String outputName, int start, int end, String text) {
        Observer[] observers = (Observer[])observersTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].updatedOutput(this, section, outputName, start, end, text);
            }
        }
    }

    private synchronized void notifyUpdatedOutput(Section section, String outputName, int start, int end, char[] buf, int offset, int len) {
        Observer[] observers = (Observer[])observersTable.get(this);
        if (observers != null) {
            String text = new String(buf, offset, len);
            for (int i = 0; i < observers.length; ++i) {
                observers[i].updatedOutput(this, section, outputName, start, end, text);
            }
        }
    }

    private synchronized void notifyUpdatedProperty(String key, String value) {
        Observer[] observers = (Observer[])observersTable.get(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].updatedProperty(this, key, value);
            }
        }
    }

    private synchronized void notifyCompleted() {
        Observer[] observers = (Observer[])observersTable.remove(this);
        if (observers != null) {
            for (int i = 0; i < observers.length; ++i) {
                observers[i].completed(this);
            }
            observersTable.remove(this);
        }
    }

    private synchronized int findSection(String name) {
        int location;
        if (this.sections == null || this.sections.length == 0) {
            return -1;
        }
        for (location = 0; location < this.sections.length && !this.sections[location].getTitle().equals(name); ++location) {
        }
        if (location == this.sections.length) {
            location = -1;
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToShrinkList() {
        LinkedList linkedList = shrinkList;
        synchronized (linkedList) {
            Iterator iter = shrinkList.iterator();
            while (iter.hasNext()) {
                WeakReference wref = (WeakReference)iter.next();
                Object o = wref.get();
                if (o != null && o != this) continue;
                iter.remove();
            }
            while (shrinkList.size() >= maxShrinkListSize) {
                WeakReference wref = (WeakReference)shrinkList.removeFirst();
                TestResult tr = (TestResult)wref.get();
                if (tr == null) continue;
                tr.shrink();
            }
            shrinkList.addLast(new WeakReference<TestResult>(this));
        }
    }

    private synchronized void shrink() {
        if (this.isMutable()) {
            throw new IllegalStateException("Can't shrink a mutable test result!");
        }
        this.sections = null;
    }

    static /* synthetic */ String[] access$102(TestResult x0, String[] x1) {
        x0.env = x1;
        return x1;
    }

    private static interface OutputBuffer {
        public String getName();

        public String getOutput();

        public PrintWriter getPrintWriter();
    }

    private class LockedWriter
    extends PrintWriter {
        public LockedWriter(Writer out, Object theLock) {
            super(out);
            this.lock = theLock;
        }
    }

    public class Section {
        private OutputBuffer[] buffers = new OutputBuffer[0];
        private String title;
        private Status result;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMutable() {
            TestResult testResult = TestResult.this;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    return TestResult.this.isMutable() && this.result == inProgress;
                }
            }
        }

        public Status getStatus() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStatus(Status result) {
            TestResult testResult = TestResult.this;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    this.checkMutable();
                    for (int i = 0; i < this.buffers.length; ++i) {
                        OutputBuffer b = this.buffers[i];
                        if (!(b instanceof WritableOutputBuffer)) continue;
                        WritableOutputBuffer wb = (WritableOutputBuffer)b;
                        wb.getPrintWriter().close();
                    }
                    if (TestResult.this.env == null) {
                        TestResult.access$102(TestResult.this, emptyStringArray);
                    }
                    this.result = result;
                    if (TestResult.this.env == null) {
                        TestResult.access$102(TestResult.this, emptyStringArray);
                    }
                    TestResult.this.notifyCompletedSection(this);
                }
            }
        }

        public String getTitle() {
            return this.title;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintWriter getMessageWriter() {
            TestResult testResult = TestResult.this;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    this.checkMutable();
                    return this.buffers[0].getPrintWriter();
                }
            }
        }

        public synchronized int getOutputCount() {
            return this.buffers.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintWriter createOutput(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            TestResult testResult = TestResult.this;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    this.checkMutable();
                    WritableOutputBuffer b = new WritableOutputBuffer(name);
                    this.buffers = (OutputBuffer[])DynamicArray.append(this.buffers, b);
                    TestResult.this.notifyCreatedOutput(this, name);
                    return b.getPrintWriter();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getOutput(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            TestResult testResult = TestResult.this;
            synchronized (testResult) {
                Section section = this;
                synchronized (section) {
                    OutputBuffer b = this.findOutputBuffer(name);
                    return b == null ? null : b.getOutput();
                }
            }
        }

        public synchronized String[] getOutputNames() {
            String[] names = new String[this.buffers.length];
            for (int i = 0; i < this.buffers.length; ++i) {
                names[i] = this.buffers[i].getName();
                if (names[i] != null) continue;
                throw new IllegalStateException("BUFFER IS BROKEN");
            }
            return names;
        }

        Section(String title) {
            if (title == null) {
                throw new NullPointerException();
            }
            if (title.indexOf(32) != -1) {
                throw new IllegalArgumentException("space invalid in section title");
            }
            this.title = title;
            this.result = inProgress;
        }

        Section(BufferedReader in) throws IOException, ReloadFault {
            String line = in.readLine();
            while (line != null) {
                if (line.startsWith(TestResult.JTR_V2_SECTION)) {
                    this.title = TestResult.this.extractSlice(line, 0, ":", null);
                    break;
                }
                line = in.readLine();
            }
            if (this.title == null) {
                throw new ReloadFault(i18n, "rslt.noSectionTitle");
            }
            if (this.title.equals(TestResult.MSG_SECTION_NAME)) {
                this.title = TestResult.MSG_SECTION_NAME;
            }
            while ((line = in.readLine()).startsWith(TestResult.JTR_V2_SECTSTREAM)) {
                FixedOutputBuffer b = new FixedOutputBuffer(line, in);
                this.buffers = (OutputBuffer[])DynamicArray.append(this.buffers, b);
            }
            if (this.title != TestResult.MSG_SECTION_NAME) {
                if (line != null) {
                    if (line.startsWith(TestResult.JTR_V2_SECTRESULT)) {
                        this.result = Status.parse(line.substring(TestResult.JTR_V2_SECTRESULT.length()));
                    } else {
                        throw new ReloadFault(i18n, "rslt.badLine", line);
                    }
                }
                if (this.result == null) {
                    throw new ReloadFault(i18n, "rslt.noSectionResult");
                }
            }
        }

        void save(Writer out) throws IOException {
            out.write(TestResult.JTR_V2_SECTION + this.getTitle());
            out.write(lineSeparator);
            for (int index = 0; index < this.buffers.length; ++index) {
                boolean needsEscape;
                char c;
                int i;
                String text = this.buffers[index].getOutput();
                int numLines = 0;
                int numBackslashes = 0;
                int numNonASCII = 0;
                boolean needsFinalNewline = false;
                for (i = 0; i < text.length(); ++i) {
                    c = text.charAt(i);
                    if (c < ' ') {
                        if (c == '\n') {
                            ++numLines;
                            continue;
                        }
                        if (c == '\t' || c == '\r') continue;
                        ++numNonASCII;
                        continue;
                    }
                    if (c < '\u007f') {
                        if (c != '\\') continue;
                        ++numBackslashes;
                        continue;
                    }
                    ++numNonASCII;
                }
                boolean bl = needsEscape = numBackslashes > 0 || numNonASCII > 0;
                if (text.length() != 0 && !text.endsWith("\n")) {
                    needsFinalNewline = true;
                    ++numLines;
                }
                out.write(TestResult.JTR_V2_SECTSTREAM);
                out.write(this.buffers[index].getName());
                out.write(":");
                out.write(40);
                out.write(String.valueOf(numLines));
                out.write(47);
                if (needsEscape) {
                    out.write(String.valueOf(text.length() + numBackslashes + 5 * numNonASCII));
                } else {
                    out.write(String.valueOf(text.length()));
                }
                out.write(41);
                if (needsEscape) {
                    out.write(42);
                }
                out.write(TestResult.JTR_V2_SECTSTREAM);
                out.write(lineSeparator);
                if (needsEscape) {
                    block6: for (i = 0; i < text.length(); ++i) {
                        c = text.charAt(i);
                        if (' ' <= c && c < '\u007f' && c != '\\') {
                            out.write(c);
                            continue;
                        }
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case '\r': {
                                out.write(c);
                                continue block6;
                            }
                            case '\\': {
                                out.write("\\\\");
                                continue block6;
                            }
                            default: {
                                out.write("\\u");
                                out.write(Character.forDigit(c >> 12 & 0xF, 16));
                                out.write(Character.forDigit(c >> 8 & 0xF, 16));
                                out.write(Character.forDigit(c >> 4 & 0xF, 16));
                                out.write(Character.forDigit(c >> 0 & 0xF, 16));
                            }
                        }
                    }
                } else {
                    out.write(text);
                }
                if (!needsFinalNewline) continue;
                out.write(lineSeparator);
            }
            if (this.getTitle() != TestResult.MSG_SECTION_NAME) {
                out.write(TestResult.JTR_V2_SECTRESULT + this.result.toString());
                out.write(lineSeparator);
            }
            out.write(lineSeparator);
        }

        synchronized void reloadOutput(String name, String data) {
            if (name.equals(TestResult.MESSAGE_OUTPUT_NAME)) {
                name = TestResult.MESSAGE_OUTPUT_NAME;
            }
            FixedOutputBuffer b = new FixedOutputBuffer(name, data);
            this.buffers = (OutputBuffer[])DynamicArray.append(this.buffers, b);
        }

        synchronized void reloadStatus(Status s) {
            this.result = s;
        }

        private void checkMutable() {
            if (!this.isMutable()) {
                throw new IllegalStateException("This section of the test result is now immutable.");
            }
        }

        private synchronized void makeOutputImmutable(OutputBuffer b, String name, String output) {
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] != b) continue;
                this.buffers[i] = new FixedOutputBuffer(name, output);
                return;
            }
        }

        private synchronized OutputBuffer findOutputBuffer(String name) {
            for (int i = this.buffers.length - 1; i >= 0; --i) {
                if (!name.equals(this.buffers[i].getName())) continue;
                return this.buffers[i];
            }
            return null;
        }

        private class WritableOutputBuffer
        extends Writer
        implements OutputBuffer {
            private boolean overflowed;
            private int overflowStart;
            private final String name;
            private StringBuffer output;
            private final PrintWriter pw;

            WritableOutputBuffer(String name) {
                super(TestResult.this);
                if (name == null) {
                    throw new NullPointerException();
                }
                this.name = name;
                this.output = new StringBuffer();
                this.pw = new LockedWriter(this, TestResult.this);
            }

            public String getName() {
                return this.name;
            }

            public String getOutput() {
                return new String(this.output);
            }

            public PrintWriter getPrintWriter() {
                return this.pw;
            }

            public void write(char[] buf, int offset, int len) throws IOException {
                if (this.output == null) {
                    throw new IOException("stream has been closed");
                }
                int end = this.output.length();
                this.output.append(buf, offset, len);
                TestResult.this.notifyUpdatedOutput(Section.this, this.name, end, end, buf, offset, len);
                if (this.output.length() > maxOutputSize) {
                    int overflowEnd = maxOutputSize * 2 / 3;
                    if (this.overflowed) {
                        String s = this.output.toString();
                        this.output = new StringBuffer(s.substring(0, this.overflowStart) + s.substring(overflowEnd));
                        TestResult.this.notifyUpdatedOutput(Section.this, this.name, this.overflowStart, overflowEnd, "");
                    } else {
                        String OVERFLOW_MESSAGE = "\n\n...\nOutput overflow:\nJT Harness has limited the test output to the text to that\nat the beginning and the end, so that you can see how the\ntest began, and how it completed.\n\nIf you need to see more of the output from the test,\nset the system property javatest.maxOutputSize to a higher\nvalue. The current value is " + maxOutputSize + "\n...\n\n";
                        this.overflowStart = maxOutputSize / 3;
                        String s = this.output.toString();
                        this.output = new StringBuffer(s.substring(0, this.overflowStart) + OVERFLOW_MESSAGE + s.substring(overflowEnd));
                        TestResult.this.notifyUpdatedOutput(Section.this, this.name, this.overflowStart, overflowEnd, OVERFLOW_MESSAGE);
                        this.overflowStart += OVERFLOW_MESSAGE.length();
                        this.overflowed = true;
                    }
                }
            }

            public void flush() {
            }

            public void close() {
                Section.this.makeOutputImmutable(this, this.name, new String(this.output));
                TestResult.this.notifyCompletedOutput(Section.this, this.name);
            }
        }

        private class FixedOutputBuffer
        implements OutputBuffer {
            private final String name;
            private final String output;

            FixedOutputBuffer(String name, String output) {
                if (name == null || output == null) {
                    throw new NullPointerException();
                }
                this.name = name;
                this.output = output;
            }

            public String getName() {
                return this.name;
            }

            public String getOutput() {
                return this.output;
            }

            public PrintWriter getPrintWriter() {
                throw new IllegalStateException("This section is immutable");
            }

            FixedOutputBuffer(String header, BufferedReader in) throws ReloadFault {
                String nm = TestResult.this.extractSlice(header, TestResult.JTR_V2_SECTSTREAM.length(), null, ":");
                if (nm == null) {
                    throw new ReloadFault(i18n, "rslt.noOutputTitle");
                }
                if (nm.equals(TestResult.MESSAGE_OUTPUT_NAME)) {
                    nm = TestResult.MESSAGE_OUTPUT_NAME;
                }
                try {
                    boolean needsEscape;
                    int chars;
                    try {
                        int start = TestResult.JTR_V2_SECTSTREAM.length();
                        int lines = Integer.parseInt(TestResult.this.extractSlice(header, start, "(", "/"));
                        chars = Integer.parseInt(TestResult.this.extractSlice(header, start, "/", ")"));
                        int rp = header.indexOf(")", start);
                        needsEscape = rp >= 0 && rp < header.length() - 2 ? header.charAt(rp + 1) == '*' : false;
                    }
                    catch (NumberFormatException e) {
                        throw new ReloadFault(i18n, "rslt.badHeaderVersion", e);
                    }
                    StringBuffer buff = new StringBuffer(chars);
                    if (needsEscape) {
                        for (int i = 0; i < chars; ++i) {
                            int c = in.read();
                            if (c == -1) {
                                throw new ReloadFault(i18n, "rslt.badEOF");
                            }
                            if (c == 92) {
                                c = in.read();
                                ++i;
                                if (c == 117) {
                                    c = Character.digit((char)in.read(), 16) << 12;
                                    c += Character.digit((char)in.read(), 16) << 8;
                                    c += Character.digit((char)in.read(), 16) << 4;
                                    c += Character.digit((char)in.read(), 16);
                                    i += 4;
                                }
                            }
                            buff.append((char)c);
                        }
                    } else {
                        int n;
                        char[] data = new char[Math.min(4096, chars)];
                        for (int charsRead = 0; charsRead < chars; charsRead += n) {
                            n = in.read(data, 0, Math.min(data.length, chars - charsRead));
                            buff.append(data, 0, n);
                        }
                    }
                    this.name = nm;
                    this.output = buff.toString();
                    if (buff.length() > 0 && buff.charAt(buff.length() - 1) != '\n') {
                        int c = in.read();
                        if (c == 13) {
                            c = in.read();
                        }
                        if (c != 10) {
                            System.err.println("TR.badChars: output=" + (this.output.length() < 32 ? this.output : this.output.substring(0, 9) + " ... " + this.output.substring(this.output.length() - 10)));
                            System.err.println("TR.badChars: '" + (char)c + "' (" + c + ")");
                            throw new ReloadFault(i18n, "rslt.badChars", this.name);
                        }
                    }
                }
                catch (IOException e) {
                    throw new ReloadFault(i18n, "rslt.badFile", e);
                }
            }
        }
    }

    public static interface Observer {
        public void createdSection(TestResult var1, Section var2);

        public void completedSection(TestResult var1, Section var2);

        public void createdOutput(TestResult var1, Section var2, String var3);

        public void completedOutput(TestResult var1, Section var2, String var3);

        public void updatedOutput(TestResult var1, Section var2, String var3, int var4, int var5, String var6);

        public void updatedProperty(TestResult var1, String var2, String var3);

        public void completed(TestResult var1);
    }

    public static class ReloadFault
    extends Fault {
        ReloadFault(I18NResourceBundle i18n, String key) {
            super(i18n, key);
        }

        ReloadFault(I18NResourceBundle i18n, String key, Object arg) {
            super(i18n, key, arg);
        }

        ReloadFault(I18NResourceBundle i18n, String key, Object[] args) {
            super(i18n, key, args);
        }
    }

    public static class ResultFileNotFoundFault
    extends Fault {
        ResultFileNotFoundFault(I18NResourceBundle i18n, String key) {
            super(i18n, key);
        }

        ResultFileNotFoundFault(I18NResourceBundle i18n, String key, Object arg) {
            super(i18n, key, arg);
        }

        ResultFileNotFoundFault(I18NResourceBundle i18n, String key, Object[] args) {
            super(i18n, key, args);
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String key) {
            super(i18n.getString(key));
        }

        Fault(I18NResourceBundle i18n, String key, Object arg) {
            super(i18n.getString(key, arg));
        }

        Fault(I18NResourceBundle i18n, String key, Object[] args) {
            super(i18n.getString(key, args));
        }
    }
}

