/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.SocketConnection;
import com.sun.javatest.util.DynamicArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AgentManager {
    private static final AgentManager theManager = new AgentManager();
    private Observer[] observers = new Observer[0];
    private ActiveAgentPool pool = new ActiveAgentPool();
    private static final int PASSIVE_AGENT_RETRY_LIMIT = 12;

    public static AgentManager access() {
        return theManager;
    }

    private AgentManager() {
    }

    public synchronized void addObserver(Observer o) {
        this.observers = (Observer[])DynamicArray.append(this.observers, o);
    }

    public synchronized void removeObserver(Observer o) {
        this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, o);
    }

    private synchronized void notifyStarted(Connection connection, String tag, String request, String executable, String[] args, boolean localizeArgs) {
        for (int i = 0; i < this.observers.length; ++i) {
            this.observers[i].started(connection, tag, request, executable, args, localizeArgs);
        }
    }

    private synchronized void notifyFinished(Connection connection, Status status) {
        for (int i = 0; i < this.observers.length; ++i) {
            this.observers[i].finished(connection, status);
        }
    }

    public ActiveAgentPool getActiveAgentPool() {
        return this.pool;
    }

    public Task connect(Connection c) throws IOException {
        return new Task(c);
    }

    public Task connectToActiveAgent() throws ActiveAgentPool.NoAgentException, InterruptedException, IOException {
        return this.connect(this.pool.nextAgent());
    }

    public Task connectToPassiveAgent(String host) throws IOException {
        if (host == null) {
            throw new NullPointerException();
        }
        return this.connectToPassiveAgent(host, 1908);
    }

    public Task connectToPassiveAgent(String host, int port) throws IOException {
        if (host == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (true) {
            try {
                return this.connect(new SocketConnection(host, port));
            }
            catch (ConnectException e) {
                if (i == 12) {
                    throw e;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public class Task {
        private Connection connection;
        private DataInputStream in;
        private DataOutputStream out;
        private File[] classPath;
        private Hashtable zips = new Hashtable();

        Task(Connection c) throws IOException {
            this.connection = c;
            this.in = new DataInputStream(new BufferedInputStream(c.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(c.getOutputStream()));
        }

        public Connection getConnection() {
            return this.connection;
        }

        public File[] getClassPath() {
            return this.classPath;
        }

        public void setClassPath(String path) {
            this.classPath = this.split(path);
        }

        public void setClassPath(File[] path) {
            if (path == null) {
                throw new NullPointerException();
            }
            for (int i = 0; i < path.length; ++i) {
                if (path[i] != null) continue;
                throw new IllegalArgumentException();
            }
            this.classPath = path;
        }

        public Status executeTest(String tag, String className, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            return this.run(tag, "executeTest", className, args, localizeArgs, log, ref);
        }

        public Status executeCommand(String tag, String className, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            return this.run(tag, "executeCommand", className, args, localizeArgs, log, ref);
        }

        public Status executeMain(String tag, String className, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            return this.run(tag, "executeMain", className, args, localizeArgs, log, ref);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Status run(String tag, String request, String executable, String[] args, boolean localizeArgs, PrintWriter log, PrintWriter ref) {
            AgentManager.this.notifyStarted(this.connection, tag, request, executable, args, localizeArgs);
            Status result = null;
            try {
                this.out.writeShort(103);
                this.out.writeUTF(tag);
                this.out.writeUTF(request);
                this.out.writeUTF(executable);
                this.out.writeShort(args.length);
                for (int i = 0; i < args.length; ++i) {
                    this.out.writeUTF(args[i]);
                }
                this.out.writeBoolean(localizeArgs);
                this.out.writeBoolean(this.classPath != null);
                this.out.writeByte(0);
                this.out.flush();
                result = this.readResults(log, ref);
            }
            catch (IOException e) {
                try {
                    try {
                        if (this.out != null) {
                            this.out.close();
                        }
                        if (this.in != null) {
                            this.in.close();
                        }
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    result = e instanceof InterruptedIOException ? Status.error("Communication with agent interrupted! (timed out?)") : Status.error("Problem communicating with agent: " + e);
                }
                catch (Throwable throwable) {
                    AgentManager.this.notifyFinished(this.connection, result);
                    throw throwable;
                }
                AgentManager.this.notifyFinished(this.connection, result);
            }
            AgentManager.this.notifyFinished(this.connection, result);
            return result;
        }

        private Status readResults(PrintWriter log, PrintWriter ref) throws IOException {
            byte[] buf = new byte[1024];
            Status status = null;
            while (status == null) {
                int code = this.in.read();
                block0 : switch (code) {
                    case -1: {
                        status = Status.error("premature EOF from agent");
                        break;
                    }
                    case 67: {
                        String className = this.in.readUTF();
                        byte[] classData = this.locateClass(className);
                        if (classData == null) {
                            this.out.writeInt(0);
                        } else {
                            this.out.writeInt(classData.length);
                            this.out.write(classData, 0, classData.length);
                        }
                        this.out.flush();
                        break;
                    }
                    case 68: {
                        String resourceName = this.in.readUTF();
                        byte[] resourceData = this.locateData(resourceName);
                        if (resourceData == null) {
                            this.out.writeInt(0);
                        } else {
                            this.out.writeInt(resourceData.length);
                            this.out.write(resourceData, 0, resourceData.length);
                        }
                        this.out.flush();
                        break;
                    }
                    case 83: {
                        int type = this.in.read();
                        String reason = this.in.readUTF();
                        switch (type) {
                            case 0: {
                                status = Status.passed(reason);
                                break block0;
                            }
                            case 1: {
                                status = Status.failed(reason);
                                break block0;
                            }
                            case 2: {
                                status = Status.error(reason);
                                break block0;
                            }
                        }
                        status = Status.failed("Bad status from test: type=" + type + " reason=" + reason);
                        break;
                    }
                    case 76: {
                        log.write(this.in.readUTF());
                        break;
                    }
                    case 108: {
                        log.write(this.in.readUTF());
                        log.flush();
                        break;
                    }
                    case 82: {
                        ref.write(this.in.readUTF());
                        break;
                    }
                    case 114: {
                        ref.write(this.in.readUTF());
                        ref.flush();
                    }
                }
            }
            this.out.close();
            this.in.close();
            this.connection.close();
            log.flush();
            ref.flush();
            Enumeration e = this.zips.keys();
            while (e.hasMoreElements()) {
                File f = (File)e.nextElement();
                ZipFile z = (ZipFile)this.zips.get(f);
                this.zips.remove(f);
                z.close();
            }
            return status;
        }

        private byte[] locateClass(String name) {
            if (this.classPath != null) {
                String cname = name.replace('.', '/') + ".class";
                for (int i = 0; i < this.classPath.length; ++i) {
                    byte[] data = this.classPath[i].isDirectory() ? this.readFromDir(cname, this.classPath[i]) : this.readFromJar(cname, this.classPath[i]);
                    if (data == null) continue;
                    return data;
                }
            }
            return null;
        }

        private byte[] locateData(String name) {
            if (this.classPath != null) {
                for (int i = 0; i < this.classPath.length; ++i) {
                    byte[] data = this.classPath[i].isDirectory() ? this.readFromDir(name, this.classPath[i]) : this.readFromJar(name, this.classPath[i]);
                    if (data == null) continue;
                    return data;
                }
            }
            return null;
        }

        private byte[] readFromDir(String name, File dir) {
            try {
                File file = new File(dir, name);
                return this.read(new FileInputStream(file), (int)file.length());
            }
            catch (IOException e) {
                return null;
            }
        }

        private byte[] readFromJar(String name, File jarFile) {
            try {
                ZipEntry ze;
                ZipFile z = (ZipFile)this.zips.get(jarFile);
                if (z == null) {
                    z = new ZipFile(jarFile);
                    this.zips.put(jarFile, z);
                }
                if ((ze = z.getEntry(name)) == null) {
                    return null;
                }
                return this.read(z.getInputStream(ze), (int)ze.getSize());
            }
            catch (IOException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] read(InputStream in, int size) throws IOException {
            try {
                int n;
                byte[] data = new byte[size];
                for (int total = 0; total < data.length; total += n) {
                    n = in.read(data, total, data.length - total);
                    if (n > 0) {
                        continue;
                    }
                    throw new EOFException("unexpected end of file");
                }
                byte[] byArray = data;
                return byArray;
            }
            finally {
                in.close();
            }
        }

        private File[] split(String s) {
            char pathCh = File.pathSeparatorChar;
            Vector v = new Vector();
            int start = 0;
            int i = s.indexOf(pathCh);
            while (i != -1) {
                this.add(s.substring(start, i), v);
                start = i + 1;
                i = s.indexOf(pathCh, start);
            }
            if (start != s.length()) {
                this.add(s.substring(start), v);
            }
            Object[] path = new File[v.size()];
            v.copyInto(path);
            return path;
        }

        private void add(String s, Vector v) {
            if (s.length() != 0) {
                v.addElement(new File(s));
            }
        }
    }

    public static interface Observer {
        public void started(Connection var1, String var2, String var3, String var4, String[] var5, boolean var6);

        public void finished(Connection var1, Status var2);
    }
}

