/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.CE_FullView;
import com.sun.javatest.exec.CE_StdView;
import com.sun.javatest.exec.CE_TemplateDialog;
import com.sun.javatest.exec.CE_View;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.DetailsBrowser;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.WorkDirChooseTool;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.help.BadIDException;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class ConfigEditor
extends ToolDialog {
    public static final int DEFAULT_MODE = 0;
    public static final int FULL_MODE = 1;
    public static final int STD_MODE = 2;
    public static final int STD_TESTS_MODE = 3;
    public static final int STD_EXCLUDE_LIST_MODE = 4;
    public static final int STD_KEYWORDS_MODE = 5;
    public static final int STD_PRIOR_STATUS_MODE = 6;
    public static final int STD_ENVIRONMENT_MODE = 7;
    public static final int STD_CONCURRENCY_MODE = 8;
    public static final int STD_TIMEOUT_FACTOR_MODE = 9;
    public static final int TEMPLATE_FULL_MODE = 10;
    private Runnable afterCloseCommand;
    private boolean templateMode = false;
    private boolean runPending;
    private InterviewParameters mainConfig;
    private InterviewParameters viewConfig;
    private FileHistory history;
    private FileHistory historyTemplate;
    private boolean saveRequired;
    private JMenu markerMenu;
    private JMenu searchMenu;
    private JMenu viewMenu;
    private JRadioButtonMenuItem viewFullBtn;
    private JRadioButtonMenuItem viewStdBtn;
    private JCheckBoxMenuItem viewInfoCheckBox;
    private JCheckBoxMenuItem viewTagCheckBox;
    private JMenuItem viewRefreshItem;
    private JComponent body;
    private JPanel views;
    private JHelpContentViewer infoPanel;
    private CE_FullView fullView;
    private CE_StdView stdView;
    private CE_View currView;
    private Listener listener;
    private CE_TemplateDialog templateDialog;
    private ActionListener closeListener;
    private ExecModel model;
    private Observer observer;
    private DetailsBrowser detailsBrowser;
    private static final KeyStroke detailsKey = KeyStroke.getKeyStroke("shift alt D");
    static final String JTI = ".jti";
    static final String TEMPLATE_EXTENSION = ".jtm";
    static final String JTM = ".jtm";
    private static final String NEW = "new";
    private static final String LOAD = "load";
    private static final String NEWT = "newt";
    private static final String LOADT = "loadt";
    private static final String SAVE = "save";
    private static final String SAVE_AS = "saveAs";
    private static final String SAVE_AS_TEMPLATE = "saveAsTemplate";
    private static final String REVERT = "revert";
    private static final String DONE = "done";
    private static final String REFRESH = "refresh";
    private static final String DETAILS = "details";
    static final String CLOSE = "close";
    static final String MORE_INFO_PREF = "exec.config.moreInfo";
    static final String VIEW_PREF = "exec.config.view";

    ConfigEditor(JComponent parent, InterviewParameters config, ExecModel model, UIFactory uif) {
        super(parent, uif, "ce");
        this.model = model;
        this.history = FileHistory.getFileHistory(config.getWorkDirectory(), "configHistory.jtl");
        this.historyTemplate = FileHistory.getFileHistory(config.getWorkDirectory(), "templateHistory.jtl");
        this.mainConfig = config;
        try {
            this.viewConfig = config.getTestSuite().createInterview();
            this.viewConfig.setWorkDirectory(this.mainConfig.getWorkDirectory());
            this.copy(this.mainConfig, this.mainConfig);
            this.copy(this.mainConfig, this.viewConfig);
        }
        catch (Interview.Fault e) {
        }
        catch (TestSuite.Fault e) {
            // empty catch block
        }
    }

    public void clear() {
        this.clear(false);
    }

    void clear(boolean isTemplate) {
        this.templateMode = isTemplate;
        if (this.stdView == null) {
            this.initGUI();
        }
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        if (this.viewConfig.isEdited()) {
            if (!ConfigEditor.equal(this.mainConfig, this.viewConfig)) {
                int rc = this.uif.showYesNoCancelDialog("ce.clear.warn");
                switch (rc) {
                    case 0: {
                        if (this.save0()) break;
                        return;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.viewConfig.clear();
            this.viewConfig.setEdited(false);
        }
        this.viewConfig.setTemplate(this.templateMode);
        this.mainConfig.setTemplate(this.templateMode);
        File f = TemplateUtilities.getTemplateFile(this.mainConfig.getWorkDirectory());
        if (f != null) {
            try {
                this.model.getTestSuite().loadInterviewFromTemplate(f, this.viewConfig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TestSuite.Fault fault) {
                fault.printStackTrace();
            }
        }
        this.updateTitle();
        this.setView(this.fullView);
        this.setVisible(true);
    }

    public void load(boolean isTemplate) {
        JComponent jparent = (JComponent)SwingUtilities.getAncestorOfClass(JComponent.class, this.parent);
        WorkDirChooseTool tool = isTemplate ? WorkDirChooseTool.getTool(jparent, this.uif, this.model, 3, this.model.getTestSuite(), true) : WorkDirChooseTool.getTool(jparent, this.uif, this.model, 4, this.model.getTestSuite(), true);
        tool.setConfigEditor(this);
        tool.doTool();
    }

    public void load(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.load0(file, true);
    }

    public void loadNoUI(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.load0(file, false);
    }

    private void load0(File file, boolean showUI) {
        ContextManager cm;
        FeatureManager fm;
        if (this.isEdited()) {
            int rc = this.uif.showYesNoCancelDialog("ce.load.warn");
            switch (rc) {
                case 0: {
                    if (this.save0()) break;
                    return;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if ((fm = (cm = this.model.getContextManager()).getFeatureManager()) != null && !fm.isEnabled(5) && !fm.isEnabled(0)) {
            try {
                TemplateUtilities.ConfigInfo info = TemplateUtilities.getConfigInfo(file);
                if (info != null) {
                    String wdTmpl = TemplateUtilities.getTemplatePath(this.model.getWorkDirectory());
                    if (info.getTemplatePath() != null && !info.getTemplatePath().equals(wdTmpl)) {
                        this.uif.showError("ce.load.cmismatch", new Object[]{wdTmpl, info.getTemplatePath()});
                        return;
                    }
                }
            }
            catch (Throwable e) {
                this.uif.showError("ce.load.badfile", file.getPath());
                return;
            }
        }
        File mainConfigFile = this.mainConfig.getFile();
        FileChooser fileChooser = this.getFileChooser();
        if (mainConfigFile != null) {
            fileChooser.setCurrentDirectory(mainConfigFile.getParentFile());
        }
        if (showUI) {
            file = ConfigEditor.loadConfigFile(this.model.getContextManager(), this.parent, this.uif, fileChooser);
        }
        if (file == null) {
            return;
        }
        try {
            this.mainConfig.load(file);
            this.copy(this.mainConfig, this.viewConfig);
            if (this.currView != null && this.currView.isShowing()) {
                this.currView.load();
            }
            this.templateMode = this.mainConfig.isTemplate();
            if (this.templateMode) {
                this.historyTemplate.add(file);
            } else {
                this.history.add(file);
            }
            this.updateTitle();
            if (this.observer != null) {
                this.observer.loaded(this.mainConfig);
            }
        }
        catch (FileNotFoundException e) {
            this.uif.showError("ce.load.cantFindFile", file);
        }
        catch (IOException e) {
            this.uif.showError("ce.load.error", new Object[]{file, e});
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.load.error", new Object[]{file, e.getMessage()});
        }
    }

    public void save() {
        this.save0();
    }

    void saveMain() {
        File file = this.mainConfig.getFile();
        if (file == null) {
            throw new IllegalStateException("No configuration file saved yet, cannot update!");
        }
        try {
            this.mainConfig.save(file);
            if (this.observer != null) {
                this.observer.saved(this.mainConfig);
            }
        }
        catch (IOException e) {
            if (!file.canWrite()) {
                this.uif.showError("ce.save.cantWriteFile", file);
            } else if (e instanceof FileNotFoundException) {
                this.uif.showError("ce.save.cantFindFile", file);
            } else {
                this.uif.showError("ce.save.error", new Object[]{file, e});
            }
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.save.error", new Object[]{file, e.getMessage()});
        }
    }

    private boolean save0() {
        return this.save0(this.viewConfig.getFile());
    }

    public void saveAs() {
        this.save0(null);
    }

    private boolean save0(File file) {
        File mainConfigFile;
        File mainConfigDir;
        if (file == null && (file = this.getSaveFile(mainConfigDir = (mainConfigFile = this.mainConfig.getFile()) == null ? null : mainConfigFile.getParentFile())) == null) {
            return false;
        }
        try {
            if (this.currView != null) {
                this.currView.save();
                this.copy(this.viewConfig, this.mainConfig, false);
            }
            this.mainConfig.save(file, this.templateMode);
            this.viewConfig.setFile(file);
            if (this.templateMode) {
                TemplateUtilities.setTemplateFile(this.viewConfig.getWorkDirectory(), file, true);
                this.historyTemplate.add(file);
            } else {
                this.history.add(file);
            }
            this.updateTitle();
            if (this.observer != null) {
                this.observer.saved(this.mainConfig);
            }
            return true;
        }
        catch (IOException e) {
            if (!file.canWrite()) {
                this.uif.showError("ce.save.cantWriteFile", file);
            } else if (e instanceof FileNotFoundException) {
                this.uif.showError("ce.save.cantFindFile", file);
            } else {
                this.uif.showError("ce.save.error", new Object[]{file, e});
            }
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.save.error", new Object[]{file, e.getMessage()});
        }
        return false;
    }

    private File getSaveFile(File dir) {
        FileChooser fileChooser = this.getFileChooser();
        if (this.templateMode) {
            fileChooser.setDialogTitle(this.uif.getI18NString("ce.save.titlet"));
        } else {
            fileChooser.setDialogTitle(this.uif.getI18NString("ce.save.title"));
        }
        return ConfigEditor.saveConfigFile(this.model.getContextManager(), this.parent, this.uif, fileChooser, dir, this.templateMode);
    }

    private FileChooser getFileChooser() {
        FileChooser fileChooser = new FileChooser(true);
        if (this.templateMode) {
            fileChooser.addChoosableExtension(".jtm", this.uif.getI18NString("ce.jtmFiles"));
        } else {
            fileChooser.addChoosableExtension(JTI, this.uif.getI18NString("ce.jtiFiles"));
        }
        return fileChooser;
    }

    public void saveAsTemplate() {
        if (this.templateDialog == null) {
            this.templateDialog = new CE_TemplateDialog(this.getTool(), this.viewConfig, this.model, this.uif);
        }
        if (this.currView != null) {
            this.currView.save();
        }
        this.templateDialog.setVisible(true);
    }

    public void revert() {
        if (!this.isEdited()) {
            return;
        }
        int rc = this.uif.showOKCancelDialog("ce.revert.warn");
        if (rc != 0) {
            return;
        }
        try {
            this.copy(this.mainConfig, this.viewConfig);
            if (this.currView != null && this.currView.isShowing()) {
                this.currView.load();
            }
            this.updateTitle();
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.revert", e.getMessage());
        }
    }

    public void setRunPending(boolean b) {
        this.runPending = b;
    }

    public boolean isRunPending() {
        return this.runPending;
    }

    public void show(boolean isTemplateMode) {
        if (this.stdView == null) {
            this.initGUI();
        }
        this.show(0, isTemplateMode);
    }

    public void show(int mode, boolean isTemplateMode) {
        this.templateMode = isTemplateMode;
        if (this.stdView == null) {
            this.initGUI();
        }
        this.updateTitle();
        switch (mode) {
            case 0: {
                this.show(this.currView == null ? this.getDefaultView() : this.currView);
                break;
            }
            case 1: {
                this.show(this.fullView);
                break;
            }
            case 2: {
                this.show(this.stdView);
                break;
            }
            case 3: {
                this.stdView.showTab(0);
                this.show(this.stdView);
                break;
            }
            case 4: {
                this.stdView.showTab(1);
                this.show(this.stdView);
                break;
            }
            case 5: {
                this.stdView.showTab(2);
                this.show(this.stdView);
                break;
            }
            case 6: {
                this.stdView.showTab(3);
                this.show(this.stdView);
                break;
            }
            case 7: {
                this.stdView.showTab(4);
                this.show(this.stdView);
                break;
            }
            case 8: {
                this.stdView.showTab(6);
                this.show(this.stdView);
                break;
            }
            case 9: {
                this.stdView.showTab(7);
                this.show(this.stdView);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void show(ActionListener closeListener, boolean isTemplateMode) {
        this.closeListener = closeListener;
        this.show(isTemplateMode);
    }

    public void show(int mode, ActionListener closeListener, boolean isTemplateMode) {
        this.closeListener = closeListener;
        this.show(mode, isTemplateMode);
    }

    private void show(CE_View newView) {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        } else {
            try {
                this.copy(this.mainConfig, this.viewConfig);
            }
            catch (Interview.Fault e) {
                this.uif.showError("ce.show.error", e.getMessage());
            }
        }
        this.setView(newView);
        this.setVisible(true);
    }

    private void setView(CE_View newView) {
        if (newView == null) {
            throw new NullPointerException();
        }
        if (this.currView != newView) {
            Container fcr;
            FocusTraversalPolicy ftp;
            Component c;
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component fo = kfm.getPermanentFocusOwner();
            boolean focusInView = fo != null && this.currView != null && this.currView.isAncestorOf(fo);
            this.currView = newView;
            this.currView.load();
            ((CardLayout)this.views.getLayout()).show(this.views, this.currView.getName());
            if (focusInView && (c = (ftp = (fcr = this.currView.isFocusCycleRoot() ? this.currView : this.currView.getFocusCycleRootAncestor()).getFocusTraversalPolicy()).getDefaultComponent(fcr)) != null) {
                c.requestFocusInWindow();
            }
            boolean currIsFull = this.currView == this.fullView;
            this.markerMenu.setEnabled(currIsFull);
            this.searchMenu.setEnabled(currIsFull);
            (currIsFull ? this.viewFullBtn : this.viewStdBtn).setSelected(true);
            this.viewTagCheckBox.setEnabled(currIsFull);
            if (this.detailsBrowser != null) {
                this.detailsBrowser.setQuestionInfoEnabled(currIsFull);
            }
            this.updateTitle();
        }
    }

    public void close() {
        if (this.currView != null && !this.currView.isOKToClose()) {
            if (this.afterCloseCommand != null) {
                this.afterCloseCommand.run();
                this.afterCloseCommand = null;
            }
            return;
        }
        this.close(true);
    }

    protected void windowClosingAction(AWTEvent e) {
        if (!this.canInterruptTemplateCreation()) {
            this.uif.showError("ce.force_close");
            return;
        }
        if (this.fullView.isVisible()) {
            this.fullView.prepareClosing();
        }
        this.close();
    }

    private void close(boolean checkIfEdited) {
        if (this.currView == null) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        if (checkIfEdited && this.isEdited()) {
            int rc = this.uif.showYesNoCancelDialog("ce.close.warn");
            switch (rc) {
                case 0: {
                    if (this.save0()) break;
                    if (this.afterCloseCommand != null) {
                        this.afterCloseCommand.run();
                        this.afterCloseCommand = null;
                    }
                    return;
                }
                case 1: {
                    try {
                        this.copy(this.mainConfig, this.viewConfig);
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    if (this.afterCloseCommand != null) {
                        this.afterCloseCommand.run();
                        this.afterCloseCommand = null;
                    }
                    return;
                }
            }
        }
        this.setVisible(false);
        if (this.closeListener != null) {
            ActionEvent e = new ActionEvent(this, 1001, CLOSE);
            this.closeListener.actionPerformed(e);
            this.closeListener = null;
        }
        if (this.afterCloseCommand != null) {
            this.afterCloseCommand.run();
            this.afterCloseCommand = null;
        }
    }

    void setCheckExcludeListListener(ActionListener l) {
        if (this.stdView == null) {
            this.initGUI();
        }
        this.stdView.setCheckExcludeListListener(l);
    }

    boolean isCurrentQuestionChanged() {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        Question mq = this.mainConfig.getCurrentQuestion();
        Question vq = this.viewConfig.getCurrentQuestion();
        return !ConfigEditor.equal(mq.getTag(), vq.getTag());
    }

    boolean isEdited() {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        return !ConfigEditor.equal(this.mainConfig, this.viewConfig);
    }

    private static boolean equal(InterviewParameters a, InterviewParameters b) {
        if (a.getMarkersEnabled() != b.getMarkersEnabled() || a.getMarkersFilterEnabled() != b.getMarkersFilterEnabled()) {
            return false;
        }
        Map aQuestions = a.getAllQuestions();
        Map bQuestions = b.getAllQuestions();
        TreeSet keys = new TreeSet();
        keys.addAll(aQuestions.keySet());
        keys.addAll(bQuestions.keySet());
        for (String key : keys) {
            boolean eq;
            Question aq = (Question)aQuestions.get(key);
            Question bq = (Question)bQuestions.get(key);
            if (aq == null || bq == null) {
                return false;
            }
            if (aq.equals(bq) || (eq = aq.getStringValue() == null && bq.getStringValue() == "" || aq.getStringValue() == "" && bq.getStringValue() == null)) continue;
            return false;
        }
        return true;
    }

    void setObserver(Observer o) {
        this.observer = o;
    }

    private static boolean equal(String a, String b) {
        return a == null || b == null ? a == b : a.equals(b);
    }

    protected void initGUI() {
        this.setHelp("confEdit.window.csh");
        this.listener = new Listener();
        this.updateTitle();
        if (this.viewConfig.getHelpSet() != null) {
            this.infoPanel = new JHelpContentViewer(this.viewConfig.getHelpSet());
            this.infoPanel.setName("info");
            int dpi = this.uif.getDotsPerInch();
            this.infoPanel.setPreferredSize(new Dimension(4 * dpi, 3 * dpi));
            this.infoPanel.putClientProperty("helpBrokerForHelpLink", this.uif.getHelpBroker());
        }
        this.fullView = new CE_FullView(this.viewConfig, this.infoPanel, this.uif, this.listener);
        this.stdView = new CE_StdView(this.viewConfig, this.infoPanel, this.uif, this.listener);
        this.initMenuBar();
        this.views = this.uif.createPanel("ce.views", new CardLayout(), false);
        this.views.add((Component)this.fullView, this.fullView.getName());
        this.views.add((Component)this.stdView, this.stdView.getName());
        if (this.infoPanel == null) {
            this.viewInfoCheckBox.setEnabled(false);
            this.viewInfoCheckBox.setSelected(false);
        } else {
            Preferences p = Preferences.access();
            boolean prefMoreInfo = p.getPreference(MORE_INFO_PREF, "true").equals("true");
            this.viewInfoCheckBox.setEnabled(true);
            this.viewInfoCheckBox.setSelected(prefMoreInfo);
        }
        if (this.viewInfoCheckBox.isSelected()) {
            this.views.setBorder(null);
            JSplitPane sp = this.uif.createSplitPane(1, this.views, this.infoPanel);
            sp.setDividerLocation(this.views.getPreferredSize().width + sp.getDividerSize());
            this.body = sp;
        } else {
            this.views.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.body = this.views;
        }
        this.views.registerKeyboardAction(this.listener, DETAILS, detailsKey, 1);
        if (this.infoPanel != null) {
            this.infoPanel.registerKeyboardAction(this.listener, DETAILS, detailsKey, 1);
        }
        this.setBody(this.body);
        this.setDefaultCloseOperation(0);
    }

    private void initMenuBar() {
        JMenuBar menuBar = this.uif.createMenuBar("ce.menub");
        ContextManager cm = this.model.getContextManager();
        String[] fileMenuItems = cm != null && !cm.getFeatureManager().isEnabled(2) ? new String[]{SAVE, SAVE_AS, REVERT, null, NEW, LOAD, null, CLOSE} : new String[]{SAVE, SAVE_AS, REVERT, null, NEW, LOAD, null, NEWT, LOADT, null, CLOSE};
        int historyIndex = fileMenuItems.length - 5;
        JMenu fileMenu = this.uif.createMenu("ce.file", fileMenuItems, this.listener);
        FileHistory h = FileHistory.getFileHistory(this.viewConfig.getWorkDirectory(), "configHistory.jtl");
        FileHistory.Listener l = new FileHistory.Listener(h, 0, this.listener);
        JMenu mm = this.uif.createMenu("ce.history");
        mm.addMenuListener(l);
        fileMenu.insert(mm, historyIndex);
        if (cm == null || cm != null && cm.getFeatureManager().isEnabled(2)) {
            int historyTemplateIndex = fileMenuItems.length - 1;
            FileHistory ht = FileHistory.getFileHistory(this.viewConfig.getWorkDirectory(), "templateHistory.jtl");
            FileHistory.Listener lt = new FileHistory.Listener(ht, 0, this.listener);
            JMenu mmt = this.uif.createMenu("ce.templatehistory");
            mmt.addMenuListener(lt);
            fileMenu.insert(mmt, historyTemplateIndex);
        }
        menuBar.add(fileMenu);
        this.markerMenu = this.fullView.getMarkerMenu();
        menuBar.add(this.markerMenu);
        this.searchMenu = this.fullView.getSearchMenu();
        menuBar.add(this.searchMenu);
        this.viewMenu = this.uif.createMenu("ce.view");
        this.viewMenu.addMenuListener(this.listener);
        ButtonGroup viewGroup = new ButtonGroup();
        this.viewFullBtn = this.uif.createRadioButtonMenuItem("ce.view", "full");
        this.viewFullBtn.setSelected(true);
        this.viewFullBtn.setActionCommand("full");
        this.viewFullBtn.addActionListener(this.listener);
        viewGroup.add(this.viewFullBtn);
        this.viewMenu.add(this.viewFullBtn);
        this.viewStdBtn = this.uif.createRadioButtonMenuItem("ce.view", "std");
        this.viewStdBtn.setActionCommand("std");
        this.viewStdBtn.addActionListener(this.listener);
        viewGroup.add(this.viewStdBtn);
        this.viewMenu.add(this.viewStdBtn);
        this.viewMenu.addSeparator();
        this.viewInfoCheckBox = this.uif.createCheckBoxMenuItem("ce.view", "info", false);
        this.viewInfoCheckBox.addChangeListener(this.listener);
        this.viewMenu.add(this.viewInfoCheckBox);
        this.viewTagCheckBox = this.uif.createCheckBoxMenuItem("ce.view", "tag", false);
        this.viewTagCheckBox.setAccelerator(KeyStroke.getKeyStroke("alt T"));
        this.viewTagCheckBox.addChangeListener(this.listener);
        this.viewMenu.add(this.viewTagCheckBox);
        this.viewMenu.addSeparator();
        this.viewRefreshItem = this.uif.createMenuItem("ce.view", REFRESH, this.listener);
        this.viewRefreshItem.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.viewMenu.add(this.viewRefreshItem);
        menuBar.add(this.viewMenu);
        menuBar.add(this.uif.createHorizontalGlue("ce.pad"));
        JMenu helpMenu = this.uif.createMenu("ce.help");
        JMenuItem mainItem = this.uif.createHelpMenuItem("ce.help.main", "confEdit.window.csh");
        helpMenu.add(mainItem);
        mainItem = this.uif.createHelpMenuItem("ce.help.maint", "confEdit.templateDialog.csh");
        helpMenu.add(mainItem);
        JMenuItem fullItem = this.uif.createHelpMenuItem("ce.help.full", "confEdit.fullView.csh");
        helpMenu.add(fullItem);
        JMenuItem stdItem = this.uif.createHelpMenuItem("ce.help.std", "confEdit.stdView.csh");
        helpMenu.add(stdItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    private void updateTitle() {
        File f = this.viewConfig.getFile();
        if (this.templateMode) {
            this.setI18NTitle("ce.titlet", new Object[]{new Integer(this.currView == this.fullView ? 0 : 1), new Integer(f == null ? 0 : 1), f});
        } else {
            this.setI18NTitle("ce.title", new Object[]{new Integer(this.currView == this.fullView ? 0 : 1), new Integer(f == null ? 0 : 1), f});
        }
    }

    private boolean isInfoVisible() {
        return this.body instanceof JSplitPane;
    }

    private void setInfoVisible(boolean b) {
        if (this.infoPanel == null) {
            throw new IllegalStateException();
        }
        if (b == this.isInfoVisible()) {
            return;
        }
        Dimension viewsSize = this.views.getSize();
        if (viewsSize.width == 0) {
            viewsSize = this.views.getPreferredSize();
        }
        Dimension infoSize = this.infoPanel.getSize();
        if (infoSize.width == 0) {
            infoSize = this.infoPanel.getPreferredSize();
        }
        if (b) {
            this.views.setBorder(null);
            JSplitPane sp = this.uif.createSplitPane(1, this.views, this.infoPanel);
            sp.setDividerLocation(viewsSize.width + sp.getDividerSize());
            this.body = sp;
            this.showInfoForQuestion(this.viewConfig.getCurrentQuestion());
        } else {
            this.views.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.body = this.views;
        }
        this.setBody(this.body);
        if (this.isShowing()) {
            Dimension winSize = this.getSize();
            int divWidth = new JSplitPane().getDividerSize();
            int newWidth = winSize.width;
            this.setSize(newWidth += (b ? 1 : -1) * (infoSize.width + divWidth), winSize.height);
        }
    }

    private void showInfoForQuestion(Question q) {
        try {
            Map.ID id = q.getHelpID();
            if (id == null) {
                System.err.println("WARNING: no help for " + q.getKey());
            } else {
                this.infoPanel.setCurrentID(id);
            }
        }
        catch (BadIDException e) {
            System.err.println("WARNING: no help for " + q.getKey());
        }
        catch (InvalidHelpSetContextException e) {
            JavaTestError.unexpectedException(e);
        }
    }

    private CE_View getDefaultView() {
        Preferences p = Preferences.access();
        String prefView = p.getPreference(VIEW_PREF, "full");
        if (prefView.equals("std")) {
            return this.stdView;
        }
        return this.fullView;
    }

    private void perform(String cmd) {
        if (cmd.equals(NEW)) {
            this.clear();
        } else if (cmd.equals(LOAD)) {
            this.load(false);
        } else if (cmd.equals(LOADT)) {
            this.load(true);
        } else if (cmd.equals(NEWT)) {
            this.clear(true);
        } else if (cmd.equals(SAVE)) {
            this.save();
        } else if (cmd.equals(SAVE_AS)) {
            this.saveAs();
        } else if (cmd.equals(SAVE_AS_TEMPLATE)) {
            this.saveAsTemplate();
        } else if (cmd.equals(REVERT)) {
            this.revert();
        } else if (cmd.equals("full")) {
            this.show(this.fullView);
        } else if (cmd.equals("std")) {
            this.show(this.stdView);
        } else if (cmd.equals(CLOSE)) {
            if (this.canInterruptTemplateCreation()) {
                this.close();
            } else {
                this.uif.showError("ce.force_close");
            }
        } else if (cmd.equals(DONE)) {
            Integer rp;
            int rc;
            if (this.currView != null && !this.currView.isOKToClose()) {
                return;
            }
            if (!this.canInterruptTemplateCreation() && !this.viewConfig.isFinishable()) {
                this.uif.showError("ce.force_close");
                return;
            }
            this.currView.save();
            if (!this.viewConfig.isFinishable() && (rc = this.uif.showOKCancelDialog("ce.okToClose", rp = new Integer(this.runPending ? 1 : 0))) != 0) {
                return;
            }
            if (this.isEdited() || this.isCurrentQuestionChanged()) {
                this.saveRequired = true;
            }
            if (this.saveRequired) {
                if (!this.save0()) {
                    return;
                }
                this.saveRequired = false;
            }
            this.close(false);
        } else if (cmd.equals(REFRESH)) {
            if (this.currView != null) {
                this.currView.refresh();
            }
        } else if (cmd.equals(DETAILS)) {
            if (this.detailsBrowser == null) {
                this.detailsBrowser = new DetailsBrowser(this.body, this.viewConfig, this.infoPanel);
                this.detailsBrowser.setQuestionInfoEnabled(this.currView == this.fullView);
            }
            this.detailsBrowser.setVisible(true);
        } else {
            throw new IllegalArgumentException(cmd);
        }
    }

    private boolean canInterruptTemplateCreation() {
        ContextManager cm = this.model.getContextManager();
        String wdTmpl = TemplateUtilities.getTemplatePath(this.model.getWorkDirectory());
        return !this.mainConfig.isTemplate() || cm.getFeatureManager().isEnabled(5) || wdTmpl != null;
    }

    private void copy(InterviewParameters from, InterviewParameters to) throws Interview.Fault {
        this.copy(from, to, true);
    }

    private void copy(InterviewParameters from, InterviewParameters to, boolean copyFile) throws Interview.Fault {
        HashMap data = new HashMap();
        from.save(data);
        to.load(data, false);
        if (copyFile) {
            to.setFile(from.getFile());
        }
    }

    public static File checkLoadConfigFileDefaults(ContextManager cm) {
        if (cm == null) {
            return null;
        }
        File defaultConfigLoadPath = cm.getDefaultConfigLoadPath();
        boolean allowConfigLoadOutsideDefault = cm.getAllowConfigLoadOutsideDefault();
        if (defaultConfigLoadPath == null && !allowConfigLoadOutsideDefault) {
            throw new IllegalArgumentException("Default directory not specified for load operation when allowConfigLoadOutsideDefault is false");
        }
        if (defaultConfigLoadPath != null) {
            if (!defaultConfigLoadPath.isAbsolute()) {
                throw new IllegalArgumentException("Relative paths not currently supported. The following setting is incorrect: \"" + defaultConfigLoadPath.getPath() + "\" selected for " + "load operation");
            }
            if (defaultConfigLoadPath.isFile()) {
                throw new IllegalArgumentException("Filename selected unexpectedly as a default directory: \"" + defaultConfigLoadPath.getPath() + "\" for " + "load operation");
            }
        }
        return defaultConfigLoadPath;
    }

    static File loadConfigFile(ContextManager cm, Component parent, UIFactory uif, FileChooser fileChooser) {
        if (cm == null) {
            return null;
        }
        File defaultConfigLoadPath = ConfigEditor.checkLoadConfigFileDefaults(cm);
        boolean allowConfigLoadOutsideDefault = cm.getAllowConfigLoadOutsideDefault();
        File file = null;
        fileChooser.setDialogTitle(uif.getI18NString("ce.load.title"));
        if (defaultConfigLoadPath != null) {
            if (!allowConfigLoadOutsideDefault) {
                if (!new File(defaultConfigLoadPath.getAbsolutePath()).canRead()) {
                    uif.showError("ce.load.defDirNotExists", defaultConfigLoadPath);
                    return null;
                }
                fileChooser.enableDirectories(false);
            } else {
                fileChooser.enableDirectories(true);
            }
            fileChooser.setCurrentDirectory(defaultConfigLoadPath);
        }
        boolean isMatch = true;
        while (file == null) {
            int rc = fileChooser.showDialog(parent, uif.getI18NString("ce.load.btn"));
            if (rc != 0) {
                return null;
            }
            file = fileChooser.getSelectedFile();
            if (allowConfigLoadOutsideDefault) continue;
            if (defaultConfigLoadPath == null) {
                return null;
            }
            File f = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)));
            try {
                isMatch = f.getCanonicalPath().indexOf(defaultConfigLoadPath.getCanonicalPath()) == 0;
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
                return null;
            }
            if (isMatch) continue;
            uif.showError("ce.load.notAllowedDir", defaultConfigLoadPath);
            file = null;
            fileChooser.setCurrentDirectory(defaultConfigLoadPath);
        }
        if (file != null) {
            String path = file.getPath();
            String ext = fileChooser.getChosenExtension();
            if (ext == null) {
                ext = JTI;
            }
            if (!path.endsWith(ext)) {
                file = new File(path + ext);
            }
        }
        return file;
    }

    static File saveConfigFile(ContextManager cm, Component parent, UIFactory uif, FileChooser fileChooser, File dir, boolean isTemplate) {
        if (cm == null) {
            return null;
        }
        File defaultSavePath = isTemplate ? cm.getDefaultTemplateSavePath() : cm.getDefaultConfigSavePath();
        boolean allowSaveOutsideDefault = isTemplate ? cm.getAllowTemplateSaveOutsideDefault() : cm.getAllowConfigSaveOutsideDefault();
        if (defaultSavePath == null && !allowSaveOutsideDefault) {
            throw new IllegalArgumentException("Default directory not specified for save operation when allowConfigSaveOutsideDefault is false");
        }
        if (defaultSavePath != null) {
            if (!defaultSavePath.isAbsolute()) {
                throw new IllegalArgumentException("Relative paths not currently supported. The following setting is incorrect: \"" + defaultSavePath.getPath() + "\" selected for " + "save operation");
            }
            if (defaultSavePath.isFile()) {
                throw new IllegalArgumentException("Filename selected unexpectedly as a default directory: \"" + defaultSavePath.getPath() + "\" for " + "save operation");
            }
            if (!allowSaveOutsideDefault) {
                if (!defaultSavePath.canWrite()) {
                    uif.showError("ce.save.defDirNotExists", defaultSavePath);
                    return null;
                }
                fileChooser.enableDirectories(false);
            } else {
                fileChooser.enableDirectories(true);
            }
            fileChooser.setCurrentDirectory(defaultSavePath);
        } else if (dir != null) {
            fileChooser.setCurrentDirectory(dir);
        }
        File file = null;
        boolean isMatch = true;
        while (file == null) {
            int rc = fileChooser.showDialog(parent, uif.getI18NString("ce.save.btn"));
            if (rc != 0) {
                return null;
            }
            file = fileChooser.getSelectedFile();
            if (file == null) continue;
            File f = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)));
            if (!allowSaveOutsideDefault) {
                if (defaultSavePath == null) {
                    return null;
                }
                try {
                    isMatch = defaultSavePath.getCanonicalPath().equals(f.getCanonicalPath());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                    return null;
                }
                if (!isMatch) {
                    uif.showError("ce.save.notAllowedDir", defaultSavePath);
                    file = null;
                    fileChooser.setCurrentDirectory(defaultSavePath);
                    continue;
                }
            }
            if (file.isDirectory()) {
                uif.showError("ce.save.fileIsDir", file);
                file = null;
                continue;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                if (parentFile.exists() && !parentFile.isDirectory()) {
                    uif.showError("ce.save.parentNotADir", parentFile);
                    file = null;
                    continue;
                }
                if (!parentFile.exists()) {
                    rc = uif.showYesNoDialog("ce.save.createParentDir", parentFile);
                    if (rc == 0) {
                        if (!parentFile.mkdirs()) {
                            uif.showError("ce.save.cantCreateParentDir", parentFile);
                            file = null;
                            continue;
                        }
                    } else {
                        file = null;
                        continue;
                    }
                }
            }
            if (!file.exists()) {
                String path = file.getPath();
                String ext = fileChooser.getChosenExtension();
                if (ext != null && !path.endsWith(ext)) {
                    file = new File(path + ext);
                }
            }
            if (file.exists()) {
                rc = uif.showYesNoDialog("ce.save.warn");
                switch (rc) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        fileChooser.setSelectedFile(null);
                        file = null;
                        break;
                    }
                }
            }
        }
        return file;
    }

    void setAfterCloseCommand(Runnable runnable) {
        this.afterCloseCommand = runnable;
    }

    static interface Observer {
        public void loaded(InterviewParameters var1);

        public void saved(InterviewParameters var1);
    }

    private class Listener
    implements ActionListener,
    ChangeListener,
    MenuListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi;
            File f;
            Object src = e.getSource();
            if (src instanceof JMenuItem && (f = (File)(mi = (JMenuItem)src).getClientProperty(FileHistory.FILE)) != null) {
                ConfigEditor.this.loadNoUI(f);
                return;
            }
            ConfigEditor.this.perform(e.getActionCommand());
        }

        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (src == ConfigEditor.this.viewInfoCheckBox && ConfigEditor.this.infoPanel != null) {
                ConfigEditor.this.setInfoVisible(ConfigEditor.this.viewInfoCheckBox.isSelected());
            } else if (src == ConfigEditor.this.viewTagCheckBox) {
                ConfigEditor.this.fullView.setTagVisible(ConfigEditor.this.viewTagCheckBox.isSelected());
            }
        }

        public void menuSelected(MenuEvent e) {
            Object src = e.getSource();
            if (src == ConfigEditor.this.viewMenu) {
                ConfigEditor.this.viewTagCheckBox.setSelected(ConfigEditor.this.fullView.isTagVisible());
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

