/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeListUpdateHandler;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ChecklistBrowser;
import com.sun.javatest.exec.ConfigEditor;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.EnvironmentBrowser;
import com.sun.javatest.exec.ExcludeListBrowser;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.QuestionLogBrowser;
import com.sun.javatest.exec.WorkDirChooseTool;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

class ConfigHandler {
    private static KeyStroke configEditorAccelerator = KeyStroke.getKeyStroke(69, 2);
    private static KeyStroke tEditorAccelerator = KeyStroke.getKeyStroke(84, 2);
    private JComponent parent;
    private UIFactory uif;
    private ExecModel model;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters interviewParams;
    private Interview.Observer observer;
    private JMenu changeMenu;
    private JMenu menuHistory;
    private JMenu menuTemplateHistory;
    private JMenuItem menuEdit;
    private JMenuItem menuEditT;
    private JSeparator templateSeparator;
    private JMenuItem menuEditTemplate;
    private JMenuItem menuNewTemplate;
    private Action loadConfigAction;
    private Action newConfigAction;
    private Action newConfigTAction;
    private Action showConfigTAction;
    private Action showFullConfigAction;
    private Action showStdConfigAction;
    private Action showEnvironmentAction;
    private Action showExcludeListAction;
    private Action showChecklistAction;
    private Action showQuestionLogAction;
    private Action checkUpdatesAction;
    private ConfigEditor configEditor;
    private FileHistory.Listener configHistoryListener;
    private FileHistory.Listener configTemplateHistoryListener;
    private ChecklistBrowser checkListBrowser;
    private EnvironmentBrowser environmentBrowser;
    private ExcludeListBrowser excludeListBrowser;
    private QuestionLogBrowser questionLogBrowser;
    private JTextField configNameField;
    private JTextField tmplNameField;
    private String backupTemplateName;

    ConfigHandler(JComponent parent, ExecModel model, UIFactory uif) {
        this.parent = parent;
        this.model = model;
        this.uif = uif;
        this.initActions();
    }

    void addConfigEditorAccelerator(JComponent comp) {
        String SHOW_FULL_CONFIG_EDITOR = "showFullConfigEditor";
        InputMap imap = comp.getInputMap(1);
        imap.put(configEditorAccelerator, "showFullConfigEditor");
        ActionMap amap = comp.getActionMap();
        amap.put("showFullConfigEditor", this.showFullConfigAction);
    }

    void dispose() {
        if (this.configEditor != null) {
            this.configEditor.dispose();
        }
        if (this.checkListBrowser != null) {
            this.checkListBrowser.dispose();
        }
        if (this.environmentBrowser != null) {
            this.environmentBrowser.dispose();
        }
        if (this.excludeListBrowser != null) {
            this.excludeListBrowser.dispose();
        }
        if (this.questionLogBrowser != null) {
            this.questionLogBrowser.dispose();
        }
    }

    JMenu getMenu() {
        JMenuItem[] items;
        JMenuItem[] items2;
        this.changeMenu = new ChangeConfigMenu();
        JMenu menu = this.uif.createMenu("ch");
        ContextManager cm = this.model.getContextManager();
        this.menuEdit = this.uif.createMenuItem("ch.change", "full", (ActionListener)((Object)this.changeMenu));
        this.menuEdit.putClientProperty(this.changeMenu, new Integer(1));
        this.menuEdit.setAccelerator(configEditorAccelerator);
        menu.add(this.menuEdit);
        this.menuEditT = this.uif.createMenuItem("ch.changeT", "full", (ActionListener)((Object)this.changeMenu));
        this.menuEditT.putClientProperty(this.changeMenu, new Integer(10));
        this.menuEditT.setAccelerator(tEditorAccelerator);
        if (this.isTemplateCreationEnabled()) {
            menu.add(this.menuEditT);
        }
        menu.add(this.changeMenu);
        menu.addSeparator();
        menu.add(this.uif.createMenuItem(this.newConfigAction));
        menu.add(this.uif.createMenuItem(this.loadConfigAction));
        JavaTestMenuManager menuManager = null;
        if (cm != null && (menuManager = cm.getMenuManager()) != null && (items2 = menuManager.getMenuItems(4)) != null) {
            for (int i = 0; i < items2.length; ++i) {
                menu.add(items2[i]);
            }
        }
        this.configHistoryListener = new FileHistory.Listener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                File f = (File)mi.getClientProperty(FileHistory.FILE);
                if (f != null) {
                    ConfigHandler.this.ensureConfigEditorInitialized();
                    ConfigHandler.this.configEditor.loadNoUI(f);
                    ConfigHandler.this.showConfig();
                }
            }
        });
        this.configTemplateHistoryListener = new FileHistory.Listener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = (JMenuItem)e.getSource();
                File f = (File)mi.getClientProperty(FileHistory.FILE);
                if (f != null) {
                    ConfigHandler.this.ensureConfigEditorInitialized();
                    ConfigHandler.this.configEditor.loadNoUI(f);
                    ConfigHandler.this.showTemplate(1);
                }
            }
        });
        this.menuHistory = this.uif.createMenu("ch.history");
        this.menuHistory.addMenuListener(this.configHistoryListener);
        menu.add(this.menuHistory);
        this.templateSeparator = new JPopupMenu.Separator();
        this.menuNewTemplate = this.uif.createMenuItem(this.newConfigTAction);
        this.menuEditTemplate = this.uif.createMenuItem(this.showConfigTAction);
        this.menuTemplateHistory = this.uif.createMenu("ch.templatehistory");
        this.menuTemplateHistory.addMenuListener(this.configTemplateHistoryListener);
        FeatureManager fm = null;
        if (cm != null) {
            fm = cm.getFeatureManager();
        }
        if (cm == null || fm.isEnabled(2)) {
            menu.add(this.templateSeparator);
            menu.add(this.menuNewTemplate);
            menu.add(this.menuEditTemplate);
            menu.add(this.menuTemplateHistory);
        }
        menu.addSeparator();
        menu.add(this.uif.createMenuItem(this.checkUpdatesAction));
        if (cm != null && (menuManager = cm.getMenuManager()) != null && (items = menuManager.getMenuItems(6)) != null) {
            menu.addSeparator();
            for (int i = 0; i < items.length; ++i) {
                menu.add(items[i]);
            }
        }
        return menu;
    }

    private boolean isTemplateCreationEnabled() {
        ContextManager cm = this.model.getContextManager();
        if (cm != null) {
            FeatureManager fm = cm.getFeatureManager();
            return fm.isEnabled(2);
        }
        return true;
    }

    List getStatusStrip() {
        JLabel lab = this.uif.createLabel("ch.cfname");
        lab.setDisplayedMnemonic(this.uif.getI18NString("ch.cfname.mne").charAt(0));
        lab.setBackground(MetalLookAndFeel.getMenuBackground());
        lab.setForeground(new Color(102, 102, 102));
        FontUIResource f = MetalLookAndFeel.getSystemTextFont();
        lab.setFont(new Font("Ariel", 1, f.getSize()));
        lab.setHorizontalAlignment(4);
        this.configNameField = this.uif.createOutputField("ch.cfname", lab);
        this.configNameField.setColumns(0);
        this.configNameField.setBackground(MetalLookAndFeel.getMenuBackground());
        this.configNameField.setForeground(new Color(102, 102, 102));
        this.configNameField.setFont(new Font("Ariel", 1, f.getSize()));
        this.configNameField.setBorder(BorderFactory.createEmptyBorder());
        this.configNameField.setText(this.uif.getI18NString("ch.none"));
        this.configNameField.setHorizontalAlignment(4);
        this.showConfigName(this.interviewParams);
        JLabel lab1 = this.uif.createLabel("ch.tmplname");
        lab1.setDisplayedMnemonic(this.uif.getI18NString("ch.tmplname.mne").charAt(0));
        lab1.setBackground(MetalLookAndFeel.getMenuBackground());
        lab1.setForeground(new Color(102, 102, 102));
        f = MetalLookAndFeel.getSystemTextFont();
        lab1.setFont(new Font("Ariel", 1, f.getSize()));
        lab1.setHorizontalAlignment(10);
        this.tmplNameField = this.uif.createOutputField("ch.tmplname", lab1);
        this.tmplNameField.setColumns(0);
        this.tmplNameField.setBackground(MetalLookAndFeel.getMenuBackground());
        this.tmplNameField.setForeground(new Color(102, 102, 102));
        this.tmplNameField.setFont(new Font("Ariel", 1, f.getSize()));
        this.tmplNameField.setBorder(BorderFactory.createEmptyBorder());
        this.tmplNameField.setText(this.uif.getI18NString("ch.none"));
        this.tmplNameField.setHorizontalAlignment(10);
        this.showTemplateName(this.interviewParams);
        return Arrays.asList(lab, this.configNameField, lab1, this.tmplNameField);
    }

    private void showConfigName(InterviewParameters ip) {
        if (this.interviewParams != null && !this.interviewParams.isTemplate()) {
            if (this.interviewParams.getFile() != null && !this.interviewParams.getFile().getName().endsWith(".jtm")) {
                this.configNameField.setText(this.interviewParams.getFile().getName());
            } else {
                this.configNameField.setText(this.uif.getI18NString("ch.none"));
            }
        } else {
            this.configNameField.setText(this.uif.getI18NString("ch.none"));
        }
    }

    private void showTemplateName(InterviewParameters ip) {
        if (this.interviewParams != null) {
            if (this.interviewParams.getFile() != null && this.interviewParams.getFile().getName().endsWith(".jtm")) {
                this.tmplNameField.setText(this.interviewParams.getFile().getName());
            } else if (this.interviewParams.getTemplatePath() != null) {
                String path;
                int sep = (path = this.interviewParams.getTemplatePath()).lastIndexOf(File.separator);
                path = path.substring(sep < 0 ? 0 : sep + 1);
                this.tmplNameField.setText(path);
            }
        } else if (this.backupTemplateName != null) {
            this.tmplNameField.setText(this.backupTemplateName);
        } else {
            this.tmplNameField.setText(this.uif.getI18NString("ch.none"));
        }
    }

    void setTemplateName(String name) {
        this.backupTemplateName = name;
    }

    JMenuItem[] getConfigViewMenuItems() {
        JMenuItem[] items = new JMenuItem[]{this.uif.createMenuItem(this.showChecklistAction), this.uif.createMenuItem(this.showExcludeListAction), this.uif.createMenuItem(this.showEnvironmentAction), this.uif.createMenuItem(this.showQuestionLogAction)};
        return items;
    }

    Action[] getToolBarActions() {
        return new Action[]{this.showFullConfigAction, this.showStdConfigAction};
    }

    boolean isConfigEdited() {
        return this.configEditor != null && this.configEditor.isEdited();
    }

    void checkExcludeListUpdate(JComponent parent, boolean quietIfNoUpdate) {
        try {
            Parameters.ExcludeListParameters elp = this.interviewParams.getExcludeListParameters();
            if (!(elp instanceof Parameters.MutableExcludeListParameters)) {
                return;
            }
            Parameters.MutableExcludeListParameters melp = (Parameters.MutableExcludeListParameters)elp;
            URL remote = this.testSuite.getLatestExcludeList();
            File local = this.workDir.getSystemFile("latest.jtx");
            ExcludeListUpdateHandler eluh = new ExcludeListUpdateHandler(remote, local);
            if (quietIfNoUpdate && !eluh.isUpdateAvailable()) {
                return;
            }
            JPanel info = new JPanel(new GridBagLayout());
            info.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            GridBagConstraints lc = new GridBagConstraints();
            lc.anchor = 13;
            GridBagConstraints fc = new GridBagConstraints();
            fc.gridwidth = 0;
            fc.fill = 2;
            fc.weightx = 1.0;
            JLabel remoteLbl = this.uif.createLabel("ch.elu.remote");
            info.add((Component)remoteLbl, lc);
            JTextField remoteText = this.uif.createOutputField("ch.elu.remote", remoteLbl);
            remoteText.setBorder(null);
            long remoteDate = eluh.getRemoteURLLastModified();
            String remoteDateText = remoteDate <= 0L ? this.uif.getI18NString("ch.elu.notAvailable") : new Date(remoteDate).toString();
            remoteText.setText(remoteDateText);
            remoteText.setColumns(remoteDateText.length());
            info.add((Component)remoteText, fc);
            JLabel localLbl = this.uif.createLabel("ch.elu.local");
            info.add((Component)localLbl, lc);
            JTextField localText = this.uif.createOutputField("ch.elu.local", localLbl);
            localText.setBorder(null);
            long localDate = eluh.getLocalFileLastModified();
            String localDateText = localDate <= 0L ? this.uif.getI18NString("ch.elu.notAvailable") : new Date(localDate).toString();
            localText.setText(localDateText);
            localText.setColumns(localDateText.length());
            info.add((Component)localText, fc);
            if (eluh.isUpdateAvailable()) {
                String foot;
                String title = this.uif.getI18NString("ch.elu.update.title");
                String head = this.uif.getI18NString("ch.elu.update.head");
                int rc = JOptionPane.showConfirmDialog(parent, new Object[]{head, info, foot = this.uif.getI18NString("ch.elu.update.foot")}, title, 0);
                if (rc == 0) {
                    eluh.update();
                }
            } else {
                String title = this.uif.getI18NString("ch.elu.noUpdate.title");
                String head = this.uif.getI18NString("ch.elu.noUpdate.head");
                JOptionPane.showMessageDialog(parent, new Object[]{head, info}, title, 1);
            }
        }
        catch (IOException e) {
            I18NResourceBundle i18n = this.uif.getI18NResourceBundle();
            this.workDir.log(i18n, "ch.elu.logError", e);
            this.uif.showError("ch.elu.error", e);
        }
    }

    boolean ensureInterviewUpToDate() {
        try {
            if (this.interviewParams.isFileNewer()) {
                this.interviewParams.load();
            }
            return true;
        }
        catch (IOException ex) {
            this.uif.showError("exec.loadInterview", ex.toString());
            return false;
        }
        catch (Interview.Fault ex) {
            this.uif.showError("exec.loadInterview", ex.getMessage());
            return false;
        }
    }

    void ensureConfigEditorInitialized() {
        if (this.workDir == null) {
            throw new IllegalStateException();
        }
        if (this.configEditor == null) {
            this.configEditor = new ConfigEditor(this.parent, this.interviewParams, this.model, this.uif);
            this.configEditor.setCheckExcludeListListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object src = e.getSource();
                    JComponent p = src instanceof JComponent ? (JComponent)src : ConfigHandler.this.parent;
                    ConfigHandler.this.checkExcludeListUpdate(p, false);
                }
            });
            this.configEditor.setObserver(new ConfigEditor.Observer(){

                public void saved(InterviewParameters p) {
                    ConfigHandler.this.updateGUI();
                    ConfigHandler.this.showConfigName(p);
                    ConfigHandler.this.showTemplateName(p);
                }

                public void loaded(InterviewParameters p) {
                    ConfigHandler.this.updateGUI();
                    ConfigHandler.this.showConfigName(p);
                    ConfigHandler.this.showTemplateName(p);
                }
            });
        }
    }

    void showConfigEditor() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(1, false);
    }

    void showTemplateEditor() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(1, true);
    }

    void showConfigEditor(ActionListener l) {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(1, l, false);
    }

    void showTemplateEditor(ActionListener l) {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(1, l, true);
    }

    void updateGUI() {
        this.testSuite = this.model.getTestSuite();
        this.workDir = this.model.getWorkDirectory();
        this.interviewParams = this.model.getInterviewParameters();
        if (this.interviewParams != null) {
            this.ensureInterviewUpToDate();
        }
        boolean testSuiteSet = this.testSuite != null;
        boolean templateMenuVisible = false;
        if (testSuiteSet && this.testSuite != null) {
            templateMenuVisible = this.isTemplateCreationEnabled();
        }
        this.templateSeparator.setVisible(templateMenuVisible);
        this.menuNewTemplate.setVisible(templateMenuVisible);
        this.menuEditTemplate.setVisible(templateMenuVisible);
        this.menuTemplateHistory.setVisible(templateMenuVisible);
        this.menuEditT.setVisible(templateMenuVisible);
        this.showFullConfigAction.setEnabled(testSuiteSet);
        this.showStdConfigAction.setEnabled(testSuiteSet);
        this.newConfigAction.setEnabled(testSuiteSet);
        this.loadConfigAction.setEnabled(testSuiteSet);
        this.showExcludeListAction.setEnabled(testSuiteSet);
        this.showEnvironmentAction.setEnabled(testSuiteSet);
        this.showQuestionLogAction.setEnabled(testSuiteSet);
        this.showChecklistAction.setEnabled(testSuiteSet && this.interviewParams != null && !this.interviewParams.isChecklistEmpty());
        this.newConfigTAction.setEnabled(testSuiteSet);
        this.showConfigTAction.setEnabled(testSuiteSet);
        this.checkUpdatesAction.setEnabled(testSuiteSet && this.interviewParams != null && !this.interviewParams.isTemplate() && this.interviewParams.getTemplatePath() != null);
        this.menuHistory.setEnabled(testSuiteSet);
        if (this.model.getContextManager() == null || this.model.getContextManager().getFeatureManager().isEnabled(2)) {
            this.menuTemplateHistory.setEnabled(testSuiteSet);
        }
        if (this.interviewParams != null && !this.interviewParams.isTemplate() && this.interviewParams.getFile() != null) {
            boolean noEdit = this.interviewParams.getTemplatePath() == null && this.interviewParams.getWorkDirectory() != null && TemplateUtilities.getTemplatePath(this.interviewParams.getWorkDirectory()) != null;
            this.menuEdit.setEnabled(testSuiteSet && !noEdit);
            this.changeMenu.setEnabled(testSuiteSet && !noEdit);
            if (this.menuEditT != null) {
                boolean enabled = this.interviewParams.getTemplatePath() != null || !this.interviewParams.isTemplate() || this.interviewParams.getWorkDirectory() != null && TemplateUtilities.getTemplatePath(this.interviewParams.getWorkDirectory()) != null;
                this.menuEditT.setEnabled(enabled && testSuiteSet && this.isTemplateCreationEnabled());
            }
        } else {
            this.menuEdit.setEnabled(false);
            this.changeMenu.setEnabled(false);
            if (this.menuEditT != null) {
                this.menuEditT.setEnabled(testSuiteSet && this.isTemplateCreationEnabled());
            }
        }
        if (this.workDir != null && this.configHistoryListener.getFileHistory() == null) {
            FileHistory h = FileHistory.getFileHistory(this.workDir, "configHistory.jtl");
            this.configHistoryListener.setFileHistory(h);
        }
        if (this.workDir != null && this.configTemplateHistoryListener.getFileHistory() == null) {
            FileHistory h = FileHistory.getFileHistory(this.workDir, "templateHistory.jtl");
            this.configTemplateHistoryListener.setFileHistory(h);
        }
        if (this.interviewParams != null && this.observer == null) {
            this.observer = new Interview.Observer(){

                public void currentQuestionChanged(Question q) {
                }

                public void pathUpdated() {
                    ConfigHandler.this.showChecklistAction.setEnabled(!ConfigHandler.this.interviewParams.isChecklistEmpty());
                }
            };
            this.interviewParams.addObserver(this.observer);
        }
        this.showTemplateName(this.interviewParams);
        this.showConfigName(this.interviewParams);
    }

    void syncInterview() {
        this.ensureConfigEditorInitialized();
        this.configEditor.saveMain();
    }

    void loadConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        WorkDirChooseTool tool = WorkDirChooseTool.getTool(this.parent, this.uif, this.model, 4, this.testSuite, true);
        tool.setConfigEditor(this.configEditor);
        tool.doTool();
        this.showTemplateName(null);
        this.showConfigName(null);
        this.menuEdit.setEnabled(true);
        if (this.menuEditT != null) {
            this.menuEditT.setEnabled(this.interviewParams.getTemplatePath() != null && this.isTemplateCreationEnabled());
        }
    }

    void newConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.interviewParams.setTemplate(false);
        this.configEditor.clear();
        this.updateGUI();
        this.showTemplateName(null);
        this.showConfigName(null);
        this.menuEdit.setEnabled(true);
        if (this.menuEditT != null) {
            this.menuEditT.setEnabled(this.interviewParams.getTemplatePath() != null && this.isTemplateCreationEnabled());
        }
    }

    void showConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(false);
    }

    void showTemplate(int mode) {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(mode, true);
    }

    void showConfig(int mode) {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(mode, false);
    }

    void newTemplate() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(false);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.interviewParams.setTemplate(true);
        this.interviewParams.setTemplatePath(null);
        this.configEditor.clear(true);
        this.showTemplateName(null);
        this.showConfigName(null);
        if (this.menuEditT != null) {
            this.menuEdit.setEnabled(false);
            this.menuEditT.setEnabled(true);
        }
    }

    void loadTemplate() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog(false);
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        WorkDirChooseTool tool = WorkDirChooseTool.getTool(this.parent, this.uif, this.model, 3, this.testSuite, true);
        tool.setConfigEditor(this.configEditor);
        tool.doTool();
        this.showTemplateName(null);
        this.showConfigName(null);
        if (this.menuEditT != null) {
            this.menuEdit.setEnabled(false);
            this.menuEditT.setEnabled(true);
        }
    }

    void showEnvironment() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.environmentBrowser == null) {
            this.environmentBrowser = new EnvironmentBrowser(this.parent, this.uif);
        }
        this.environmentBrowser.show(this.interviewParams);
    }

    void showExcludeList() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.excludeListBrowser == null) {
            this.excludeListBrowser = new ExcludeListBrowser(this.parent, this.uif);
        }
        this.excludeListBrowser.show(this.interviewParams);
    }

    void showChecklist() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.checkListBrowser == null) {
            this.checkListBrowser = new ChecklistBrowser(this.parent, this.model, this.uif);
        }
        this.checkListBrowser.setVisible(true);
    }

    void showQuestionLog() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.questionLogBrowser == null) {
            this.questionLogBrowser = new QuestionLogBrowser(this.parent, this.model, this.uif);
        }
        this.questionLogBrowser.setVisible(true);
    }

    void checkUpdate() {
        try {
            if (this.interviewParams.isFileNewer()) {
                this.interviewParams.load();
            } else {
                this.interviewParams.checkForUpdates();
            }
        }
        catch (IOException ex) {
            this.uif.showError("exec.loadInterview", ex.toString());
        }
        catch (Interview.Fault ex) {
            this.uif.showError("exec.loadInterview", ex.getMessage());
        }
    }

    private boolean isOKToContinue() {
        int rc = this.uif.showOKCancelDialog("ch.edited.warn");
        return rc == 0;
    }

    private void initActions() {
        this.loadConfigAction = new ToolAction(this.uif, "ch.load"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.loadConfig();
            }
        };
        this.newConfigAction = new ToolAction(this.uif, "ch.new"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.newConfig();
            }
        };
        this.newConfigTAction = new ToolAction(this.uif, "ch.newt"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.newTemplate();
            }
        };
        this.showConfigTAction = new ToolAction(this.uif, "ch.opent"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.loadTemplate();
            }
        };
        this.showFullConfigAction = new ToolAction(this.uif, "ch.full", true){

            public void actionPerformed(ActionEvent e) {
                if (ConfigHandler.this.interviewParams.isTemplate()) {
                    ConfigHandler.this.showTemplate(1);
                } else {
                    ConfigHandler.this.showConfig(1);
                }
            }
        };
        this.showStdConfigAction = new ToolAction(this.uif, "ch.std", true){

            public void actionPerformed(ActionEvent e) {
                if (ConfigHandler.this.interviewParams.isTemplate()) {
                    ConfigHandler.this.showTemplate(2);
                } else {
                    ConfigHandler.this.showConfig(2);
                }
            }
        };
        this.showEnvironmentAction = new ToolAction(this.uif, "ch.env"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.showEnvironment();
            }
        };
        this.showExcludeListAction = new ToolAction(this.uif, "ch.excl"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.showExcludeList();
            }
        };
        this.showChecklistAction = new ToolAction(this.uif, "ch.checkList"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.showChecklist();
            }
        };
        this.showQuestionLogAction = new ToolAction(this.uif, "ch.quLog"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.showQuestionLog();
            }
        };
        this.checkUpdatesAction = new ToolAction(this.uif, "ch.chUpdate"){

            public void actionPerformed(ActionEvent e) {
                ConfigHandler.this.checkUpdate();
            }
        };
    }

    void loadInterview(File file) {
        this.ensureConfigEditorInitialized();
        this.configEditor.loadNoUI(file);
    }

    private class ChangeConfigMenu
    extends JMenu
    implements ActionListener,
    MenuListener {
        private JMenuItem tests;
        private JMenuItem excludeList;
        private JMenuItem keywords;
        private JMenuItem priorStatus;
        private JMenuItem environment;
        private JMenuItem concurrency;
        private JMenuItem timeoutFactor;
        private static final String CHANGE_TESTS = "test";
        private static final String CHANGE_EXCLUDE_LIST = "excl";
        private static final String CHANGE_KEYWORDS = "keyw";
        private static final String CHANGE_PRIOR_STATUS = "stat";
        private static final String CHANGE_ENVIRONMENT = "envt";
        private static final String CHANGE_CONCURRENCY = "conc";
        private static final String CHANGE_TIMEOUT_FACTOR = "time";

        ChangeConfigMenu() {
            ConfigHandler.this.uif.initMenu(this, "ch.change");
            this.tests = this.addMenuItem(CHANGE_TESTS, 3);
            this.excludeList = this.addMenuItem(CHANGE_EXCLUDE_LIST, 4);
            this.keywords = this.addMenuItem(CHANGE_KEYWORDS, 5);
            this.priorStatus = this.addMenuItem(CHANGE_PRIOR_STATUS, 6);
            this.environment = this.addMenuItem(CHANGE_ENVIRONMENT, 7);
            this.concurrency = this.addMenuItem(CHANGE_CONCURRENCY, 8);
            this.timeoutFactor = this.addMenuItem(CHANGE_TIMEOUT_FACTOR, 9);
            this.addSeparator();
            this.addMenuListener(this);
        }

        private JMenuItem addMenuItem(String action, int configEditorMode) {
            JMenuItem mi = ConfigHandler.this.uif.createMenuItem("ch.change", action, this);
            mi.putClientProperty(this, new Integer(configEditorMode));
            this.add(mi);
            return mi;
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            if (!mi.isEnabled()) {
                return;
            }
            Integer mode = (Integer)mi.getClientProperty(this);
            if (mode != null) {
                if (ConfigHandler.this.workDir == null) {
                    ConfigHandler.this.model.showWorkDirDialog(true);
                    if (ConfigHandler.this.workDir == null) {
                        return;
                    }
                }
                ConfigHandler.this.ensureConfigEditorInitialized();
                int n = mode;
                ConfigHandler.this.configEditor;
                if (n == 10 && !ConfigHandler.this.interviewParams.isTemplate()) {
                    File tFile = null;
                    final File saved = ConfigHandler.this.interviewParams.getFile();
                    if (ConfigHandler.this.interviewParams.getTemplatePath() != null) {
                        tFile = new File(ConfigHandler.this.interviewParams.getTemplatePath());
                    } else if (ConfigHandler.this.interviewParams.getWorkDirectory() != null && TemplateUtilities.getTemplateFile(ConfigHandler.this.interviewParams.getWorkDirectory()) != null) {
                        tFile = TemplateUtilities.getTemplateFile(ConfigHandler.this.interviewParams.getWorkDirectory());
                    }
                    if (tFile != null) {
                        try {
                            TemplateUtilities.setTemplateFile(ConfigHandler.this.model.getWorkDirectory(), tFile, true);
                            ConfigHandler.this.configEditor.loadNoUI(tFile);
                            if (saved != null) {
                                ConfigHandler.this.configEditor.setAfterCloseCommand(new Runnable(){

                                    public void run() {
                                        ConfigHandler.this.configEditor.loadNoUI(saved);
                                    }
                                });
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                int n2 = mode;
                ConfigHandler.this.configEditor;
                if (n2 == 10) {
                    ConfigHandler.this.configEditor;
                    mode = new Integer(1);
                }
                ConfigHandler.this.configEditor.show(mode, ConfigHandler.this.interviewParams.isTemplate());
            }
        }

        public void menuSelected(MenuEvent e) {
            InterviewParameters c = ConfigHandler.this.interviewParams;
            if (c == null) {
                return;
            }
            this.update(this.tests, c.getTestsParameters(), Parameters.MutableTestsParameters.class);
            this.update(this.excludeList, c.getExcludeListParameters(), Parameters.MutableExcludeListParameters.class);
            this.update(this.keywords, c.getKeywordsParameters(), Parameters.MutableKeywordsParameters.class);
            this.update(this.priorStatus, c.getPriorStatusParameters(), Parameters.MutablePriorStatusParameters.class);
            this.update(this.environment, c.getEnvParameters(), Parameters.LegacyEnvParameters.class);
            this.update(this.concurrency, c.getConcurrencyParameters(), Parameters.MutableConcurrencyParameters.class);
            this.update(this.timeoutFactor, c.getTimeoutFactorParameters(), Parameters.MutableTimeoutFactorParameters.class);
        }

        private void update(JMenuItem mi, Object o, Class c) {
            mi.setVisible(o != null && c.isAssignableFrom(o.getClass()));
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }

        void loadInterview(File file) {
            ConfigHandler.this.configEditor.load(file);
        }
    }
}

