/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ConfigEditor;
import com.sun.javatest.exec.ConfigHandler;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ET_FilterHandler;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.ExecToolManager;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.LogViewer;
import com.sun.javatest.exec.MessageStrip;
import com.sun.javatest.exec.PropertiesBrowser;
import com.sun.javatest.exec.QuickStartWizard;
import com.sun.javatest.exec.ReportHandler;
import com.sun.javatest.exec.RunTestsHandler;
import com.sun.javatest.exec.TU_ViewManager;
import com.sun.javatest.exec.TestSuiteErrorsDialog;
import com.sun.javatest.exec.TestTreePanel;
import com.sun.javatest.exec.ToolBarManager;
import com.sun.javatest.exec.ToolBarPanel;
import com.sun.javatest.exec.WorkDirChooseTool;
import com.sun.javatest.logging.WorkDirLogHandler;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.help.HelpBroker;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class ExecTool
extends Tool
implements ExecModel {
    static final String TOOLBAR_PREF = "exec.toolbar";
    static final String FILTER_WARN_PREF = "exec.filterWarn";
    static final String ACTIVE_FILTER = "filter";
    private ExecToolManager manager;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters interviewParams;
    private String templatePath;
    private boolean shouldPauseTree;
    private Interview.Observer interviewObserver;
    private ContextManager context;
    private FilterConfig fConfig;
    private ConfigHandler configHandler;
    private RunTestsHandler runTestsHandler;
    private ReportHandler reportHandler;
    private ET_FilterHandler filterHandler;
    private ToolBarManager toolBarManager;
    private JavaTestMenuManager menuManager;
    private JMenuBar menuBar;
    private JToolBar toolBar;
    private JPopupMenu filterMenu;
    private JCheckBoxMenuItem pauseCheckBox;
    private TestTreePanel testTreePanel;
    private JTextField wdNameField;
    private TestSuiteErrorsDialog testSuiteErrorsDialog;
    private TestSuiteChooser testSuiteChooser;
    private Preferences.Observer prefsObserver;
    private QuickStartWizard quickStartWizard;
    private static final File userDir = new File(System.getProperty("user.dir"));
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ExecTool.class);
    private TestFinderErrorHandler testFinderErrorHandler = new TestFinderErrorHandler();
    private boolean workDirReset = false;
    private Action propertiesAction = new ToolAction(this.uif, "exec.view.props"){
        private PropertiesBrowser propertiesBrowser;

        public void actionPerformed(ActionEvent e) {
            if (this.propertiesBrowser == null) {
                this.propertiesBrowser = new PropertiesBrowser(ExecTool.this, ExecTool.this.uif);
            }
            this.propertiesBrowser.showDialog(ExecTool.this.testSuite, ExecTool.this.workDir, ExecTool.this.interviewParams);
        }
    };
    private Action testSuiteErrorsAction = new ToolAction(this.uif, "exec.view.testSuiteErrors"){

        public void actionPerformed(ActionEvent e) {
            if (ExecTool.this.testSuiteErrorsDialog == null) {
                ExecTool.this.testSuiteErrorsDialog = new TestSuiteErrorsDialog(ExecTool.this, ExecTool.this.uif);
            }
            ExecTool.this.testSuiteErrorsDialog.show(ExecTool.this.testSuite);
        }
    };
    private Action logViewerAction = new ToolAction(this.uif, "exec.view.logviewer"){

        public void actionPerformed(ActionEvent e) {
            if (ExecTool.this.workDir != null) {
                ExecTool.this.openLogViewer();
            } else {
                ExecTool.this.testSuite.getNotificationLog(null).info(ExecTool.this.uif.getI18NString("exec.view.logviewer.noworkdir"));
            }
        }
    };
    private Action helpAction = new ToolAction(this.uif, "exec.help", true){

        public void actionPerformed(ActionEvent e) {
            HelpBroker b = ExecTool.this.getHelpBroker();
            if (b != null) {
                b.setCurrentID("browse.window.csh");
                b.setDisplayed(true);
            } else {
                System.err.println("Unable to display Test Manager help, the help system isn't available.");
            }
        }
    };

    public ExecTool(ExecToolManager mgr) {
        this(mgr, (InterviewParameters)null);
    }

    public ExecTool(ExecToolManager mgr, TestSuite testSuite) throws Interview.Fault, TestSuite.Fault {
        this(mgr, testSuite.createInterview());
    }

    public ExecTool(ExecToolManager mgr, WorkDirectory workDir) throws Interview.Fault, TestSuite.Fault {
        this(mgr, ExecTool.getInterview(workDir));
    }

    private static InterviewParameters getInterview(WorkDirectory workDir) throws Interview.Fault, TestSuite.Fault {
        TestSuite ts = workDir.getTestSuite();
        InterviewParameters params = ts.createInterview();
        params.setWorkDirectory(workDir);
        FileHistory h = FileHistory.getFileHistory(workDir, "configHistory.jtl");
        File latestConfigFile = h.getLatestEntry();
        if (latestConfigFile != null) {
            try {
                params.load(latestConfigFile);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return params;
    }

    public ExecTool(ExecToolManager mgr, InterviewParameters interviewParams) {
        this(mgr, interviewParams, null);
    }

    public void dispose() {
        TestFinder tf;
        super.dispose();
        this.configHandler.dispose();
        this.runTestsHandler.dispose();
        this.testTreePanel.dispose();
        this.reportHandler.dispose();
        Preferences p = Preferences.access();
        p.removeObserver(TOOLBAR_PREF, this.prefsObserver);
        if (this.testSuite != null && (tf = this.testSuite.getTestFinder()).getErrorHandler() == this.testFinderErrorHandler) {
            tf.setErrorHandler(null);
        }
        TU_ViewManager.dispose(this);
    }

    protected String[] getCloseAlerts() {
        Harness h;
        Vector<String> v = null;
        String configName = null;
        if (this.workDir == null) {
            return null;
        }
        if (this.configHandler.isConfigEdited()) {
            v = new Vector<String>();
            configName = this.getConfigName();
            v.add(this.uif.getI18NString("exec.alert.unsavedData", new Object[]{configName, this.workDir.getPath()}));
        }
        if ((h = this.runTestsHandler.getHarness()) != null && h.isRunning()) {
            if (v == null) {
                v = new Vector();
            }
            if (configName == null) {
                configName = this.getConfigName();
            }
            v.add(this.uif.getI18NString("exec.alert.taskRunning", new Object[]{configName, this.workDir.getPath()}));
        }
        this.closeLogger();
        if (v == null) {
            return null;
        }
        Object[] alerts = new String[v.size()];
        v.copyInto(alerts);
        return alerts;
    }

    private String getConfigName() {
        TestEnvironment env;
        if (this.interviewParams != null && (env = this.interviewParams.getEnv()) != null) {
            return env.getName();
        }
        return this.uif.getI18NString("exec.unknownConfig");
    }

    public UIFactory getUIF() {
        return this.uif;
    }

    public ContextManager getContextManager() {
        if (this.context != null) {
            return this.context;
        }
        this.context = ExecTool.createContextManager(this.testSuite);
        if (this.context != null) {
            this.context.setInterview(this.interviewParams);
            this.context.setTool(this);
            this.context.setWorkDir(this.workDir);
        }
        return this.context;
    }

    static ContextManager createContextManager(TestSuite testSuite) {
        ContextManager context = null;
        String cls = null;
        if (testSuite != null) {
            cls = testSuite.getTestSuiteInfo("tmcontext");
        }
        try {
            context = cls == null ? (ContextManager)Class.forName("com.sun.javatest.exec.ContextManager").newInstance() : (ContextManager)Class.forName(cls, true, testSuite.getClassLoader()).newInstance();
            context.setTestSuite(testSuite);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return context;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int dpi = this.uif.getDotsPerInch();
        d.width = Math.max(d.width, 6 * dpi);
        d.height = Math.max(d.height, 3 * dpi);
        return d;
    }

    public boolean isEmpty() {
        return this.testSuite == null;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public TestSuite[] getLoadedTestSuites() {
        TestSuite[] testSuiteArray;
        if (this.testSuite == null) {
            testSuiteArray = null;
        } else {
            TestSuite[] testSuiteArray2 = new TestSuite[1];
            testSuiteArray = testSuiteArray2;
            testSuiteArray2[0] = this.testSuite;
        }
        return testSuiteArray;
    }

    public boolean containsTestSuite(TestSuite ts) {
        return this.testSuite != null && this.testSuite.getRoot().equals(ts.getRoot());
    }

    public boolean containsTestSuite(File f) {
        return this.testSuite != null && this.testSuite.getRoot().equals(f);
    }

    void setTestSuite(TestSuite testSuite) throws Interview.Fault, TestSuite.Fault {
        this.init(testSuite, null);
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public WorkDirectory[] getLoadedWorkDirectories() {
        WorkDirectory[] workDirectoryArray;
        if (this.workDir == null) {
            workDirectoryArray = null;
        } else {
            WorkDirectory[] workDirectoryArray2 = new WorkDirectory[1];
            workDirectoryArray = workDirectoryArray2;
            workDirectoryArray2[0] = this.workDir;
        }
        return workDirectoryArray;
    }

    public boolean containsWorkDirectory(File f) {
        return this.workDir != null && this.workDir.getRoot().equals(f);
    }

    void setWorkDirectory(WorkDirectory workDir) throws Interview.Fault, TestSuite.Fault {
        this.init(null, workDir);
        if (this.context != null) {
            this.context.setWorkDir(workDir);
        }
    }

    void setInterviewParameters(InterviewParameters interviewParams) {
        if (interviewParams == null) {
            throw new NullPointerException();
        }
        if (this.testSuite != null || this.workDir != null) {
            throw new IllegalStateException();
        }
        this.interviewParams = interviewParams;
        this.testSuite = interviewParams.getTestSuite();
        this.context = null;
        this.getContextManager();
        this.workDir = interviewParams.getWorkDirectory();
        this.captureWorkDirInfo();
        if (this.context != null) {
            this.context.setWorkDir(this.workDir);
        }
        this.updateGUI();
    }

    public InterviewParameters getInterviewParameters() {
        return this.interviewParams;
    }

    public FilterConfig getFilterConfig() {
        return this.filterHandler.getFilterConfig();
    }

    public void showQuickStartWizard() {
        if (this.testSuite != null) {
            throw new IllegalStateException();
        }
        this.quickStartWizard = new QuickStartWizard(this, this.uif);
        if (this.isShowing()) {
            this.quickStartWizard.setVisible(true);
        } else {
            this.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent e) {
                    if (ExecTool.this.isShowing()) {
                        ExecTool.this.quickStartWizard.setVisible(true);
                        ExecTool.this.removeHierarchyListener(this);
                    }
                }
            });
        }
    }

    boolean isQuickStartWizardShowing() {
        return this.quickStartWizard != null && this.quickStartWizard.isShowing();
    }

    public void showConfigEditor(boolean runTestsWhenDone) {
        if (runTestsWhenDone) {
            ActionListener l = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int option;
                    if (ExecTool.this.interviewParams.isFinishable() && (option = ExecTool.this.uif.showOKCancelDialog("exec.configDone")) == 0) {
                        ExecTool.this.runTestsHandler.start();
                    }
                }
            };
            this.configHandler.showConfigEditor(l);
        } else {
            this.configHandler.showConfigEditor();
        }
    }

    public void showTemplateEditor() {
        this.configHandler.showTemplateEditor();
    }

    public void runTests() {
        this.runTestsHandler.start();
    }

    public void runTests(String[] urls) {
        if (urls == null || urls.length == 0) {
            return;
        }
        try {
            this.runTestsHandler.executeImmediate(urls);
        }
        catch (Interview.Fault f) {
            f.printStackTrace();
        }
        catch (TestSuite.Fault f) {
            f.printStackTrace();
        }
    }

    public void save(Map m) {
        if (this.testSuite != null && this.testSuite.getRoot() != null) {
            m.put("testSuite", this.testSuite.getRoot().getPath());
        }
        if (this.workDir != null) {
            m.put("workDir", this.workDir.getPath());
        }
        if (this.interviewParams != null && this.interviewParams.getFile() != null) {
            m.put("config", this.interviewParams.getFile().getPath());
        }
        this.reportHandler.save(m);
        this.testTreePanel.save(m);
        this.filterHandler.save(m);
        this.toolBarManager.save(m);
    }

    ExecTool(ExecToolManager mgr, Map m) throws Interview.Fault {
        this(mgr, ExecTool.getInterview(m), m);
        this.reportHandler.restore(m);
    }

    private ExecTool(ExecToolManager mgr, InterviewParameters interviewParams, Map map) {
        super(mgr, "exec", "browse.window.csh");
        this.manager = mgr;
        this.interviewParams = interviewParams;
        if (interviewParams != null) {
            this.testSuite = interviewParams.getTestSuite();
            this.workDir = interviewParams.getWorkDirectory();
            this.captureWorkDirInfo();
            String testSuiteName = this.testSuite.getName();
            if (testSuiteName != null) {
                this.setShortTitle(testSuiteName);
            }
        }
        this.configHandler = new ConfigHandler(this, this, this.uif);
        this.runTestsHandler = new RunTestsHandler(this, this, this.configHandler, this.uif);
        Harness harness = this.runTestsHandler.getHarness();
        this.reportHandler = new ReportHandler(this, this, harness, this.uif);
        this.filterHandler = new ET_FilterHandler(this, this, this.runTestsHandler.getHarness(), this.uif, map);
        if (this.interviewParams != null) {
            this.interviewParams.setTemplateManger(this.getContextManager());
        }
        if (this.templatePath != null) {
            int sep = this.templatePath.lastIndexOf(File.separator);
            this.configHandler.setTemplateName(this.templatePath.substring(sep < 0 ? 0 : sep + 1));
        }
        this.initGUI(map);
    }

    private static InterviewParameters getInterview(Map m) throws Interview.Fault {
        String tsp = (String)m.get("testSuite");
        String wdp = (String)m.get("workDir");
        String cfp = (String)m.get("config");
        if (ExecTool.isEmpty(tsp) && ExecTool.isEmpty(wdp) && ExecTool.isEmpty(cfp)) {
            return null;
        }
        return InterviewParameters.open(tsp, wdp, cfp);
    }

    private void init(TestSuite newTestSuite, WorkDirectory newWorkDir) throws TestSuite.Fault, Interview.Fault {
        block26: {
            this.context = null;
            if (newTestSuite == null && newWorkDir == null) {
                throw new IllegalArgumentException();
            }
            if (newTestSuite == null) {
                newTestSuite = newWorkDir.getTestSuite();
            }
            if (this.testSuite != null && this.testSuite != newTestSuite) {
                throw new IllegalStateException();
            }
            if (this.workDir != null && this.workDir != newWorkDir) {
                this.manager.showWorkDirectory(newWorkDir);
                return;
            }
            if (this.interviewParams != null && this.interviewParams.getTestSuite() != newTestSuite) {
                throw new IllegalStateException();
            }
            if (this.workDir != null || newWorkDir != null) {
                // empty if block
            }
            this.testSuite = newTestSuite;
            this.workDir = newWorkDir;
            this.captureWorkDirInfo();
            if (this.interviewParams == null) {
                this.interviewParams = this.testSuite.createInterview();
            }
            if (this.templatePath != null) {
                try {
                    this.testSuite.loadInterviewFromTemplate(new File(this.templatePath), this.interviewParams);
                    this.interviewParams.setTemplatePath(this.templatePath);
                }
                catch (TestSuite.Fault f) {
                    this.uif.showError("exec.cantLoadTmpl", f.getMessage());
                }
                catch (IOException e) {
                    this.uif.showError("exec.cantLoadTmpl", e.getMessage());
                }
            }
            this.interviewParams.setTemplateManger(this.getContextManager());
            if (this.templatePath != null) {
                this.interviewParams.setTemplatePath(this.templatePath);
            }
            if (this.workDir != null) {
                TestResultTable trt;
                if (this.workDirReset && newWorkDir.getTestResultTable() == null) {
                    newWorkDir.setTestResultTable(new TestResultTable(newWorkDir));
                    this.workDirReset = false;
                }
                if ((trt = this.testTreePanel.getTestResultTable()) != null) {
                    try {
                        this.workDir.setTestResultTable(trt);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
                this.interviewParams.setWorkDirectory(this.workDir);
                FileHistory h = FileHistory.getFileHistory(this.workDir, "configHistory.jtl");
                File latestConfigFile = h.getLatestEntry();
                if (latestConfigFile != null) {
                    try {
                        if (!this.context.getAllowConfigLoadOutsideDefault()) {
                            File defaultConfigLoadPath = ConfigEditor.checkLoadConfigFileDefaults(this.getContextManager());
                            File dir = new File(latestConfigFile.getAbsolutePath().substring(0, latestConfigFile.getAbsolutePath().lastIndexOf(File.separator)));
                            boolean isMatch = true;
                            if (dir != null && defaultConfigLoadPath != null) {
                                try {
                                    isMatch = dir.getCanonicalPath().indexOf(defaultConfigLoadPath.getCanonicalPath()) == 0;
                                }
                                catch (IOException ioe) {
                                    this.uif.showError("exec.internalError", ioe);
                                    return;
                                }
                            }
                            if (!isMatch) {
                                this.resetWorkDirectory();
                                this.uif.showError("ce.load.notAllowedDir", defaultConfigLoadPath);
                            } else {
                                this.interviewParams.load(latestConfigFile);
                            }
                            break block26;
                        }
                        this.interviewParams.load(latestConfigFile);
                    }
                    catch (IOException e) {
                        this.uif.showError("exec.cantLoadDefaultConfig", new Object[]{latestConfigFile, e});
                    }
                }
            }
        }
        this.updateGUI();
    }

    private void initGUI(Map map) {
        this.context = null;
        this.setShortTitle(this.uif.getI18NString("exec.shortTitle"));
        this.configHandler.addConfigEditorAccelerator(this);
        if (this.menuBar != null) {
            throw new IllegalStateException();
        }
        ContextManager cm = this.getContextManager();
        this.menuManager = cm.getMenuManager();
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.configHandler.getMenu());
        this.menuBar.add(this.runTestsHandler.getMenu());
        this.menuBar.add(this.reportHandler.getMenu());
        Action[] viewActions = new Action[]{this.propertiesAction, this.testSuiteErrorsAction, this.logViewerAction};
        JMenu viewMenu = this.uif.createMenu("exec.view", viewActions);
        viewMenu.insertSeparator(0);
        JMenuItem fmItem = this.createFilterMenu();
        this.menuBar.add(viewMenu);
        this.menuBar.add(this.uif.createHorizontalGlue("exec.pad"));
        JMenu helpMenu = this.uif.createMenu("exec.help");
        helpMenu.add(this.uif.createHelpMenuItem("exec.help.window", "browse.window.csh"));
        this.menuBar.add(helpMenu);
        this.setLayout(new BorderLayout());
        Vector<Action> v = new Vector<Action>();
        v.addAll(Arrays.asList(this.configHandler.getToolBarActions()));
        v.add(null);
        v.addAll(Arrays.asList(this.runTestsHandler.getToolBarActions()));
        v.add(null);
        v.add(this.helpAction);
        Object[] toolBarActions = new Action[v.size()];
        v.copyInto(toolBarActions);
        Preferences p = Preferences.access();
        this.toolBar = this.uif.createToolBar(TOOLBAR_PREF);
        this.toolBar.setFloatable(false);
        this.toolBar.setVisible(p.getPreference(TOOLBAR_PREF, "true").equals("true"));
        this.toolBar.getMargin().left = 10;
        this.toolBar.getMargin().right = 10;
        JLabel lab = this.uif.createLabel("exec.filter", false);
        JComponent selector = this.filterHandler.getFilterSelectionHandler().getFilterSelector();
        lab.setMaximumSize(lab.getPreferredSize());
        this.toolBar.add(lab);
        this.toolBar.addSeparator();
        this.toolBar.add(selector);
        this.toolBar.addSeparator();
        this.uif.addToolBarActions(this.toolBar, (Action[])toolBarActions);
        ToolBarPanel toolBarPanel = new ToolBarPanel();
        toolBarPanel.add(this.toolBar);
        this.toolBarManager = this.getContextManager().getToolBarManager();
        this.toolBarManager.setUIFactory(this.uif);
        this.toolBarManager.setPanel(toolBarPanel);
        this.add((Component)toolBarPanel, "North");
        viewMenu.insert(this.toolBarManager.getToolbarMenu(), 0);
        viewMenu.insert(fmItem, 0);
        viewMenu.insert(this.createViewConfigMenu(), 0);
        this.prefsObserver = new Preferences.Observer(){

            public void updated(String name, String newValue) {
                if (name.equals(ExecTool.TOOLBAR_PREF)) {
                    ExecTool.this.toolBar.setVisible("true".equals(newValue));
                }
            }
        };
        p.addObserver(TOOLBAR_PREF, this.prefsObserver);
        Harness harness = this.runTestsHandler.getHarness();
        this.testTreePanel = new TestTreePanel(this.uif, harness, this, this.filterHandler.getFilterSelectionHandler(), this, map);
        if (this.shouldPauseTree) {
            this.testTreePanel.getTreePanelModel().pauseWork();
        }
        this.runTestsHandler.setTreePanelModel(this.testTreePanel.getTreePanelModel());
        this.add((Component)this.testTreePanel, "Center");
        JPanel statusStrips = this.uif.createPanel("exec.strips", false);
        MessageStrip messageStrip = this.runTestsHandler.getMessageStrip();
        statusStrips.setLayout(new BorderLayout());
        statusStrips.add((Component)this.makeStatusStrip(), "North");
        statusStrips.add((Component)messageStrip, "South");
        this.add((Component)statusStrips, "South");
        TU_ViewManager.register(this, this.uif, this.configHandler);
        this.updateGUI();
        if (this.getInterviewParameters() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExecTool.this.getInterviewParameters().checkForUpdates();
                }
            });
        }
    }

    private void captureWorkDirInfo() {
        this.templatePath = this.workDir == null ? null : TemplateUtilities.getTemplatePath(this.workDir);
    }

    private JComponent makeStatusStrip() {
        Vector vStrips = new Vector();
        vStrips.addAll(this.makeWDField());
        vStrips.addAll(this.configHandler.getStatusStrip());
        JPanel statusStrips = this.uif.createPanel("exec.status", false);
        statusStrips.setLayout(new GridBagLayout());
        for (int i = 0; i < vStrips.size() - 1; i += 2) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 0.0;
            statusStrips.add((Component)((JLabel)vStrips.elementAt(i)), gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            JTextField tf = (JTextField)vStrips.elementAt(i + 1);
            tf.setHorizontalAlignment(2);
            statusStrips.add((Component)tf, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.weightx = 0.0;
            final JTextField ellipsis = new JTextField("...");
            ellipsis.setMinimumSize(ellipsis.getPreferredSize());
            ellipsis.setMaximumSize(ellipsis.getPreferredSize());
            ellipsis.setFont(tf.getFont());
            ellipsis.setBackground(tf.getBackground());
            ellipsis.setDisabledTextColor(tf.getForeground());
            ellipsis.setBorder(BorderFactory.createEmptyBorder());
            ellipsis.setEnabled(false);
            ellipsis.setEditable(false);
            statusStrips.add((Component)ellipsis, gbc);
            tf.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    ExecTool.this.process(e, ellipsis);
                }

                public void componentMoved(ComponentEvent e) {
                    ExecTool.this.process(e, ellipsis);
                }
            });
            tf.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    ExecTool.this.process(e, ellipsis);
                }

                public void focusLost(FocusEvent e) {
                    ExecTool.this.process(e, ellipsis);
                }
            });
        }
        return statusStrips;
    }

    private void process(ComponentEvent e, JTextField ellipsis) {
        JTextField c = (JTextField)e.getComponent();
        if (c.getSize().getWidth() < c.getPreferredSize().getWidth() && !c.isFocusOwner()) {
            ellipsis.setVisible(true);
        } else {
            ellipsis.setVisible(false);
        }
        c.getParent().validate();
    }

    private List makeWDField() {
        JLabel lab = this.uif.createLabel("exec.bar.wdname");
        lab.setDisplayedMnemonic(this.uif.getI18NString("exec.bar.wdname.mne").charAt(0));
        lab.setBackground(MetalLookAndFeel.getMenuBackground());
        lab.setForeground(new Color(102, 102, 102));
        FontUIResource f = MetalLookAndFeel.getSystemTextFont();
        lab.setFont(new Font("Ariel", 1, f.getSize()));
        lab.setHorizontalAlignment(4);
        this.wdNameField = this.uif.createOutputField("exec.bar.wdnamef", 0, lab);
        this.wdNameField.setHorizontalAlignment(10);
        this.wdNameField.setBorder(BorderFactory.createEmptyBorder());
        this.wdNameField.setBackground(MetalLookAndFeel.getMenuBackground());
        this.wdNameField.setForeground(new Color(102, 102, 102));
        this.wdNameField.setFont(new Font("Ariel", 1, f.getSize()));
        this.wdNameField.setText(this.uif.getI18NString("exec.bar.none"));
        return Arrays.asList(lab, this.wdNameField);
    }

    private JMenuItem createFilterMenu() {
        return this.filterHandler.getMenu();
    }

    private JMenuItem createViewConfigMenu() {
        JMenuItem[] items = this.configHandler.getConfigViewMenuItems();
        if (items != null) {
            int i;
            JMenu m = this.uif.createMenu("exec.view.cfg");
            for (i = 0; i < items.length; ++i) {
                m.add(items[i]);
            }
            if (this.menuManager != null && (items = this.menuManager.getMenuItems(5)) != null) {
                for (i = 0; i < items.length; ++i) {
                    m.add(items[i]);
                }
            }
            return m;
        }
        return null;
    }

    private void updateGUI() {
        String workDirPath;
        this.configHandler.updateGUI();
        this.runTestsHandler.updateGUI();
        this.reportHandler.updateGUI();
        if (this.interviewParams != null && this.interviewObserver == null) {
            this.interviewObserver = new Interview.Observer(){

                public void currentQuestionChanged(Question q) {
                }

                public void pathUpdated() {
                    ExecTool.this.filterHandler.updateParameters();
                }
            };
            this.interviewParams.addObserver(this.interviewObserver);
        }
        String testSuiteName = this.testSuite == null ? null : this.testSuite.getName();
        String string = workDirPath = this.workDir == null ? null : this.workDir.getRoot().getPath();
        if (this.wdNameField != null && workDirPath != null) {
            int slash = workDirPath.lastIndexOf(File.separator);
            this.wdNameField.setText(workDirPath.substring(slash < 0 ? 0 : slash + 1));
        }
        if (this.testSuite == null) {
            this.setI18NTitle("exec.title.noTS.txt");
        } else if (workDirPath == null) {
            if (testSuiteName == null) {
                this.setI18NTitle("exec.title.noWD.txt");
            } else {
                this.setShortTitle(testSuiteName);
                this.setI18NTitle("exec.title.tsName.txt", testSuiteName);
            }
        } else if (testSuiteName == null) {
            if (workDirPath != null) {
                this.setI18NTitle("exec.title.wd.txt", workDirPath);
            } else {
                this.setI18NTitle("exec.title.noTsName.txt");
            }
        } else {
            this.setShortTitle(testSuiteName);
            this.setI18NTitle("exec.title.tsName_wd.txt", new Object[]{testSuiteName, workDirPath});
        }
        if (this.testSuite != null) {
            TestFinder tf = this.testSuite.getTestFinder();
            tf.setErrorHandler(this.testFinderErrorHandler);
            this.testSuiteErrorsAction.setEnabled(tf.getErrorCount() > 0);
            if (this.workDir != null && this.workDir.getLogFileName() != null) {
                this.logViewerAction.setEnabled(true);
            } else {
                this.logViewerAction.setEnabled(false);
            }
        } else {
            this.logViewerAction.setEnabled(false);
        }
        this.testTreePanel.setParameters(this.interviewParams);
        this.filterHandler.updateParameters();
        this.testTreePanel.updateGUI();
    }

    private void setTestSuite(TestSuite ts, boolean addToFileHistory) throws Interview.Fault, TestSuite.Fault {
        this.init(ts, null);
        if (addToFileHistory) {
            this.manager.addToFileHistory(ts);
        }
    }

    public void setWorkDir(WorkDirectory wd, boolean addToFileHistory) throws Interview.Fault, TestSuite.Fault {
        this.init(null, wd);
        if (addToFileHistory) {
            this.manager.addToFileHistory(wd);
        }
    }

    public void showWorkDirDialog(boolean allowTemplates) {
        int mode;
        ActionListener optionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = (Component)e.getSource();
                JOptionPane op = (JOptionPane)SwingUtilities.getAncestorOfClass(JOptionPane.class, c);
                op.setValue(c);
                op.setVisible(false);
            }
        };
        JTextArea msg = this.uif.createMessageArea("exec.wd.need");
        String title = this.uif.getI18NString("exec.wd.need.title");
        Object[] options = new JButton[]{this.uif.createButton("exec.wd.open", optionListener), this.uif.createButton("exec.wd.new", optionListener), this.uif.createCancelButton("exec.wd.cancel", optionListener)};
        int option = JOptionPane.showOptionDialog(this, msg, title, 1, 3, null, options, null);
        switch (option) {
            case 0: {
                mode = 2;
                break;
            }
            case 1: {
                mode = 0;
                break;
            }
            default: {
                return;
            }
        }
        WorkDirChooseTool.getTool(this, this.uif, this, mode, this.testSuite, allowTemplates).doTool();
    }

    public void showMessage(ResourceBundle msgs, String key) {
        this.runTestsHandler.getMessageStrip().showMessage(msgs, key);
    }

    public void printSetup() {
        this.getDesktop().printSetup();
    }

    public void print(Printable p) {
        this.getDesktop().print(p);
    }

    public void showConfigEditor() {
        this.configHandler.showConfigEditor();
    }

    public void showConfigEditor(ActionListener l) {
        this.configHandler.showConfigEditor(l);
    }

    public void resetWorkDirectory() throws TestSuite.Fault {
        this.interviewParams = this.testSuite.createInterview();
        this.workDir = this.interviewParams.getWorkDirectory();
        this.captureWorkDirInfo();
        this.workDirReset = true;
        this.updateGUI();
    }

    public void closeLogger() {
        if (this.workDir == null) {
            return;
        }
        Logger l = this.testSuite.getNotificationLog(this.workDir);
        Handler[] hs = l.getHandlers();
        for (int i = 0; i < hs.length; ++i) {
            if (!(hs[i] instanceof WorkDirLogHandler) || !((WorkDirLogHandler)hs[i]).getPattern().equals(this.workDir.getLogFileName())) continue;
            hs[i].close();
            l.removeHandler(hs[i]);
        }
    }

    void syncInterview() {
        this.configHandler.syncInterview();
    }

    public TestResultTable getActiveTestResultTable() {
        if (this.workDir != null) {
            return this.workDir.getTestResultTable();
        }
        if (this.testTreePanel != null) {
            return this.testTreePanel.getTestResultTable();
        }
        return null;
    }

    public ExecToolManager getExecToolManager() {
        return this.manager;
    }

    TestSuiteChooser getTestSuiteChooser() {
        if (this.testSuiteChooser == null) {
            this.testSuiteChooser = new TestSuiteChooser();
        }
        return this.testSuiteChooser;
    }

    void pauseTreeCacheWork() {
        if (this.testTreePanel != null && this.testTreePanel.getTreePanelModel() != null) {
            this.testTreePanel.getTreePanelModel().pauseWork();
        } else {
            this.shouldPauseTree = true;
        }
    }

    void unpauseTreeCacheWork() {
        if (this.testTreePanel != null && this.testTreePanel.getTreePanelModel() != null) {
            this.testTreePanel.getTreePanelModel().unpauseWork();
        } else {
            this.shouldPauseTree = false;
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private void openLogViewer() {
        new LogViewer(this.workDir, this.uif, this);
    }

    void loadInterview(File file) {
        this.configHandler.loadInterview(file);
    }

    private class TestFinderErrorHandler
    implements TestFinder.ErrorHandler {
        private boolean shownErrorDialog = false;

        private TestFinderErrorHandler() {
        }

        public void error(final String message) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TestFinderErrorHandler.this.error(message);
                    }
                });
                return;
            }
            if (ExecTool.this.testSuiteErrorsDialog != null && ExecTool.this.testSuiteErrorsDialog.isShowing()) {
                ExecTool.this.testSuiteErrorsDialog.show(ExecTool.this.testSuite);
            }
            ExecTool.this.testSuiteErrorsAction.setEnabled(true);
            if (!this.shownErrorDialog) {
                this.shownErrorDialog = true;
                ExecTool.this.uif.showError("exec.testFinderErr", message);
            }
        }
    }
}

