/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;

class ParameterFilter
extends ObservableTestFilter {
    private InitialUrlFilter iurlFilter;
    private boolean rmInitFiles = true;
    private TestFilter[] filters;
    private String[] initUrls;
    private Parameters params;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ParameterFilter.class);

    ParameterFilter() {
    }

    public void setFilterTests(boolean state) {
        this.rmInitFiles = state;
    }

    public boolean isTestsFiltered() {
        return this.rmInitFiles;
    }

    public String getName() {
        return i18n.getString("pFilter.name");
    }

    public String getDescription() {
        return i18n.getString("pFilter.desc");
    }

    public String getReason() {
        return i18n.getString("pFilter.reason");
    }

    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        return this.accepts(td, null);
    }

    public boolean accepts(TestDescription td, TestFilter.Observer o) throws TestFilter.Fault {
        if (this.filters == null || this.filters.length == 0) {
            if (this.iurlFilter == null) {
                return true;
            }
            boolean result = this.iurlFilter.accepts(td);
            if (!result && o != null) {
                o.rejected(td, this.iurlFilter);
            }
        }
        for (int i = 0; i < this.filters.length; ++i) {
            boolean result = this.filters[i].accepts(td);
            if (result) continue;
            if (o != null) {
                o.rejected(td, this.filters[i]);
            }
            return false;
        }
        if (this.rmInitFiles && this.iurlFilter != null && !this.iurlFilter.accepts(td)) {
            if (o != null) {
                o.rejected(td, this.iurlFilter);
            }
            return false;
        }
        return true;
    }

    public TestFilter[] getTestFilters() {
        TestFilter[] copy = null;
        copy = this.rmInitFiles && this.iurlFilter != null ? new TestFilter[this.filters.length + 1] : new TestFilter[this.filters.length];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        if (this.rmInitFiles) {
            copy[copy.length - 1] = this.iurlFilter;
        }
        return copy;
    }

    void update(Parameters p) {
        if (p == null) {
            return;
        }
        boolean wasUpdated = false;
        if (this.params == null) {
            this.params = p;
            this.filters = p.getFilters();
            wasUpdated = true;
        } else if (p != this.params) {
            this.params = p;
            this.filters = p.getFilters();
            wasUpdated = true;
        } else {
            TestFilter[] newFilters = p.getFilters();
            if (newFilters != null || this.filters != null) {
                if (newFilters == null && this.filters != null || this.filters == null && newFilters != null) {
                    this.filters = newFilters;
                    wasUpdated = true;
                } else if (newFilters.length == this.filters.length) {
                    if (!CompositeFilter.equals(newFilters, this.filters)) {
                        this.filters = newFilters;
                        wasUpdated = true;
                    }
                } else {
                    this.filters = newFilters;
                    wasUpdated = true;
                }
            }
        }
        File[] initFiles = ParameterFilter.stringsToFiles(p.getTests());
        this.iurlFilter = new InitialUrlFilter(initFiles);
        if (wasUpdated) {
            this.notifyUpdated(this);
        }
    }

    private static File[] stringsToFiles(String[] tests) {
        if (tests == null) {
            return null;
        }
        File[] files = new File[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            files[i] = new File(tests[i]);
        }
        return files;
    }
}

