/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.help.HelpBroker;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

class PrefsPane
extends Preferences.Pane {
    private UIFactory uif;
    private JCheckBox toolBarChk;
    private JCheckBox filterWarnChk;
    private ConfigEditorPane configEditorPane;
    private Preferences.Pane[] childPanes;

    PrefsPane(HelpBroker helpBroker) {
        this.uif = new UIFactory(this, helpBroker);
        this.initGUI();
    }

    public Preferences.Pane[] getChildPanes() {
        if (this.configEditorPane == null) {
            this.configEditorPane = new ConfigEditorPane();
        }
        if (this.childPanes == null) {
            this.childPanes = new Preferences.Pane[]{this.configEditorPane};
        }
        return this.childPanes;
    }

    public String getText() {
        return this.uif.getI18NString("ep.title");
    }

    public void load(Map m) {
        super.load(m);
        String p = (String)m.get("exec.toolbar");
        this.toolBarChk.setSelected(p == null || p.equals("true"));
        p = (String)m.get("exec.filterWarn");
        this.filterWarnChk.setSelected(p == null || p.equals("true"));
    }

    public void save(Map m) {
        super.save(m);
        m.put("exec.toolbar", String.valueOf(this.toolBarChk.isSelected()));
        m.put("exec.filterWarn", String.valueOf(this.filterWarnChk.isSelected()));
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.createToolBarPanel(), c);
        this.add((Component)this.createFilterPanel(), c);
        c.weighty = 1.0;
        this.add(Box.createVerticalGlue(), c);
    }

    private JPanel createToolBarPanel() {
        JPanel p = this.uif.createPanel("exec.prefs", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.toolbar"));
        this.toolBarChk = this.uif.createCheckBox("ep.toolbar", true);
        this.uif.setAccessibleName(this.toolBarChk, "ep.toolbar");
        p.add((Component)this.toolBarChk, c);
        return p;
    }

    private JPanel createFilterPanel() {
        JPanel p = this.uif.createPanel("exec.prefs.filter", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.filt"));
        this.filterWarnChk = this.uif.createCheckBox("ep.filt", true);
        this.uif.setAccessibleName(this.filterWarnChk, "ep.filt");
        p.add((Component)this.filterWarnChk, c);
        return p;
    }

    private class ConfigEditorPane
    extends Preferences.Pane {
        private JRadioButton fullBtn;
        private JRadioButton stdBtn;
        private JCheckBox moreInfoChk;

        ConfigEditorPane() {
            this.initGUI();
        }

        public String getText() {
            return PrefsPane.this.uif.getI18NString("ep.ce.title");
        }

        public void load(Map m) {
            String vp = (String)m.get("exec.config.view");
            if (vp != null && vp.equals("std")) {
                this.stdBtn.setSelected(true);
            } else {
                this.fullBtn.setSelected(true);
            }
            String mp = (String)m.get("exec.config.moreInfo");
            this.moreInfoChk.setSelected(mp == null || mp.equals("true"));
        }

        public void save(Map m) {
            m.put("exec.config.view", this.stdBtn.isSelected() ? "std" : "full");
            m.put("exec.config.moreInfo", String.valueOf(this.moreInfoChk.isSelected()));
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)this.createDefaultViewPanel(), c);
            c.weighty = 1.0;
            this.add(Box.createVerticalGlue(), c);
        }

        private JPanel createDefaultViewPanel() {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridwidth = 0;
            c.insets.left = 10;
            c.weightx = 1.0;
            c.weighty = 0.0;
            JPanel p = new JPanel(new GridBagLayout());
            JTextArea infoTa = PrefsPane.this.uif.createMessageArea("ep.ce.info");
            infoTa.setOpaque(false);
            this.add((Component)infoTa, c);
            p.setBorder(PrefsPane.this.uif.createTitledBorder("ep.ce.defView"));
            ButtonGroup grp = new ButtonGroup();
            this.fullBtn = PrefsPane.this.uif.createRadioButton("ep.ce.defView.full", grp);
            p.add((Component)this.fullBtn, c);
            this.stdBtn = PrefsPane.this.uif.createRadioButton("ep.ce.defView.std", grp);
            p.add((Component)this.stdBtn, c);
            this.moreInfoChk = PrefsPane.this.uif.createCheckBox("ep.ce.moreInfo", true);
            PrefsPane.this.uif.setAccessibleName(this.moreInfoChk, "ep.ce.moreInfo");
            c.insets.top = 10;
            p.add((Component)this.moreInfoChk, c);
            return p;
        }
    }
}

