/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.JavaTestContextMenu;
import com.sun.javatest.exec.MultiSelectPanel;
import com.sun.javatest.exec.TT_Renderer;
import com.sun.javatest.exec.TestPanel;
import com.sun.javatest.exec.TestTree;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.Deck;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class TestTreePanel
extends JPanel {
    private UIFactory uif;
    private Harness harness;
    private FilterSelectionHandler filterHandler;
    private ExecModel execModel;
    private JComponent parent;
    private Thread bgThread;
    private Map stateMap;
    private boolean disposed;
    private PanelModel pm;
    private TestTree tree;
    private TT_Renderer treeRend;
    private TestPanel testPanel;
    private BranchPanel brPanel;
    private MultiSelectPanel msPanel;
    private JPopupMenu popup;
    private TreePath lastPopupPath;
    private JMenuItem refreshMI;
    private JMenuItem purgeMI;
    private JMenuItem runMI;
    private String activeTest;
    private ArrayList testMenus;
    private ArrayList folderMenus;
    private ArrayList mixedMenus;
    private ArrayList customMenus;
    private TestTreeModel treeModel;
    private Deck deck;
    private JPanel deckPanel;
    private JTextField titleField;
    private Listener listener;
    private TestSuite lastTs;
    private Parameters params;
    private static final int WAIT_DIALOG_DELAY = 3000;
    private static final String OPEN_PATHS_PREF = "openpaths";
    protected static boolean debug = Boolean.getBoolean("debug." + TestTreePanel.class.getName());

    public TestTreePanel(UIFactory uif, Harness h, ExecModel em, FilterSelectionHandler fh, JComponent parent, Map map) {
        this.uif = uif;
        this.harness = h;
        this.filterHandler = fh;
        this.execModel = em;
        this.parent = parent;
        this.stateMap = map;
        this.pm = new PanelModel();
        this.harness.addObserver(this.pm);
        this.initGUI();
        uif.setAccessibleInfo(this, "treep");
    }

    public TestResultTable getTestResultTable() {
        return this.treeModel.getTestResultTable();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public TreePanelModel getTreePanelModel() {
        return this.pm;
    }

    public void dispose() {
        this.disposed = true;
        if (this.treeModel != null) {
            this.treeModel.dispose();
            this.treeModel = null;
        }
        if (this.brPanel != null) {
            this.brPanel.dispose();
            this.brPanel = null;
        }
        if (this.bgThread != null && this.bgThread.isAlive()) {
            this.bgThread.interrupt();
        }
        this.popup = null;
        this.lastPopupPath = null;
        this.customMenus = null;
        this.mixedMenus = null;
        this.folderMenus = null;
        this.testMenus = null;
    }

    void setParameters(Parameters p) {
        if (p == null) {
            return;
        }
        String[] paths = null;
        if (this.params == null && this.stateMap != null) {
            String tmp = (String)this.stateMap.get(OPEN_PATHS_PREF);
            if (tmp != null) {
                paths = StringArray.split(tmp);
            }
        } else {
            paths = this.getOpenPaths();
        }
        this.params = p;
        if (this.treeModel != null) {
            this.treeModel.setParameters(this.params);
        }
        if (this.tree != null) {
            this.tree.setParameters(this.params);
            this.treeRend.setParameters(this.params);
        }
        if (this.testPanel != null) {
            this.testPanel.setTestSuite(this.params.getTestSuite());
        }
        if (this.brPanel != null) {
            this.brPanel.setParameters(this.params);
        }
        TestResultTable trt = this.getTestResultTable();
        TreePath[] translatedPaths = this.getTreePaths(paths);
        if (translatedPaths != null) {
            TestTreePanel.restore(translatedPaths, this.tree);
        }
    }

    private TreePath[] getTreePaths(String[] paths) {
        TestResultTable trt = this.getTestResultTable();
        if (paths != null && trt != null) {
            Object[] translatedPaths = new TreePath[]{};
            for (int i = 0; i < paths.length; ++i) {
                Object targetNode = trt.resolveUrl(paths[i]);
                TreePath tp = this.nodeToPath(targetNode, trt);
                if (tp == null) continue;
                translatedPaths = (TreePath[])DynamicArray.append(translatedPaths, tp);
            }
            return translatedPaths;
        }
        return null;
    }

    void save(Map m) {
        String[] paths = this.getOpenPaths();
        Preferences p = Preferences.access();
        m.put(OPEN_PATHS_PREF, StringArray.join(paths));
    }

    private String[] getOpenPaths() {
        if (this.tree == null) {
            return null;
        }
        TreePath[] paths = this.tree.snapshotOpenPaths();
        TestResultTable trt = this.getTestResultTable();
        Vector<String> urls = new Vector<String>();
        if (paths != null && trt != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object last = paths[i].getLastPathComponent();
                String url = last instanceof TestResult ? ((TestResult)last).getTestName() : TestResultTable.getRootRelativePath((TestResultTable.TreeNode)last);
                urls.addElement(url);
            }
        }
        if (urls == null || urls.size() == 0) {
            return null;
        }
        Object[] result = new String[urls.size()];
        urls.copyInto(result);
        return result;
    }

    private TreePath nodeToPath(Object node, TestResultTable trt) {
        if (node instanceof TestResult) {
            TestResult tr = (TestResult)node;
            TestResultTable.TreeNode[] ptr = TestResultTable.getObjectPath(tr);
            Object[] longPath = new Object[ptr.length + 1];
            System.arraycopy(ptr, 0, longPath, 0, ptr.length);
            longPath[longPath.length - 1] = tr;
            return new TreePath(longPath);
        }
        Object[] ttp = TestResultTable.getObjectPath((TestResultTable.TreeNode)node);
        if (ttp != null && ttp.length > 0) {
            return new TreePath(ttp);
        }
        return null;
    }

    private void setPopupItemsEnabled(boolean state) {
        if (state) {
            boolean haveWorkDir = this.params != null && this.params.getWorkDirectory() != null;
            this.purgeMI.setEnabled(haveWorkDir);
            this.refreshMI.setEnabled(this.params != null && this.params.getTestSuite() != null);
            this.runMI.setEnabled(haveWorkDir);
        } else {
            this.purgeMI.setEnabled(false);
            this.refreshMI.setEnabled(false);
            this.runMI.setEnabled(false);
        }
    }

    private void clearNodes(final TreePath[] what) {
        final WorkDirectory wd = this.execModel.getWorkDirectory();
        if (wd == null) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeNoWd.msg"), this.uif.getI18NString("treep.cantPurgeNoWd.title"), 2);
            return;
        }
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantPurgeRunning.msg"), this.uif.getI18NString("treep.cantPurgeRunning.title"), 2);
            return;
        }
        boolean ack = false;
        Object[] toPurge = new Object[what.length];
        if (what.length > 1) {
            String[] paths = TestTreePanel.createNodeList(what);
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = paths.length; i > 0; --i) {
                model.add(model.getSize(), paths[model.getSize()]);
            }
            int confirm = this.showConfirmListDialog("treep.purgeItemsSure", null, model);
            if (confirm == 1) {
                return;
            }
            ack = true;
            for (int i = 0; i < what.length; ++i) {
                Object item = what[i].getLastPathComponent();
                if (item instanceof TestResult) {
                    toPurge[i] = ((TestResult)item).getWorkRelativePath();
                    continue;
                }
                if (!(item instanceof TestResultTable.TreeNode)) continue;
                TestResultTable.TreeNode tn = (TestResultTable.TreeNode)item;
                if (tn.isRoot()) {
                    toPurge = new Object[]{""};
                    break;
                }
                toPurge[i] = TestResultTable.getRootRelativePath(tn);
            }
        } else if (what[0].getLastPathComponent() instanceof TestResult) {
            TestResult tr = (TestResult)what[0].getLastPathComponent();
            int confirm = this.uif.showYesNoDialog("treep.purgeTestSure", tr.getTestName());
            if (confirm == 1) {
                return;
            }
            ack = true;
            toPurge[0] = tr.getWorkRelativePath();
        } else {
            TestResultTable.TreeNode tn = (TestResultTable.TreeNode)what[0].getLastPathComponent();
            int confirm = 0;
            confirm = tn.isRoot() ? this.uif.showYesNoDialog("treep.purgeRootSure", TestResultTable.getRootRelativePath(tn)) : this.uif.showYesNoDialog("treep.purgeNodeSure", TestResultTable.getRootRelativePath(tn));
            if (confirm == 1) {
                return;
            }
            ack = true;
            toPurge[0] = TestResultTable.getRootRelativePath(tn);
        }
        if (ack) {
            final JDialog d = this.uif.createWaitDialog("treep.waitPurge", this);
            final String[] finalList = TestTreePanel.createNodeList(toPurge);
            this.setPopupItemsEnabled(false);
            final Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    for (int i = 0; i < what.length; ++i) {
                        for (int j = 0; j < finalList.length; ++j) {
                            wd.purge(finalList[j]);
                        }
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                public void run() {
                                    if (d.isShowing()) {
                                        d.hide();
                                    }
                                    TestTreePanel.this.setPopupItemsEnabled(true);
                                    TreePath[] translatedPaths = TestTreePanel.this.getTreePaths(finalList);
                                    if (translatedPaths != null && TestTreePanel.this.tree != null) {
                                        TestTreePanel.this.tree.setSelectionPaths(translatedPaths);
                                    }
                                }
                            });
                        }
                        catch (InterruptedException e) {
                        }
                        catch (InvocationTargetException e) {}
                        continue;
                        catch (WorkDirectory.PurgeFault f) {
                            try {
                                I18NResourceBundle i18n = TestTreePanel.this.uif.getI18NResourceBundle();
                                wd.log(i18n, "treep.purgeFail.err", f);
                            }
                            catch (Throwable throwable) {
                                try {
                                    EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (InterruptedException e) {
                                }
                                catch (InvocationTargetException e) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (InterruptedException e) {
                            }
                            catch (InvocationTargetException invocationTargetException) {}
                            continue;
                        }
                    }
                }
            };
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (t == null) {
                        return;
                    }
                    if (t.isAlive() && !d.isVisible()) {
                        d.show();
                    } else if (!t.isAlive() && d.isVisible()) {
                        d.hide();
                    }
                }
            };
            this.bgThread = t;
            Timer timer = new Timer(3000, al);
            timer.setRepeats(false);
            timer.start();
            t.start();
        }
    }

    static String createNodeListString(String[] items) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            sb.append("      ");
            sb.append(items[i]);
            if (i + 1 >= items.length) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    static String[] createNodeList(Object[] items) {
        String[] result = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object item = items[i];
            if (item instanceof TreePath) {
                item = ((TreePath)item).getLastPathComponent();
            }
            if (item instanceof TestResult) {
                TestResult tr = (TestResult)item;
                result[i] = tr.getTestName();
                continue;
            }
            if (item instanceof TestResultTable.TreeNode) {
                TestResultTable.TreeNode tn = (TestResultTable.TreeNode)item;
                result[i] = TestResultTable.getRootRelativePath(tn);
                continue;
            }
            result[i] = items[i].toString();
        }
        return result;
    }

    private void showNodeInfoDialog(TreePath what) {
        if (what.getLastPathComponent() instanceof TestResultTable.TreeNode) {
            TestResultTable.TreeNode tn = (TestResultTable.TreeNode)what.getLastPathComponent();
            Debug.println("info for this node not implemented" + tn.getName() + " (" + tn + ")");
        }
    }

    private void runNodes(TreePath[] what) {
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRunRunning.msg"), this.uif.getI18NString("treep.cantRunRunning.title"), 2);
            return;
        }
        this.execModel.runTests(TestTreePanel.createNodeList(what));
    }

    private static void restore(final TreePath[] paths, final TestTree targetTree) {
        if (paths == null || targetTree == null) {
            return;
        }
        Runnable restorer = new Runnable(){

            public void run() {
                targetTree.restorePaths(paths);
            }
        };
        EventQueue.invokeLater(restorer);
    }

    private void refreshNodes(TreePath[] what) {
        if (this.harness.isRunning()) {
            JOptionPane.showMessageDialog(this.parent, this.uif.getI18NString("treep.cantRefreshRunning.msg"), this.uif.getI18NString("treep.cantRefreshRunning.title"), 2);
            return;
        }
        final TestResultTable trt = this.treeModel.getTestResultTable();
        boolean ack = false;
        Object[] ackTargets = new Object[what.length];
        if (what.length > 1) {
            String[] paths = TestTreePanel.createNodeList(what);
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = paths.length; i > 0; --i) {
                model.add(model.getSize(), paths[model.getSize()]);
            }
            int confirm = this.showConfirmListDialog("treep.refreshNodeSure", null, model);
            if (confirm == 1) {
                return;
            }
            for (int i = 0; i < what.length; ++i) {
                Object item = what[i].getLastPathComponent();
                if (item instanceof TestResult) {
                    ackTargets[i] = ((TestResult)item).getTestName();
                    continue;
                }
                if (!(item instanceof TestResultTable.TreeNode)) continue;
                TestResultTable.TreeNode tn = (TestResultTable.TreeNode)item;
                if (tn.isRoot()) {
                    ackTargets = new Object[]{null};
                    continue;
                }
                ackTargets[i] = TestResultTable.getRootRelativePath(tn);
            }
        } else if (what[0].getLastPathComponent() instanceof TestResult) {
            TestResult tr = (TestResult)what[0].getLastPathComponent();
            int confirm = this.uif.showYesNoDialog("treep.refreshTestSure", tr.getTestName());
            if (confirm == 1) {
                return;
            }
            ack = true;
            ackTargets[0] = tr.getTestName();
        } else {
            TestResultTable.TreeNode tn = (TestResultTable.TreeNode)what[0].getLastPathComponent();
            int confirm = 1;
            confirm = tn.isRoot() ? this.uif.showYesNoDialog("treep.refreshRootSure") : this.uif.showYesNoDialog("treep.refreshNodeSure", TestResultTable.getRootRelativePath(tn));
            if (confirm == 1) {
                return;
            }
            ack = true;
            ackTargets[0] = tn;
        }
        if (ack) {
            final JDialog d = this.uif.createWaitDialog("treep.waitRef", this);
            final Object[] finalTargets = ackTargets;
            this.setPopupItemsEnabled(false);
            final Thread t = new Thread(){
                {
                    this.setName("Tree refresh");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        trt.waitUntilReady();
                        TestTreePanel.this.treeModel.pauseWork();
                        for (int i = 0; i < finalTargets.length; ++i) {
                            try {
                                if (finalTargets[i] instanceof String) {
                                    trt.refreshIfNeeded((String)finalTargets[i]);
                                    continue;
                                }
                                trt.refreshIfNeeded((TestResultTable.TreeNode)finalTargets[i]);
                                continue;
                            }
                            catch (TestResultTable.Fault f) {
                                WorkDirectory wd = TestTreePanel.this.execModel.getWorkDirectory();
                                if (wd == null) continue;
                                I18NResourceBundle i18n = TestTreePanel.this.uif.getI18NResourceBundle();
                                wd.log(i18n, "treep.refFail", new Object[]{finalTargets[i] instanceof String ? finalTargets[i] : TestResultTable.getRootRelativePath((TestResultTable.TreeNode)finalTargets[i]), f.getMessage()});
                            }
                        }
                        TestTreePanel.this.treeModel.unpauseWork();
                    }
                    catch (Throwable throwable) {
                        TestTreePanel.this.treeModel.unpauseWork();
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                public void run() {
                                    if (d.isShowing()) {
                                        d.hide();
                                    }
                                    TestTreePanel.this.setPopupItemsEnabled(true);
                                }
                            });
                        }
                        catch (InterruptedException e) {
                        }
                        catch (InvocationTargetException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            };
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (t == null) {
                        return;
                    }
                    if (t.isAlive() && !d.isVisible()) {
                        d.show();
                    } else if (!t.isAlive() && d.isVisible()) {
                        d.hide();
                    }
                }
            };
            this.bgThread = t;
            Timer timer = new Timer(3000, al);
            timer.setRepeats(true);
            timer.start();
            t.start();
        }
    }

    void updateGUI() {
        MenuElement[] elems;
        if (debug) {
            Debug.println("TTP.updateGUI()");
        }
        if (this.disposed) {
            return;
        }
        if (this.popup != null && this.params != null && (elems = this.popup.getSubElements()) != null) {
            boolean haveWorkDir = this.params.getWorkDirectory() != null;
            this.purgeMI.setEnabled(haveWorkDir);
            this.refreshMI.setEnabled(this.params.getTestSuite() != null);
            this.runMI.setEnabled(haveWorkDir);
        }
        this.tree.updateGUI();
        this.brPanel.updateGUI();
        TestResultTable trt = this.getTestResultTable();
        if (trt != null && this.pm != null) {
            trt.addObserver(this.pm);
        }
    }

    private void initGUI() {
        JavaTestContextMenu[] cms;
        JSplitPane splitPane;
        block15: {
            this.setName("treeAndDetails");
            splitPane = this.uif.createSplitPane(1);
            this.listener = new Listener();
            this.treeModel = new TestTreeModel(this.params, this.filterHandler, this.uif);
            this.treeRend = new TT_Renderer(this.uif, this.filterHandler, this.pm);
            this.tree = new TestTree(this.uif, this.pm, this.filterHandler, this.treeModel);
            this.tree.setTreeModel(this.treeModel);
            this.tree.setCellRenderer(this.treeRend);
            this.tree.addTreeSelectionListener(this.listener);
            this.tree.addTreeExpansionListener(this.listener);
            this.tree.addMouseListener(this.listener);
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.getInputMap(1).put(KeyStroke.getKeyStroke(121, 1, false), "triggerPopup");
            this.tree.getActionMap().put("triggerPopup", new TreePopupAction(this.uif.getI18NResourceBundle(), "treep.popup"));
            this.uif.setAccessibleInfo(this.tree, "treep.tree");
            JPanel left = this.uif.createPanel("tree", new BorderLayout(), false);
            left.add((Component)this.uif.createScrollPane(this.tree, 20, 30), "Center");
            splitPane.setLeftComponent(left);
            this.deck = new Deck(){

                public Dimension getPreferredSize() {
                    int dpi = TestTreePanel.this.uif.getDotsPerInch();
                    return new Dimension(6 * dpi, 4 * dpi);
                }
            };
            this.testPanel = new TestPanel(this.uif, this.harness, this.execModel.getContextManager());
            this.brPanel = new BranchPanel(this.uif, this.pm, this.harness, this.execModel, this.parent, this.filterHandler, this.treeModel);
            this.msPanel = new MultiSelectPanel(this.uif, this.pm, this.treeModel);
            this.deck.add(this.testPanel);
            this.deck.add(this.brPanel);
            this.deck.add(this.msPanel);
            this.deckPanel = this.uif.createPanel("main", false);
            this.deckPanel.setLayout(new BorderLayout());
            this.deckPanel.add((Component)this.deck, "Center");
            this.titleField = this.uif.createOutputField("treep.title");
            this.titleField.setBorder(null);
            this.titleField.setText(this.uif.getI18NString("treep.title.noSelection.txt"));
            this.titleField.setBackground(MetalLookAndFeel.getMenuBackground());
            this.titleField.setForeground(new Color(102, 102, 102));
            FontUIResource f = MetalLookAndFeel.getSystemTextFont();
            this.titleField.setFont(new Font("Ariel", 1, f.getSize()));
            this.titleField.setEnabled(true);
            this.titleField.setEditable(false);
            this.deckPanel.add((Component)this.titleField, "North");
            splitPane.setRightComponent(this.deckPanel);
            this.testPanel.setVisible(false);
            this.brPanel.setVisible(false);
            this.deck.setVisible(true);
            this.deckPanel.setVisible(true);
            splitPane.setDividerLocation(0.3);
            splitPane.setResizeWeight(0.3);
            if (this.tree.getSelectionPath() == null) {
                TreeModel tm = this.tree.getModel();
                try {
                    TestResultTable.TreeNode root = (TestResultTable.TreeNode)tm.getRoot();
                    this.tree.setRootVisible(true);
                    EventQueue.invokeLater(new Selector(root, new TreePath(root)));
                }
                catch (ClassCastException e) {
                    if (!debug) break block15;
                    e.printStackTrace(Debug.getWriter());
                }
            }
        }
        this.popup = this.uif.createPopupMenu("treep.popup.mnu");
        this.runMI = this.uif.createMenuItem("treep.popup", "run", this.listener);
        this.popup.add(this.runMI);
        this.popup.addSeparator();
        this.refreshMI = this.uif.createMenuItem("treep.popup", "refresh", this.listener);
        this.popup.add(this.refreshMI);
        this.purgeMI = this.uif.createMenuItem("treep.popup", "clear", this.listener);
        this.popup.add(this.purgeMI);
        ContextManager cm = this.execModel.getContextManager();
        if (cm != null && (cms = cm.getContextMenus()) != null) {
            this.popup.addSeparator();
            for (int i = 0; i < cms.length; ++i) {
                switch (cms[i].getMenuApplication()) {
                    case 0: {
                        if (this.mixedMenus == null) {
                            this.mixedMenus = new ArrayList();
                        }
                        this.mixedMenus.add(cms[i]);
                        break;
                    }
                    case 1: {
                        if (this.testMenus == null) {
                            this.testMenus = new ArrayList();
                        }
                        this.testMenus.add(cms[i]);
                        break;
                    }
                    case 2: {
                        if (this.folderMenus == null) {
                            this.folderMenus = new ArrayList();
                        }
                        this.folderMenus.add(cms[i]);
                        break;
                    }
                    case 99: {
                        if (this.customMenus == null) {
                            this.customMenus = new ArrayList();
                        }
                        this.customMenus.add(cms[i]);
                        break;
                    }
                }
                this.popup.add(cms[i].getMenu());
            }
        }
        this.runMI.setEnabled(false);
        this.refreshMI.setEnabled(false);
        this.purgeMI.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    private void updatePopupMenu() {
        block39: {
            JavaTestContextMenu m;
            int i;
            TreePath[] paths;
            block37: {
                int i2;
                block40: {
                    int i3;
                    Object item;
                    block38: {
                        int i4;
                        paths = this.tree.getSelectionPaths();
                        if (paths == null || paths.length == 0) {
                            return;
                        }
                        if (paths.length != 1) break block37;
                        item = paths[0];
                        if (item instanceof TreePath) {
                            item = ((TreePath)item).getLastPathComponent();
                        }
                        if (!(item instanceof TestResult)) break block38;
                        if (this.testMenus != null) {
                            for (i4 = 0; i4 < this.testMenus.size(); ++i4) {
                                ((JavaTestContextMenu)this.testMenus.get(i4)).getMenu().setEnabled(true);
                                ((JavaTestContextMenu)this.testMenus.get(i4)).updateState((TestResult)item);
                            }
                        }
                        if (this.customMenus != null) {
                            for (i4 = 0; i4 < this.customMenus.size(); ++i4) {
                                ((JavaTestContextMenu)this.customMenus.get(i4)).updateState((TestResult)item);
                            }
                        }
                        if (this.mixedMenus != null) {
                            for (i4 = 0; i4 < this.mixedMenus.size(); ++i4) {
                                ((JavaTestContextMenu)this.mixedMenus.get(i4)).getMenu().setEnabled(true);
                                ((JavaTestContextMenu)this.mixedMenus.get(i4)).updateState((TestResult)item);
                            }
                        }
                        if (this.folderMenus == null) break block39;
                        for (i4 = 0; i4 < this.folderMenus.size(); ++i4) {
                            ((JavaTestContextMenu)this.folderMenus.get(i4)).getMenu().setEnabled(false);
                        }
                        break block39;
                    }
                    if (!(item instanceof TestResultTable.TreeNode)) break block40;
                    TestResultTable.TreeNode tn = (TestResultTable.TreeNode)item;
                    String url = TestResultTable.getRootRelativePath(tn);
                    if (this.testMenus != null) {
                        for (i3 = 0; i3 < this.testMenus.size(); ++i3) {
                            ((JavaTestContextMenu)this.testMenus.get(i3)).getMenu().setEnabled(false);
                        }
                    }
                    if (this.customMenus != null) {
                        for (i3 = 0; i3 < this.customMenus.size(); ++i3) {
                            ((JavaTestContextMenu)this.customMenus.get(i3)).updateState(url);
                        }
                    }
                    if (this.mixedMenus != null) {
                        for (i3 = 0; i3 < this.mixedMenus.size(); ++i3) {
                            ((JavaTestContextMenu)this.mixedMenus.get(i3)).getMenu().setEnabled(true);
                            ((JavaTestContextMenu)this.mixedMenus.get(i3)).updateState(url);
                        }
                    }
                    if (this.folderMenus == null) break block39;
                    for (i3 = 0; i3 < this.folderMenus.size(); ++i3) {
                        ((JavaTestContextMenu)this.folderMenus.get(i3)).getMenu().setEnabled(true);
                        ((JavaTestContextMenu)this.folderMenus.get(i3)).updateState(url);
                    }
                    break block39;
                }
                if (this.testMenus != null) {
                    for (i2 = 0; i2 < this.testMenus.size(); ++i2) {
                        ((JavaTestContextMenu)this.testMenus.get(i2)).getMenu().setEnabled(false);
                    }
                }
                if (this.customMenus != null) {
                    for (i2 = 0; i2 < this.customMenus.size(); ++i2) {
                        ((JavaTestContextMenu)this.customMenus.get(i2)).getMenu().setEnabled(false);
                    }
                }
                if (this.mixedMenus != null) {
                    for (i2 = 0; i2 < this.mixedMenus.size(); ++i2) {
                        ((JavaTestContextMenu)this.mixedMenus.get(i2)).getMenu().setEnabled(false);
                    }
                }
                if (this.folderMenus != null) {
                    for (i2 = 0; i2 < this.folderMenus.size(); ++i2) {
                        ((JavaTestContextMenu)this.folderMenus.get(i2)).getMenu().setEnabled(false);
                    }
                }
                throw new JavaTestError("Unknown node type from JTree!");
            }
            ArrayList<Object> tests = new ArrayList<Object>();
            ArrayList<String> folders = new ArrayList<String>();
            for (int i5 = 0; i5 < paths.length; ++i5) {
                Object item = paths[i5];
                if (item instanceof TreePath) {
                    item = ((TreePath)item).getLastPathComponent();
                }
                if (item instanceof TestResult) {
                    tests.add(item);
                    continue;
                }
                folders.add(TestResultTable.getRootRelativePath((TestResultTable.TreeNode)item));
            }
            TestResult[] t = null;
            if (tests.size() > 0) {
                tests.toArray(new TestResult[tests.size()]);
            }
            String[] f = null;
            if (folders.size() > 0) {
                folders.toArray(new String[folders.size()]);
            }
            if (this.testMenus != null) {
                for (i = 0; i < this.testMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.testMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
            if (this.customMenus != null) {
                for (i = 0; i < this.customMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.customMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
            if (this.mixedMenus != null) {
                for (i = 0; i < this.mixedMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.mixedMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
            if (this.folderMenus != null) {
                for (i = 0; i < this.folderMenus.size(); ++i) {
                    m = (JavaTestContextMenu)this.folderMenus.get(i);
                    m.getMenu().setEnabled(m.isMultiSelectAllowed());
                    m.updateState(f, t);
                }
            }
        }
    }

    private void selectTest(TestResult tr, TreePath path) {
        if (debug) {
            Debug.println("TTP showing: " + tr);
            Debug.println("   -> path provided is " + path.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectTest() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a leaf. No action.");
            }
            return;
        }
        this.brPanel.setVisible(false);
        this.deck.show(this.testPanel);
        if (!this.tree.isPathSelected(path)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(path);
        }
        if (!this.tree.isVisible(path)) {
            this.tree.scrollPathToVisible(path);
        }
        if (tr != this.testPanel.getTest()) {
            this.testPanel.setTest(tr);
            this.activeTest = tr.getTestName();
        }
        this.titleField.setText(this.uif.getI18NString("treep.test", tr.getTestName()));
        this.testPanel.setVisible(true);
        this.tree.repaint();
        this.deckPanel.repaint();
    }

    private void selectBranch(TestResultTable.TreeNode tn, TreePath path) {
        if (debug) {
            Debug.println("TTP showing: " + tn.getName());
            Debug.println("   -> " + tn);
            Debug.println("   -> path provided is " + path.getPathCount() + " components long.");
        }
        if (this.disposed) {
            if (debug) {
                Debug.println("TTP - selectBranch() not running, panel is disposed.");
            }
            return;
        }
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display a branch. No action.");
            }
            return;
        }
        if (this.deck.getCurrentCard() != this.brPanel) {
            this.deck.show(this.brPanel);
            this.testPanel.setVisible(false);
            this.activeTest = null;
        }
        if (!this.tree.isPathSelected(path)) {
            this.tree.clearSelection();
            this.tree.setSelectionPath(path);
        }
        if (!this.tree.isVisible(path)) {
            this.tree.scrollPathToVisible(path);
        }
        if (tn != this.brPanel.getNode()) {
            this.brPanel.setNode(tn);
            this.treeModel.setActiveNode(tn);
        }
        if (tn.isRoot()) {
            TestSuite ts = this.params.getTestSuite();
            String tsn = ts.getName();
            if (tsn != null) {
                this.titleField.setText(this.uif.getI18NString("treep.ts", tsn));
            } else {
                this.titleField.setText(this.uif.getI18NString("treep.ts", ts.getPath()));
            }
        } else {
            String nName = TestResultTable.getRootRelativePath(tn);
            this.titleField.setText(this.uif.getI18NString("treep.node", nName));
        }
        if (!this.brPanel.isVisible()) {
            this.brPanel.setVisible(true);
        }
        this.deckPanel.repaint();
        this.tree.repaint();
    }

    private void selectNodes(String[] paths) {
    }

    private void selectNodes(TreePath[] paths) {
        if (!this.isPopulated()) {
            if (debug) {
                Debug.println("TTP - no data, cannot display selections. No action.");
            }
            return;
        }
        Object[] leaves = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            leaves[i] = paths[i].getLastPathComponent();
        }
        this.msPanel.setNodes(leaves);
        if (this.deck.getCurrentCard() != this.msPanel) {
            this.deck.show(this.msPanel);
            this.activeTest = null;
        }
        this.titleField.setText(this.uif.getI18NString("treep.ms"));
        this.msPanel.setVisible(true);
        this.deckPanel.repaint();
    }

    private int showConfirmListDialog(String prefix, Object[] args, ListModel model) {
        JPanel p = this.uif.createPanel("ttp.confirmPanel", false);
        JTextArea msg = this.uif.createMessageArea(prefix, args);
        p.setLayout(new BorderLayout());
        p.add((Component)msg, "North");
        JList list = this.uif.createList("treep.nodeList", model);
        p.add((Component)this.uif.createScrollPane(list, 20, 30), "Center");
        return this.uif.showCustomYesNoDialog(prefix, p);
    }

    private boolean isPopulated() {
        return this.params != null && this.params.getTestSuite() != null;
    }

    private class PanelModel
    implements TreePanelModel,
    Harness.Observer,
    TestResultTable.Observer {
        private Hashtable runningTests;
        private Hashtable activeNodes;
        private Integer ONE = new Integer(1);

        PanelModel() {
            this.runningTests = new Hashtable();
            this.activeNodes = new Hashtable();
        }

        public void pauseWork() {
            TestTreePanel.this.treeModel.pauseWork();
        }

        public void unpauseWork() {
            TestTreePanel.this.treeModel.unpauseWork();
        }

        public void nodeSelected(Object node, TreePath path) {
        }

        public void testSelected(TestResult node, TreePath path) {
        }

        public void nodeUnSelected(Object node, TreePath path) {
        }

        public void testUnSelected(TestResult node, TreePath path) {
        }

        public void showNode(Object node, TreePath path) {
            TestTreePanel.this.selectBranch((TestResultTable.TreeNode)node, path);
        }

        public void showNode(String url) {
            TestResultTable trt = this.getTestResultTable();
            if (trt == null) {
                return;
            }
            TestResultTable.TreeNode node = TestResultTable.findNode(trt.getRoot(), url);
            if (node != null) {
                TestTreePanel.this.selectBranch(node, new TreePath(TestResultTable.getObjectPath(node)));
            }
        }

        public void showTest(TestResult node, TreePath path) {
            TestTreePanel.this.selectTest(node, path);
        }

        public void showTest(TestResult tr) {
            TestResultTable.TreeNode[] path = TestResultTable.getObjectPath(tr);
            Object[] fp = new Object[path.length + 1];
            System.arraycopy(path, 0, fp, 0, path.length);
            fp[fp.length - 1] = tr;
            this.showTest(tr, new TreePath(fp));
        }

        public void showTest(String url) {
            TestResultTable trt = this.getTestResultTable();
            if (trt == null) {
                return;
            }
            TestResult tr = trt.lookup(TestResult.getWorkRelativePath(url));
            if (tr != null) {
                this.showTest(tr);
            }
        }

        public void hideNode(Object node, TreePath path) {
        }

        public void hideTest(TestResult node, TreePath path) {
        }

        public TestResultTable getTestResultTable() {
            return TestTreePanel.this.treeModel.getTestResultTable();
        }

        public String getSelectedTest() {
            return TestTreePanel.this.activeTest;
        }

        public boolean isActive(TestResult tr) {
            return this.runningTests.containsKey(tr.getTestName());
        }

        public boolean isActive(TestResultTable.TreeNode node) {
            return this.activeNodes.containsKey(node);
        }

        public void startingTestRun(Parameters params) {
            TestTreePanel.this.runMI.setEnabled(false);
            TestTreePanel.this.purgeMI.setEnabled(false);
            TestTreePanel.this.refreshMI.setEnabled(false);
        }

        public void startingTest(TestResult tr) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.put(tr.getTestName(), tr);
            TestResult lookupTr = TestTreePanel.this.treeModel.getTestResultTable().lookup(tr.getWorkRelativePath());
            TestResultTable.TreeNode[] nodes = TestResultTable.getObjectPath(lookupTr);
            for (int i = 0; i < nodes.length; ++i) {
                Object hit = this.activeNodes.get(nodes[i]);
                if (hit == null) {
                    this.activeNodes.put(nodes[i], this.ONE);
                    continue;
                }
                this.activeNodes.put(nodes[i], new Integer(1 + (Integer)hit));
            }
            TestTreePanel.this.tree.repaint();
        }

        public void finishedTest(TestResult tr) {
            if (TestTreePanel.this.treeModel == null) {
                return;
            }
            this.runningTests.remove(tr.getTestName());
            TestResult lookupTr = TestTreePanel.this.treeModel.getTestResultTable().lookup(tr.getWorkRelativePath());
            TestResultTable.TreeNode[] nodes = TestResultTable.getObjectPath(lookupTr);
            if (tr.getTestName().equals(TestTreePanel.this.activeTest)) {
                Object[] p = new Object[nodes.length + 1];
                System.arraycopy(nodes, 0, p, 0, nodes.length);
                p[p.length - 1] = tr;
                EventQueue.invokeLater(new Selector(tr, new TreePath(p)));
            }
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    Integer n;
                    Object hit = this.activeNodes.get(nodes[i]);
                    if (hit == null) continue;
                    if (hit == this.ONE) {
                        this.activeNodes.remove(nodes[i]);
                        continue;
                    }
                    int currHits = (Integer)hit;
                    TestResultTable.TreeNode treeNode = nodes[i];
                    if (currHits == 2) {
                        n = this.ONE;
                    } else {
                        Integer n2 = new Integer(--currHits);
                        n = n2;
                    }
                    this.activeNodes.put(treeNode, n);
                }
            }
            TestTreePanel.this.tree.repaint();
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean allOK) {
            this.runningTests.clear();
            this.activeNodes.clear();
            TestTreePanel.this.runMI.setEnabled(true);
            TestTreePanel.this.purgeMI.setEnabled(true);
            TestTreePanel.this.refreshMI.setEnabled(true);
            TestTreePanel.this.tree.repaint();
        }

        public void error(String msg) {
        }

        public void update(TestResult oldValue, TestResult newValue) {
            if (TestTreePanel.this.treeModel == null || TestTreePanel.this.treeModel.getTestResultTable() == null) {
                return;
            }
            if (newValue.getTestName().equals(TestTreePanel.this.activeTest)) {
                TestResult lookupTr = TestTreePanel.this.treeModel.getTestResultTable().lookup(newValue.getWorkRelativePath());
                TestResultTable.TreeNode[] nodes = TestResultTable.getObjectPath(lookupTr);
                Object[] p = new Object[nodes.length + 1];
                System.arraycopy(nodes, 0, p, 0, nodes.length);
                p[p.length - 1] = newValue;
                EventQueue.invokeLater(new Selector(newValue, new TreePath(p)));
            }
        }

        public void updated(TestResult whichTR) {
        }
    }

    private class TreePopupAction
    extends AbstractAction {
        private String name;
        private String desc;

        TreePopupAction(I18NResourceBundle bund, String key) {
            this.desc = bund.getString(key + ".desc");
            this.name = bund.getString(key + ".act");
        }

        public void actionPerformed(ActionEvent e) {
            if (TestTreePanel.this.disposed) {
                return;
            }
            TestTreePanel.this.lastPopupPath = TestTreePanel.this.tree.getSelectionPath();
            Rectangle loc = TestTreePanel.this.tree.getPathBounds(TestTreePanel.this.lastPopupPath);
            if (loc == null) {
                return;
            }
            TestTreePanel.this.updatePopupMenu();
            TestTreePanel.this.popup.show(TestTreePanel.this.tree, loc.x + (int)loc.getWidth(), loc.y + (int)loc.getHeight());
        }

        public Object getValue(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (key.equals("Name")) {
                return this.name;
            }
            if (key.equals("ShortDescription")) {
                return this.desc;
            }
            return null;
        }
    }

    class Selector
    implements Runnable {
        private TreePath tp;
        private TestResult tr;
        private TestResultTable.TreeNode tn;

        Selector(TestResult tr, TreePath path) {
            this.tr = tr;
            this.tp = path;
        }

        Selector(TestResultTable.TreeNode tn, TreePath path) {
            this.tn = tn;
            this.tp = path;
        }

        public void run() {
            if (this.tr != null) {
                TestTreePanel.this.selectTest(this.tr, this.tp);
            } else {
                TestTreePanel.this.selectBranch(this.tn, this.tp);
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    TreeSelectionListener,
    TreeExpansionListener {
        private int lastX;
        private int lastY;

        private Listener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (e.getSource() == TestTreePanel.this.tree) {
                TreePath[] tp = e.getPaths();
                TestTree source = (TestTree)e.getSource();
                this.dispatchSelection(source);
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            TestResult[] trs;
            if (TestTreePanel.this.disposed) {
                return;
            }
            TreePath tp = event.getPath();
            TestResultTable.TreeNode tn = (TestResultTable.TreeNode)tp.getLastPathComponent();
            TestResultTable.TreeNode[] childs = tn.getTreeNodes();
            if (childs != null) {
                for (int i = 0; i < childs.length; ++i) {
                    TestTreePanel.this.treeModel.removeRelevantNode(childs[i]);
                }
            }
            if ((trs = tn.getTestResults()) != null) {
                for (int i = 0; i < trs.length; ++i) {
                    TestTreePanel.this.treeModel.removeRelevantTest(trs[i]);
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            TestResult[] trs;
            if (TestTreePanel.this.disposed) {
                return;
            }
            TreePath tp = event.getPath();
            TestResultTable.TreeNode tn = (TestResultTable.TreeNode)tp.getLastPathComponent();
            TestResultTable.TreeNode[] childs = tn.getTreeNodes();
            if (childs != null) {
                for (int i = 0; i < childs.length; ++i) {
                    TestTreePanel.this.treeModel.addRelevantNode(childs[i]);
                }
            }
            if ((trs = tn.getTestResults()) != null) {
                for (int i = 0; i < trs.length; ++i) {
                    TestTreePanel.this.treeModel.addRelevantTest(trs[i]);
                }
            }
        }

        private void dispatchSelection(TestTree source) {
            TreePath[] paths = source.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                return;
            }
            if (paths.length == 1) {
                Object target = paths[0].getLastPathComponent();
                if (target instanceof TestResult) {
                    TestTreePanel.this.selectTest((TestResult)target, paths[0]);
                } else if (target instanceof TestResultTable.TreeNode) {
                    TestTreePanel.this.selectBranch((TestResultTable.TreeNode)target, paths[0]);
                } else if (debug) {
                    Debug.println("Unknown node click target in TestTreePanel: ");
                    Debug.println("   => " + target);
                }
            } else {
                TestTreePanel.this.selectNodes(paths);
            }
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && e.getComponent() == TestTreePanel.this.tree) {
                this.lastX = e.getX();
                this.lastY = e.getY();
                TestTreePanel.this.updatePopupMenu();
                TestTreePanel.this.popup.show(e.getComponent(), this.lastX, this.lastY);
            }
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = TestTreePanel.this.tree.getSelectionPaths();
            if (e.getActionCommand().equals("clear")) {
                if (paths != null && paths.length > 0) {
                    TestTreePanel.this.clearNodes(TestTreePanel.this.tree.getSelectionPaths());
                }
            } else if (e.getActionCommand().equals("run")) {
                if (paths != null && paths.length > 0) {
                    for (int i = 0; i < paths.length; ++i) {
                        Object target;
                        if (paths[i].getPathCount() > 1 || !((target = paths[i].getPathComponent(0)) instanceof TestResultTable.TreeNode) || !((TestResultTable.TreeNode)target).isRoot()) continue;
                        paths = new TreePath[]{new TreePath(target)};
                        break;
                    }
                    TestTreePanel.this.runNodes(paths);
                }
            } else if (e.getActionCommand().equals("refresh") && paths != null && paths.length > 0) {
                TestTreePanel.this.refreshNodes(TestTreePanel.this.tree.getSelectionPaths());
            }
        }
    }
}

