/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.JavaTestToolBar;
import com.sun.javatest.exec.ToolBarPanel;
import com.sun.javatest.tool.UIFactory;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ToolBarManager {
    private UIFactory uif;
    private JMenu toolBarMenu;
    private TBMenuManager mmanager = new TBMenuManager();
    private Map store = Collections.synchronizedMap(new LinkedHashMap());
    private Map restoredSettings = new HashMap();
    private ToolBarPanel panel;

    public boolean addToolBar(final JavaTestToolBar theBar, String toolBarID) {
        if (!this.store.containsKey(toolBarID)) {
            this.store.put(toolBarID, theBar);
            theBar.load(this.restoredSettings);
            if (this.panel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ToolBarManager.this.panel.add(theBar);
                        ToolBarManager.this.mmanager.addToolbar(theBar);
                    }
                });
            }
            return true;
        }
        return false;
    }

    public JavaTestToolBar getToolBar(String toolBarID) {
        return (JavaTestToolBar)this.store.get(toolBarID);
    }

    public JavaTestToolBar[] getToolBars() {
        JavaTestToolBar[] ret = new JavaTestToolBar[]{};
        ret = this.store.values().toArray(ret);
        return ret;
    }

    boolean removeToolBar(String toolBarID) {
        if (this.store.containsKey(toolBarID)) {
            final JavaTestToolBar tb = (JavaTestToolBar)this.store.get(toolBarID);
            if (this.panel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ToolBarManager.this.panel.remove(tb);
                        ToolBarManager.this.mmanager.removeToolbar(tb);
                    }
                });
            } else {
                this.mmanager.removeToolbar(tb);
            }
            this.store.remove(toolBarID);
            return true;
        }
        return false;
    }

    JMenu getToolbarMenu() {
        if (this.toolBarMenu == null) {
            this.toolBarMenu = this.uif.createMenu("tbmanager.viewmenu");
            this.toolBarMenu.setVisible(false);
        }
        return this.toolBarMenu;
    }

    void save(Map m) {
        for (Object o : this.restoredSettings.keySet()) {
            if (!(o instanceof String) || !((String)o).startsWith("JavaTestToolBar.toolbar_")) continue;
            m.put(o, this.restoredSettings.get(o));
        }
    }

    void load(Map m) {
        m.putAll(this.restoredSettings);
    }

    void setUIFactory(UIFactory u) {
        this.uif = u;
    }

    void setPanel(ToolBarPanel p) {
        if (p == null) {
            throw new NullPointerException();
        }
        this.panel = p;
        if (this.store.size() > 0) {
            JavaTestToolBar[] tbs = this.getToolBars();
            for (int i = 0; i < tbs.length; ++i) {
                this.panel.add(tbs[i]);
                this.mmanager.addToolbar(tbs[i]);
            }
        }
    }

    class TBMenuManager {
        TBMenuManager() {
        }

        public void addToolbar(JavaTestToolBar t) {
            t.setVisible(t.readVisiblePrefs());
            if (t.isMenuControlled()) {
                JMenu m = ToolBarManager.this.getToolbarMenu();
                ToolbarMenuAction ac = new ToolbarMenuAction(t);
                JCheckBoxMenuItem mi = new JCheckBoxMenuItem(ac);
                mi.setState(t.isVisible());
                ((Container)m).add(mi);
                ToolBarManager.this.toolBarMenu.setVisible(true);
            }
        }

        public void removeToolbar(JavaTestToolBar t) {
            if (t.isMenuControlled()) {
                JMenu m = ToolBarManager.this.getToolbarMenu();
                for (int i = 0; i < m.getItemCount(); ++i) {
                    JMenuItem it = m.getItem(i);
                    Action act = it.getAction();
                    if (!(act instanceof ToolbarMenuAction) || ((ToolbarMenuAction)act).getBar() != t) continue;
                    m.remove(i);
                    break;
                }
                if (m.getItemCount() == 0) {
                    m.setVisible(false);
                }
            }
        }

        private class ToolbarMenuAction
        extends AbstractAction {
            private JavaTestToolBar theBar;

            public JToolBar getBar() {
                return this.theBar;
            }

            public ToolbarMenuAction(JavaTestToolBar bar) {
                super(bar.getName());
                this.theBar = bar;
            }

            public void actionPerformed(ActionEvent evt) {
                this.theBar.setVisible(!this.theBar.isVisible());
            }
        }
    }
}

