/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.logging;

import com.sun.javatest.util.I18NResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

class JTFormatter
extends Formatter {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JTFormatter.class);
    private int lastOffset;
    public static final String LOG_SIGNATURE = "=JTLOG=";

    JTFormatter() {
    }

    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        StringBuffer msgBuf = new StringBuffer(record.getMessage());
        if (record.getThrown() != null) {
            Throwable th = record.getThrown();
            String excMessage = i18n.getString("logger.exception.message");
            msgBuf.append('\n');
            msgBuf.append(excMessage).append(" ").append(record.getSourceClassName()).append(",").append(record.getSourceMethodName()).append("\n");
            msgBuf.append(th.toString());
            msgBuf.append('\n');
            StackTraceElement[] trace = th.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                msgBuf.append("  at ").append(trace[i]);
                if (i == trace.length - 1) continue;
                msgBuf.append('\n');
            }
        }
        String msg = msgBuf.toString();
        sb.append(record.getLoggerName());
        sb.append('\n');
        sb.append(record.getLevel().intValue());
        sb.append('\n');
        sb.append(record.getMillis());
        sb.append('\n');
        sb.append(msg.length());
        sb.append('\n');
        this.lastOffset = sb.length();
        sb.append(msg);
        sb.append('\n');
        return sb.toString();
    }

    public String getHead(Handler h) {
        return "=JTLOG=\n";
    }

    void setErasing() {
    }

    public int getLastOffset() {
        return this.lastOffset;
    }
}

