/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.report.ConfigSection;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.ResultSection;
import com.sun.javatest.report.StatisticsSection;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

class HTMLReport
implements ReportFormat {
    File reportDir;
    private BackupPolicy backupPolicy;
    private I18NResourceBundle i18n;
    static final String REPORT_NAME = "report.html";
    static final String NEW_REPORT_NAME = "index.html";
    static final String[] anchors = new String[]{"selection", "execution", "locations", "keywordSummary"};
    static final int SELECT_ANCHOR = 0;
    static final int EXEC_ANCHOR = 1;
    static final int LOC_ANCHOR = 2;
    static final int KEYWORD_ANCHOR = 3;
    static final String[] files = new String[]{"report.html", "index.html", "config.html", "env.html", "excluded.html", "passed.html", "failed.html", "error.html", "notRun.html"};
    static final int REPORT_HTML = 0;
    static final int INDEX_HTML = 1;
    static final int CONFIG_HTML = 2;
    static final int ENV_HTML = 3;
    static final int EXCLUDED_HTML = 4;
    static final int PASSED_HTML = 5;
    static final int FAILED_HTML = 6;
    static final int ERROR_HTML = 7;
    static final int NOTRUN_HTML = 8;

    HTMLReport(I18NResourceBundle rb) {
        this.i18n = rb;
        HTMLSection.i18n = rb;
    }

    public void write(Report.Settings s, File dir) throws IOException {
        this.reportDir = dir;
        Vector<HTMLSection> mainSecs = new Vector<HTMLSection>(3);
        Vector<HTMLSection> auxSecs = new Vector<HTMLSection>(3);
        ConfigSection cs = new ConfigSection(this, s, dir);
        if (s.isConfigSectionEnabled()) {
            mainSecs.addElement(cs);
            auxSecs.addElement(cs);
        }
        ResultSection rs = null;
        if (s.isResultsEnabled()) {
            rs = new ResultSection(this, s, dir);
            mainSecs.addElement(rs);
        }
        if (s.isStateFileEnabled(0) || s.isStateFileEnabled(2) || s.isStateFileEnabled(3) || s.isStateFileEnabled(1)) {
            if (rs == null) {
                rs = new ResultSection(this, s, dir);
            }
            auxSecs.addElement(rs);
        }
        if (s.isKeywordSummaryEnabled()) {
            mainSecs.addElement(new StatisticsSection(this, s, dir));
            auxSecs.addElement(new StatisticsSection(this, s, dir));
        }
        Object[] mainSections = new HTMLSection[mainSecs.size()];
        mainSecs.copyInto(mainSections);
        Object[] auxSections = new HTMLSection[auxSecs.size()];
        auxSecs.copyInto(auxSections);
        Writer writer = null;
        if (s.reportHtml && s.indexHtml) {
            writer = new DuplexWriter(this.openWriter(this.reportDir, 0), this.openWriter(this.reportDir, 1));
        } else if (s.reportHtml) {
            writer = this.openWriter(this.reportDir, 0);
        } else if (s.indexHtml) {
            writer = this.openWriter(this.reportDir, 1);
        }
        ReportWriter.initializeDirectory(this.reportDir);
        if (writer != null) {
            int i;
            ReportWriter out = new ReportWriter(writer, this.i18n.getString("report.title"), this.i18n);
            String testSuiteName = s.ip.getTestSuite().getName();
            if (testSuiteName != null) {
                out.startTag("h2");
                out.writeI18N("report.testSuite", testSuiteName);
                out.endTag("h2");
            }
            out.startTag("ul");
            for (i = 0; i < mainSections.length; ++i) {
                out.startTag("li");
                ((HTMLSection)mainSections[i]).writeContents(out);
                out.endTag("li");
            }
            out.endTag("ul");
            for (i = 0; i < mainSections.length; ++i) {
                out.startTag("p");
                out.startTag("hr");
                ((HTMLSection)mainSections[i]).writeSummary(out);
                out.newLine();
            }
            out.close();
        }
        for (int i = 0; i < auxSections.length; ++i) {
            ((HTMLSection)auxSections[i]).writeExtraFiles();
        }
    }

    public static String[] getReportFilenames() {
        return new String[]{REPORT_NAME, NEW_REPORT_NAME};
    }

    public static String getFile(int code) {
        return files[code];
    }

    static String[] getFilenamesUsed() {
        return files;
    }

    File getReportDirectory() {
        return this.reportDir;
    }

    Writer openWriter(File reportDir, int code) throws IOException {
        return new BufferedWriter(new FileWriter(new File(reportDir, files[code])));
    }

    static class DuplexWriter
    extends Writer {
        private Writer[] targets;

        public DuplexWriter(Writer[] writers) {
            if (writers == null) {
                return;
            }
            this.targets = new Writer[writers.length];
            System.arraycopy(writers, 0, this.targets, 0, writers.length);
        }

        public DuplexWriter(Writer w1, Writer w2) {
            this.targets = new Writer[2];
            this.targets[0] = w1;
            this.targets[1] = w2;
        }

        public void close() throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].close();
            }
        }

        public void flush() throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].flush();
            }
        }

        public void write(char[] cbuf) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(cbuf);
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(cbuf, off, len);
            }
        }

        public void write(int c) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(c);
            }
        }

        public void write(String str) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(str);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(str, off, len);
            }
        }
    }
}

