/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class ChoiceQuestionRenderer
implements QuestionRenderer {
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    private JPanel btnPanel;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private HashMap layoutHistory = new HashMap();

    ChoiceQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        ChoiceQuestion q = (ChoiceQuestion)qq;
        return this.createChoiceTable(q, listener);
    }

    public String getInvalidValueMessage(Question q) {
        return null;
    }

    private JComponent createChoiceTable(final ChoiceQuestion q, final ActionListener editedListener) {
        final String[] displayChoices = q.getDisplayChoices();
        final String[] values = q.getChoices();
        final int starts_from = values[0] == null ? 1 : 0;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestTableModel
        extends AbstractTableModel {
            TestTableModel() {
            }

            public Class getColumnClass(int c) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return displayChoices.length - starts_from;
            }

            @Override
            public Object getValueAt(int r, int c) {
                return values[r + starts_from];
            }

            @Override
            public void setValueAt(Object o, int r, int c) {
                if (c == 0) {
                    q.setValue(values[r + starts_from]);
                    ChoiceQuestionRenderer.this.fireEditedEvent(this, editedListener);
                }
            }

            @Override
            public boolean isCellEditable(int r, int c) {
                return true;
            }
        }
        TestTableModel tm = new TestTableModel();
        final JTable tbl = new JTable(tm);
        final JRadioButton[] rb = new JRadioButton[displayChoices.length - starts_from];
        ButtonGroup bg = new ButtonGroup();
        String v = q.getValue();
        for (int i = 0; i < rb.length; ++i) {
            rb[i] = new JRadioButton(displayChoices[i + starts_from], values[i + starts_from] == v);
            rb[i].setActionCommand(values[i + starts_from]);
            rb[i].setName("chc.btn." + values[i + starts_from]);
            if (i < 10) {
                rb[i].setMnemonic(48 + i);
            }
            rb[i].setToolTipText(i18n.getString("chc.btn.tip"));
            rb[i].getAccessibleContext().setAccessibleName(rb[i].getName());
            rb[i].getAccessibleContext().setAccessibleDescription(rb[i].getToolTipText());
            rb[i].setBackground(tbl.getBackground());
            rb[i].setFocusPainted(false);
            bg.add(rb[i]);
            rb[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableCellEditor editor = tbl.getCellEditor();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                }
            });
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestTableRenderer
        implements TableCellRenderer {
            TestTableRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return rb[row];
            }
        }
        TestTableRenderer r = new TestTableRenderer();
        tbl.setPreferredScrollableViewportSize(new Dimension(DOTS_PER_INCH, DOTS_PER_INCH));
        tbl.setShowHorizontalLines(false);
        tbl.setShowVerticalLines(false);
        tbl.setTableHeader(null);
        tbl.setAutoResizeMode(0);
        tbl.setRowSelectionAllowed(false);
        tbl.setColumnSelectionAllowed(false);
        tbl.setToolTipText(i18n.getString("chcArr.tbl.tip"));
        TableColumn col0 = tbl.getColumnModel().getColumn(0);
        col0.setCellRenderer(r);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestTableEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            TestTableEditor() {
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                rb[row].setSelected(true);
                return rb[row];
            }
        }
        col0.setCellEditor(new TestTableEditor());
        col0.setPreferredWidth(this.getColumnWidth(tbl, 0) + 20);
        JScrollPane sp = new JScrollPane(tbl);
        sp.setName("chcArr.sp");
        sp.getViewport().setBackground(tbl.getBackground());
        JLabel lbl = new JLabel(i18n.getString("chcArr.tbl.lbl"));
        lbl.setName("chcArr.tbl.lbl");
        lbl.setDisplayedMnemonic(i18n.getString("chcArr.tbl.mne").charAt(0));
        lbl.setToolTipText(i18n.getString("chcArr.tbl.tip"));
        lbl.setLabelFor(sp);
        JPanel result = new JPanel(new BorderLayout());
        tbl.setRowHeight(22);
        result.add((Component)lbl, "North");
        result.add((Component)sp, "Center");
        return result;
    }

    private int getColumnWidth(JTable table, int colIndex) {
        int width = -1;
        TableModel model = table.getModel();
        int rowCount = model.getRowCount();
        TableColumn col = table.getColumnModel().getColumn(colIndex);
        for (int i = 0; i < rowCount; ++i) {
            TableCellRenderer r = table.getCellRenderer(i, colIndex);
            Component c = r.getTableCellRendererComponent(table, model.getValueAt(i, colIndex), false, false, i, colIndex);
            width = Math.max(width, c.getPreferredSize().width);
        }
        return width;
    }

    private void fireEditedEvent(Object src, ActionListener l) {
        ActionEvent e = new ActionEvent(src, 1001, "edited");
        l.actionPerformed(e);
    }
}

