/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.SocketConnection;
import java.io.IOException;
import java.net.ServerSocket;

public class PassiveConnectionFactory
implements ConnectionFactory {
    private ServerSocket serverSocket;

    public PassiveConnectionFactory(int port, int backlog) throws IOException {
        if (port < 0 || backlog < 0) {
            throw new IllegalArgumentException();
        }
        this.serverSocket = new ServerSocket(port, backlog);
    }

    public PassiveConnectionFactory(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public Connection nextConnection() throws ConnectionFactory.Fault {
        try {
            return new SocketConnection(this.serverSocket.accept());
        }
        catch (IOException e) {
            throw new ConnectionFactory.Fault(e, false);
        }
    }

    public void close() throws ConnectionFactory.Fault {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new ConnectionFactory.Fault(e, true);
        }
    }
}

