/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.util.XMLWriter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;

abstract class COFItem {
    BeanInfo bi = null;
    LinkedHashMap itemAttributes = this.getItemAttributes();
    LinkedHashMap itemElements = this.getItemElements();
    String itemTagName = this.getItemTagName();
    PropertyDescriptor[] pds = null;

    COFItem() {
    }

    private String[] getAttributeProperties() {
        return this.itemAttributes == null ? null : this.itemAttributes.keySet().toArray(new String[this.itemAttributes.size()]);
    }

    LinkedHashMap getItemAttributes() {
        return null;
    }

    LinkedHashMap getItemElements() {
        return null;
    }

    String getItemTagName() {
        return null;
    }

    Object getProperty(String name) {
        if (this.bi == null) {
            try {
                this.bi = Introspector.getBeanInfo(this.getClass());
                this.pds = this.bi.getPropertyDescriptors();
                Arrays.sort(this.pds, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        PropertyDescriptor pd1 = (PropertyDescriptor)o1;
                        PropertyDescriptor pd2 = (PropertyDescriptor)o2;
                        return pd1.getName().compareTo(pd2.getName());
                    }
                });
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        if (this.pds == null) {
            return null;
        }
        Object result = null;
        int propIndex = Arrays.binarySearch(this.pds, name, new Comparator(){

            public int compare(Object o1, Object o2) {
                PropertyDescriptor pd = (PropertyDescriptor)o1;
                String propName = (String)o2;
                return pd.getName().compareTo(propName);
            }
        });
        try {
            result = this.pds[propIndex].getReadMethod().invoke((Object)this, null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String[] getPropOrder() {
        return this.itemElements == null ? null : this.itemElements.keySet().toArray(new String[this.itemElements.size()]);
    }

    void write(XMLWriter out) throws IOException {
        int i;
        if (this.itemTagName == null) {
            return;
        }
        out.startTag(this.itemTagName);
        if (this.itemAttributes != null) {
            String[] attrOrder = this.getAttributeProperties();
            for (i = 0; i < attrOrder.length; ++i) {
                out.writeAttr(this.itemAttributes.get(attrOrder[i]).toString(), (String)this.getProperty(attrOrder[i]));
            }
        }
        if (this.itemElements != null) {
            String[] propOrder = this.getPropOrder();
            for (i = 0; i < propOrder.length; ++i) {
                Object propValue = this.getProperty(propOrder[i]);
                if (propValue instanceof COFItem) {
                    COFItem item = (COFItem)propValue;
                    item.write(out);
                    continue;
                }
                if (propValue instanceof Collection) {
                    this.writeCollection(out, propOrder[i]);
                    continue;
                }
                if (propValue == null) continue;
                out.startTag(this.itemElements.get(propOrder[i]).toString());
                this.write(out, propValue);
                out.endTag(this.itemElements.get(propOrder[i]).toString());
            }
        }
        out.endTag(this.itemTagName);
    }

    protected void write(XMLWriter out, Object o) throws IOException {
        if (o instanceof String) {
            out.write((String)o);
        } else if (o instanceof Date) {
            out.writeDate((Date)o);
        } else {
            out.write(o.toString());
        }
    }

    void writeCollection(XMLWriter out, String propName) throws IOException {
        Collection col = (Collection)this.getProperty(propName);
        for (Object value : col) {
            if (value instanceof COFItem) {
                ((COFItem)value).write(out);
                continue;
            }
            out.startTag(this.itemElements.get(propName).toString());
            this.write(out, value);
            out.endTag(this.itemElements.get(propName).toString());
        }
    }
}

