/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFStatus;
import com.sun.javatest.cof.COFTestAttribute;
import com.sun.javatest.cof.COFTestAttributes;
import com.sun.javatest.cof.COFTestCase;
import com.sun.javatest.cof.COFTestCases;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class COFTest
extends COFItem {
    private static final Date badDate = new Date(0L);
    private static final String[] cofStatus = new String[4];
    static long count = 0L;
    private static DateFormat[] dateFormats;
    protected static Pattern idPattern;
    static boolean noTestCases;
    protected static Pattern testCasePattern;
    static LinkedHashMap xmlAttributes;
    static LinkedHashMap xmlElements;
    static String xmlTagName;
    protected String analysis;
    protected List appuse;
    protected COFTestAttributes attributes;
    protected String description;
    protected Date endtime;
    protected String id;
    final long idNum = count++;
    protected String name;
    protected Date starttime;
    protected COFStatus status;
    protected COFTestCases testcases;
    private COFData cofData;

    COFTest(TestResult tr, COFData data) {
        this.cofData = data;
        this.initDateFormats();
        this.status = new COFStatus();
        this.status.setValue(cofStatus[tr.getStatus().getType()]);
        this.status.setActual(tr.getStatus().getReason());
        this.fillTestCases(tr);
        this.setName(tr.getTestName());
        this.setStarttime(this.parseDate(tr, "start"));
        this.setEndtime(this.parseDate(tr, "end"));
        this.attributes = new COFTestAttributes();
        this.attributes.getAttribute().add(new COFTestAttribute("logfile", tr.getWorkRelativePath()));
        String jo = this.cofData.get("jvmopt", null);
        if (jo != null) {
            this.attributes.getAttribute().add(new COFTestAttribute("javaopt", jo));
        }
    }

    protected void fillTestCases(TestResult tr) {
        if (noTestCases) {
            return;
        }
        this.testcases = new COFTestCases();
        int sCount = tr.getSectionCount();
        if (sCount == 0 && tr.getStatus().getType() != 3) {
            try {
                tr = new TestResult(new File(this.cofData.get("workdir") + File.separator + tr.getWorkRelativePath()));
                sCount = tr.getSectionCount();
            }
            catch (TestResult.ResultFileNotFoundFault e) {
                System.err.println(e.getMessage());
            }
            catch (TestResult.ReloadFault e) {
                System.err.println(tr.getFile());
            }
        }
        for (int i = 0; i < sCount; ++i) {
            try {
                String sectionOut = tr.getSection(i).getOutput("out1");
                if (sectionOut == null) continue;
                BufferedReader reader = new BufferedReader(new StringReader(sectionOut));
                String s = reader.readLine();
                while (s != null) {
                    Matcher m = testCasePattern.matcher(s);
                    if (m.matches()) {
                        COFTestCase tc = new COFTestCase();
                        COFStatus status = new COFStatus();
                        tc.setName(m.group(1));
                        status.setValue(cofStatus[Status.parse(m.group(2)).getType()]);
                        status.setActual(m.group(3));
                        tc.setStatus(status);
                        this.testcases.getTestcase().add(tc);
                    }
                    s = reader.readLine();
                }
                continue;
            }
            catch (TestResult.ReloadFault e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getAnalysis() {
        if (this.analysis == null) {
            return "accept";
        }
        return this.analysis;
    }

    public List getAppuse() {
        if (this.appuse == null) {
            this.appuse = new ArrayList();
        }
        return this.appuse;
    }

    public COFTestAttributes getAttributes() {
        return this.attributes;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getEndtime() {
        return this.endtime;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.name == null) {
            throw new IllegalStateException("Name was not set.");
        }
        Matcher m = idPattern.matcher(this.name);
        this.id = m.matches() ? m.group(1) + ":" + this.idNum : "test:" + this.idNum;
        return this.id;
    }

    LinkedHashMap getItemAttributes() {
        return xmlAttributes;
    }

    LinkedHashMap getItemElements() {
        return xmlElements;
    }

    String getItemTagName() {
        return xmlTagName;
    }

    public String getName() {
        return this.name;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public COFStatus getStatus() {
        return this.status;
    }

    public COFTestCases getTestcases() {
        return this.testcases;
    }

    private void initDateFormats() {
        Vector<DateFormat> v = new Vector<DateFormat>();
        v.addElement(DateFormat.getDateTimeInstance());
        v.addElement(new SimpleDateFormat("EEE, dd MMMM yyyy HH:mm:ss zzz"));
        v.addElement(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy"));
        v.addElement(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS"));
        String s = System.getProperty("javatest.date.format");
        if (s != null) {
            v.addElement(new SimpleDateFormat(s));
        }
        dateFormats = new DateFormat[v.size()];
        v.copyInto(dateFormats);
    }

    private Date parseDate(String s) {
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                Date d = dateFormats[i].parse(s);
                if (i > 0) {
                    DateFormat tmp = dateFormats[i];
                    System.arraycopy(dateFormats, 0, dateFormats, 1, i);
                    COFTest.dateFormats[0] = tmp;
                }
                return d;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return badDate;
    }

    private Date parseDate(TestResult tr, String key) {
        try {
            String s = tr.getProperty(key);
            if (s != null && s.length() > 0) {
                return this.parseDate(s);
            }
        }
        catch (TestResult.Fault e) {
            System.err.println(e);
        }
        return badDate;
    }

    public void setAnalysis(String value) {
        this.analysis = value;
    }

    public void setAttributes(COFTestAttributes value) {
        this.attributes = value;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setEndtime(Date value) {
        this.endtime = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setStarttime(Date value) {
        this.starttime = value;
    }

    public void setStatus(COFStatus value) {
        this.status = value;
    }

    public void setTestcases(COFTestCases value) {
        this.testcases = value;
    }

    static {
        idPattern = Pattern.compile(".*[^\\w\\.\\[\\]\\(\\)\\{\\},_\\-]([\\w\\.\\[\\]\\(\\)\\{\\},_\\-]+)");
        noTestCases = false;
        testCasePattern = Pattern.compile("^(\\S+): (Passed\\.|Failed\\.|Error\\.|Not\\ run\\.)(.*)");
        xmlElements = new LinkedHashMap();
        xmlAttributes = new LinkedHashMap();
        xmlElements.put("name", "name");
        xmlElements.put("appuse", "appuse");
        xmlElements.put("status", "status");
        xmlElements.put("testcases", "testcases");
        xmlElements.put("starttime", "starttime");
        xmlElements.put("endtime", "endtime");
        xmlElements.put("attributes", "attributes");
        xmlElements.put("description", "description");
        xmlAttributes.put("id", "id");
        xmlTagName = "test";
        COFTest.cofStatus[0] = "pass";
        COFTest.cofStatus[1] = "fail";
        COFTest.cofStatus[2] = "error";
        COFTest.cofStatus[3] = "did_not_run";
    }
}

