/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.CustomTestResultViewer;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.JavaTestContextMenu;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.ToolBarManager;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.Report;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import java.io.File;

public class ContextManager
implements InterviewParameters.TemplateManager,
Report.CustomReportManager {
    protected File configLoadPath;
    protected File configSavePath;
    protected boolean configLoadOutside = true;
    protected boolean configSaveOutside = true;
    protected File templateLoadPath;
    protected File templateSavePath;
    protected boolean templateLoadOutside = true;
    protected boolean templateSaveOutside = true;
    protected File wdPath;
    protected FeatureManager featureManager = new FeatureManager();
    private WorkDirectory workdir;
    private TestSuite testSuite;
    private InterviewParameters interview;
    private ExecTool parentTool;
    private volatile boolean pendingRefresh = false;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ContextManager.class);

    public JavaTestMenuManager getMenuManager() {
        return null;
    }

    public ToolBarManager getToolBarManager() {
        return new ToolBarManager();
    }

    public JavaTestContextMenu[] getContextMenus() {
        return null;
    }

    public CustomReport[] getCustomReports() {
        return null;
    }

    public CustomTestResultViewer[] getCustomResultViewers() {
        return null;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public WorkDirectory getWorkDirectory() {
        return this.workdir;
    }

    public InterviewParameters getInterview() {
        return this.interview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTests() {
        ContextManager contextManager = this;
        synchronized (contextManager) {
            if (this.pendingRefresh) {
                return;
            }
            this.pendingRefresh = true;
        }
        if (EventQueue.isDispatchThread()) {
            Runnable cmd = new Runnable(){

                public void run() {
                    ContextManager.this.refreshTestsImpl();
                }
            };
            Thread t = new Thread(cmd, "ContextMgr Refresh Defer");
            t.start();
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.refreshTestsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTestsImpl() {
        TestResultTable trt;
        ContextManager contextManager = this;
        synchronized (contextManager) {
            this.pendingRefresh = false;
        }
        if (this.parentTool != null && (trt = this.parentTool.getActiveTestResultTable()) != null) {
            try {
                this.parentTool.pauseTreeCacheWork();
                ((TRT_TreeNode)trt.getRoot()).refreshIfNeeded();
            }
            finally {
                this.parentTool.unpauseTreeCacheWork();
            }
        }
    }

    public void syncInterview() {
        this.parentTool.syncInterview();
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public void setFeatureManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public boolean canSaveTemplate(File file) {
        return true;
    }

    public void setDefaultWorkDirPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.wdPath = dir;
    }

    public File getDefaultWorkDirPath() {
        return this.wdPath;
    }

    public void setDefaultTemplateLoadPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.templateLoadPath = dir;
    }

    public File getDefaultTemplateLoadPath() {
        return this.templateLoadPath;
    }

    public void setDefaultTemplateSavePath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.templateSavePath = dir;
    }

    public File getDefaultTemplateSavePath() {
        return this.templateSavePath;
    }

    public void setAllowTemplateLoadOutsideDefault(boolean state) {
        this.templateLoadOutside = state;
    }

    public boolean getAllowTemplateLoadOutsideDefault() {
        return this.templateLoadOutside;
    }

    public void setAllowTemplateSaveOutsideDefault(boolean state) {
        this.templateSaveOutside = state;
    }

    public boolean getAllowTemplateSaveOutsideDefault() {
        return this.templateSaveOutside;
    }

    public void setDefaultConfigLoadPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.configLoadPath = dir;
    }

    public File getDefaultConfigLoadPath() {
        return this.configLoadPath;
    }

    public void setDefaultConfigSavePath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.configSavePath = dir;
    }

    public File getDefaultConfigSavePath() {
        return this.configSavePath;
    }

    public void setAllowConfigLoadOutsideDefault(boolean state) {
        this.configLoadOutside = state;
    }

    public boolean getAllowConfigLoadOutsideDefault() {
        return this.configLoadOutside;
    }

    public void setAllowConfigSaveOutsideDefault(boolean state) {
        this.configSaveOutside = state;
    }

    public boolean getAllowConfigSaveOutsideDefault() {
        return this.configSaveOutside;
    }

    public void loadConfiguration(File file) {
        this.parentTool.loadInterview(file);
    }

    protected void setWorkDir(WorkDirectory w) {
        this.setWorkDirectory(w);
    }

    protected void setWorkDirectory(WorkDirectory w) {
        this.workdir = w;
    }

    protected void setTestSuite(TestSuite ts) {
        this.testSuite = ts;
    }

    void setInterview(InterviewParameters i) {
        this.interview = i;
    }

    void setTool(ExecTool t) {
        this.parentTool = t;
    }

    public static abstract class TestManagerDialog
    extends ToolDialog {
        public TestManagerDialog(ContextManager context, UIFactory uif, String key) {
            super(context.parentTool, uif, key);
        }
    }
}

