/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.logging.LogModel;
import com.sun.javatest.logging.LoggerFactory;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.XMLReportMaker;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.BackupPolicy;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.Timer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class LogViewerTools
extends Thread {
    private JDialog waitDialog;
    private TransformerHandler ser;
    private LogModel model;
    private File out;
    private Logger log;
    private Component parent;
    private UIFactory uif;
    private String XML_CHARSET = "UTF-8";
    private static final int WAIT_DIALOG_DELAY = 3000;

    LogViewerTools(LogModel model, File out, Logger log, Component parent, UIFactory uif) {
        this.model = model;
        this.out = out;
        this.log = log;
        this.parent = parent;
        this.uif = uif;
    }

    void go() {
        this.waitDialog = this.uif.createWaitDialog("lvt.wait", this.parent);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LogViewerTools.this.isAlive()) {
                    LogViewerTools.this.waitDialog.show();
                }
            }
        };
        Timer timer = new Timer(3000, al);
        timer.setRepeats(false);
        timer.start();
        this.start();
    }

    public void run() {
        Properties outputProps = new Properties();
        outputProps.put("indent", "yes");
        outputProps.put("encoding", this.XML_CHARSET);
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        stf.setAttribute("indent-number", 4);
        try {
            this.ser = stf.newTransformerHandler();
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
            return;
        }
        this.ser.getTransformer().setOutputProperties(outputProps);
        AttributesImpl emptyAttr = new AttributesImpl();
        try {
            Report.Settings settings = Report.getSettingsPrefs();
            BackupPolicy backupPolicy = settings.isBackupsEnabled() ? BackupPolicy.simpleBackups(settings.getBackupLevel()) : BackupPolicy.noBackups();
            Writer w = backupPolicy.backupAndOpenWriter(this.out, this.XML_CHARSET);
            this.ser.setResult(new StreamResult(w));
            this.ser.startDocument();
            this.ser.startElement("", "", "report", emptyAttr);
            for (int i = 0; i < this.model.getRecords().size(); ++i) {
                LogModel.LiteLogRecord llr = this.model.getRecords().get(i);
                this.outRecord(llr);
            }
            this.ser.endElement("", "", "report");
            this.ser.endDocument();
            w.close();
            this.waitDialog.hide();
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "LogViewer report", ex);
        }
        catch (SAXException ex) {
            this.log.log(Level.SEVERE, "LogViewer report", ex);
        }
    }

    private void outRecord(LogModel.LiteLogRecord llr) throws SAXException, IOException {
        String msg = this.model.getRecordMessage(llr);
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "Logger", "String", this.model.getLogname(llr.loggerID));
        atts.addAttribute("", "", "Level", "String", "" + llr.severety);
        atts.addAttribute("", "", "LevelName", "String", LoggerFactory.getLocalizedLevelName(Level.parse("" + llr.severety)));
        atts.addAttribute("", "", "Time", "String", this.dateToISO8601(llr.time));
        this.ser.startElement("", "", "logrecord", atts);
        XMLReportMaker.writeCDATA(this.ser, this.ser, msg);
        this.ser.endElement("", "", "logrecord");
    }

    private String dateToISO8601(long time) {
        SimpleDateFormat dfISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String dateStr = dfISO8601.format(new Date(time));
        return dateStr.substring(0, 22) + ":" + dateStr.substring(22);
    }
}

