/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ConfigHandler;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ElapsedTimeMonitor;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.MessageStrip;
import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.exec.ProgressMonitor;
import com.sun.javatest.exec.RunProgressMonitor;
import com.sun.javatest.exec.TestTreePanel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class RunTestsHandler {
    private JComponent parent;
    private ExecModel model;
    private ConfigHandler configHandler;
    private UIFactory uif;
    private TreePanelModel tpm;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters interviewParams;
    private Action showProgressAction;
    private Action startAction;
    private Action stopAction;
    private Harness harness;
    private HarnessObserver observer;
    private MonitorState mState;
    private MessageStrip messageStrip;
    private ProgressMonitor progMonitor;

    RunTestsHandler(JComponent parent, ExecModel model, ConfigHandler configHandler, UIFactory uif) {
        this.parent = parent;
        this.model = model;
        this.configHandler = configHandler;
        this.uif = uif;
        this.initActions();
        this.initHarness();
    }

    void setTreePanelModel(TreePanelModel tpm) {
        this.tpm = tpm;
        if (this.progMonitor != null) {
            this.progMonitor.setTreePanelModel(tpm);
        }
    }

    JMenu getMenu() {
        int i;
        JMenuItem[] items;
        JMenu menu = this.uif.createMenu("rh");
        menu.add(this.uif.createMenuItem(this.startAction));
        menu.add(this.uif.createMenuItem(this.stopAction));
        ContextManager cm = this.model.getContextManager();
        JavaTestMenuManager mm = null;
        if (cm != null && (mm = cm.getMenuManager()) != null && (items = mm.getMenuItems(7)) != null) {
            for (i = 0; i < items.length; ++i) {
                menu.add(items[i]);
            }
        }
        menu.addSeparator();
        menu.add(this.uif.createMenuItem(this.showProgressAction));
        if (mm != null && (items = mm.getMenuItems(8)) != null) {
            menu.addSeparator();
            for (i = 0; i < items.length; ++i) {
                menu.add(items[i]);
            }
        }
        return menu;
    }

    Action[] getToolBarActions() {
        return new Action[]{this.startAction, this.stopAction};
    }

    Harness getHarness() {
        return this.harness;
    }

    MessageStrip getMessageStrip() {
        if (this.messageStrip == null) {
            Monitor[] monitors = new Monitor[]{new ElapsedTimeMonitor(this.mState, this.uif), new RunProgressMonitor(this.mState, this.uif)};
            ActionListener zoom = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunTestsHandler.this.setProgressMonitorVisible(!RunTestsHandler.this.isProgressMonitorVisible());
                }
            };
            this.messageStrip = new MessageStrip(this.uif, monitors, this.mState, zoom);
            this.messageStrip.setRunningMonitor(monitors[1]);
            this.messageStrip.setIdleMonitor(monitors[0]);
            this.harness.addObserver(this.messageStrip);
        }
        return this.messageStrip;
    }

    synchronized void dispose() {
        if (this.harness != null) {
            this.harness.stop();
            this.harness = null;
        }
        this.parent = null;
        this.model = null;
        this.configHandler = null;
        this.tpm = null;
        if (this.progMonitor != null) {
            this.progMonitor.dispose();
        }
    }

    void updateGUI() {
        boolean testSuiteSet;
        this.testSuite = this.model.getTestSuite();
        this.workDir = this.model.getWorkDirectory();
        this.interviewParams = this.model.getInterviewParameters();
        boolean bl = testSuiteSet = this.testSuite != null;
        if (testSuiteSet) {
            if (!this.startAction.isEnabled() && !this.stopAction.isEnabled()) {
                this.startAction.setEnabled(true);
            }
        } else {
            this.startAction.setEnabled(false);
        }
    }

    void start() {
        this.startAction.setEnabled(false);
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                this.startAction.setEnabled(true);
                return;
            }
        }
        this.configHandler.ensureInterviewUpToDate();
        this.interviewParams = this.model.getInterviewParameters();
        if (!this.interviewParams.isTemplate() && this.interviewParams.isFinishable()) {
            this.startHarness(this.interviewParams);
        } else {
            int option = this.interviewParams.isStarted() ? this.uif.showOKCancelDialog("rh.completeConfigure") : this.uif.showOKCancelDialog("rh.startConfigure");
            if (option != 0) {
                this.startAction.setEnabled(true);
                return;
            }
            this.configHandler.showConfigEditor(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    int option = RunTestsHandler.this.uif.showOKCancelDialog("rh.configDone");
                    if (option != 0) {
                        RunTestsHandler.this.startAction.setEnabled(true);
                        return;
                    }
                    RunTestsHandler.this.startHarness(RunTestsHandler.this.interviewParams);
                }
            });
        }
    }

    void executeImmediate(String[] paths) throws Interview.Fault, TestSuite.Fault {
        this.startAction.setEnabled(false);
        if (this.workDir == null) {
            this.model.showWorkDirDialog(true);
            if (this.workDir == null) {
                this.startAction.setEnabled(true);
                return;
            }
        }
        this.configHandler.ensureInterviewUpToDate();
        if (!this.interviewParams.isFinishable()) {
            int option = this.uif.showOKCancelDialog("rh.mustConfigure");
            if (option == 0) {
                this.configHandler.showConfigEditor(null);
            }
            this.startAction.setEnabled(true);
            return;
        }
        Object[] items = new Object[]{this.interviewParams.getEnv().getName(), TestTreePanel.createNodeListString(TestTreePanel.createNodeList(paths))};
        int option = 0;
        if (paths[0].equals("")) {
            option = this.uif.showYesNoDialog("rh.confirmQuickAll", new Object[]{this.interviewParams.getEnv().getName()});
        } else {
            JPanel p = this.uif.createPanel("rh.confirmPanel", false);
            JTextArea msg = this.uif.createMessageArea("rh.confirmQuick", new Object[]{this.interviewParams.getEnv().getName()});
            p.setLayout(new BorderLayout());
            p.add((Component)msg, "North");
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = paths.length; i > 0; --i) {
                model.add(model.getSize(), paths[model.getSize()]);
            }
            JList list = this.uif.createList("rh.confirmList", model);
            p.add((Component)this.uif.createScrollPane(list, 20, 30), "Center");
            option = this.uif.showCustomYesNoDialog("rh.confirmQuick", p);
        }
        if (option != 0) {
            this.startAction.setEnabled(true);
            return;
        }
        InterviewParameters localParams = this.workDir.getTestSuite().createInterview();
        localParams.setWorkDirectory(this.interviewParams.getWorkDirectory());
        HashMap data = new HashMap();
        this.interviewParams.save(data);
        localParams.load(data, false);
        Parameters.TestsParameters tps = localParams.getTestsParameters();
        Parameters.MutableTestsParameters mtps = (Parameters.MutableTestsParameters)tps;
        if (paths == null || paths.length == 0 || paths[0].equals("")) {
            mtps.setTestsMode(1);
        } else {
            mtps.setTestsMode(2);
            mtps.setTests(paths);
        }
        this.startHarness(localParams);
    }

    private void startHarness(InterviewParameters ips) {
        if (this.getNeedToAutoCheckExcludeList()) {
            this.configHandler.checkExcludeListUpdate(this.parent, false);
        }
        try {
            if (!this.interviewParams.getWorkDirectory().getTestResultTable().isReady()) {
                I18NResourceBundle i18n = this.uif.getI18NResourceBundle();
                this.messageStrip.showMessage(i18n, "rh.waitToStart.txt");
            }
            this.harness.start(ips);
        }
        catch (Harness.Fault e) {
            this.uif.showError("rh", e.toString());
        }
    }

    private boolean getNeedToAutoCheckExcludeList() {
        Parameters.ExcludeListParameters elp = this.interviewParams.getExcludeListParameters();
        if (!(elp instanceof Parameters.MutableExcludeListParameters)) {
            return false;
        }
        Parameters.MutableExcludeListParameters melp = (Parameters.MutableExcludeListParameters)elp;
        if (melp.getExcludeMode() != 3) {
            return false;
        }
        if (this.interviewParams.getTestSuite().getLatestExcludeList() == null) {
            return false;
        }
        if (!melp.isLatestExcludeAutoCheckEnabled()) {
            return false;
        }
        if (melp.getLatestExcludeAutoCheckMode() == 2) {
            return true;
        }
        File local = this.workDir.getSystemFile("latest.jtx");
        if (!local.exists()) {
            return true;
        }
        long localLastModified = local.lastModified();
        long now = System.currentTimeMillis();
        int ageInDays = melp.getLatestExcludeAutoCheckInterval();
        long ageInMillis = ageInDays * 24 * 60 * 60 * 1000;
        return ageInDays > 0 && now > localLastModified + ageInMillis;
    }

    private void initHarness() {
        this.harness = new Harness();
        BackupPolicy backupPolicy = new BackupPolicy(){
            private int numBackupsToKeep = Integer.getInteger("javatest.backup.count", 5);
            private String[] ignoreExtns = StringArray.split(System.getProperty("javatest.backup.ignore", ".jtr"));

            public int getNumBackupsToKeep(File file) {
                return this.numBackupsToKeep;
            }

            public boolean isBackupRequired(File file) {
                if (this.ignoreExtns != null) {
                    for (int i = 0; i < this.ignoreExtns.length; ++i) {
                        if (!file.getPath().endsWith(this.ignoreExtns[i])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        this.harness.setBackupPolicy(backupPolicy);
        this.observer = new HarnessObserver();
        this.harness.addObserver(this.observer);
        this.mState = new MonitorState(this.harness);
    }

    private boolean isProgressMonitorVisible() {
        return this.progMonitor != null && this.progMonitor.isVisible();
    }

    private void setProgressMonitorVisible(boolean state) {
        if (this.progMonitor == null) {
            this.progMonitor = new ProgressMonitor((Component)this.parent, this.uif, this.mState);
            this.progMonitor.setTreePanelModel(this.tpm);
        }
        this.progMonitor.setVisible(state);
    }

    private void initActions() {
        this.showProgressAction = new ToolAction(this.uif, "rh.progress"){

            public void actionPerformed(ActionEvent e) {
                RunTestsHandler.this.setProgressMonitorVisible(true);
            }
        };
        this.startAction = new ToolAction(this.uif, "rh.start", true){

            public void actionPerformed(ActionEvent e) {
                RunTestsHandler.this.start();
            }
        };
        this.stopAction = new ToolAction(this.uif, "rh.stop", true){
            {
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent e) {
                RunTestsHandler.this.harness.stop();
            }
        };
    }

    private class HarnessObserver
    implements Harness.Observer {
        private HarnessObserver() {
        }

        public void startingTestRun(Parameters params) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RunTestsHandler.this.startAction.setEnabled(false);
                    RunTestsHandler.this.stopAction.setEnabled(true);
                    I18NResourceBundle i18n = RunTestsHandler.this.uif.getI18NResourceBundle();
                    RunTestsHandler.this.messageStrip.showMessage(i18n, "rh.starting.txt");
                }
            });
        }

        public void startingTest(TestResult tr) {
        }

        public void finishedTest(TestResult tr) {
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean allOK) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RunTestsHandler.this.startAction.setEnabled(true);
                    RunTestsHandler.this.stopAction.setEnabled(false);
                }
            });
        }

        public void error(final String msg) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RunTestsHandler.this.uif.showError("rh.error", msg);
                }
            });
        }
    }
}

