/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BinaryTestFinder
extends TestFinder {
    private File jtdFile;
    private ZipFile zipFile;
    private ZipEntry stringsEntry;
    private ZipEntry testsEntry;
    private ZipEntry treeEntry;
    private StringTable stringTable;
    private TestTable testTable;
    private TestTree testTree;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BinaryTestFinder.class);

    public BinaryTestFinder() {
    }

    public BinaryTestFinder(File jtdFile) throws TestFinder.Fault {
        this.jtdFile = jtdFile;
        this.openBinaryFile();
    }

    public BinaryTestFinder(File testSuiteRoot, File jtdFile) throws TestFinder.Fault {
        this.init(testSuiteRoot, jtdFile);
    }

    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        super.init(args, testSuiteRoot, env);
        this.openBinaryFile();
    }

    public void init(File testSuiteRoot, File jtdFile) throws TestFinder.Fault {
        super.init(null, testSuiteRoot, null);
        this.jtdFile = jtdFile;
        this.openBinaryFile();
    }

    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if (args[i].equalsIgnoreCase("-binary") || args[i].equalsIgnoreCase("-jtd")) {
            String e = args[i + 1];
            this.jtdFile = new File(e);
            return 2;
        }
        if (i == args.length - 1 && !args[i].startsWith("-")) {
            this.jtdFile = new File(args[i]);
            return 1;
        }
        return super.decodeArg(args, i);
    }

    public long lastModified(File f) {
        return 1L;
    }

    public boolean isFolder(File path) {
        TestTree.Node node;
        if (this.zipFile != null) {
            this.readBinaryFile();
        }
        File rootDir = this.getRootDir();
        String relPath = this.getRelativePath(rootDir, path);
        TestTree.Node node2 = node = this.testTree == null ? null : this.testTree.getNode(relPath);
        if (path.getPath().endsWith(".html") || path.getPath().endsWith(".java") || path.getPath().endsWith(".xml")) {
            return false;
        }
        return node != null;
    }

    protected void scan(File file) {
        if (this.zipFile != null) {
            this.readBinaryFile();
        }
        try {
            TestTree.Node node;
            File rootDir = this.getRootDir();
            String relPath = this.getRelativePath(rootDir, file);
            TestTree.Node node2 = node = this.testTree == null ? null : this.testTree.getNode(relPath);
            if (node == null) {
                this.error(i18n, "bin.cantFindPath", file.getPath());
                return;
            }
            TestTree.Node[] children = node.children;
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    File f = relPath.length() == 0 ? new File(children[i].name) : new File(relPath, children[i].name);
                    this.foundFile(f);
                }
            }
            if (node.testIndexes != null) {
                File testFile = new File(relPath);
                for (int i = 0; i < node.testIndexes.length; ++i) {
                    TestDescription td = node.getTest(i, rootDir, testFile, this.testTable);
                    this.foundTestDescription(td);
                }
            }
        }
        catch (IOException e) {
            this.error(i18n, "bin.internalIOError", new Object[]{file.getPath(), e});
        }
    }

    private String getRelativePath(File rootDir, File file) {
        if (file.isAbsolute()) {
            String rootDirPath = rootDir.getPath();
            String filePath = file.getPath();
            if (filePath.startsWith(rootDirPath)) {
                return filePath.equals(rootDirPath) ? "" : filePath.substring(rootDirPath.length() + 1);
            }
            throw new IllegalArgumentException();
        }
        return file.getPath();
    }

    private void openBinaryFile() throws TestFinder.Fault {
        try {
            if (this.jtdFile == null) {
                throw new TestFinder.Fault(i18n, "bin.noFile");
            }
            File root = this.getRoot();
            File f = this.jtdFile.isAbsolute() || root == null ? this.jtdFile : new File(root, this.jtdFile.getPath());
            this.zipFile = new ZipFile(f);
            this.stringsEntry = this.zipFile.getEntry("strings");
            this.testsEntry = this.zipFile.getEntry("tests");
            this.treeEntry = this.zipFile.getEntry("tree");
            if (this.stringsEntry == null || this.testsEntry == null || this.treeEntry == null) {
                throw new TestFinder.Fault(i18n, "bin.badBinFile", this.zipFile.getName());
            }
        }
        catch (FileNotFoundException e) {
            throw new TestFinder.Fault(i18n, "bin.cantFindFile", this.jtdFile.getPath());
        }
        catch (IOException e) {
            throw new TestFinder.Fault(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readBinaryFile() {
        block15: {
            if (this.zipFile == null) {
                throw new IllegalStateException();
            }
            this.stringTable = StringTable.read(this.zipFile, this.stringsEntry);
            this.testTable = TestTable.read(this.zipFile, this.testsEntry, this.stringTable);
            this.testTree = TestTree.read(this.zipFile, this.treeEntry);
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), e});
            }
            this.stringsEntry = null;
            this.testsEntry = null;
            this.treeEntry = null;
            this.zipFile = null;
            break block15;
            catch (TestFinder.Fault e) {
                this.error(i18n, "bin.fault", new Object[]{this.jtdFile.getPath(), e});
                try {
                    this.zipFile.close();
                }
                catch (IOException e2) {
                    this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), e2});
                }
                this.stringsEntry = null;
                this.testsEntry = null;
                this.treeEntry = null;
                this.zipFile = null;
            }
            catch (IOException e2) {
                this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), e2});
                {
                    catch (Throwable throwable) {
                        try {
                            this.zipFile.close();
                        }
                        catch (IOException e3) {
                            this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), e3});
                        }
                        this.stringsEntry = null;
                        this.testsEntry = null;
                        this.treeEntry = null;
                        this.zipFile = null;
                        throw throwable;
                    }
                }
                try {
                    this.zipFile.close();
                }
                catch (IOException e4) {
                    this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), e4});
                }
                this.stringsEntry = null;
                this.testsEntry = null;
                this.treeEntry = null;
                this.zipFile = null;
            }
        }
    }

    private static int readInt(DataInputStream in) throws IOException {
        int b;
        int n = 0;
        while ((b = in.readUnsignedByte()) >= 128) {
            n = n << 7 | b & 0x7F;
        }
        n = n << 7 | b;
        return n;
    }

    static class TestTree {
        private Node root;

        static TestTree read(ZipFile zf, ZipEntry ze) throws IOException, TestFinder.Fault {
            DataInputStream in = new DataInputStream(new BufferedInputStream(zf.getInputStream(ze)));
            Node root = new Node(in);
            return new TestTree(root);
        }

        TestTree(Node root) {
            this.root = root;
        }

        Node getNode(String path) {
            return path.length() == 0 ? this.root : this.root.getNode(path);
        }

        static class Node {
            private String name;
            private int[] testIndexes;
            private Node[] children;

            Node(DataInputStream in) throws IOException {
                int childCount;
                this.name = in.readUTF();
                int testCount = BinaryTestFinder.readInt(in);
                if (testCount > 0) {
                    this.testIndexes = new int[testCount];
                    for (int i = 0; i < this.testIndexes.length; ++i) {
                        this.testIndexes[i] = BinaryTestFinder.readInt(in);
                    }
                }
                if ((childCount = BinaryTestFinder.readInt(in)) > 0) {
                    this.children = new Node[childCount];
                    for (int i = 0; i < this.children.length; ++i) {
                        this.children[i] = new Node(in);
                    }
                }
            }

            Node getNode(String path) {
                int sep = path.indexOf(File.separatorChar);
                String head = sep == -1 ? path : path.substring(0, sep);
                for (int i = 0; i < this.children.length; ++i) {
                    Node child = this.children[i];
                    if (!child.name.equals(head)) continue;
                    return sep == -1 ? child : child.getNode(path.substring(sep + 1));
                }
                return null;
            }

            TestDescription getTest(int index, File root, File path, TestTable testTable) throws IOException {
                if (this.testIndexes == null || index > this.testIndexes.length) {
                    throw new IllegalArgumentException();
                }
                return testTable.get(root, path, this.testIndexes[index]);
            }
        }
    }

    static class TestTable {
        private ByteArrayInputStream bais;
        private StringTable stringTable;

        static TestTable read(ZipFile zf, ZipEntry ze, StringTable stringTable) throws IOException, TestFinder.Fault {
            byte[] bytes = new byte[(int)ze.getSize()];
            InputStream in = zf.getInputStream(ze);
            for (int total = 0; total < bytes.length; total += in.read(bytes, total, bytes.length - total)) {
            }
            return new TestTable(bytes, stringTable);
        }

        TestTable(byte[] data, StringTable stringTable) {
            this.bais = new ByteArrayInputStream(data);
            this.stringTable = stringTable;
        }

        TestDescription get(File root, File file, int index) throws IOException {
            this.bais.reset();
            this.bais.skip(index);
            HashMap<String, String> m = new HashMap<String, String>();
            DataInputStream in = new DataInputStream(this.bais);
            int n = BinaryTestFinder.readInt(in);
            for (int i = 0; i < n; ++i) {
                String key = this.stringTable.readRef(in);
                String value = this.stringTable.readRef(in);
                m.put(key, value);
            }
            return new TestDescription(root, file, m);
        }
    }

    static class StringTable {
        private String[] strings;

        static StringTable read(ZipFile zf, ZipEntry ze) throws IOException, TestFinder.Fault {
            DataInputStream in = new DataInputStream(new BufferedInputStream(zf.getInputStream(ze)));
            return new StringTable(in);
        }

        StringTable(DataInputStream in) throws IOException {
            int count = BinaryTestFinder.readInt(in);
            this.strings = new String[count];
            for (int i = 0; i < count; ++i) {
                this.strings[i] = in.readUTF();
            }
        }

        String readRef(DataInputStream in) throws IOException {
            int index = BinaryTestFinder.readInt(in);
            if (index == 0) {
                return in.readUTF();
            }
            return this.strings[index];
        }

        String get(int i) {
            return this.strings[i];
        }
    }
}

