/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.logging;

import com.sun.javatest.logging.FileEvent;
import com.sun.javatest.logging.JTFormatter;
import com.sun.javatest.logging.ObservedFile;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class WorkDirLogHandler
extends StreamHandler {
    private String pattern;
    private BufferedOutputStream bout;
    private ObservedFile of = null;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(WorkDirLogHandler.class);
    private boolean first;

    private void open(File fname) throws IOException {
        this.bout = new BufferedOutputStream(new FileOutputStream(fname.toString()));
        this.setOutputStream(this.bout);
        this.first = true;
    }

    public WorkDirLogHandler(ObservedFile of) {
        this.setLevel(Level.ALL);
        this.setFormatter(new JTFormatter());
        this.pattern = of.getAbsolutePath();
        this.of = of;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(LogRecord record) {
        Class<WorkDirLogHandler> clazz = WorkDirLogHandler.class;
        synchronized (WorkDirLogHandler.class) {
            if (this.bout == null) {
                try {
                    this.open(this.of);
                }
                catch (IOException ix) {
                    ix.printStackTrace();
                }
            }
            long startOff = this.of.length();
            JTFormatter frm = (JTFormatter)this.getFormatter();
            super.publish(record);
            if (this.bout != null) {
                this.flush();
            }
            if (this.first) {
                this.first = false;
                startOff += (long)frm.getHead(this).length();
            }
            long endOff = this.of.length();
            this.of.addToIndex(record, startOff += (long)frm.getLastOffset(), endOff);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<WorkDirLogHandler> clazz = WorkDirLogHandler.class;
        synchronized (WorkDirLogHandler.class) {
            if (this.bout != null) {
                try {
                    byte[] bytes = this.getFormatter().getTail(this).getBytes();
                    this.bout.write(bytes, 0, bytes.length);
                    this.bout.flush();
                    this.bout.close();
                    this.bout = null;
                }
                catch (IOException ioe) {
                    this.reportError(null, ioe, 3);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseLogFile() throws IOException {
        Class<WorkDirLogHandler> clazz = WorkDirLogHandler.class;
        synchronized (WorkDirLogHandler.class) {
            if (this.bout == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (!this.of.canWrite()) {
                throw new IOException(i18n.getString("workdirloghandler.canterasefile") + this.of.getAbsolutePath());
            }
            ((JTFormatter)this.getFormatter()).setErasing();
            this.of.fireFileEvent(new FileEvent(this.of, "start_erasing"));
            this.close();
            RandomAccessFile raf = new RandomAccessFile(this.of, "rw");
            raf.setLength(0L);
            raf.close();
            raf = new RandomAccessFile(this.of.getRecordInexFile(), "rw");
            raf.setLength(0L);
            raf.close();
            raf = new RandomAccessFile(this.of.getLoggersInexFile(), "rw");
            raf.setLength(0L);
            raf.close();
            this.of.fireFileEvent(new FileEvent(this.of, "content_erased"));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

