/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.interview.WizPrint;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.Keywords;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.StringArrayComparator;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

class ConfigSection
extends HTMLSection {
    ConfigSection(HTMLReport parent, Report.Settings s, File dir) {
        super(i18n.getString("config.title"), s, dir, parent);
    }

    void writeContents(ReportWriter out) throws IOException {
        super.writeContents(out);
        if (this.settings.isQuestionLogEnabled()) {
            out.startTag("ul");
            out.startTag("li");
            out.writeLink(HTMLReport.files[2], i18n.getString("config.confInterview"));
            out.endTag("li");
            out.endTag("ul");
        }
        if (this.settings.isStdEnabled()) {
            out.startTag("ul");
            out.startTag("li");
            out.writeLink("#" + HTMLReport.anchors[0], i18n.getString("config.selectValue"));
            out.endTag("li");
            if (this.settings.isEnvEnabled()) {
                out.startTag("li");
                out.writeLink("#" + HTMLReport.anchors[1], i18n.getString("config.execValue"));
                out.endTag("li");
            }
            out.startTag("li");
            out.writeLink("#" + HTMLReport.anchors[2], i18n.getString("config.locValue"));
            out.endTag("li");
            out.endTag("ul");
        }
    }

    void writeSummary(ReportWriter out) throws IOException {
        super.writeSummary(out);
        out.startTag("table");
        out.writeAttr("border", 1);
        out.startTag("tr");
        out.writeTH(i18n.getString("config.testSuite"), "row");
        out.startTag("td");
        TestSuite ts = this.settings.ip.getTestSuite();
        if (ts != null) {
            out.writeLink(ts.getRoot());
        } else {
            out.write(i18n.getString("config.noTestSuite"));
        }
        out.endTag("td");
        out.endTag("tr");
        out.endTag("table");
        if (this.settings.isStdEnabled()) {
            this.writeStdValSummary(out);
        }
        if (this.settings.isEnvEnabled()) {
            this.writeExecutionSummary(out);
        }
        this.writeLocationSummary(out);
    }

    void writeExtraFiles() throws IOException {
        if (this.settings.isQuestionLogEnabled()) {
            this.writeConfigInterview();
        }
        if (this.settings.isEnvEnabled()) {
            this.writeEnvironment();
        }
        if (this.settings.isStdEnabled()) {
            this.writeExcludeList();
        }
    }

    private void writeStdValSummary(ReportWriter out) throws IOException {
        out.startTag("h3");
        out.writeLinkDestination(HTMLReport.anchors[0], i18n.getString("config.selectValue"));
        out.endTag("h3");
        out.startTag("table");
        out.writeAttr("border", 1);
        TestSuite ts = this.settings.ip.getTestSuite();
        String[] tests = this.settings.ip.getTests();
        out.startTag("tr");
        out.writeTH(i18n.getString("config.tests.hdr"), "row");
        out.startTag("td");
        if (tests != null && tests.length > 0) {
            for (int i = 0; i < tests.length; ++i) {
                File file;
                if (i > 0) {
                    out.startTag("br");
                }
                if ((file = new File(ts.getTestsDir(), tests[i])).exists()) {
                    out.writeLink(file, tests[i]);
                    continue;
                }
                out.write(tests[i]);
            }
        } else {
            out.write(i18n.getString("config.tests.all"));
        }
        out.endTag("td");
        out.endTag("tr");
        out.startTag("tr");
        out.writeTH(i18n.getString("config.previous.hdr"), "row");
        boolean[] b = this.settings.ip.getPriorStatusValues();
        if (b != null) {
            String[] ss = new String[]{i18n.getString("config.status.passed"), i18n.getString("config.status.failed"), i18n.getString("config.status.error"), i18n.getString("config.status.notRun")};
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < b.length; ++i) {
                if (!b[i]) continue;
                if (sb.length() > 0) {
                    sb.append(" or ");
                }
                sb.append(ss[i]);
            }
            out.writeTD(sb.toString());
        } else {
            out.writeTD(i18n.getString("config.previous.none"));
        }
        out.endTag("tr");
        out.startTag("tr");
        out.writeTH(i18n.getString("config.excludeTests"), "row");
        out.startTag("td");
        ExcludeList excludeList = this.settings.ip.getExcludeList();
        if (excludeList != null) {
            out.writeI18N("config.entries", new Object[]{new Integer(excludeList.size())});
            Parameters.ExcludeListParameters exclParams = this.settings.ip.getExcludeListParameters();
            File[] excludeFiles = null;
            if (exclParams instanceof Parameters.MutableExcludeListParameters) {
                excludeFiles = ((Parameters.MutableExcludeListParameters)exclParams).getExcludeFiles();
            }
            if (excludeFiles != null && excludeFiles.length > 0) {
                for (int i = 0; i < excludeFiles.length; ++i) {
                    out.startTag("br");
                    out.writeLink(HTMLReport.files[4], excludeFiles[i].getPath());
                }
            }
        } else {
            out.write(i18n.getString("config.jtx.nofiles"));
        }
        out.endTag("td");
        out.endTag("tr");
        int concurrency = this.settings.ip.getConcurrency();
        out.startTag("tr");
        out.writeTH(i18n.getString("config.concurrency"), "row");
        out.startTag("td");
        out.write(Integer.toString(concurrency));
        out.endTag("td");
        out.endTag("tr");
        float timeout = this.settings.ip.getTimeoutFactor();
        out.startTag("tr");
        out.writeTH(i18n.getString("config.timeOut"), "row");
        out.startTag("td");
        out.write(NumberFormat.getInstance().format(timeout));
        out.endTag("td");
        out.endTag("tr");
        out.startTag("tr");
        out.writeTH(i18n.getString("config.keywords.hdr"), "row");
        Keywords keywords = this.settings.ip.getKeywords();
        if (keywords != null) {
            out.writeTD(this.settings.ip.getKeywords().toString());
        } else {
            out.writeTD(i18n.getString("config.keywords.none"));
        }
        out.endTag("tr");
        out.endTag("table");
    }

    private void writeExecutionSummary(ReportWriter out) throws IOException {
        TestEnvironment env;
        String envName;
        Parameters.EnvParameters envParams;
        out.startTag("h3");
        out.writeLinkDestination(HTMLReport.anchors[1], i18n.getString("config.execValue"));
        out.endTag("h3");
        out.startTag("table");
        out.writeAttr("border", 1);
        File[] envFiles = null;
        if (this.settings.isQuestionLogEnabled()) {
            out.startTag("tr");
            out.writeTH(i18n.getString("config.configInterview"), "row");
            out.startTag("td");
            String name = this.settings.ip.getName();
            if (name == null) {
                out.writeLink(HTMLReport.files[2], i18n.getString("config.confInterview"));
            } else {
                out.writeLink(HTMLReport.files[2], name);
            }
            if (!this.settings.ip.isValid()) {
                out.writeWarning(i18n.getString("config.intIncomplete"));
            }
            out.endTag("td");
            out.endTag("tr");
        }
        if ((envParams = this.settings.ip.getEnvParameters()) != null && envParams instanceof Parameters.LegacyEnvParameters && (envFiles = ((Parameters.LegacyEnvParameters)envParams).getEnvFiles()) != null) {
            out.startTag("tr");
            out.writeTH(i18n.getString("config.envFiles"), "row");
            out.startTag("td");
            for (int i = 0; i < envFiles.length; ++i) {
                out.writeLink(new File(envFiles[i].getPath()));
                out.startTag("br");
            }
            out.endTag("td");
            out.endTag("tr");
        }
        String string = envName = (env = this.settings.ip.getEnv()) != null ? env.getName() : null;
        if (envName != null && envName.length() > 0) {
            out.startTag("tr");
            out.writeTH(i18n.getString("config.env"), "row");
            out.startTag("td");
            out.writeLink(HTMLReport.files[3], envName);
            out.endTag("td");
            out.endTag("tr");
        }
        out.endTag("table");
    }

    private void writeLocationSummary(ReportWriter out) throws IOException {
        WorkDirectory workDir = this.settings.ip.getWorkDirectory();
        out.startTag("h3");
        out.writeLinkDestination(HTMLReport.anchors[2], i18n.getString("config.locValue"));
        out.endTag("h3");
        out.startTag("table");
        out.writeAttr("border", 1);
        out.startTag("tr");
        out.writeTH(i18n.getString("config.wd"), "row");
        out.startTag("td");
        out.writeLink(workDir.getRoot());
        out.endTag("td");
        out.endTag("tr");
        out.startTag("tr");
        out.writeTH(i18n.getString("config.rd"), "row");
        out.startTag("td");
        out.writeLink(this.reportDir);
        out.endTag("td");
        out.endTag("tr");
        out.endTag("table");
    }

    private void writeConfigInterview() throws IOException {
        WizPrint wp = new WizPrint(this.settings.ip);
        wp.setShowResponses(true);
        wp.write(this.openWriter(2));
    }

    private void writeEnvironment() throws IOException {
        TestEnvironment env = this.settings.ip.getEnv();
        String envName = env != null ? env.getName() : null;
        ReportWriter out = this.openAuxFile(3, i18n.getString("config.env.title", envName), i18n);
        if (env == null) {
            out.write(i18n.getString("config.noEnv"));
            return;
        }
        String desc = env.getDescription();
        if (desc != null) {
            out.startTag("h2");
            out.write(desc);
            out.endTag("h2");
        }
        TreeSet<String[]> envTable = new TreeSet<String[]>(new StringArrayComparator());
        for (TestEnvironment.Element envElem : env.elements()) {
            String[] envTableRow = new String[]{envElem.getKey(), envElem.getValue()};
            envTable.add(envTableRow);
        }
        out.startTag("table");
        out.writeAttr("border", 1);
        for (String[] envEntry : envTable) {
            out.startTag("tr");
            for (int j = 0; j < envEntry.length; ++j) {
                out.startTag("td");
                out.write(envEntry[j]);
                out.endTag("td");
            }
            out.endTag("tr");
        }
        out.endTag("table");
        out.close();
    }

    private void writeExcludeList() throws IOException {
        ReportWriter out = this.openAuxFile(4, i18n.getString("config.excludedTests"), i18n);
        ExcludeList excludeList = this.settings.ip.getExcludeList();
        if (excludeList == null || excludeList.size() == 0) {
            out.writeI18N("config.excl.none");
        } else {
            TreeSet sortedEntries = new TreeSet(new ExcludeListEntryComparator());
            Iterator iter = excludeList.getIterator(false);
            while (iter.hasNext()) {
                sortedEntries.add(iter.next());
            }
            out.startTag("table");
            out.writeAttr("border", 1);
            out.startTag("tr");
            out.startTag("th");
            out.writeI18N("config.excl.name");
            out.endTag("th");
            out.startTag("th");
            out.writeI18N("config.excl.testcase");
            out.endTag("th");
            out.startTag("th");
            out.writeI18N("config.excl.bugids");
            out.endTag("th");
            out.startTag("th");
            out.writeI18N("config.excl.platforms");
            out.endTag("th");
            out.startTag("th");
            out.writeI18N("config.excl.synopsis");
            out.endTag("th");
            out.endTag("tr");
            for (ExcludeList.Entry e : sortedEntries) {
                out.startTag("tr");
                this.writeTD(out, e.getRelativeURL());
                this.writeTD(out, e.getTestCases());
                out.startTag("td");
                String[] bugIds = e.getBugIdStrings();
                for (int i = 0; i < bugIds.length; ++i) {
                    if (i > 0) {
                        out.write(" ");
                    }
                    out.write(bugIds[i]);
                }
                out.endTag("td");
                this.writeTD(out, StringArray.join(e.getPlatforms()));
                this.writeTD(out, e.getSynopsis());
                out.endTag("tr");
            }
            out.endTag("table");
        }
        out.newLine();
        out.close();
    }

    private void writeTD(ReportWriter out, String text) throws IOException {
        out.startTag("td");
        if (text == null || text.length() == 0) {
            out.writeEntity("&nbsp;");
        } else {
            out.write(text);
        }
        out.endTag("td");
    }

    private static class ExcludeListEntryComparator
    implements Comparator {
        private ExcludeListEntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            ExcludeList.Entry e1 = (ExcludeList.Entry)o1;
            ExcludeList.Entry e2 = (ExcludeList.Entry)o2;
            int x = ExcludeListEntryComparator.compare(e1.getRelativeURL(), e2.getRelativeURL());
            if (x == 0) {
                x = ExcludeListEntryComparator.compare(e1.getTestCases(), e2.getTestCases());
            }
            return x;
        }

        private static int compare(String[] a, String[] b) {
            int alen = a == null ? 0 : a.length;
            int blen = b == null ? 0 : b.length;
            for (int i = 0; i < Math.min(alen, blen); ++i) {
                int c = ExcludeListEntryComparator.compare(a[i], b[i]);
                if (c == 0) continue;
                return c;
            }
            return alen < blen ? -1 : (alen == blen ? 0 : 1);
        }

        private static int compare(String a, String b) {
            return a == null && b == null ? 0 : (a == null ? -1 : (b == null ? 1 : a.compareTo(b)));
        }
    }
}

