/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.servlets;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExcludeBrowser
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ExcludeList excludeList;
        String uri = req.getRequestURI();
        File file = new File(req.getRealPath(uri));
        if (!file.exists()) {
            res.sendError(404);
            return;
        }
        try {
            excludeList = new ExcludeList(file);
        }
        catch (ExcludeList.Fault e) {
            String msg = "The file does not appear to be a valid exclude-list file. The following exception was received while trying to open it: " + e.toString();
            res.sendError(404, msg);
            return;
        }
        catch (IOException e) {
            String msg = "The file does not appear to be a valid exclude-list file. The following exception was received while trying to open it: " + e.toString();
            res.sendError(404, msg);
            return;
        }
        String bugLink = this.getInitParameter("bugLink");
        res.setContentType("text/html");
        PrintWriter out = new PrintWriter((OutputStream)res.getOutputStream());
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + file + "</title>");
        out.println("</head>");
        out.println("<body>");
        if (excludeList.size() == 0) {
            out.println("Exclude list is empty.");
        } else {
            out.println("<table border=1>");
            Iterator iter = excludeList.getIterator(false);
            while (iter.hasNext()) {
                ExcludeList.Entry entry = (ExcludeList.Entry)iter.next();
                String[] bugIds = entry.getBugIdStrings();
                StringBuffer bugIdText = new StringBuffer();
                for (int i = 0; i < bugIds.length; ++i) {
                    if (i > 0) {
                        bugIdText.append(" ");
                    }
                    String b = bugIds[i];
                    if (bugLink == null) {
                        bugIdText.append(b);
                        continue;
                    }
                    bugIdText.append("<a href=\"" + bugLink + b + "\">" + b + "</a>");
                }
                out.print("<tr>");
                out.print("<td>" + entry.getRelativeURL());
                if (entry.getTestCases() != null) {
                    out.print("[" + entry.getTestCases() + "]");
                }
                out.print("<td>" + bugIdText);
                out.print("<td>" + StringArray.join(entry.getPlatforms()));
                out.print("<td>" + entry.getSynopsis());
                out.println();
            }
            out.println("</table>");
        }
        out.println("<p><hr>");
        out.println("File: <em>" + file + "</em>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
}

