/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.VerboseCommand;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CommandContext {
    private Vector commands = new Vector();
    private File testSuitePath;
    private File workDirectoryPath;
    private String defaultWorkDirPath;
    private boolean autoCreateWorkDirectory;
    private File configFilePath;
    private InterviewParameters config;
    private Command autoRunCommand;
    private File autoRunReportDir;
    private boolean closeDesktopWhenDoneEnabled;
    private Desktop desktop;
    private PrintWriter out;
    private int[] cumulativeTestStats = new int[4];
    private HashMap verboseOptionValues = new HashMap();
    private boolean verboseMax;
    private boolean verboseQuiet;
    private boolean verboseDate = true;
    private boolean errors;
    private Harness.Observer[] harnessObservers = new Harness.Observer[0];
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(CommandContext.class);
    static final String VERBOSE_COMMANDS = "commands";
    static final String TRACE_PREFIX = "+ ";

    public CommandContext() {
        this(new PrintWriter(System.err));
    }

    public CommandContext(PrintWriter out) {
        this.out = out;
    }

    public void addCommand(Command cmd) {
        this.commands.add(cmd);
    }

    public Command[] getCommands() {
        Object[] a = new Command[this.commands.size()];
        this.commands.copyInto(a);
        return a;
    }

    public void runCommands() throws Fault {
        boolean foundAction = false;
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            foundAction |= cmd.isActionCommand();
            boolean verbose = this.getVerboseOptionValue(VERBOSE_COMMANDS, false);
            if (verbose) {
                this.out.println(TRACE_PREFIX + cmd.toString());
            }
            try {
                cmd.run(this);
                continue;
            }
            catch (Command.Fault e) {
                throw new Fault(e);
            }
        }
        if (!foundAction && this.autoRunCommand != null) {
            try {
                this.autoRunCommand.run(this);
            }
            catch (Command.Fault e) {
                throw new Fault(i18n, "cc.errorInDefault", e.getMessage());
            }
        }
    }

    public void addHarnessObserver(Harness.Observer o) {
        this.harnessObservers = (Harness.Observer[])DynamicArray.append(this.harnessObservers, o);
    }

    public Harness.Observer[] getHarnessObservers() {
        return this.harnessObservers;
    }

    public Command getAutoRunCommand() {
        return this.autoRunCommand;
    }

    public void setAutoRunCommand(Command c) {
        this.autoRunCommand = c;
    }

    public File getAutoRunReportDir() {
        return this.autoRunReportDir;
    }

    public void setAutoRunReportDir(File dir) {
        this.autoRunReportDir = dir;
    }

    public void addTestStats(int[] stats) {
        if (stats.length != 4) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stats.length; ++i) {
            int n = i;
            this.cumulativeTestStats[n] = this.cumulativeTestStats[n] + stats[i];
        }
    }

    public int[] getTestStats() {
        int[] s = new int[4];
        System.arraycopy(this.cumulativeTestStats, 0, s, 0, s.length);
        return s;
    }

    public boolean isCloseDesktopWhenDoneEnabled() {
        return this.closeDesktopWhenDoneEnabled;
    }

    public void setCloseDesktopWhenDoneEnabled(boolean b) {
        this.closeDesktopWhenDoneEnabled = b;
    }

    public boolean isTestSuiteSet() {
        return this.hasConfig();
    }

    public TestSuite getTestSuite() throws Fault {
        this.initConfig();
        return this.config.getTestSuite();
    }

    public void setTestSuite(File path) throws Fault {
        if (this.testSuitePath != null && !this.testSuitePath.equals(path)) {
            throw new Fault(i18n, "cc.tsAlreadySet", this.testSuitePath);
        }
        this.testSuitePath = path;
    }

    public void setTestSuite(TestSuite ts) throws Fault, TestSuite.Fault {
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config == null) {
            this.config = ts.createInterview();
        } else if (this.config.getTestSuite() != ts) {
            throw new Fault(i18n, "cc.tsAlreadySet", this.testSuitePath);
        }
    }

    public boolean isWorkDirectorySet() {
        return this.hasConfig() && this.config.getWorkDirectory() != null;
    }

    public WorkDirectory getWorkDirectory() throws Fault {
        this.initConfig();
        return this.config.getWorkDirectory();
    }

    public void setWorkDirectory(File path) throws Fault {
        this.setWorkDirectory(path, false);
    }

    public void setWorkDirectory(File path, boolean create) throws Fault {
        if (this.workDirectoryPath != null && !this.workDirectoryPath.equals(path)) {
            throw new Fault(i18n, "cc.wdAlreadySet", this.workDirectoryPath);
        }
        this.autoCreateWorkDirectory = create;
        this.workDirectoryPath = path;
    }

    public void setWorkDirectory(WorkDirectory wd) throws Fault, TestSuite.Fault {
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config == null) {
            this.config = wd.getTestSuite().createInterview();
        } else {
            if (wd.getTestSuite() != this.config.getTestSuite()) {
                throw new Fault(i18n, "cc.wdTestSuiteMismatch", new Object[]{wd.getRoot(), this.config.getTestSuite().getRoot()});
            }
            WorkDirectory cwd = this.config.getWorkDirectory();
            if (cwd != null && cwd != wd) {
                throw new Fault(i18n, "cc.wdAlreadySet", this.workDirectoryPath);
            }
        }
        this.config.setWorkDirectory(wd);
    }

    public InterviewParameters getInterviewParameters() throws Fault {
        return this.getConfig();
    }

    public InterviewParameters getConfig() throws Fault {
        this.initConfig();
        return this.config;
    }

    public boolean hasConfig() {
        return this.config != null || this.testSuitePath != null || this.workDirectoryPath != null || this.configFilePath != null;
    }

    public void setConfig(File path) throws Fault {
        if (this.config != null) {
            if (this.configFilePath == null) {
                throw new Fault(i18n, "cc.confAlreadySetDefault", path);
            }
            throw new Fault(i18n, "cc.confAlreadySet", new Object[]{path, this.configFilePath});
        }
        this.configFilePath = path;
    }

    void setDefaultWorkDir(String path) {
        this.defaultWorkDirPath = path;
    }

    public void setInterviewParameters(InterviewParameters p) throws Fault {
        WorkDirectory cwd;
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config != null) {
            if (this.config.getTestSuite() != p.getTestSuite()) {
                throw new Fault(i18n, "cc.confTestSuiteMismatch", new Object[]{this.config.getTestSuite().getRoot()});
            }
            cwd = this.config.getWorkDirectory();
            WorkDirectory pwd = p.getWorkDirectory();
            if (cwd != null && pwd != null && pwd != cwd) {
                throw new Fault(i18n, "cc.confWorkDirMismatch", new Object[]{cwd.getRoot()});
            }
        } else {
            cwd = null;
        }
        this.config = p;
        if (this.config.getWorkDirectory() == null && cwd != null) {
            this.config.setWorkDirectory(cwd);
        }
    }

    private boolean isInitConfigRequired() {
        return this.config == null && (this.testSuitePath != null || this.workDirectoryPath != null || this.configFilePath != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initConfig() throws Fault {
        block39: {
            block40: {
                WorkDirectory wd;
                TestSuite ts;
                File tsPath;
                Properties configData;
                if (this.config != null) {
                    return;
                }
                if (this.testSuitePath != null && this.workDirectoryPath == null && this.defaultWorkDirPath != null) {
                    this.workDirectoryPath = new File(this.defaultWorkDirPath);
                }
                if (this.workDirectoryPath == null || !this.autoCreateWorkDirectory && !WorkDirectory.isEmptyDirectory(this.workDirectoryPath)) break block40;
                if (this.testSuitePath == null) {
                    if (this.configFilePath == null) {
                        throw new Fault(i18n, "cc.noTestSuite");
                    }
                    configData = new Properties();
                    try {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.configFilePath));
                        try {
                            configData.load(in);
                        }
                        catch (RuntimeException e) {
                            throw new Fault(i18n, "cc.cantReadConfig", new Object[]{this.configFilePath, e});
                        }
                        finally {
                            ((InputStream)in).close();
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new Fault(i18n, "cc.cantFindConfig", this.configFilePath);
                    }
                    catch (IOException e) {
                        throw new Fault(i18n, "cc.cantReadConfig", new Object[]{this.configFilePath, e});
                    }
                    String tsp = (String)configData.get("TESTSUITE");
                    if (tsp == null) {
                        throw new Fault(i18n, "cc.noTestSuiteInConfigFile", this.configFilePath);
                    }
                    tsPath = new File(tsp);
                } else {
                    configData = null;
                    tsPath = this.testSuitePath;
                }
                try {
                    ts = TestSuite.open(tsPath);
                }
                catch (FileNotFoundException e) {
                    throw new Fault(i18n, "cc.cantFindTS", new Object[]{tsPath, new Integer(this.testSuitePath != null ? 0 : 1), this.configFilePath});
                }
                catch (TestSuite.Fault e) {
                    throw new Fault(i18n, "cc.cantOpenTS", new Object[]{tsPath, new Integer(this.testSuitePath != null ? 0 : 1), this.configFilePath, e.getMessage()});
                }
                try {
                    wd = WorkDirectory.create(this.workDirectoryPath, ts);
                }
                catch (WorkDirectory.Fault e) {
                    throw new Fault(i18n, "cc.cantCreateWD", this.workDirectoryPath);
                }
                if (this.configFilePath == null || configData != null) {
                    try {
                        this.config = ts.createInterview();
                    }
                    catch (TestSuite.Fault e) {
                        throw new Fault(i18n, "cc.cantCreateConfig", new Object[]{this.testSuitePath, e.getMessage()});
                    }
                    try {
                        if (configData != null) {
                            this.config.load((Map)configData, this.configFilePath);
                        }
                    }
                    catch (Interview.Fault e) {
                        throw new Fault(i18n, "cc.cantOpenConfig", new Object[]{this.configFilePath, e.getMessage()});
                    }
                    this.config.setWorkDirectory(wd);
                    break block39;
                } else {
                    try {
                        this.config = InterviewParameters.open(this.configFilePath, wd);
                    }
                    catch (IOException e) {
                        throw new Fault(i18n, "cc.cantReadConfig", new Object[]{this.configFilePath, e});
                    }
                    catch (Interview.Fault e) {
                        throw new Fault(i18n, "cc.cantOpenConfig", new Object[]{this.configFilePath, e.getMessage()});
                    }
                }
            }
            try {
                this.config = InterviewParameters.open(this.testSuitePath, this.workDirectoryPath, this.configFilePath);
                if (this.config.getWorkDirectory() == null) break block39;
                File templateFile = TemplateUtilities.getTemplateFile(this.config.getWorkDirectory());
                if (this.config.getTemplatePath() != null || templateFile == null) break block39;
                try {
                    InterviewParameters tConfig = this.config.getTestSuite().loadInterviewFromTemplate(templateFile, this.config);
                    if (tConfig != null) {
                        tConfig.setWorkDirectory(this.config.getWorkDirectory());
                        this.config = tConfig;
                    }
                }
                catch (IOException e) {
                }
                catch (TestSuite.Fault fault) {}
            }
            catch (Interview.Fault e) {
                throw new Fault(i18n, "cc.cantInitConfig", e.getMessage());
            }
        }
        if (this.testSuitePath == null) {
            this.testSuitePath = this.config.getTestSuite().getRoot();
        }
        if (this.workDirectoryPath == null && this.config.getWorkDirectory() != null) {
            this.workDirectoryPath = this.config.getWorkDirectory().getRoot();
        }
        if (this.configFilePath == null) {
            this.configFilePath = this.config.getFile();
        }
    }

    public boolean isDesktopRequired() {
        int mode = 0;
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd = (Command)this.commands.elementAt(i);
            mode = Math.max(mode, cmd.getDesktopMode());
        }
        return mode != 1;
    }

    public void setDesktop(Desktop d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.desktop = d;
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public void setVerboseMax(boolean on) {
        this.verboseMax = on;
    }

    public void setVerboseQuiet(boolean on) {
        this.verboseQuiet = on;
    }

    public void setVerboseTimestampEnabled(boolean on) {
        this.verboseDate = on;
    }

    public void setVerboseOptionValue(String name, boolean on) {
        this.verboseOptionValues.put(name.toLowerCase(), new Boolean(on));
    }

    public boolean getVerboseOptionValue(String name) {
        return this.getVerboseOptionValue(name, false);
    }

    public boolean getVerboseOptionValue(String name, boolean defaultValue) {
        if (this.verboseMax) {
            return true;
        }
        if (this.verboseQuiet) {
            return false;
        }
        Boolean b = (Boolean)this.verboseOptionValues.get(name.toLowerCase());
        return b == null ? defaultValue : b;
    }

    public boolean isVerboseOptionSet(String name) {
        return this.verboseOptionValues.get(name.toLowerCase()) != null;
    }

    public boolean isVerboseTimestampEnabled() {
        return this.verboseDate;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public void printMessage(I18NResourceBundle i18n, String key) {
        this.out.println(i18n.getString(key));
    }

    public void printMessage(I18NResourceBundle i18n, String key, Object arg) {
        this.out.println(i18n.getString(key, arg));
    }

    public void printMessage(I18NResourceBundle i18n, String key, Object[] args) {
        this.out.println(i18n.getString(key, args));
    }

    public void printErrorMessage(I18NResourceBundle i18n, String key) {
        this.out.println(i18n.getString(key));
        this.errors = true;
    }

    public void printErrorMessage(I18NResourceBundle i18n, String key, Object arg) {
        this.out.println(i18n.getString(key, arg));
        this.errors = true;
    }

    public void printErrorMessage(I18NResourceBundle i18n, String key, Object[] args) {
        this.out.println(i18n.getString(key, args));
        this.errors = true;
    }

    static {
        VerboseCommand.addOption(VERBOSE_COMMANDS, new HelpTree.Node(i18n, "cc.verbose"));
    }

    public class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }

        Fault(Command.Fault e) {
            super(e.getMessage(), e);
        }

        public CommandContext getContext() {
            return CommandContext.this;
        }
    }
}

