/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.WizPane;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.CommandParser;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.DesktopManager;
import com.sun.javatest.tool.HelpManager;
import com.sun.javatest.tool.ManagerLoader;
import com.sun.javatest.tool.Startup;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.text.html.HTMLEditorKit;

public class Main {
    private CommandManager[] commandManagers;
    private HelpManager helpManager;
    private DesktopManager desktopManager;
    private static boolean tracing;
    private static long traceStartTime;
    private static PrintWriter traceOut;
    private static boolean initialized;
    private static final String CMDMGRLIST = "JavaTest.cmdMgrs.lst";
    private static I18NResourceBundle i18n;
    private static final int RC_GUI_ACTIVE = -1;
    private static final int RC_OK = 0;
    private static final int RC_BATCH_TESTS_FAILED = 1;
    private static final int RC_BATCH_TESTS_ERROR = 2;
    private static final int RC_USER_ERROR = 3;
    private static final int RC_INTERNAL_ERROR = 4;

    public static void main(String[] args) {
        String javaVersion;
        tracing = Boolean.getBoolean("javatest.trace.startup");
        if (tracing) {
            traceStartTime = System.currentTimeMillis();
        }
        if ((javaVersion = System.getProperty("java.version")) != null) {
            String[] oldVersions = new String[]{"1.0", "1.1", "1.2", "1.3", "1.4"};
            for (int i = 0; i < oldVersions.length; ++i) {
                if (!javaVersion.startsWith(oldVersions[i])) continue;
                System.err.println("Please use Java(TM) Standard Edition, Version 5.0 or better to run the JT Harness(TM) harness.");
                System.exit(1);
            }
        }
        try {
            Class<?> t = Class.forName("javax.help.AbstractHelpAction");
        }
        catch (ClassNotFoundException e) {
            System.err.println("JavaHelp 2.x is required to run the harness, please add it to the classpath or available libraries.");
            System.exit(1);
        }
        Main.main0(args);
    }

    private static void main0(String[] args) {
        Debug.setProperties(System.getProperties());
        PrintWriter out = new PrintWriter(System.err){

            public void close() {
                this.flush();
            }
        };
        if (tracing) {
            traceOut = out;
        }
        try {
            ExitCount.inc();
            Main m = new Main();
            CommandContext ctx = new CommandContext(out);
            m.run(args, ctx);
            if (tracing) {
                Main.trace("Main.run complete");
            }
            out.flush();
            int[] stats = ctx.getTestStats();
            int rc = stats[2] > 0 ? 2 : (stats[1] > 0 ? 1 : 0);
            ExitCount.dec(true, rc);
            boolean preload = System.getProperty("javatest.preload.classes", "true").equals("true");
            if (preload) {
                if (tracing) {
                    Main.trace("preloading classes...");
                }
                Main.preloadUsefulClasses();
                if (tracing) {
                    Main.trace("preloaded classes");
                }
            }
            out.flush();
        }
        catch (Command.Fault e) {
            out.println("+ " + e.getCommand().toString());
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (CommandContext.Fault e) {
            CommandContext ctx;
            boolean verboseCommands;
            Throwable t = e.getCause();
            if (t instanceof Command.Fault && !(verboseCommands = (ctx = e.getContext()).getVerboseOptionValue("commands"))) {
                Command.Fault ce = (Command.Fault)t;
                Command c = ce.getCommand();
                out.println("+ " + c.toString());
            }
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (CommandParser.Fault e) {
            Throwable t = e.getCause();
            if (t instanceof Command.Fault) {
                Command.Fault ce = (Command.Fault)t;
                Command c = ce.getCommand();
                out.println("+ " + c.toString());
            }
            out.println(e.getMessage());
            out.flush();
            Main.exit(3);
        }
        catch (Fault e) {
            out.println(e.getMessage());
            out.flush();
            Main.exit(4);
        }
        catch (Error e) {
            e.printStackTrace(out);
            out.flush();
            Main.exit(4);
        }
        catch (RuntimeException e) {
            e.printStackTrace(out);
            out.flush();
            Main.exit(4);
        }
    }

    public final void run(String[] args, PrintWriter out) throws Fault, Command.Fault, CommandContext.Fault, CommandParser.Fault {
        this.run(args, new CommandContext(out));
    }

    public final void run(String[] args, final CommandContext ctx) throws Fault, Command.Fault, CommandContext.Fault, CommandParser.Fault {
        block31: {
            Runnable task;
            Desktop desktop;
            boolean needDesktop;
            if (this.commandManagers == null) {
                this.desktopManager = new DesktopManager();
                this.helpManager = new HelpManager();
                try {
                    ManagerLoader ml = new ManagerLoader(CommandManager.class, System.err);
                    Set mgrs = ml.loadManagers(CMDMGRLIST);
                    mgrs.add(this.desktopManager);
                    mgrs.add(this.helpManager);
                    this.commandManagers = mgrs.toArray(new CommandManager[mgrs.size()]);
                    this.helpManager.setCommandManagers(this.commandManagers);
                }
                catch (IOException e) {
                    throw new Fault(i18n, "main.cantAccessResource", new Object[]{CMDMGRLIST, e});
                }
            }
            CommandParser p = new CommandParser(this.commandManagers);
            boolean urlEncoded = Boolean.getBoolean("javatest.command.urlEncoded");
            p.parse(args, urlEncoded, ctx);
            if (!initialized) {
                File classDir = ProductInfo.getJavaTestClassDir();
                Harness.setClassDir(classDir);
                JavaTestSecurityManager.install();
                initialized = true;
            }
            final Command[] cmds = ctx.getCommands();
            boolean helpInfoRequired = this.helpManager.isInfoRequired();
            if (helpInfoRequired) {
                this.helpManager.showRequiredInfo(ctx.getLogWriter(), ctx);
                if (cmds.length == 0) {
                    return;
                }
            }
            if (needDesktop = ctx.isDesktopRequired()) {
                block30: {
                    if (tracing) {
                        Main.trace("creating desktop...");
                    }
                    desktop = this.desktopManager.createDesktop(ctx);
                    task = new Runnable(){

                        public void run() {
                            if (tracing) {
                                Main.trace("creating splash screen...");
                            }
                            Startup su = null;
                            for (int i = 0; i < cmds.length; ++i) {
                                URL ss = cmds[i].getCustomSplash();
                                if (ss == null) continue;
                                su = new Startup(ss);
                                break;
                            }
                            if (su == null) {
                                su = new Startup();
                            }
                            final Startup splashScreen = su;
                            Thread splashTimer = new Thread(){

                                public void run() {
                                    block7: {
                                        int splashSecs = Integer.getInteger("javatest.splashScreen.time", 15);
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(splashSecs * 1000);
                                        }
                                        catch (InterruptedException e) {
                                            // empty catch block
                                        }
                                        if (tracing) {
                                            Main.trace("splash timer done: showing desktop...");
                                        }
                                        Runnable task2 = new Runnable(){

                                            public void run() {
                                                desktop.setVisible(true);
                                                splashScreen.disposeLater();
                                            }
                                        };
                                        try {
                                            EventQueue.invokeAndWait(task2);
                                        }
                                        catch (InterruptedException e) {
                                            if (tracing) {
                                                e.printStackTrace();
                                            }
                                        }
                                        catch (InvocationTargetException e) {
                                            if (!tracing) break block7;
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            };
                            splashTimer.setDaemon(true);
                            splashTimer.start();
                        }
                    };
                    try {
                        EventQueue.invokeAndWait(task);
                    }
                    catch (InterruptedException e) {
                        if (tracing) {
                            e.printStackTrace();
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (!tracing) break block30;
                        e.printStackTrace();
                    }
                }
                ctx.setDesktop(desktop);
            } else {
                desktop = null;
            }
            if (tracing) {
                Main.trace("executing command line...");
            }
            ctx.runCommands();
            if (tracing) {
                Main.trace("command line done");
            }
            if (desktop != null) {
                InterviewParameters ip;
                if (ctx.isCloseDesktopWhenDoneEnabled() && desktop.isOKToAutoExit()) {
                    task = new Runnable(){

                        public void run() {
                            desktop.setVisible(false);
                            desktop.dispose();
                        }
                    };
                    try {
                        EventQueue.invokeAndWait(task);
                    }
                    catch (InterruptedException e) {
                        if (tracing) {
                            e.printStackTrace();
                        }
                        break block31;
                    }
                    catch (InvocationTargetException e) {
                        if (tracing) {
                            e.printStackTrace();
                        }
                        break block31;
                    }
                }
                if (desktop.isEmpty() && ctx.hasConfig()) {
                    try {
                        ip = ctx.getConfig();
                    }
                    catch (CommandContext.Fault e) {
                        throw new Fault(i18n, "main.cantGetConfig", e.getMessage());
                    }
                } else {
                    ip = null;
                }
                Runnable task2 = new Runnable(){

                    public void run() {
                        if (desktop.isEmpty()) {
                            if (ctx.hasConfig()) {
                                if (tracing) {
                                    Main.trace("show specified test suite");
                                }
                                desktop.addDefaultTool(ip);
                            } else if (desktop.isFirstTime()) {
                                if (tracing) {
                                    Main.trace("show default");
                                }
                                desktop.addDefaultTool();
                            } else {
                                if (tracing) {
                                    Main.trace("restore desktop");
                                }
                                desktop.restore();
                            }
                        }
                        if (tracing) {
                            Main.trace("set desktop visible");
                        }
                        desktop.setVisible(true);
                    }
                };
                try {
                    EventQueue.invokeAndWait(task2);
                }
                catch (InterruptedException e) {
                    if (tracing) {
                        e.printStackTrace();
                    }
                }
                catch (InvocationTargetException e) {
                    if (!tracing) break block31;
                    e.printStackTrace();
                }
            }
        }
    }

    private static void preloadUsefulClasses() {
        new HTMLEditorKit().createDefaultDocument();
        Interview i = new Interview("dummy"){
            Question qEnd = new FinalQuestion(this);
            {
                this.setFirstQuestion(this.qEnd);
            }
        };
        new WizPane(i);
    }

    private static void trace(String msg) {
        long now = System.currentTimeMillis();
        traceOut.println(MessageFormat.format("{0,number,[##0.0]} {1}", new Float((float)(now - traceStartTime) / 1000.0f), msg));
        traceOut.flush();
    }

    private static final void exit(int exitCode) {
        SecurityManager sc = System.getSecurityManager();
        if (sc instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)sc).setAllowExit(true);
        }
        System.exit(exitCode);
        throw new JavaTestError(i18n, "main.cannotExit.err");
    }

    static {
        initialized = false;
        i18n = I18NResourceBundle.getBundleForClass(Main.class);
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18n, String key) {
            super(i18n.getString(key));
        }

        public Fault(I18NResourceBundle i18n, String key, Object arg) {
            super(i18n.getString(key, arg));
        }

        public Fault(I18NResourceBundle i18n, String key, Object[] args) {
            super(i18n.getString(key, args));
        }
    }
}

