/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demots.tests.bignum;

import com.sun.demoapi.BigNum;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import java.io.PrintWriter;

public class CompareTest
implements Test {
    private PrintWriter err;

    public static void main(String[] args) {
        PrintWriter err = new PrintWriter(System.err, true);
        CompareTest t = new CompareTest();
        Status s = t.run(args, null, err);
        s.exit();
    }

    public Status run(String[] args, PrintWriter out, PrintWriter err) {
        this.err = err;
        boolean ok = true;
        ok &= this.test("-12345678901234567890", "-12345678901234567891", 1);
        ok &= this.test("-12345678901234567890", "-12345678901234567890", 0);
        ok &= this.test("-12345678901234567890", "-12345678901234567889", -1);
        ok &= this.test("-12345678901234567890", "-1234567890", -1);
        ok &= this.test("-12345678901234567890", "-123", -1);
        ok &= this.test("-12345678901234567890", "0", -1);
        ok &= this.test("-12345678901234567890", "123", -1);
        ok &= this.test("-12345678901234567890", "1234567890", -1);
        ok &= this.test("-12345678901234567890", "12345678901234567890", -1);
        ok &= this.test("-1234567890", "-12345678901234567890", 1);
        ok &= this.test("-1234567890", "-1234567891", 1);
        ok &= this.test("-1234567890", "-1234567890", 0);
        ok &= this.test("-1234567890", "-1234567889", -1);
        ok &= this.test("-1234567890", "-123", -1);
        ok &= this.test("-1234567890", "0", -1);
        ok &= this.test("-1234567890", "123", -1);
        ok &= this.test("-1234567890", "1234567890", -1);
        ok &= this.test("-1234567890", "12345678901234567890", -1);
        ok &= this.test("-123", "-12345678901234567890", 1);
        ok &= this.test("-123", "-1234567890", 1);
        ok &= this.test("-123", "-124", 1);
        ok &= this.test("-123", "-123", 0);
        ok &= this.test("-123", "-122", -1);
        ok &= this.test("-123", "0", -1);
        ok &= this.test("-123", "123", -1);
        ok &= this.test("-123", "1234567890", -1);
        ok &= this.test("-123", "12345678901234567890", -1);
        ok &= this.test("0", "-12345678901234567890", 1);
        ok &= this.test("0", "-1234567890", 1);
        ok &= this.test("0", "-123", 1);
        ok &= this.test("0", "-1", 1);
        ok &= this.test("0", "0", 0);
        ok &= this.test("0", "1", -1);
        ok &= this.test("0", "123", -1);
        ok &= this.test("0", "1234567890", -1);
        ok &= this.test("0", "12345678901234567890", -1);
        ok &= this.test("123", "-12345678901234567890", 1);
        ok &= this.test("123", "-1234567890", 1);
        ok &= this.test("123", "-123", 1);
        ok &= this.test("123", "0", 1);
        ok &= this.test("123", "122", 1);
        ok &= this.test("123", "123", 0);
        ok &= this.test("123", "124", -1);
        ok &= this.test("123", "1234567890", -1);
        ok &= this.test("123", "12345678901234567890", -1);
        ok &= this.test("1234567890", "-12345678901234567890", 1);
        ok &= this.test("1234567890", "-1234567890", 1);
        ok &= this.test("1234567890", "-123", 1);
        ok &= this.test("1234567890", "0", 1);
        ok &= this.test("1234567890", "123", 1);
        ok &= this.test("1234567890", "1234567889", 1);
        ok &= this.test("1234567890", "1234567890", 0);
        ok &= this.test("1234567890", "1234567891", -1);
        ok &= this.test("1234567890", "12345678901234567890", -1);
        ok &= this.test("12345678901234567890", "-12345678901234567890", 1);
        ok &= this.test("12345678901234567890", "-1234567890", 1);
        ok &= this.test("12345678901234567890", "-123", 1);
        ok &= this.test("12345678901234567890", "0", 1);
        ok &= this.test("12345678901234567890", "123", 1);
        ok &= this.test("12345678901234567890", "1234567890", 1);
        ok &= this.test("12345678901234567890", "12345678901234567889", 1);
        ok &= this.test("12345678901234567890", "12345678901234567890", 0);
        if (ok &= this.test("12345678901234567890", "12345678901234567891", -1)) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)"one or more test cases failed");
    }

    boolean test(String s1, String s2, int expectedResult) {
        BigNum bn1 = new BigNum(s1);
        BigNum bn2 = new BigNum(s2);
        int actualResult = bn1.compare(bn2);
        if (actualResult == expectedResult) {
            return true;
        }
        this.err.println("s1: " + s1 + " s2: " + s2 + " expected result: " + expectedResult + " actual result: " + actualResult);
        return false;
    }
}

