/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demots.tests.lists.LinkedList;

import com.sun.demoapi.lists.LinkedList;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import java.io.PrintWriter;

public class RemoveTest
implements Test {
    private PrintWriter err;

    public static void main(String[] args) {
        PrintWriter err = new PrintWriter(System.err, true);
        RemoveTest t = new RemoveTest();
        Status s = t.run(args, null, err);
        s.exit();
    }

    public Status run(String[] args, PrintWriter out, PrintWriter err) {
        this.err = err;
        Integer i0 = new Integer(0);
        Integer i10 = new Integer(10);
        Integer i100 = new Integer(100);
        Integer i1000 = new Integer(1000);
        Integer i10000 = new Integer(10000);
        boolean ok = true;
        ok &= this.test(new Object[]{i0});
        ok &= this.test(new Object[]{i0, i10});
        ok &= this.test(new Object[]{i0, i10, i100});
        ok &= this.test(new Object[]{i0, i10, i100, i1000});
        ok &= this.test(new Object[]{i0, i10, i100, i1000, i10000});
        ok &= this.test(new Object[]{i0, i0, i10, i100});
        ok &= this.test(new Object[]{i0, i10, i0, i100});
        ok &= this.test(new Object[]{i0, i10, i100, i0});
        ok &= this.test(new Object[]{"a"});
        ok &= this.test(new Object[]{"a", "b"});
        ok &= this.test(new Object[]{"a", "b", "c"});
        ok &= this.test(new Object[]{"a", "b", "c", i0});
        ok &= this.test(new Object[]{"a", "b", "c", i0, i10});
        ok &= this.test(new Object[]{"a", "b", "c", i0, i10, i100});
        ok &= this.test(new Object[]{null, "a", "b", "c"});
        ok &= this.test(new Object[]{"a", null, "b", "c"});
        ok &= this.test(new Object[]{"a", "b", null, "c"});
        if (ok &= this.test(new Object[]{"a", "b", "c", null})) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)"one or more test cases failed");
    }

    boolean test(Object[] data) {
        this.err.println("test: " + this.toString(data, 0, data.length));
        boolean ok1 = this.testRemoveFirst(data);
        boolean ok2 = this.testRemoveLast(data);
        boolean ok3 = this.testRemoveMiddle(data);
        return ok1 & ok2 & ok3;
    }

    boolean testRemoveFirst(Object[] data) {
        LinkedList list = this.createList(data);
        Object[] ref = this.copy(data);
        for (int i = 0; i < ref.length; ++i) {
            int refLen = ref.length - i;
            Object o = ref[0];
            list.remove(o);
            if (this.remove(ref, 0, refLen, o)) {
                --refLen;
            }
            if (this.verify(list, ref, 0, refLen)) continue;
            this.err.println("removeFirst mismatch:");
            this.err.println("  expected: " + this.toString(ref, 0, refLen));
            this.err.println("     found: " + list);
            return false;
        }
        return true;
    }

    boolean testRemoveLast(Object[] data) {
        LinkedList list = this.createList(data);
        Object[] ref = this.copy(data);
        for (int i = 0; i < ref.length; ++i) {
            int refLen = ref.length - i;
            Object o = ref[refLen - 1];
            list.remove(o);
            if (this.remove(ref, 0, refLen, o)) {
                --refLen;
            }
            if (this.verify(list, ref, 0, refLen)) continue;
            this.err.println("removeLast mismatch:");
            this.err.println("  expected: " + this.toString(ref, 0, refLen));
            this.err.println("     found: " + list);
            return false;
        }
        return true;
    }

    boolean testRemoveMiddle(Object[] data) {
        LinkedList list = this.createList(data);
        Object[] ref = this.copy(data);
        for (int i = 0; i < ref.length; ++i) {
            int refLen = ref.length - i;
            Object o = ref[refLen / 2];
            list.remove(o);
            if (this.remove(ref, 0, refLen, o)) {
                --refLen;
            }
            if (this.verify(list, ref, 0, refLen)) continue;
            this.err.println("removeLast mismatch:");
            this.err.println("  expected: " + this.toString(ref, 0, refLen));
            this.err.println("     found: " + list);
            return false;
        }
        return true;
    }

    Object[] copy(Object[] data) {
        Object[] d = new Object[data.length];
        System.arraycopy(data, 0, d, 0, data.length);
        return d;
    }

    LinkedList createList(Object[] data) {
        LinkedList list = new LinkedList();
        for (int i = data.length - 1; i >= 0; --i) {
            list.insert(data[i]);
        }
        return list;
    }

    boolean remove(Object[] data, int offset, int length, Object o) {
        for (int i = offset; i < offset + length; ++i) {
            boolean found;
            boolean bl = data[i] == null ? o == null : (found = data[i].equals(o));
            if (!found) continue;
            System.arraycopy(data, i + 1, data, i, offset + length - i - 1);
            return true;
        }
        return false;
    }

    String toString(Object[] array, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            if (i > offset) {
                sb.append(",");
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    boolean verify(LinkedList l, Object[] ref, int offset, int length) {
        int i = offset;
        for (LinkedList.Entry e = l.getFirst(); e != null; e = e.getNext()) {
            if (i < ref.length) {
                Object d = e.getData();
                if (d == null ? ref[i] != null : !d.equals(ref[i])) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return i == offset + length;
    }
}

