/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ChoiceArrayQuestion;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FloatQuestion;
import com.sun.interview.InetAddressQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.ListQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.PropertiesQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringListQuestion;
import com.sun.interview.StringQuestion;
import com.sun.interview.TreeQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.interview.wizard.ChoiceArrayQuestionRenderer;
import com.sun.interview.wizard.ChoiceQuestionRenderer;
import com.sun.interview.wizard.FileListQuestionRenderer;
import com.sun.interview.wizard.FileQuestionRenderer;
import com.sun.interview.wizard.FloatQuestionRenderer;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.InetAddressQuestionRenderer;
import com.sun.interview.wizard.IntQuestionRenderer;
import com.sun.interview.wizard.ListQuestionRenderer;
import com.sun.interview.wizard.NullQuestionRenderer;
import com.sun.interview.wizard.PropertiesQuestionRenderer;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.StringListQuestionRenderer;
import com.sun.interview.wizard.StringQuestionRenderer;
import com.sun.interview.wizard.TreeQuestionRenderer;
import com.sun.interview.wizard.YesNoQuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

class QuestionPanel
extends JPanel
implements Scrollable {
    private Interview interview;
    private Question currentQuestion;
    private QuestionRenderer currentRenderer;
    private JLabel graphicLabel;
    private JTextField titleField;
    private JTextArea textArea;
    private JPanel valuePanel;
    private Runnable valueSaver;
    private JTextField valueMessageField;
    private JPanel propsPanel;
    private JTextField tagField;
    private Map renderers;
    private Map customRenderers;
    private Listener listener = new Listener();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static String INVALID_VALUE = i18n.getString("qu.invalidValue.txt");
    private static Color INVALID_VALUE_COLOR = i18n.getErrorColor();
    private KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private Action valueAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("edited")) {
                QuestionPanel.this.showValueMessage(null);
            } else if (QuestionPanel.this.nextAction != null) {
                QuestionPanel.this.nextAction.actionPerformed(e);
            } else {
                try {
                    QuestionPanel.this.saveCurrentResponse();
                    QuestionPanel.this.interview.next();
                }
                catch (Interview.Fault ex) {
                    QuestionPanel.this.showValueInvalidMessage();
                }
            }
        }
    };
    private Action nextAction;
    private static final int PREFERRED_HEIGHT = 3;
    private static final int PREFERRED_WIDTH = 4;
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    private static final int TEXT_AREA_INSETS_TOP = 20;
    private static final int TEXT_AREA_INSETS_LEFT_RIGHT = 10;
    private static final int TEXT_AREA_INSETS_BOTTOM = 10;
    private static final int VALUE_PANEL_INSETS_TOP = 0;
    private static final int VALUE_PANEL_INSETS_BOTTOM = 10;
    private static final int VALUE_MESSAGE_FIELD_INSETS_TOP = 0;
    private static final int VALUE_MESSAGE_FIELD_INSETS_BOTTOM = 0;
    private static final int PROPS_PANEL_INSETS_TOP = 0;
    private static final int PROPS_PANEL_INSETS_BOTTOM = 10;

    QuestionPanel(Interview i) {
        this.interview = i;
        this.initRenderers();
        this.initGUI();
        this.addAncestorListener(this.listener);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = Math.max(d.height, 3 * DOTS_PER_INCH);
        d.width = Math.max(d.width, 4 * DOTS_PER_INCH);
        return d;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension maxD = new Dimension(4 * DOTS_PER_INCH, 3 * DOTS_PER_INCH);
        Dimension ps = this.getPreferredSize();
        ps.width = Math.min(ps.width, maxD.width);
        ps.height = Math.min(ps.height, maxD.height);
        return ps;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public final boolean getScrollableTracksViewportWidth() {
        return true;
    }

    void setNextAction(Action nextAction) {
        this.nextAction = nextAction;
    }

    void saveCurrentResponse() {
        if (this.valueSaver != null) {
            this.valueSaver.run();
        }
    }

    boolean isTagVisible() {
        return this.propsPanel.isVisible();
    }

    void setTagVisible(boolean v) {
        this.propsPanel.setVisible(v);
    }

    private void initRenderers() {
        this.renderers = new HashMap();
        this.renderers.put(ChoiceQuestion.class, new ChoiceQuestionRenderer());
        this.renderers.put(ChoiceArrayQuestion.class, new ChoiceArrayQuestionRenderer());
        this.renderers.put(FileQuestion.class, new FileQuestionRenderer());
        this.renderers.put(FileListQuestion.class, new FileListQuestionRenderer());
        this.renderers.put(FloatQuestion.class, new FloatQuestionRenderer());
        this.renderers.put(IntQuestion.class, new IntQuestionRenderer());
        this.renderers.put(InetAddressQuestion.class, new InetAddressQuestionRenderer());
        this.renderers.put(ListQuestion.class, new ListQuestionRenderer());
        this.renderers.put(NullQuestion.class, new NullQuestionRenderer());
        this.renderers.put(PropertiesQuestion.class, new PropertiesQuestionRenderer());
        this.renderers.put(StringQuestion.class, new StringQuestionRenderer());
        this.renderers.put(StringListQuestion.class, new StringListQuestionRenderer());
        this.renderers.put(TreeQuestion.class, new TreeQuestionRenderer());
        this.renderers.put(YesNoQuestion.class, new YesNoQuestionRenderer());
        this.setCustomRenderers(new HashMap());
    }

    private void initGUI() {
        URL u;
        this.setInfo(this, "qu", false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.graphicLabel = new JLabel();
        this.setInfo(this.graphicLabel, "qu.icon", false);
        this.graphicLabel.setFocusable(false);
        if (this.interview != null && (u = this.interview.getDefaultImage()) != null) {
            this.graphicLabel.setIcon(new ImageIcon(u));
        }
        c.anchor = 10;
        c.gridheight = 0;
        this.add((Component)this.graphicLabel, c);
        this.titleField = new JTextField();
        this.setInfo(this.titleField, "qu.title", true);
        this.titleField.setEditable(false);
        this.titleField.setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
        this.titleField.setForeground(MetalLookAndFeel.getWindowBackground());
        FontUIResource f = MetalLookAndFeel.getSystemTextFont();
        this.titleField.setFont(f.deriveFont((float)f.getSize() * 1.5f));
        c.fill = 2;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        this.add((Component)this.titleField, c);
        this.textArea = new JTextArea(3, 30);
        this.setInfo(this.textArea, "qu.text", true);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setOpaque(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFocusTraversalKeys(0, null);
        this.textArea.setFocusTraversalKeys(1, null);
        InputMap im = this.textArea.getInputMap();
        im.put(this.enterKey, "next");
        ActionMap am = this.textArea.getActionMap();
        am.put("next", this.valueAction);
        c.insets.top = 20;
        c.insets.right = 10;
        c.insets.left = 10;
        c.insets.bottom = 10;
        c.fill = 1;
        this.add((Component)this.textArea, c);
        this.valuePanel = new JPanel(new BorderLayout());
        this.setInfo(this.valuePanel, "qu.vp", false);
        this.valuePanel.setOpaque(true);
        im = this.valuePanel.getInputMap(1);
        im.put(this.enterKey, "next");
        am = this.valuePanel.getActionMap();
        am.put("next", this.valueAction);
        c.insets.top = 0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets.bottom = 10;
        this.add((Component)this.valuePanel, c);
        c.fill = 1;
        this.valueMessageField = new JTextField();
        this.setInfo(this.valueMessageField, "qu.vmsg", false);
        this.valueMessageField.setEditable(false);
        this.valueMessageField.setOpaque(false);
        this.valueMessageField.setFont(this.valueMessageField.getFont().deriveFont(1));
        this.valueMessageField.setBorder(null);
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.weighty = 0.0;
        this.add((Component)this.valueMessageField, c);
        this.propsPanel = new JPanel(new BorderLayout());
        this.propsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.propsPanel.setName("qu.props.pnl");
        this.propsPanel.setFocusable(false);
        JLabel tagLabel = new JLabel(i18n.getString("qu.tag.lbl"));
        this.setInfo(tagLabel, "qu.tag.lbl", true);
        tagLabel.setDisplayedMnemonic(i18n.getString("qu.tag.mne").charAt(0));
        tagLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 7));
        this.propsPanel.add((Component)tagLabel, "West");
        this.tagField = new JTextField();
        this.tagField.setName("qu.tag.fld");
        this.tagField.setEditable(false);
        this.tagField.setBorder(null);
        tagLabel.setLabelFor(this.tagField);
        this.propsPanel.add((Component)this.tagField, "Center");
        this.propsPanel.setVisible(false);
        c.insets.top = 0;
        c.insets.bottom = 10;
        this.add((Component)this.propsPanel, c);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("hideProps", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                QuestionPanel.this.propsPanel.setVisible(false);
            }
        });
        actionMap.put("showProps", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                QuestionPanel.this.propsPanel.setVisible(true);
            }
        });
        actionMap.put("toggleProps", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                QuestionPanel.this.propsPanel.setVisible(!QuestionPanel.this.propsPanel.isVisible());
            }
        });
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ctrl T"), "toggleProps");
    }

    private void setInfo(JComponent jc, String uiKey, boolean addToolTip) {
        jc.setName(uiKey);
        AccessibleContext ac = jc.getAccessibleContext();
        ac.setAccessibleName(i18n.getString(uiKey + ".name"));
        if (addToolTip) {
            String tip = i18n.getString(uiKey + ".tip");
            jc.setToolTipText(tip);
            ac.setAccessibleDescription(tip);
        } else {
            ac.setAccessibleDescription(i18n.getString(uiKey + ".desc"));
        }
    }

    public void showQuestion(Question q) {
        ImageIcon icon;
        if (q instanceof ErrorQuestion) {
            JTextArea txt = new JTextArea(q.getText());
            txt.setOpaque(false);
            txt.setEditable(false);
            txt.setLineWrap(true);
            txt.setWrapStyleWord(true);
            txt.setSize(new Dimension(5 * DOTS_PER_INCH, Integer.MAX_VALUE));
            JOptionPane.showMessageDialog(this, txt, q.getSummary(), 0);
            try {
                this.interview.prev();
            }
            catch (Interview.Fault ignore) {
                // empty catch block
            }
            return;
        }
        URL u = q.getImage();
        ImageIcon imageIcon = icon = u == null ? null : new ImageIcon(u);
        if (icon != null) {
            this.graphicLabel.setIcon(icon);
        }
        this.titleField.setText(q.getSummary());
        this.textArea.setText(q.getText());
        this.tagField.setText(q.getTag());
        boolean focus = this.anyChildHasFocus(this.valuePanel);
        this.valuePanel.removeAll();
        QuestionRenderer r = this.getRenderer(q);
        if (r == null) {
            this.valueSaver = null;
        } else {
            JComponent rc = r.getQuestionRendererComponent(q, this.valueAction);
            if (rc == null) {
                this.valueSaver = null;
                if (focus) {
                    this.textArea.requestFocus();
                }
            } else {
                if (rc.getName() == null) {
                    rc.setName(r.getClass().getName());
                }
                this.valueSaver = (Runnable)rc.getClientProperty("valueSaver");
                this.valuePanel.add(rc);
                if (focus) {
                    FocusManager fm = FocusManager.getCurrentManager();
                    fm.focusNextComponent(this.textArea);
                }
            }
        }
        if (q.isValueAlwaysValid()) {
            this.valueMessageField.setVisible(false);
        } else {
            this.showValueMessage(null);
            this.valueMessageField.setVisible(true);
        }
        this.revalidate();
        this.repaint();
        this.currentRenderer = r;
        this.currentQuestion = q;
    }

    public void prepareClosing() {
        if (this.currentRenderer instanceof PropertiesQuestionRenderer) {
            AncestorEvent e = new AncestorEvent(this, 2, this.valuePanel, this.valuePanel.getParent());
            Component[] childs = this.valuePanel.getComponents();
            for (int i = 0; i < childs.length; ++i) {
                EventListener[] l = childs[i].getListeners(AncestorListener.class);
                for (int j = 0; j < l.length; ++j) {
                    if (!(l[i] instanceof AncestorListener)) continue;
                    ((AncestorListener)l[i]).ancestorRemoved(e);
                }
            }
        }
    }

    public void showValueInvalidMessage() {
        String msg = this.currentRenderer == null ? null : this.currentRenderer.getInvalidValueMessage(this.currentQuestion);
        this.showValueMessage(msg == null ? INVALID_VALUE : msg, INVALID_VALUE_COLOR);
    }

    private void showValueMessage(String msg) {
        this.showValueMessage(msg, MetalLookAndFeel.getBlack());
    }

    private void showValueMessage(String msg, Color c) {
        if (msg == null || msg.length() == 0) {
            this.valueMessageField.setText("");
            this.valueMessageField.setEnabled(false);
        } else {
            this.valueMessageField.setForeground(c);
            this.valueMessageField.setText(msg);
            this.valueMessageField.setEnabled(true);
        }
    }

    private QuestionRenderer getRenderer(Question q) {
        QuestionRenderer result = null;
        if (this.customRenderers != null) {
            result = this.getRenderer(q, this.customRenderers);
        }
        if (result == null) {
            result = this.getRenderer(q, this.renderers);
        }
        return result;
    }

    private QuestionRenderer getRenderer(Question q, Map rendMap) {
        for (Class<?> c = q.getClass(); c != null; c = c.getSuperclass()) {
            QuestionRenderer r = (QuestionRenderer)rendMap.get(c);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private boolean anyChildHasFocus(JPanel p) {
        if (p.hasFocus()) {
            return true;
        }
        for (int i = 0; i < p.getComponentCount(); ++i) {
            Component c = p.getComponent(i);
            if ((!(c instanceof JComponent) || !((JComponent)c).hasFocus()) && (!(c instanceof JPanel) || !this.anyChildHasFocus((JPanel)c))) continue;
            return true;
        }
        return false;
    }

    public void setCustomRenderers(Map customRenderers) {
        this.customRenderers = customRenderers;
    }

    private class Listener
    implements AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        public void ancestorAdded(AncestorEvent e) {
            QuestionPanel.this.interview.addObserver(this);
            QuestionPanel.this.showQuestion(QuestionPanel.this.interview.getCurrentQuestion());
        }

        public void ancestorMoved(AncestorEvent e) {
        }

        public void ancestorRemoved(AncestorEvent e) {
            QuestionPanel.this.interview.removeObserver(this);
        }

        public void pathUpdated() {
            QuestionPanel.this.showValueMessage(null);
        }

        public void currentQuestionChanged(Question q) {
            QuestionPanel.this.showQuestion(q);
        }

        public void finished() {
        }
    }
}

