/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeQuestionRenderer
implements QuestionRenderer {
    protected static final int NONE_SELECTED = 0;
    protected static final int SOME_SELECTED = 1;
    protected static final int ALL_SELECTED = 2;
    protected static Icon[] folderIcons;
    protected static Icon[] leafIcons;
    private static final I18NResourceBundle i18n;

    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        final TreeQuestion tq = (TreeQuestion)qq;
        final TQTree tree = new TQTree(tq.getModel(), listener);
        tree.setName("tree");
        tree.setToolTipText(i18n.getString("tree.tip"));
        tree.getAccessibleContext().setAccessibleName(tree.getName());
        tree.getAccessibleContext().setAccessibleDescription(tree.getToolTipText());
        JScrollPane sp = new JScrollPane(tree);
        tree.setSelection(tq.getValue());
        Runnable valueSaver = new Runnable(){

            public void run() {
                tq.setValue(tree.getSelection());
            }
        };
        sp.putClientProperty("valueSaver", valueSaver);
        return sp;
    }

    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected TQNode createTQTreeRoot(TQTree tree, TQNode parent, Object clientNode) {
        return new TQNode(tree, parent, clientNode);
    }

    protected TQModel createTQTreeModel(TQNode root) {
        return new TQModel(root);
    }

    protected TQRenderer createTQTreeCellRenderer() {
        return new TQRenderer();
    }

    protected TQListener createTQTreeListener(ActionListener editedListener) {
        return new TQListener(editedListener);
    }

    static {
        i18n = I18NResourceBundle.getDefaultBundle();
    }

    public static class LeafIcon
    implements Icon {
        protected int style;
        protected Image image;
        protected static final int width = 16;
        protected static final int height = 16;

        public LeafIcon(int style) {
            this.style = style;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics imageG = this.image.getGraphics();
                this.paintMe(c, imageG);
                imageG.dispose();
            }
            g.drawImage(this.image, x, y, null);
        }

        protected void paintMe(Component c, Graphics g) {
            int right = 15;
            int bottom = 15;
            g.setColor(MetalLookAndFeel.getWindowBackground());
            g.fillRect(4, 2, 9, 12);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(2, 0, 2, bottom);
            g.drawLine(2, 0, right - 4, 0);
            g.drawLine(2, bottom, right - 1, bottom);
            g.drawLine(right - 1, 6, right - 1, bottom);
            g.drawLine(right - 6, 2, right - 2, 6);
            g.drawLine(right - 5, 1, right - 4, 1);
            g.drawLine(right - 3, 2, right - 3, 3);
            g.drawLine(right - 2, 4, right - 2, 5);
            switch (this.style) {
                case 0: {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawLine(3, 1, 3, bottom - 1);
                    g.drawLine(3, 1, right - 6, 1);
                    g.drawLine(right - 2, 7, right - 2, bottom - 1);
                    g.drawLine(right - 5, 2, right - 3, 4);
                    g.drawLine(3, bottom - 1, right - 2, bottom - 1);
                    break;
                }
                case 2: {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawLine(4, 2, 9, 2);
                    g.drawLine(4, 3, 9, 3);
                    g.drawLine(4, 4, 10, 4);
                    g.drawLine(4, 5, 10, 5);
                    g.drawLine(4, 6, 11, 6);
                    g.fillRect(4, 6, 10, 9);
                }
            }
        }
    }

    public static class FolderIcon
    implements Icon {
        protected int style;
        protected Image image;
        protected static final int width = 16;
        protected static final int height = 16;

        FolderIcon(int style) {
            this.style = style;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics imageG = this.image.getGraphics();
                this.paintMe(c, imageG);
                imageG.dispose();
            }
            g.drawImage(this.image, x, y - 1, null);
        }

        protected void paintMe(Component c, Graphics g) {
            int right = 15;
            int bottom = 15;
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(right - 5, 3, right, 3);
            g.drawLine(right - 6, 4, right, 4);
            g.setColor(MetalLookAndFeel.getPrimaryControl());
            g.fillRect(2, 7, 13, 8);
            switch (this.style) {
                case 0: {
                    g.setColor(Color.white);
                    g.fillRect(2, 7, 13, 8);
                    break;
                }
                case 1: {
                    g.setColor(Color.white);
                    for (int i = 0; i < 8; ++i) {
                        g.drawLine(4 + i, 7 + i, 18, 7 + i);
                    }
                    break;
                }
            }
            g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            g.drawLine(right - 6, 5, right - 1, 5);
            g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            g.drawLine(0, 6, 0, bottom);
            g.drawLine(1, 5, right - 7, 5);
            g.drawLine(right - 6, 6, right - 1, 6);
            g.drawLine(right, 5, right, bottom);
            g.drawLine(0, bottom, right, bottom);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(1, 6, 1, bottom - 1);
            g.drawLine(1, 6, right - 7, 6);
            g.drawLine(right - 6, 7, right - 1, 7);
        }
    }

    protected class TQListener
    implements TreeExpansionListener,
    TreeSelectionListener {
        private boolean ignoreEvents;
        protected ActionListener editedListener;
        protected Vector vector;

        public TQListener(ActionListener editedListener) {
            this.editedListener = editedListener;
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            TreePath p = e.getPath();
            TQNode node = (TQNode)p.getLastPathComponent();
            this.vector = new Vector();
            this.vector.add(p);
            TQTree tree = (TQTree)e.getSource();
            TreePath[] paths = tree.getSelectionPaths();
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    if (!p.isDescendant(paths[i])) continue;
                    this.vector.add(paths[i]);
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent e) {
            this.vector = null;
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (this.ignoreEvents) {
                return;
            }
            TQTree tree = (TQTree)e.getSource();
            TreePath[] paths = e.getPaths();
            if (this.vector != null) {
                boolean contains = true;
                for (int i = 0; i < paths.length; ++i) {
                    if (this.vector.contains(paths[i])) continue;
                    contains = false;
                    break;
                }
                if (!contains) {
                    this.vector = null;
                } else {
                    HashSet<TreePath> added = new HashSet<TreePath>();
                    HashSet<TreePath> removed = new HashSet<TreePath>();
                    for (int i = 0; i < paths.length; ++i) {
                        if (!e.isAddedPath(paths[i])) {
                            added.add(paths[i]);
                            continue;
                        }
                        removed.add(paths[i]);
                    }
                    this.setIgnoreEvents(true);
                    tree.getSelectionModel().addSelectionPaths(added.toArray(new TreePath[0]));
                    tree.getSelectionModel().removeSelectionPaths(removed.toArray(new TreePath[0]));
                    this.setIgnoreEvents(false);
                    return;
                }
            }
            for (int i = 0; i < paths.length; ++i) {
                TreePath p = paths[i];
                TQNode node = (TQNode)p.getLastPathComponent();
                if (e.isAddedPath(p)) {
                    node.setSelected(true);
                    continue;
                }
                node.setSelected(false);
            }
            TreePath p = e.getNewLeadSelectionPath();
            if (p != null) {
                TQNode node = (TQNode)p.getLastPathComponent();
                node.setSelected(true);
            }
            ActionEvent ae = new ActionEvent(e.getSource(), 1001, "edited");
            this.editedListener.actionPerformed(ae);
        }

        protected void setIgnoreEvents(boolean b) {
            this.ignoreEvents = b;
        }
    }

    protected class TQRenderer
    extends DefaultTreeCellRenderer {
        protected int style;

        public TQRenderer() {
            if (folderIcons == null) {
                folderIcons = new FolderIcon[3];
                TreeQuestionRenderer.folderIcons[0] = new FolderIcon(0);
                TreeQuestionRenderer.folderIcons[1] = new FolderIcon(1);
                TreeQuestionRenderer.folderIcons[2] = new FolderIcon(2);
            }
            if (leafIcons == null) {
                leafIcons = new LeafIcon[3];
                TreeQuestionRenderer.leafIcons[0] = new LeafIcon(0);
                TreeQuestionRenderer.leafIcons[2] = new LeafIcon(2);
            }
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TQModel model = (TQModel)tree.getModel();
            TQNode node = (TQNode)value;
            value = model.getName(node);
            this.style = node.selectState;
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }

        public Icon getOpenIcon() {
            return folderIcons[this.style];
        }

        public Icon getClosedIcon() {
            return folderIcons[this.style];
        }

        public Icon getLeafIcon() {
            return leafIcons[this.style];
        }
    }

    protected class TQModel
    implements TreeModel {
        protected TQNode root;
        protected EventListenerList listenerList = new EventListenerList();

        public TQModel(TQNode root) {
            this.root = root;
        }

        public String getName(Object node) {
            return ((TQNode)node).getName();
        }

        public Object getChild(Object parent, int index) {
            return ((TQNode)parent).getChild(index);
        }

        public int getChildCount(Object parent) {
            return ((TQNode)parent).getChildCount();
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((TQNode)parent).getIndexOfChild((TQNode)child);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return ((TQNode)node).isLeaf();
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException();
        }

        void fireTreeNodesChanged(TQTree tree, TQNode node) {
            TreeModelEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TreeModelListener.class) continue;
                if (event == null) {
                    event = new TreeModelEvent((Object)tree, tree.getTreePath(node));
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(event);
            }
        }
    }

    protected class TQNode {
        protected TQTree tree;
        protected TQNode parent;
        protected TQNode[] children;
        protected int selectState;
        protected Object clientNode;

        public TQNode(TQTree tree, TQNode parent, Object clientNode) {
            if (tree == null || clientNode == null) {
                throw new NullPointerException();
            }
            this.tree = tree;
            this.parent = parent;
            this.clientNode = clientNode;
        }

        public String toString() {
            return this.getName();
        }

        protected String getName() {
            return this.tree.clientModel.getName(this.clientNode);
        }

        protected int getChildCount() {
            return this.children == null ? this.tree.clientModel.getChildCount(this.clientNode) : this.children.length;
        }

        protected TQNode getChild(int index) {
            if (this.children == null) {
                this.initChildren();
            }
            return this.children[index];
        }

        protected boolean isLeaf() {
            return this.tree.clientModel.isLeaf(this.clientNode);
        }

        protected int getIndexOfChild(TQNode child) {
            if (this.children == null) {
                this.initChildren();
            }
            for (int i = 0; i < this.children.length; ++i) {
                if (child != this.children[i]) continue;
                return i;
            }
            return -1;
        }

        protected void setSelected(boolean b) {
            if (b && this.selectState == 2 || !b && this.selectState == 0) {
                return;
            }
            this.setSelectState(b ? 2 : 0);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].setSelected(b);
                }
            }
            TQNode n = this;
            TQNode p = this.parent;
            while (p != null) {
                int state = p.children[0].selectState;
                for (int i = 1; i < p.children.length && state != 1; ++i) {
                    TQNode c = p.children[i];
                    if ((state != 2 || c.selectState == 2) && (state != 0 || c.selectState == 0)) continue;
                    state = 1;
                }
                if (p.selectState == state) break;
                p.setSelectState(state);
                n = p;
                p = n.parent;
            }
        }

        private void setSelectState(int newState) {
            if (this.selectState == newState) {
                return;
            }
            if (this.selectState == 2) {
                this.tree.removeFromSelection(this);
            }
            this.selectState = newState;
            ((TQModel)this.tree.getModel()).fireTreeNodesChanged(this.tree, this);
            if (this.selectState == 2) {
                this.tree.addToSelection(this);
            }
        }

        private void initChildren() {
            int i;
            this.children = new TQNode[this.getChildCount()];
            for (i = 0; i < this.children.length; ++i) {
                this.children[i] = new TQNode(this.tree, this, this.tree.clientModel.getChild(this.clientNode, i));
            }
            if (this.selectState == 2) {
                for (i = 0; i < this.children.length; ++i) {
                    this.children[i].setSelectState(2);
                }
            }
        }
    }

    protected class TQTree
    extends JTree {
        protected TreeQuestion.Model clientModel;
        protected TQListener listener;
        protected TQNode root;

        public TQTree(TreeQuestion.Model model, ActionListener editedListener) {
            this.clientModel = model;
            this.listener = TreeQuestionRenderer.this.createTQTreeListener(editedListener);
            this.addTreeSelectionListener(this.listener);
            this.addTreeExpansionListener(this.listener);
            this.root = TreeQuestionRenderer.this.createTQTreeRoot(this, null, this.clientModel.getRoot());
            this.setModel(TreeQuestionRenderer.this.createTQTreeModel(this.root));
            this.setCellRenderer(TreeQuestionRenderer.this.createTQTreeCellRenderer());
            this.setExpandsSelectedPaths(false);
        }

        protected String[] getSelection() {
            Vector v = new Vector();
            this.getSelection(this.root, v);
            Object[] paths = new String[v.size()];
            v.copyInto(paths);
            return paths;
        }

        private void getSelection(TQNode node, Vector v) {
            switch (node.selectState) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        this.getSelection(node.getChild(i), v);
                    }
                    break;
                }
                case 2: {
                    v.add(this.getPath(node));
                }
            }
        }

        protected void setSelection(String[] paths) {
            if (paths == null || paths.length == 0) {
                this.root.setSelected(true);
            } else {
                this.root.setSelected(false);
                if (paths != null) {
                    for (int i = 0; i < paths.length; ++i) {
                        TQNode node = this.getNode(this.root, paths[i]);
                        if (node == null) continue;
                        node.setSelected(true);
                    }
                }
            }
        }

        protected void addToSelection(TQNode node) {
            this.listener.setIgnoreEvents(true);
            TreePath p = this.getTreePath(node);
            this.getSelectionModel().addSelectionPath(p);
            this.listener.setIgnoreEvents(false);
        }

        protected void removeFromSelection(TQNode node) {
            this.listener.setIgnoreEvents(true);
            TreePath p = this.getTreePath(node);
            this.getSelectionModel().removeSelectionPath(p);
            this.listener.setIgnoreEvents(false);
        }

        private TQNode getNode(TQNode node, String path) {
            String tail;
            String head;
            if (node == null) {
                throw new NullPointerException();
            }
            if (path.length() == 0) {
                return node;
            }
            int sep = path.indexOf("/");
            if (sep == -1) {
                head = path;
                tail = null;
            } else {
                head = path.substring(0, sep);
                tail = path.substring(sep + 1);
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                TQNode c = node.getChild(i);
                if (!c.getName().equals(head)) continue;
                return tail == null ? c : this.getNode(c, tail);
            }
            return null;
        }

        protected String getPath(TQNode node) {
            return this.getPath(node, 0).toString();
        }

        private StringBuffer getPath(TQNode node, int length) {
            if (node.parent == null) {
                return new StringBuffer(length);
            }
            String nodeName = node.getName();
            StringBuffer sb = this.getPath(node.parent, 1 + nodeName.length() + length);
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(nodeName);
            return sb;
        }

        protected TreePath getTreePath(TQNode node) {
            if (node.parent == null) {
                return new TreePath(node);
            }
            return this.getTreePath(node.parent).pathByAddingChild(node);
        }
    }
}

