/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Harness;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BP_BranchSubpanel;
import com.sun.javatest.exec.BP_Model;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.TT_BasicNode;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TT_TestNode;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TestTreePanel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class BP_TestListSubpanel
extends BP_BranchSubpanel {
    private int state;
    private JTable table;
    private TestTableModel mod;
    private TT_NodeCache cache;
    private CacheObserver cacheWatcher;
    private volatile TableSynchronizer resyncThread;
    private TableCellRenderer renderer;
    private InputListener listener;
    private JTextArea infoTL;
    private boolean rowHeightSet;
    private static final int ROW_HEIGHT_PADDING = 3;
    private static final int WAIT_DIALOG_DELAY = 3000;
    private JPopupMenu popupTable;
    private JPopupMenu popupHeader;
    private JMenu showDescrMenu;
    private JMenu showRunMenu;
    private JMenu sortMenu;
    private Harness harness;
    private ExecModel execModel;
    private boolean debug = Debug.getBoolean(BP_TestListSubpanel.class);
    private boolean sortingRequested = false;
    private String show = "execStatus";
    private Vector[] newData;
    private boolean updateRequired;

    BP_TestListSubpanel(UIFactory uif, Harness h, ExecModel em, BP_Model bpm, TestTreeModel ttm, int state) {
        super("tl" + state, uif, bpm, ttm, "br.list");
        this.state = state;
        this.harness = h;
        this.execModel = em;
        this.init();
        switch (state) {
            case 0: {
                CSH.setHelpIDString(this, "browse.passedTab.csh");
                break;
            }
            case 1: {
                CSH.setHelpIDString(this, "browse.failedTab.csh");
                break;
            }
            case 2: {
                CSH.setHelpIDString(this, "browse.errorTab.csh");
                break;
            }
            case 3: {
                CSH.setHelpIDString(this, "browse.notRunTab.csh");
                break;
            }
            case 4: {
                CSH.setHelpIDString(this, "browse.filteredOutTab.csh");
            }
        }
        this.cacheWatcher = new CacheObserver(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(TT_NodeCache cache) {
        if (this.cache != null) {
            TT_NodeCache cacheCopy;
            TT_NodeCache tT_NodeCache = cacheCopy = this.cache;
            synchronized (tT_NodeCache) {
                BP_TestListSubpanel bP_TestListSubpanel = this;
                synchronized (bP_TestListSubpanel) {
                    cacheCopy.removeObserver(this.cacheWatcher);
                }
            }
        }
        BP_TestListSubpanel bP_TestListSubpanel = this;
        synchronized (bP_TestListSubpanel) {
            this.cache = cache;
            if (this.resyncThread != null) {
                this.resyncThread.halt();
            }
            if (this.mod != null) {
                this.mod.reset();
            }
        }
        this.validateEnableState();
    }

    protected void invalidateFilters() {
        super.invalidateFilters();
        if (this.cache != null) {
            this.cache.removeObserver(this.cacheWatcher);
            if (this.subpanelNode != null) {
                this.cache = this.ttm.getNodeInfo(this.subpanelNode.getTableNode(), false);
                this.validateEnableState();
            }
        }
    }

    public void setUpdateRequired(boolean updateRequired) {
        this.updateRequired = updateRequired;
    }

    protected synchronized void updateSubpanel(TT_BasicNode currNode) {
        super.updateSubpanel(currNode);
        if (this.debug) {
            Debug.println("updating test list " + this.state);
            Debug.println("  -> size " + (this.mod == null ? 0 : this.mod.getRowCount()));
        }
        if (this.updateRequired || this.filtersInvalidated) {
            if (this.resyncThread != null) {
                this.resyncThread.halt();
            }
            this.resyncThread = new TableSynchronizer(this.state);
            this.resyncThread.start();
            this.filtersInvalidated = false;
            this.validateEnableState();
            this.updateRequired = false;
        }
    }

    private void validateEnableState() {
        if (this.state < 4) {
            if (this.cache.getStats()[this.state] > 0) {
                this.model.setEnabled(this, true);
            } else if (this.cache.getStats()[this.state] == 0) {
                this.model.setEnabled(this, false);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void init() {
        this.mod = new TestTableModel(this.uif);
        this.renderer = new TestCellRenderer(this.uif);
        this.listener = new InputListener();
        this.table = this.uif.createTable("br.fo.tbl", this.mod);
        this.table.setOpaque(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this.listener);
        TableColumn tc = this.table.getColumnModel().getColumn(0);
        tc.setCellRenderer(this.renderer);
        tc.setResizable(true);
        tc = this.table.getColumnModel().getColumn(1);
        tc.setCellRenderer(this.renderer);
        tc.setResizable(true);
        this.uif.setAccessibleInfo(this, "br.fo");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.gridy = 0;
        gbc.ipady = 12;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.infoTL = this.uif.createMessageArea("br.tl.info");
        this.infoTL.setOpaque(false);
        this.add((Component)this.infoTL, gbc);
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.uif.createScrollPane(this.table, 20, 30), gbc);
        InputListener tableListener = new InputListener();
        this.table.addMouseListener(tableListener);
        this.table.getTableHeader().addMouseListener(tableListener);
        this.table.getSelectionModel().addListSelectionListener(tableListener);
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "gotoTest");
        this.table.getActionMap().put("gotoTest", new KbTableAction(this.uif.getI18NResourceBundle(), "br.list.enter"));
        String[] showDescr = new String[]{"show.title", "show.keywords"};
        this.showDescrMenu = this.uif.createMenu("br.description", showDescr, tableListener);
        String[] showRun = new String[]{"show.status", "show.time.start", "show.time.end"};
        this.showRunMenu = this.uif.createMenu("br.runtime", showRun, tableListener);
        this.popupHeader = this.uif.createPopupMenu("br");
        this.popupHeader.add(this.showDescrMenu);
        this.popupHeader.add(this.showRunMenu);
        String[] actions = new String[]{"action.run", "action.clear"};
        this.popupTable = this.uif.createPopupMenu("br", actions, tableListener);
        if (this.state == 3) {
            this.showRunMenu.setEnabled(false);
            this.popupTable.getComponent(1).setEnabled(false);
        }
        actions = new String[]{"action.cpnamelist", "action.cpnamestr"};
        this.popupTable.add(this.uif.createMenu("br.cp", actions, tableListener));
        this.setMinimumSize(new Dimension(150, 100));
    }

    static /* synthetic */ Vector[] access$102(BP_TestListSubpanel x0, Vector[] x1) {
        x0.newData = x1;
        return x1;
    }

    class TestCellRenderer
    extends DefaultTableCellRenderer {
        private Border spacerBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);

        public TestCellRenderer(UIFactory uif) {
            this.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            if (value instanceof TestResult) {
                TestResult tr = (TestResult)value;
                this.setText(tr.getTestName());
                this.setToolTipText(I18NUtils.getStatusMessage(tr.getStatus()));
            } else if (value instanceof TT_TestNode) {
                TestResult tr = ((TT_TestNode)value).getTestResult();
                this.setText(tr.getTestName());
                this.setToolTipText(I18NUtils.getStatusMessage(tr.getStatus()));
            } else {
                this.setText(value.toString());
            }
            this.setBorder(this.spacerBorder);
            this.setFont(this.getFont().deriveFont(0));
            if (isSelected) {
                this.setOpaque(true);
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(Color.black);
                this.setOpaque(false);
            }
            if (!BP_TestListSubpanel.this.rowHeightSet) {
                table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 3);
                BP_TestListSubpanel.this.rowHeightSet = true;
            }
            return this;
        }
    }

    private class KbTableAction
    extends AbstractAction {
        private String name;
        private String desc;

        KbTableAction(I18NResourceBundle bund, String key) {
            this.desc = bund.getString(key + ".desc");
            this.name = bund.getString(key + ".act");
        }

        public void actionPerformed(ActionEvent e) {
            int row = BP_TestListSubpanel.this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            Object target = BP_TestListSubpanel.this.table.getModel().getValueAt(row, 0);
            if (!(target instanceof TestResult)) {
                return;
            }
            TestResult tr = (TestResult)target;
            BP_TestListSubpanel.this.showTest(tr);
        }

        public Object getValue(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (key.equals("Name")) {
                return this.name;
            }
            if (key.equals("ShortDescription")) {
                return this.desc;
            }
            return null;
        }
    }

    class InputListener
    extends MouseAdapter
    implements ListSelectionListener,
    ActionListener {
        private int lastIndex = -2;

        InputListener() {
        }

        public void actionPerformed(ActionEvent e) {
            final int[] rows = BP_TestListSubpanel.this.table.getSelectedRows();
            if (e.getActionCommand().equals("action.clear")) {
                if (rows.length > 0) {
                    final WorkDirectory wd = BP_TestListSubpanel.this.execModel.getWorkDirectory();
                    if (BP_TestListSubpanel.this.harness.isRunning()) {
                        BP_TestListSubpanel.this.uif.showInformationDialog("treep.cantPurgeRunning", null);
                        return;
                    }
                    Object[] toPurge = new Object[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        Object item = BP_TestListSubpanel.this.table.getValueAt(rows[i], 0);
                        if (!(item instanceof TestResult)) continue;
                        toPurge[i] = ((TestResult)item).getWorkRelativePath();
                    }
                    int confirm = BP_TestListSubpanel.this.uif.showYesNoDialog("treep.purgeItemsSure", TestTreePanel.createNodeListString(TestTreePanel.createNodeList(toPurge)));
                    if (confirm == 1) {
                        return;
                    }
                    final JDialog d = BP_TestListSubpanel.this.uif.createWaitDialog("treep.waitPurge", BP_TestListSubpanel.this.table);
                    final String[] finalList = TestTreePanel.createNodeList(toPurge);
                    final Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        public void run() {
                            for (int i = 0; i < rows.length; ++i) {
                                for (int j = 0; j < finalList.length; ++j) {
                                    wd.purge(finalList[j]);
                                }
                                try {
                                    EventQueue.invokeAndWait(new Runnable(){

                                        public void run() {
                                            if (d.isShowing()) {
                                                d.hide();
                                            }
                                        }
                                    });
                                }
                                catch (InterruptedException e) {
                                }
                                catch (InvocationTargetException e) {}
                                continue;
                                catch (WorkDirectory.PurgeFault f) {
                                    try {
                                        I18NResourceBundle i18n = BP_TestListSubpanel.this.uif.getI18NResourceBundle();
                                        wd.log(i18n, "treep.purgeFail.err", f);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                        }
                                        catch (InterruptedException e) {
                                        }
                                        catch (InvocationTargetException e) {
                                            // empty catch block
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    catch (InterruptedException e) {
                                    }
                                    catch (InvocationTargetException invocationTargetException) {}
                                    continue;
                                }
                            }
                        }
                    };
                    ActionListener al = new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            if (t == null) {
                                return;
                            }
                            if (t.isAlive() && !d.isVisible()) {
                                d.show();
                            } else if (!t.isAlive() && d.isVisible()) {
                                d.hide();
                            }
                        }
                    };
                    Timer timer = new Timer(3000, al);
                    timer.setRepeats(false);
                    timer.start();
                    t.start();
                }
            } else if (e.getActionCommand().equals("action.run")) {
                if (rows.length > 0) {
                    if (BP_TestListSubpanel.this.harness.isRunning()) {
                        BP_TestListSubpanel.this.uif.showInformationDialog("treep.cantRunRunning", null);
                        return;
                    }
                    String[] result = new String[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        if (BP_TestListSubpanel.this.table.getValueAt(rows[i], 0) instanceof TestResult) {
                            TestResult r = (TestResult)BP_TestListSubpanel.this.table.getValueAt(rows[i], 0);
                            result[i] = r.getTestName();
                            continue;
                        }
                        result[i] = BP_TestListSubpanel.this.table.getValueAt(rows[i], 0).toString();
                    }
                    BP_TestListSubpanel.this.execModel.runTests(result);
                }
            } else if (e.getActionCommand().equals("action.cpnamelist") || e.getActionCommand().equals("action.cpnamestr")) {
                if (rows.length > 0) {
                    if (BP_TestListSubpanel.this.harness.isRunning()) {
                        BP_TestListSubpanel.this.uif.showInformationDialog("bp.cp.isRunning", null);
                        return;
                    }
                    String[] result = new String[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        if (BP_TestListSubpanel.this.table.getValueAt(rows[i], 0) instanceof TestResult) {
                            TestResult r = (TestResult)BP_TestListSubpanel.this.table.getValueAt(rows[i], 0);
                            result[i] = r.getTestName();
                            continue;
                        }
                        result[i] = BP_TestListSubpanel.this.table.getValueAt(rows[i], 0).toString();
                    }
                    StringSelection payload = null;
                    payload = e.getActionCommand().equals("action.cpnamestr") ? new StringSelection(StringArray.join(result)) : new StringSelection(StringArray.join(result, "\n"));
                    if (payload != null) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(payload, null);
                        Clipboard selection = Toolkit.getDefaultToolkit().getSystemSelection();
                        if (selection != null) {
                            selection.setContents(payload, null);
                        }
                    }
                }
            } else if (e.getActionCommand().equals("show.title")) {
                BP_TestListSubpanel.this.table.getColumnModel().getColumn(1).setHeaderValue(BP_TestListSubpanel.this.uif.getI18NString("br.description.show.title.mit"));
                BP_TestListSubpanel.this.table.getTableHeader().resizeAndRepaint();
                BP_TestListSubpanel.this.show = "title";
            } else if (e.getActionCommand().equals("show.keywords")) {
                BP_TestListSubpanel.this.table.getColumnModel().getColumn(1).setHeaderValue(BP_TestListSubpanel.this.uif.getI18NString("br.description.show.keywords.mit"));
                BP_TestListSubpanel.this.table.getTableHeader().resizeAndRepaint();
                BP_TestListSubpanel.this.show = "keywords";
            } else if (e.getActionCommand().equals("show.status")) {
                BP_TestListSubpanel.this.table.getColumnModel().getColumn(1).setHeaderValue(BP_TestListSubpanel.this.uif.getI18NString("br.runtime.show.status.mit"));
                BP_TestListSubpanel.this.table.getTableHeader().resizeAndRepaint();
                BP_TestListSubpanel.this.show = "execStatus";
            } else if (e.getActionCommand().equals("show.time.start")) {
                BP_TestListSubpanel.this.table.getColumnModel().getColumn(1).setHeaderValue(BP_TestListSubpanel.this.uif.getI18NString("br.runtime.show.time.start.mit"));
                BP_TestListSubpanel.this.table.getTableHeader().resizeAndRepaint();
                BP_TestListSubpanel.this.show = "start";
            } else if (e.getActionCommand().equals("show.time.end")) {
                BP_TestListSubpanel.this.table.getColumnModel().getColumn(1).setHeaderValue(BP_TestListSubpanel.this.uif.getI18NString("br.runtime.show.time.end.mit"));
                BP_TestListSubpanel.this.table.getTableHeader().resizeAndRepaint();
                BP_TestListSubpanel.this.show = "end";
            }
            BP_TestListSubpanel.this.table.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getComponent() == BP_TestListSubpanel.this.table) {
                if (e.getButton() == 3) {
                    BP_TestListSubpanel.this.popupTable.show(e.getComponent(), e.getX(), e.getY());
                } else {
                    JTable tbl = (JTable)e.getComponent();
                    int col = BP_TestListSubpanel.this.table.columnAtPoint(e.getPoint());
                    int row = BP_TestListSubpanel.this.table.rowAtPoint(e.getPoint());
                    TableModel tm = BP_TestListSubpanel.this.table.getModel();
                    if (tm.getRowCount() < 1) {
                        BP_TestListSubpanel.this.showMessage("");
                        return;
                    }
                    TestResult tr = (TestResult)tm.getValueAt(row, 0);
                    if (e.getClickCount() == 1) {
                        BP_TestListSubpanel.this.showMessage(I18NUtils.getStatusMessage(tr.getStatus()));
                    } else if (e.getClickCount() == 2) {
                        BP_TestListSubpanel.this.showTest(tr);
                    }
                }
            } else if (e.getComponent() == BP_TestListSubpanel.this.table.getTableHeader()) {
                if (e.getButton() == 3) {
                    BP_TestListSubpanel.this.popupHeader.show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getButton() == 1) {
                    int tableColumn = BP_TestListSubpanel.this.table.columnAtPoint(e.getPoint());
                    int modelColumn = BP_TestListSubpanel.this.table.convertColumnIndexToModel(tableColumn);
                    BP_TestListSubpanel.this.mod.SORTING_COLUMN = modelColumn;
                    BP_TestListSubpanel.this.mod.SORTING_MODE = !BP_TestListSubpanel.this.mod.SORTING_MODE;
                    BP_TestListSubpanel.this.sortingRequested = true;
                    BP_TestListSubpanel.this.mod.sortTests(BP_TestListSubpanel.this.mod.liveData, BP_TestListSubpanel.this.mod.SORTING_COLUMN, BP_TestListSubpanel.this.mod.SORTING_MODE);
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = e.getLastIndex();
            if (BP_TestListSubpanel.this.mod.getRowCount() == 0 || index >= BP_TestListSubpanel.this.mod.getRowCount()) {
                return;
            }
            if (index != this.lastIndex) {
                TestResult tr = (TestResult)BP_TestListSubpanel.this.mod.getValueAt(index, 0);
                BP_TestListSubpanel.this.showMessage(I18NUtils.getStatusMessage(tr.getStatus()));
                this.lastIndex = index;
            }
        }
    }

    class TableNotifier
    implements Runnable {
        TT_BasicNode node;
        TestTableModel tm;
        private TableModelEvent tme;
        private boolean isValid = true;

        TableNotifier(TT_BasicNode n, TestTableModel m) {
            this.node = n;
            this.tm = m;
            this.tm.isUpdateScheduled = true;
        }

        TableNotifier(TableModelEvent e, TestTableModel m) {
            this.tm = m;
            this.tme = e;
        }

        public void run() {
            this.tm.pendingEvents.remove(this);
            if (!this.isValid) {
                return;
            }
            if (this.tme == null) {
                this.tm.isUpdateScheduled = false;
                this.tm.goLive();
            } else {
                this.tm.fireTableChanged(this.tme);
            }
        }

        public void cancel() {
            this.isValid = false;
        }
    }

    private class CacheObserver
    extends TT_NodeCache.TT_NodeCacheObserver {
        CacheObserver(int state) {
            this.interestList[0] = false;
            this.interestList[1] = false;
            switch (state) {
                case 0: {
                    this.interestList[2] = true;
                    break;
                }
                case 1: {
                    this.interestList[3] = true;
                    break;
                }
                case 2: {
                    this.interestList[4] = true;
                    break;
                }
                case 3: {
                    this.interestList[5] = true;
                    break;
                }
                case 4: {
                    this.interestList[6] = true;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testAdded(int msgType, TestResultTable.TreeNode[] path, TestResult what, int index) {
            BP_TestListSubpanel bP_TestListSubpanel = BP_TestListSubpanel.this;
            synchronized (bP_TestListSubpanel) {
                BP_TestListSubpanel.this.mod.addTest(what, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testRemoved(int msgType, TestResultTable.TreeNode[] path, TestResult what, int index) {
            BP_TestListSubpanel bP_TestListSubpanel = BP_TestListSubpanel.this;
            synchronized (bP_TestListSubpanel) {
                BP_TestListSubpanel.this.mod.removeTest(what);
            }
        }

        public void statsUpdated(int[] stats) {
        }
    }

    private class TestTableModel
    extends AbstractTableModel {
        private String[] colNames;
        private final Object vLock = new Object();
        private Vector inQueue;
        private Vector rmQueue;
        private LinkedList liveData;
        Vector pendingEvents = new Vector();
        volatile boolean isUpdateScheduled;
        private static final int BATCH_SIZE = 100;
        private static final int COLUMN_COUNT = 2;
        private Sorter[] rows;
        private Object[] o;
        private int SORTING_COLUMN = -1;
        private boolean SORTING_MODE = false;

        TestTableModel(UIFactory uif) {
            this.colNames = new String[]{uif.getI18NString("br.list.col0.txt"), uif.getI18NString("br.list.col1.txt")};
            if (BP_TestListSubpanel.this.debug) {
                Debug.println("TableModel constructed: ");
                Debug.println("   -> " + this);
            }
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            LinkedList linkedList = this.liveData;
            synchronized (linkedList) {
                return this.liveData.size();
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex >= this.colNames.length) {
                throw new IndexOutOfBoundsException();
            }
            return columnIndex == 0 ? this.colNames[0] : BP_TestListSubpanel.this.uif.getI18NString("br.runtime.show.status.mit");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    return this.liveData.get(row);
                }
            }
            if (column == 1) {
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    if (this.liveData.get(row) instanceof TestResult) {
                        return this.getSelectedProperty((TestResult)this.liveData.get(row));
                    }
                    return BP_TestListSubpanel.this.uif.getI18NString("br.list.notAvailable.txt");
                }
            }
            throw new IndexOutOfBoundsException("Index into filtered out table is out of range: " + row + ", " + column);
        }

        public boolean isCellEditable(int rowIndex, int colIndex) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTest(Object tr, boolean suppressNotify) {
            Object object = this.vLock;
            synchronized (object) {
                if (!this.inQueue.contains(tr) && !this.liveData.contains(tr)) {
                    this.inQueue.addElement(tr);
                }
            }
            if (!suppressNotify && !this.isUpdateScheduled) {
                TableNotifier tn = new TableNotifier(BP_TestListSubpanel.this.subpanelNode, this);
                this.pendingEvents.addElement(tn);
                EventQueue.invokeLater(tn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sortTests(LinkedList v, int column, boolean mode) {
            Object object = this.vLock;
            synchronized (object) {
                this.inQueue = this.sort(v, mode);
                TableNotifier tn = new TableNotifier(BP_TestListSubpanel.this.subpanelNode, this);
                this.pendingEvents.addElement(tn);
                EventQueue.invokeLater(tn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeTest(Object tr) {
            Object object = this.vLock;
            synchronized (object) {
                this.rmQueue.addElement(tr);
                if (!this.isUpdateScheduled) {
                    TableNotifier tn = new TableNotifier(BP_TestListSubpanel.this.subpanelNode, this);
                    this.pendingEvents.addElement(tn);
                    EventQueue.invokeLater(tn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = this.vLock;
            synchronized (object) {
                this.init();
            }
            this.notifyDone();
        }

        private String getSelectedProperty(TestResult tst) {
            try {
                if (BP_TestListSubpanel.this.show.equals("title")) {
                    return tst.getDescription().getTitle();
                }
                if (BP_TestListSubpanel.this.show.equals("keywords")) {
                    String[] s = tst.getDescription().getKeywords();
                    if (s.length == 0) {
                        return BP_TestListSubpanel.this.uif.getI18NString("br.list.noKeywords.txt");
                    }
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < s.length; ++i) {
                        sb.append(s[i]);
                        sb.append(" ");
                    }
                    return sb.toString();
                }
                if (BP_TestListSubpanel.this.show.equals("execStatus")) {
                    String tmpStr = tst.getStatus().getReason();
                    return tmpStr == null || tmpStr.equals("") ? BP_TestListSubpanel.this.uif.getI18NString("br.list.notAvailable.txt") : tmpStr;
                }
                return tst.getProperty(BP_TestListSubpanel.this.show) == null ? BP_TestListSubpanel.this.uif.getI18NString("br.list.notAvailable.txt") : tst.getProperty(BP_TestListSubpanel.this.show);
            }
            catch (TestResult.Fault fault) {
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Vector vector = this.pendingEvents;
            synchronized (vector) {
                for (int i = 0; i < this.pendingEvents.size(); ++i) {
                    TableNotifier tn = (TableNotifier)this.pendingEvents.get(i);
                    tn.cancel();
                }
            }
            this.inQueue = new Vector();
            this.rmQueue = new Vector();
            this.liveData = new LinkedList();
            this.isUpdateScheduled = false;
        }

        private Vector sort(LinkedList v, boolean mode) {
            int i;
            this.o = new Object[v.size()];
            if (this.SORTING_COLUMN == 0) {
                this.o = v.toArray();
            } else if (this.SORTING_COLUMN == 1) {
                for (i = 0; i < v.size(); ++i) {
                    this.o[i] = v.get(i) instanceof TestResult ? this.getSelectedProperty((TestResult)v.get(i)) : "";
                }
            } else {
                throw new JavaTestError("Internal error: invalid column number specified: " + this.SORTING_COLUMN);
            }
            this.rows = new Sorter[this.o.length];
            for (i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Sorter();
                this.rows[i].index = i;
            }
            Arrays.sort(this.rows);
            int[] aaa = new int[v.size()];
            for (int i2 = 0; i2 < this.rows.length; ++i2) {
                aaa[i2] = mode ? this.rows[i2].index : this.rows[this.rows.length - i2 - 1].index;
            }
            Vector temp = new Vector(v.size());
            for (int i3 = 0; i3 < v.size(); ++i3) {
                temp.addElement(v.get(aaa[i3]));
            }
            return temp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void goLive() {
            int lastNew = 0;
            if (BP_TestListSubpanel.this.debug) {
                Debug.println("BP_TL.TLM - goLive() starting.");
            }
            BP_TestListSubpanel bP_TestListSubpanel = BP_TestListSubpanel.this;
            synchronized (bP_TestListSubpanel) {
                Object object = this.vLock;
                synchronized (object) {
                    if (this.inQueue.size() == 0 && this.rmQueue.size() == 0) {
                        if (BP_TestListSubpanel.this.debug) {
                            Debug.println("BP_TT.TTM - goLive() nothing to do, returning");
                        }
                        return;
                    }
                    this.processRemoveQueue();
                    if (this.inQueue.size() != 0) {
                        int firstNew;
                        LinkedList linkedList = this.liveData;
                        synchronized (linkedList) {
                            firstNew = this.liveData.size();
                            if (this.inQueue.size() < 100) {
                                if (BP_TestListSubpanel.this.sortingRequested) {
                                    this.liveData.clear();
                                    this.liveData.addAll(this.inQueue);
                                    BP_TestListSubpanel.this.sortingRequested = false;
                                } else {
                                    this.liveData.addAll(this.inQueue);
                                    this.inQueue.setSize(0);
                                }
                                BP_TestListSubpanel.this.table.repaint();
                                lastNew = this.liveData.size() - 1;
                            } else {
                                if (BP_TestListSubpanel.this.sortingRequested) {
                                    this.liveData.clear();
                                    BP_TestListSubpanel.this.sortingRequested = false;
                                }
                                for (int i = 0; i < 100; ++i) {
                                    Object o = this.inQueue.remove(0);
                                    this.liveData.add(o);
                                }
                                if (!this.isUpdateScheduled) {
                                    TableNotifier tn = new TableNotifier(BP_TestListSubpanel.this.subpanelNode, this);
                                    this.pendingEvents.addElement(tn);
                                    EventQueue.invokeLater(tn);
                                }
                                BP_TestListSubpanel.this.table.repaint();
                                lastNew = this.liveData.size() - 1;
                            }
                        }
                        if (this.listenerList.getListenerCount() > 0) {
                            TableModelEvent e = new TableModelEvent(this, firstNew, lastNew, -1, 1);
                            TableNotifier tn = new TableNotifier(e, this);
                            this.pendingEvents.addElement(tn);
                            EventQueue.invokeLater(tn);
                        }
                    }
                    if (BP_TestListSubpanel.this.table.getSelectedRow() == -1 && this.inQueue.size() == 0) {
                        BP_TestListSubpanel.this.showMessage("");
                    }
                }
            }
            if (BP_TestListSubpanel.this.debug) {
                Debug.println("BP_TL.LT - goLive() finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRemoveQueue() {
            if (this.rmQueue.size() == 0) {
                return;
            }
            while (this.rmQueue.size() > 0) {
                TestResult target = (TestResult)this.rmQueue.remove(0);
                int targetIndex = this.liveData.indexOf(target);
                if (targetIndex == -1) continue;
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    targetIndex = this.liveData.indexOf(target);
                    if (targetIndex == -1) {
                        continue;
                    }
                    this.liveData.remove(targetIndex);
                    this.notifyRemoved(target, targetIndex);
                }
            }
        }

        private void preprocessAddQueue() {
            for (int i = 0; i < this.inQueue.size(); ++i) {
                if (!this.liveData.contains(this.inQueue.elementAt(i))) continue;
                this.inQueue.remove(i);
                --i;
            }
        }

        private void notifyAdded(TestResult what, int index) {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent e = new TableModelEvent(this, index, index, -1, 1);
                if (EventQueue.isDispatchThread()) {
                    this.fireTableChanged(e);
                } else {
                    TableNotifier tn = new TableNotifier(e, BP_TestListSubpanel.this.mod);
                    this.pendingEvents.addElement(tn);
                    EventQueue.invokeLater(tn);
                }
            }
        }

        private void notifyRemoved(TestResult what, int index) {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent e = new TableModelEvent(this, index, index, -1, -1);
                if (EventQueue.isDispatchThread()) {
                    this.fireTableChanged(e);
                } else {
                    TableNotifier tn = new TableNotifier(e, BP_TestListSubpanel.this.mod);
                    this.pendingEvents.addElement(tn);
                    EventQueue.invokeLater(tn);
                }
            }
        }

        private void notifyDone() {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent e = new TableModelEvent(this);
                TableNotifier tn = new TableNotifier(e, BP_TestListSubpanel.this.mod);
                this.pendingEvents.addElement(tn);
                EventQueue.invokeLater(tn);
            }
        }

        private class Sorter
        implements Comparable {
            public int index;

            private Sorter() {
            }

            public int compareTo(Object other) {
                Sorter otherRow = (Sorter)other;
                if (TestTableModel.this.o[this.index] instanceof TestResult) {
                    return ((TestResult)TestTableModel.this.o[this.index]).getTestName().compareTo(((TestResult)TestTableModel.this.o[otherRow.index]).getTestName());
                }
                if (TestTableModel.this.o[this.index] instanceof String) {
                    return ((Comparable)TestTableModel.this.o[this.index]).compareTo(TestTableModel.this.o[otherRow.index]);
                }
                return this.index - otherRow.index;
            }
        }
    }

    private class TableSynchronizer
    extends Thread {
        private volatile boolean stopping;

        TableSynchronizer(int whichList) {
            super("Test List Synchronizer" + whichList);
            this.setPriority(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TT_NodeCache cacheCopy;
            TT_NodeCache tT_NodeCache = cacheCopy = BP_TestListSubpanel.this.cache;
            synchronized (tT_NodeCache) {
                BP_TestListSubpanel bP_TestListSubpanel = BP_TestListSubpanel.this;
                synchronized (bP_TestListSubpanel) {
                    BP_TestListSubpanel.access$102(BP_TestListSubpanel.this, cacheCopy.addObserver(BP_TestListSubpanel.this.cacheWatcher, true));
                    for (int j = 0; j < BP_TestListSubpanel.this.newData[BP_TestListSubpanel.this.state].size() - 1 && !this.stopping; ++j) {
                        if (BP_TestListSubpanel.this.sortingRequested) {
                            BP_TestListSubpanel.this.mod.sortTests(BP_TestListSubpanel.this.mod.liveData, BP_TestListSubpanel.this.mod.SORTING_COLUMN, BP_TestListSubpanel.this.mod.SORTING_MODE);
                            continue;
                        }
                        BP_TestListSubpanel.this.mod.addTest(BP_TestListSubpanel.this.newData[BP_TestListSubpanel.this.state].elementAt(j), true);
                    }
                    if (BP_TestListSubpanel.this.newData[BP_TestListSubpanel.this.state].size() > 0 && !this.stopping) {
                        BP_TestListSubpanel.this.mod.addTest(BP_TestListSubpanel.this.newData[BP_TestListSubpanel.this.state].lastElement(), false);
                    }
                    BP_TestListSubpanel.this.resyncThread = null;
                }
            }
            BP_TestListSubpanel.this.validateEnableState();
        }

        public void halt() {
            this.stopping = true;
        }
    }
}

