/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.help.HelpBroker;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class PrefsPane
extends Preferences.Pane {
    private UIFactory uif;
    private JCheckBox toolBarChk;
    private JCheckBox filterWarnChk;
    private JCheckBox tests2RunChk;
    private JCheckBox wrapResChk;
    private ConfigEditorPane configEditorPane;
    private Preferences.Pane[] childPanes;

    PrefsPane(HelpBroker helpBroker) {
        this.uif = new UIFactory(this, helpBroker);
        this.initGUI();
    }

    public Preferences.Pane[] getChildPanes() {
        if (this.configEditorPane == null) {
            this.configEditorPane = new ConfigEditorPane();
        }
        if (this.childPanes == null) {
            this.childPanes = new Preferences.Pane[]{this.configEditorPane};
        }
        return this.childPanes;
    }

    public String getText() {
        return this.uif.getI18NString("ep.title");
    }

    public void load(Map m) {
        super.load(m);
        String p = (String)m.get("exec.toolbar");
        this.toolBarChk.setSelected(p == null || p.equals("true"));
        p = (String)m.get("exec.filterWarn");
        this.filterWarnChk.setSelected(p == null || p.equals("true"));
        p = (String)m.get("exec.tests2runPop");
        this.tests2RunChk.setSelected(p == null ? false : p.equals("true"));
        p = (String)m.get("testOutput.lineWrap");
        this.wrapResChk.setSelected(p == null ? true : p.equals("true"));
    }

    public void save(Map m) {
        super.save(m);
        m.put("exec.toolbar", String.valueOf(this.toolBarChk.isSelected()));
        m.put("exec.filterWarn", String.valueOf(this.filterWarnChk.isSelected()));
        m.put("exec.tests2runPop", String.valueOf(this.tests2RunChk.isSelected()));
        m.put("testOutput.lineWrap", String.valueOf(this.wrapResChk.isSelected()));
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.createToolBarPanel(), c);
        this.add((Component)this.createFilterPanel(), c);
        this.add((Component)this.createExecutionPanel(), c);
        this.add((Component)this.createTestRunMsgPanel(), c);
        c.weighty = 1.0;
        this.add(Box.createVerticalGlue(), c);
    }

    private JPanel createToolBarPanel() {
        JPanel p = this.uif.createPanel("exec.prefs", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.toolbar"));
        this.toolBarChk = this.uif.createCheckBox("ep.toolbar", true);
        this.uif.setAccessibleName(this.toolBarChk, "ep.toolbar");
        p.add((Component)this.toolBarChk, c);
        return p;
    }

    private JPanel createFilterPanel() {
        JPanel p = this.uif.createPanel("exec.prefs.filter", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.filt"));
        this.filterWarnChk = this.uif.createCheckBox("ep.filt", true);
        this.uif.setAccessibleName(this.filterWarnChk, "ep.filt");
        p.add((Component)this.filterWarnChk, c);
        return p;
    }

    private JPanel createExecutionPanel() {
        JPanel p = this.uif.createPanel("exec.prefs.exec", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.exec"));
        this.tests2RunChk = this.uif.createCheckBox("ep.tests2run", true);
        this.uif.setAccessibleName(this.tests2RunChk, "ep.tests2run");
        p.add((Component)this.tests2RunChk, c);
        return p;
    }

    private JPanel createTestRunMsgPanel() {
        JPanel p = this.uif.createPanel("exec.prefs.testrun", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        p.setBorder(this.uif.createTitledBorder("ep.testrun"));
        this.wrapResChk = this.uif.createCheckBox("ep.wrapres", true);
        this.uif.setAccessibleName(this.wrapResChk, "ep.wrapres");
        p.add((Component)this.wrapResChk, c);
        return p;
    }

    private class ConfigEditorPane
    extends Preferences.Pane {
        private JCheckBox moreInfoChk;

        ConfigEditorPane() {
            this.initGUI();
        }

        public String getText() {
            return PrefsPane.this.uif.getI18NString("ep.ce.title");
        }

        public void load(Map m) {
            String mp = (String)m.get("exec.config.moreInfo");
            this.moreInfoChk.setSelected(mp == null || mp.equals("true"));
        }

        public void save(Map m) {
            m.put("exec.config.moreInfo", String.valueOf(this.moreInfoChk.isSelected()));
        }

        private void initGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)this.createDefaultViewPanel(), c);
            c.weighty = 1.0;
            this.add(Box.createVerticalGlue(), c);
        }

        private JPanel createDefaultViewPanel() {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridwidth = 0;
            c.insets.left = 10;
            c.weightx = 1.0;
            c.weighty = 0.0;
            JPanel p = new JPanel(new GridBagLayout());
            JTextArea infoTa = PrefsPane.this.uif.createMessageArea("ep.ce.info");
            infoTa.setOpaque(false);
            this.add((Component)infoTa, c);
            p.setBorder(PrefsPane.this.uif.createTitledBorder("ep.ce.defView"));
            this.moreInfoChk = PrefsPane.this.uif.createCheckBox("ep.ce.moreInfo", true);
            PrefsPane.this.uif.setAccessibleName(this.moreInfoChk, "ep.ce.moreInfo");
            c.insets.top = 10;
            p.add((Component)this.moreInfoChk, c);
            return p;
        }
    }
}

