/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_TestNode;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.awt.EventQueue;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class TestTree
extends JTree {
    private UIFactory uif;
    private TestTreeModel currModel;
    private TreePanelModel tpm;
    private FilterSelectionHandler filterHandler;
    private EventWatcher watcher = new EventWatcher();
    private static int debug = Debug.getInt("debug." + TestTree.class.getName());

    public TestTree(UIFactory uif, TreePanelModel model, FilterSelectionHandler fh, TestTreeModel treeModel) {
        this.uif = uif;
        this.tpm = model;
        this.filterHandler = fh;
        this.filterHandler.addObserver(this.watcher);
        this.currModel = treeModel;
        this.setModel(this.currModel);
        this.setLargeModel(true);
        this.setScrollsOnExpand(true);
        this.setName("tree");
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void updateGUI() {
        this.repaint();
    }

    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        newModel.addTreeModelListener(this.watcher);
    }

    void setParameters(Parameters p) {
    }

    void setTreeModel(TestTreeModel mod) {
        if (this.currModel != null) {
            this.currModel.removeTreeModelListener(this.watcher);
        }
        this.currModel = mod;
        this.setModel(this.currModel);
    }

    TestResultTable getTestResultTable() {
        return this.currModel.getTestResultTable();
    }

    TreePath[] snapshotOpenPaths() {
        if (this.currModel == null || this.currModel.getRoot() == null) {
            return null;
        }
        Object[] paths = new TreePath[]{};
        Enumeration<TreePath> e = this.getDescendantToggledPaths(new TreePath(this.currModel.getRoot()));
        while (e != null && e.hasMoreElements()) {
            TreePath tp = e.nextElement();
            if (!this.isVisible(tp) || !this.isExpanded(tp)) continue;
            paths = (TreePath[])DynamicArray.append(paths, tp);
        }
        return paths;
    }

    void restorePaths(String[] openUrls, boolean queue) {
        if (openUrls == null || openUrls.length == 0) {
            return;
        }
        if (this.currModel instanceof TestTreeModel) {
            final TreePath[] paths = this.currModel.urlsToPaths(openUrls);
            if (!EventQueue.isDispatchThread() || queue) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TestTree.this.restorePaths(paths);
                    }
                });
            } else {
                this.restorePaths(paths);
            }
        }
    }

    void restorePaths(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].getPathCount() == 1) continue;
            this.setExpandedState(paths[i], true);
            this.makeVisible(paths[i]);
        }
    }

    private class EventWatcher
    implements TreeModelListener,
    FilterSelectionHandler.Observer {
        private EventWatcher() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            String activeTest = TestTree.this.tpm.getSelectedTest();
            if (activeTest == null) {
                return;
            }
            Object[] targets = e.getChildren();
            if (targets == null) {
                return;
            }
            for (int i = 0; i < targets.length; ++i) {
                TestResult tr;
                if (!(targets[i] instanceof TT_TestNode) || !(tr = ((TT_TestNode)targets[i]).getTestResult()).getTestName().equals(activeTest)) continue;
                TestTree.this.tpm.showTest(tr);
            }
            TestTree.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            String activeTest = TestTree.this.tpm.getSelectedTest();
            if (activeTest == null) {
                return;
            }
            Object[] targets = e.getChildren();
            if (targets == null) {
                return;
            }
            for (int i = 0; i < targets.length; ++i) {
                TestResult tr;
                if (!(targets[i] instanceof TT_TestNode) || !(tr = ((TT_TestNode)targets[i]).getTestResult()).getTestName().equals(activeTest)) continue;
                TestTree.this.tpm.showTest(tr);
            }
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
            TreePath[] tp = TestTree.this.snapshotOpenPaths();
            if (tp != null && tp.length != 0) {
                TestTree.this.restorePaths(tp);
            }
        }

        public void filterUpdated(TestFilter f) {
            TestTree.this.updateGUI();
        }

        public void filterSelected(TestFilter f) {
            TestTree.this.updateGUI();
        }

        public void filterAdded(TestFilter f) {
        }

        public void filterRemoved(TestFilter f) {
        }
    }
}

