/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;

class ReportWriter
extends HTMLWriter {
    private I18NResourceBundle i18n;
    private static final String BODY = "body";
    private static final String FONT_SIZE = "font-size";
    private static final String FONT_FAMILY = "font-family";
    private static final String BGCOLOR = "bgcolor";
    private static final String MARGIN_LEFT = "margin-left";
    private static final String SANSSERIF = "SansSerif";
    private static final String WHITE = "white";
    private static final String _12PT = "12pt";
    private static final String CSS_FILENAME = "report.css";

    ReportWriter(Writer out) throws IOException {
        super(out);
    }

    ReportWriter(Writer out, I18NResourceBundle i18n) throws IOException {
        super(out, i18n);
        this.i18n = i18n;
    }

    ReportWriter(Writer out, String title, I18NResourceBundle i18n) throws IOException {
        super(out, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">", i18n);
        this.i18n = i18n;
        this.startTag("html");
        this.startTag("head");
        this.startTag("title");
        this.writeI18N("reportWriter.product.name", new Object[]{ProductInfo.getName(), title});
        this.endTag("title");
        this.writeStyle();
        this.endTag("head");
        this.startTag(BODY);
        this.startTag("h1");
        this.writeI18N("reportWriter.product.name", new Object[]{ProductInfo.getName(), title});
        this.endTag("h1");
    }

    public void close() throws IOException {
        Date now = new Date();
        String name = ProductInfo.getName();
        String version = ProductInfo.getVersion();
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        Date date = ProductInfo.getBuildDate();
        String build_date = date != null ? df.format(date) : (this.i18n != null ? this.i18n.getString("reportWriter.noDate") : "unknown");
        String build_version = ProductInfo.getBuildJavaVersion();
        this.startTag("p");
        this.startTag("hr");
        this.startTag("small");
        this.writeI18N("reportWriter.generatedOn", now);
        this.startTag("br");
        this.writeI18N("reportWriter.productInfo", new Object[]{name, version, build_date, build_version});
        this.endTag("small");
        this.endTag(BODY);
        this.endTag("html");
        super.flush();
        super.close();
    }

    public static void initializeDirectory(File dir) throws IOException {
        File cssFile = new File(dir, CSS_FILENAME);
        if (dir.exists() && dir.canWrite() && !cssFile.exists()) {
            FileWriter fw = new FileWriter(cssFile);
            fw.write("h1 {font-size: 18pt;\n");
            fw.write("      font-family: SansSerif;\n");
            fw.write("      bgcolor: white;\n");
            fw.write("      margin-left: 3}\n");
            fw.write("h2 {font-size: 15pt;\n");
            fw.write("      font-family: SansSerif;\n");
            fw.write("      bgcolor: white;\n");
            fw.write("      margin-left: 3}\n");
            fw.write("body , h3 {font-size: 12pt;\n");
            fw.write("           font-family: SansSerif;\n");
            fw.write("           bgcolor: white;\n");
            fw.write("           margin-left: 3}\n");
            fw.close();
        }
    }

    void writeStyle() throws IOException {
        this.startTag("link");
        this.writeAttr("rel", "stylesheet");
        this.writeAttr("href", CSS_FILENAME);
        this.writeAttr("type", "text/css");
        this.endEmptyTag("link");
    }

    void writeStyleSheetProperty(String key, String value, boolean separator) throws IOException {
        if (separator) {
            this.writeI18N("reportWriter.keyValue.separator", new Object[]{key, value});
        } else {
            this.writeI18N("reportWriter.keyValue", new Object[]{key, value});
        }
        this.newLine();
    }

    void writeTD(String body) throws IOException {
        this.startTag("td");
        this.write(body);
        this.endTag("td");
    }

    void writeTH(String heading) throws IOException {
        this.writeTH(heading, null);
    }

    void writeTH(String heading, String scope) throws IOException {
        this.startTag("th");
        if (scope != null) {
            this.writeAttr("scope", scope);
        }
        this.write(heading);
        this.endTag("th");
    }

    void writeWarning(String text) throws IOException {
        this.startTag("font");
        this.writeAttr("color", this.i18n.getString("reportWriter.warn.clr"));
        this.write(text);
        this.endTag("font");
    }
}

