/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.ConfigManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Properties;

public class EnvironmentManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ConfigManager.class);

    EnvironmentManager() {
        TestEnvironment.clearDefaultPropTables();
        String[] stdSysProps = new String[]{"user.dir", "user.home"};
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < stdSysProps.length; ++i) {
            String name = stdSysProps[i];
            m.put(name, System.getProperty(name));
        }
        TestEnvironment.addDefaultPropTable(i18n.getString("env.def.sysProps"), m);
    }

    public HelpTree.Node getHelp() {
        String[] opts = new String[]{"EsysProps", "EnameVar"};
        return new HelpTree.Node(i18n, "env", opts);
    }

    public boolean parseCommand(String cmd, ListIterator argIter, CommandContext ctx) throws Command.Fault {
        if (cmd.equalsIgnoreCase("EsysProps")) {
            ctx.addCommand(new ESysPropsCommand());
            return true;
        }
        if (cmd.startsWith("E") && cmd.indexOf(61) > 0) {
            int sep = cmd.indexOf(61);
            String name = cmd.substring(1, sep).trim();
            String value = cmd.substring(sep + 1).trim();
            ctx.addCommand(new ENameValueCommand(name, value));
            return true;
        }
        return false;
    }

    private class ESysPropsCommand
    extends Command {
        ESysPropsCommand() {
            super("EsysProps");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(CommandContext ctx) throws Command.Fault {
            try {
                Properties sysProps;
                SecurityManager sc = System.getSecurityManager();
                if (sc instanceof JavaTestSecurityManager) {
                    boolean prev = ((JavaTestSecurityManager)sc).setAllowPropertiesAccess(true);
                    try {
                        sysProps = System.getProperties();
                    }
                    finally {
                        ((JavaTestSecurityManager)sc).setAllowPropertiesAccess(prev);
                    }
                } else {
                    sysProps = System.getProperties();
                }
                TestEnvironment.addDefaultPropTable(i18n.getString("env.def.sysProps"), sysProps);
            }
            catch (SecurityException e) {
                throw (Command)this.new Command.Fault(i18n, "env.cantAccessSysProps", e);
            }
        }
    }

    private class ENameValueCommand
    extends Command {
        private String name;
        private String value;

        ENameValueCommand(String name, String value) {
            super("E" + name + "=" + value);
            this.name = name;
            this.value = value;
        }

        public void run(CommandContext ctx) throws Command.Fault {
            HashMap<String, String> m = new HashMap<String, String>(1);
            m.put(this.name, this.value);
            TestEnvironment.addDefaultPropTable(i18n.getString("env.def.cmdLine"), m);
        }
    }
}

