/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InitialUrlFilter;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;

public class ParameterFilter
extends ObservableTestFilter {
    private InitialUrlFilter iurlFilter;
    private String lastInitStrings;
    private TestFilter[] filters;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ParameterFilter.class);

    public String getName() {
        return i18n.getString("pFilter.name");
    }

    public String getDescription() {
        return i18n.getString("pFilter.desc");
    }

    public String getReason() {
        return i18n.getString("pFilter.reason");
    }

    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        return this.accepts(td, null);
    }

    public boolean accepts(TestDescription td, TestFilter.Observer o) throws TestFilter.Fault {
        if (this.filters == null || this.filters.length == 0) {
            if (this.iurlFilter == null) {
                return true;
            }
            boolean result = this.iurlFilter.accepts(td);
            if (!result && o != null) {
                o.rejected(td, this.iurlFilter);
            }
        }
        for (int i = 0; i < this.filters.length; ++i) {
            boolean result = this.filters[i].accepts(td);
            if (result) continue;
            if (o != null) {
                o.rejected(td, this.filters[i]);
            }
            return false;
        }
        if (this.iurlFilter != null && !this.iurlFilter.accepts(td)) {
            if (o != null) {
                o.rejected(td, this.iurlFilter);
            }
            return false;
        }
        return true;
    }

    public TestFilter[] getTestFilters() {
        TestFilter[] copy = null;
        if (this.iurlFilter != null) {
            copy = new TestFilter[this.filters.length + 1];
            copy[copy.length - 1] = this.iurlFilter;
        } else {
            copy = new TestFilter[this.filters.length];
        }
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        return copy;
    }

    public void update(Parameters p) {
        if (p == null) {
            boolean isUpdated = this.filters != null;
            this.filters = null;
            this.iurlFilter = null;
            if (isUpdated) {
                this.notifyUpdated(this);
            }
            return;
        }
        boolean wasUpdated = false;
        TestFilter[] newFilters = p.getFilters();
        if (newFilters != null || this.filters != null) {
            if (newFilters == null && this.filters != null || this.filters == null && newFilters != null) {
                this.filters = newFilters;
                wasUpdated = true;
            } else if (newFilters.length == this.filters.length) {
                if (!CompositeFilter.equals(newFilters, this.filters)) {
                    this.filters = newFilters;
                    wasUpdated = true;
                }
            } else {
                this.filters = newFilters;
                wasUpdated = true;
            }
        }
        String[] initStrings = p.getTests();
        File[] initFiles = ParameterFilter.stringsToFiles(initStrings);
        this.iurlFilter = new InitialUrlFilter(initFiles);
        wasUpdated = wasUpdated || !StringArray.join(initStrings).equals(this.lastInitStrings);
        this.lastInitStrings = StringArray.join(initStrings);
        if (wasUpdated) {
            this.notifyUpdated(this);
        }
    }

    public InitialUrlFilter getIUrlFilter() {
        return this.iurlFilter;
    }

    private static File[] stringsToFiles(String[] tests) {
        if (tests == null) {
            return null;
        }
        File[] files = new File[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            files[i] = new File(tests[i]);
        }
        return files;
    }
}

