/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.EditableFileList;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_ExcludeListPane
extends CE_StdPane {
    Parameters.ExcludeListParameters excludeListParameters;
    Parameters.MutableExcludeListParameters mutableExcludeListParameters;
    private JToolBar toolBar;
    private ButtonGroup btnGrp;
    private JRadioButton customBtn;
    private JRadioButton initialBtn;
    private JRadioButton latestBtn;
    private JRadioButton noneBtn;
    private JPanel body;
    private JPanel blankPanel;
    private CustomPanel customPanel;
    private InitialPanel initialPanel;
    private LatestPanel latestPanel;
    private Listener listener = new Listener();

    CE_ExcludeListPane(UIFactory uif, InterviewParameters config) {
        super(uif, config, "excl");
        this.updateConfig();
        this.initGUI();
    }

    boolean isOKToClose() {
        if (this.mutableExcludeListParameters == null) {
            return true;
        }
        if (this.noneBtn.isSelected()) {
            return true;
        }
        if (this.initialBtn.isSelected()) {
            return this.initialPanel.isOKToClose();
        }
        if (this.latestBtn.isSelected()) {
            return this.latestPanel.isOKToClose();
        }
        if (this.customBtn.isSelected()) {
            return this.customPanel.isOKToClose();
        }
        throw new Error();
    }

    void updateConfig() {
        if (this.config == null) {
            return;
        }
        this.excludeListParameters = this.config.getExcludeListParameters();
        this.mutableExcludeListParameters = this.excludeListParameters instanceof Parameters.MutableExcludeListParameters ? (Parameters.MutableExcludeListParameters)this.excludeListParameters : null;
    }

    void load() {
        this.updateConfig();
        if (this.mutableExcludeListParameters != null) {
            int mode = this.mutableExcludeListParameters.getExcludeMode();
            switch (mode) {
                case 1: {
                    this.noneBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.initialBtn.setSelected(true);
                    break;
                }
                case 3: {
                    this.latestBtn.setSelected(true);
                    break;
                }
                case 4: {
                    this.customBtn.setSelected(true);
                }
            }
            TestSuite testSuite = this.config.getTestSuite();
            WorkDirectory workDir = this.config.getWorkDirectory();
            this.noneBtn.setEnabled(true);
            File initialExcludeList = testSuite.getInitialExcludeList();
            this.initialBtn.setEnabled(initialExcludeList != null);
            this.initialPanel.load(initialExcludeList);
            URL latestExcludeListURL = testSuite.getLatestExcludeList();
            File latestExcludeListFile = workDir.getSystemFile("latest.jtx");
            this.latestBtn.setEnabled(latestExcludeListURL != null);
            this.latestPanel.load(latestExcludeListURL, latestExcludeListFile);
            this.customBtn.setEnabled(true);
            this.customPanel.load();
            this.customPanel.setEnabled(true);
        } else {
            this.noneBtn.setEnabled(false);
            this.initialBtn.setEnabled(false);
            this.latestBtn.setEnabled(false);
            this.customBtn.setSelected(true);
            this.customBtn.setEnabled(false);
            this.customPanel.clear();
            this.customPanel.setEnabled(false);
        }
    }

    void save() {
        if (this.mutableExcludeListParameters != null) {
            int mode = this.customBtn.isSelected() ? 4 : (this.initialBtn.isSelected() ? 2 : (this.latestBtn.isSelected() ? 3 : 1));
            this.mutableExcludeListParameters.setExcludeMode(mode);
            this.latestPanel.save();
            this.customPanel.save();
        }
    }

    void setCheckExcludeListListener(ActionListener l) {
        this.latestPanel.setCheckExcludeListListener(l);
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.excludeTab.csh");
        JPanel p = this.uif.createPanel("ce.excl", new BorderLayout(), false);
        this.initToolBar();
        p.add((Component)this.toolBar, "West");
        this.body = this.uif.createPanel("ce.excl.body", new CardLayout(), false);
        this.body.setBorder(BorderFactory.createEtchedBorder());
        this.blankPanel = this.uif.createPanel("ce.excl.blank");
        this.blankPanel.setName("blank");
        this.body.add((Component)this.blankPanel, this.blankPanel.getName());
        this.customPanel = new CustomPanel();
        this.body.add((Component)this.customPanel, this.customPanel.getName());
        this.initialPanel = new InitialPanel();
        this.body.add((Component)this.initialPanel, this.initialPanel.getName());
        this.latestPanel = new LatestPanel();
        this.body.add((Component)this.latestPanel, this.latestPanel.getName());
        p.add((Component)this.body, "Center");
        this.addBody(p);
        if (this.mutableExcludeListParameters == null) {
            this.setEnabled(false);
        }
    }

    private void initToolBar() {
        this.toolBar = new JToolBar(1);
        this.toolBar.setFloatable(false);
        this.btnGrp = new ButtonGroup();
        this.noneBtn = this.uif.createRadioButton("ce.excl.none", this.btnGrp);
        this.noneBtn.addChangeListener(this.listener);
        this.toolBar.add(this.noneBtn);
        this.initialBtn = this.uif.createRadioButton("ce.excl.initial", this.btnGrp);
        this.initialBtn.addChangeListener(this.listener);
        this.toolBar.add(this.initialBtn);
        this.latestBtn = this.uif.createRadioButton("ce.excl.latest", this.btnGrp);
        this.latestBtn.addChangeListener(this.listener);
        this.toolBar.add(this.latestBtn);
        this.customBtn = this.uif.createRadioButton("ce.excl.custom", this.btnGrp);
        this.customBtn.addChangeListener(this.listener);
        this.toolBar.add(this.customBtn);
    }

    private class LatestPanel
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private JTextArea urlField;
        private JTextField dateField;
        private JCheckBox autoCheck;
        private ButtonGroup btnGrp;
        private JRadioButton daysButton;
        private JTextField daysField;
        private JTextField daysLabel;
        private JRadioButton runButton;
        private JButton nowButton;
        private File latestFile;
        private ActionListener checkExcludeListListener;

        LatestPanel() {
            super(new BorderLayout());
            this.setName("latest");
            JPanel head = CE_ExcludeListPane.this.uif.createPanel("ce.excl.latest.head", new GridBagLayout(), false);
            head.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints lc = new GridBagConstraints();
            lc.anchor = 18;
            lc.insets.right = 5;
            GridBagConstraints fc = new GridBagConstraints();
            fc.fill = 2;
            fc.weightx = 1.0;
            fc.gridwidth = 0;
            JLabel urlLabel = CE_ExcludeListPane.this.uif.createLabel("ce.excl.latest.url", true);
            head.add((Component)urlLabel, lc);
            this.urlField = CE_ExcludeListPane.this.uif.createTextArea("ce.excl.latest.url");
            this.urlField.setEditable(false);
            this.urlField.setLineWrap(true);
            this.urlField.setOpaque(false);
            this.urlField.setBorder(null);
            this.urlField.setMinimumSize(new Dimension(100, 10));
            this.urlField.setSize(new Dimension(2 * CE_ExcludeListPane.this.uif.getDotsPerInch(), Integer.MAX_VALUE));
            urlLabel.setLabelFor(this.urlField);
            head.add((Component)this.urlField, fc);
            JLabel dateLabel = CE_ExcludeListPane.this.uif.createLabel("ce.excl.latest.date", true);
            head.add((Component)dateLabel, lc);
            this.dateField = CE_ExcludeListPane.this.uif.createOutputField("ce.excl.latest.date", dateLabel);
            this.dateField.setBorder(null);
            dateLabel.setLabelFor(this.dateField);
            head.add((Component)this.dateField, fc);
            this.add((Component)head, "North");
            JPanel body = CE_ExcludeListPane.this.uif.createPanel("ce.excl.latest.body", new GridBagLayout(), false);
            body.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            GridBagConstraints c = new GridBagConstraints();
            this.autoCheck = CE_ExcludeListPane.this.uif.createCheckBox("ce.excl.latest.auto");
            this.autoCheck.addChangeListener(this);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.anchor = 17;
            body.add((Component)this.autoCheck, c);
            this.btnGrp = new ButtonGroup();
            c = new GridBagConstraints();
            c.insets.left = 17;
            this.daysButton = CE_ExcludeListPane.this.uif.createRadioButton("ce.excl.latest.everyXDays", this.btnGrp);
            this.daysButton.addChangeListener(this);
            body.add((Component)this.daysButton, c);
            this.daysField = CE_ExcludeListPane.this.uif.createInputField("ce.excl.latest.days", 3);
            this.daysField.setText("7");
            c.insets.left = 0;
            c.insets.right = 5;
            body.add((Component)this.daysField, c);
            this.daysLabel = CE_ExcludeListPane.this.uif.createHeading("ce.excl.latest.days");
            this.daysLabel.setFont(this.daysButton.getFont());
            this.daysLabel.setForeground(this.daysButton.getForeground());
            body.add((Component)this.daysLabel, c);
            this.runButton = CE_ExcludeListPane.this.uif.createRadioButton("ce.excl.latest.everyRun", this.btnGrp);
            this.runButton.addChangeListener(this);
            c.insets.left = 20;
            c.anchor = 17;
            c.weightx = 1.0;
            body.add((Component)this.runButton, c);
            this.add((Component)body, "Center");
            JPanel foot = CE_ExcludeListPane.this.uif.createPanel("ce.excl.latest.foot", new GridBagLayout(), false);
            foot.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            c = new GridBagConstraints();
            c.anchor = 13;
            c.weightx = 1.0;
            this.nowButton = CE_ExcludeListPane.this.uif.createButton("ce.excl.latest.now", this);
            foot.add((Component)this.nowButton, c);
            this.add((Component)foot, "South");
        }

        boolean isOKToClose() {
            File l;
            if (this.autoCheck.isSelected() && this.daysButton.isSelected()) {
                String dt = this.daysField.getText();
                if (dt == null || dt.length() == 0) {
                    CE_ExcludeListPane.this.uif.showError("ce.excl.latest.noDays");
                    return false;
                }
                try {
                    int d = Integer.parseInt(dt);
                    if (d <= 0) {
                        CE_ExcludeListPane.this.uif.showError("ce.excl.latest.badDays");
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    CE_ExcludeListPane.this.uif.showError("ce.excl.latest.badDays");
                    return false;
                }
            }
            if (!(l = CE_ExcludeListPane.this.config.getWorkDirectory().getSystemFile("latest.jtx")).exists() && !this.autoCheck.isSelected()) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.latest.noFile");
                return false;
            }
            return true;
        }

        void load(URL latestURL, File latestFile) {
            if (latestURL == null) {
                this.urlField.setText("");
            } else {
                this.urlField.setText(latestURL.toString());
            }
            this.latestFile = latestFile;
            this.updateDateField();
            boolean ac = CE_ExcludeListPane.this.mutableExcludeListParameters.isLatestExcludeAutoCheckEnabled();
            this.autoCheck.setSelected(ac);
            int acm = CE_ExcludeListPane.this.mutableExcludeListParameters.getLatestExcludeAutoCheckMode();
            if (acm == 1) {
                this.daysButton.setSelected(true);
            } else {
                this.runButton.setSelected(true);
            }
            int days = CE_ExcludeListPane.this.mutableExcludeListParameters.getLatestExcludeAutoCheckInterval();
            if (days < 0) {
                this.daysField.setText("");
            } else {
                this.daysField.setText(String.valueOf(days));
            }
        }

        void save() {
            boolean ac = this.autoCheck.isSelected();
            CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckEnabled(ac);
            int acm = this.daysButton.isSelected() ? 1 : 2;
            CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckMode(acm);
            try {
                String ds = this.daysField.getText();
                if (ds.length() > 0) {
                    int days = Integer.parseInt(ds);
                    CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(days);
                }
            }
            catch (NumberFormatException e) {
                CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(Integer.MIN_VALUE);
            }
        }

        void setCheckExcludeListListener(ActionListener l) {
            this.checkExcludeListListener = l;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.checkExcludeListListener != null) {
                this.checkExcludeListListener.actionPerformed(e);
                this.updateDateField();
            }
        }

        public void stateChanged(ChangeEvent e) {
            boolean ac = this.autoCheck.isSelected();
            this.daysButton.setEnabled(ac);
            this.daysField.setEnabled(ac && this.daysButton.isSelected());
            this.daysLabel.setEnabled(ac);
            this.runButton.setEnabled(ac);
        }

        private void updateDateField() {
            long latestLastModified = this.latestFile.lastModified();
            if (latestLastModified <= 0L) {
                this.dateField.setText(CE_ExcludeListPane.this.uif.getI18NString("ce.excl.latest.dateNotAvailable"));
            } else {
                DateFormat df = DateFormat.getDateTimeInstance();
                this.dateField.setText(df.format(new Date(latestLastModified)));
            }
        }
    }

    private class InitialPanel
    extends JPanel {
        private JTextArea fileArea;
        private File initialFile;

        InitialPanel() {
            super(new GridBagLayout());
            this.setName("initial");
            GridBagConstraints c = new GridBagConstraints();
            JLabel fileLabel = CE_ExcludeListPane.this.uif.createLabel("ce.excl.initial.file", true);
            c.anchor = 11;
            c.insets.top = 20;
            c.insets.bottom = 5;
            c.insets.left = 5;
            c.insets.right = 5;
            c.weighty = 1.0;
            this.add((Component)fileLabel, c);
            this.fileArea = CE_ExcludeListPane.this.uif.createTextArea("ce.excl.initial.file");
            this.fileArea.setMinimumSize(new Dimension(100, 10));
            this.fileArea.setEditable(false);
            this.fileArea.setOpaque(false);
            this.fileArea.setLineWrap(true);
            this.fileArea.setBorder(null);
            c.fill = 1;
            c.weightx = 1.0;
            fileLabel.setLabelFor(this.fileArea);
            this.add((Component)this.fileArea, c);
        }

        boolean isOKToClose() {
            if (this.initialFile == null) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.initial.noFile");
                return false;
            }
            if (!this.initialFile.exists()) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.initial.cantFindFile", this.initialFile);
                return false;
            }
            if (!this.initialFile.isFile() || !this.initialFile.canRead()) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.initial.cantReadFile", this.initialFile);
                return false;
            }
            return true;
        }

        void load(File initialFile) {
            this.initialFile = initialFile;
            if (initialFile == null) {
                this.fileArea.setText("");
            } else {
                this.fileArea.setText(initialFile.getPath());
            }
        }
    }

    private class CustomPanel
    extends JPanel {
        private EditableFileList filesField;

        CustomPanel() {
            super(new GridBagLayout());
            this.setName("custom");
            GridBagConstraints c = new GridBagConstraints();
            JLabel filesLabel = CE_ExcludeListPane.this.uif.createLabel("ce.excl.custom.files", true);
            c.insets.top = 5;
            c.insets.bottom = 5;
            c.insets.left = 5;
            this.add((Component)filesLabel, c);
            FileChooser chooser = new FileChooser(true);
            chooser.addChoosableExtension(".jtx", CE_ExcludeListPane.this.uif.getI18NString("ce.excl.jtxfiles"));
            this.filesField = new EditableFileList(chooser);
            this.filesField.setDuplicatesAllowed(false);
            CE_ExcludeListPane.this.uif.setToolTip(this.filesField, "ce.excl.custom.files");
            c.fill = 2;
            c.gridwidth = 0;
            c.insets.right = 5;
            c.weightx = 1.0;
            c.weighty = 1.0;
            filesLabel.setLabelFor(this.filesField);
            this.add((Component)this.filesField, c);
        }

        public void setEnabled(boolean b) {
            this.filesField.setEnabled(b);
        }

        void clear() {
            this.filesField.clear();
        }

        boolean isOKToClose() {
            File tsr = CE_ExcludeListPane.this.config.getTestSuite().getRoot();
            File[] files = this.filesField.getFiles();
            if (files.length == 0) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.custom.noFiles");
                return false;
            }
            for (int i = 0; i < files.length; ++i) {
                File absFile;
                File file = files[i];
                File file2 = absFile = file.isAbsolute() ? file : new File(tsr, file.getPath());
                if (!absFile.exists()) {
                    CE_ExcludeListPane.this.uif.showError("ce.excl.custom.cantFindFile", file);
                    return false;
                }
                if (absFile.isFile() && absFile.canRead()) continue;
                CE_ExcludeListPane.this.uif.showError("ce.excl.custom.badFile", file);
                return false;
            }
            return true;
        }

        void load() {
            File[] files = CE_ExcludeListPane.this.mutableExcludeListParameters.getCustomExcludeFiles();
            this.filesField.setFiles(files);
        }

        void save() {
            File[] files = this.filesField.getFiles();
            CE_ExcludeListPane.this.mutableExcludeListParameters.setCustomExcludeFiles(files);
        }
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent e) {
            JPanel comp = CE_ExcludeListPane.this.customBtn.isSelected() ? CE_ExcludeListPane.this.customPanel : (CE_ExcludeListPane.this.initialBtn.isSelected() ? CE_ExcludeListPane.this.initialPanel : (CE_ExcludeListPane.this.latestBtn.isSelected() ? CE_ExcludeListPane.this.latestPanel : CE_ExcludeListPane.this.blankPanel));
            ((CardLayout)CE_ExcludeListPane.this.body.getLayout()).show(CE_ExcludeListPane.this.body, comp.getName());
        }
    }
}

